/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.actions.SetArraySizeInplaceEditor;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressInputComponent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/AddWatchAsArrayAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "perform", "nodeName", "", "getWatchesView", "Lcom/intellij/xdebugger/impl/frame/XWatchesView;", "Companion", "intellij.cidr.debugger.core"})
public final class AddWatchAsArrayAction
extends XDebuggerTreeActionBase
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CUSTOM_INFO_MARKER = "AddWatchAsArrayAction.marker: ";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        XValue value = XDebuggerTreeActionBase.getSelectedValue((DataContext)e.getDataContext());
        boolean isFeatureEnabled = Registry.Companion.is("cidr.debugger.value.showAsArray", false);
        e.getPresentation().setVisible(value instanceof CidrPhysicalValue && isFeatureEnabled);
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!super.isEnabled(node, e)) {
            return false;
        }
        XValueContainer xValueContainer = node.getValueContainer();
        CidrPhysicalValue cidrPhysicalValue = xValueContainer instanceof CidrPhysicalValue ? (CidrPhysicalValue)xValueContainer : null;
        if (cidrPhysicalValue == null) {
            return false;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return false;
        }
        LLValueData lLValueData = value.getPreparedVarData();
        Intrinsics.checkNotNullExpressionValue((Object)lLValueData, (String)"getPreparedVarData(...)");
        LLValueData data = lLValueData;
        return data.isValidPointer();
    }

    protected void perform(@NotNull XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XValueContainer xValueContainer = node.getValueContainer();
        CidrPhysicalValue cidrPhysicalValue = xValueContainer instanceof CidrPhysicalValue ? (CidrPhysicalValue)xValueContainer : null;
        if (cidrPhysicalValue == null) {
            return;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return;
        }
        String string = value.getEvaluationExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEvaluationExpression(...)");
        String baseExpr = string;
        XExpressionImpl xExpressionImpl = XExpressionImpl.fromText((String)baseExpr);
        Intrinsics.checkNotNullExpressionValue((Object)xExpressionImpl, (String)"fromText(...)");
        String string2 = GotoAddressInputComponent.Companion.dereference$intellij_cidr_debugger_core((XExpression)xExpressionImpl).getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExpression(...)");
        String baseExprDeref = string2;
        XWatchesView xWatchesView = this.getWatchesView(e);
        if (xWatchesView == null) {
            return;
        }
        XWatchesView watchesView = xWatchesView;
        SetArraySizeInplaceEditor setArraySizeInplaceEditor = new SetArraySizeInplaceEditor(node, nodeName, (Function1<? super String, Unit>)((Function1)arg_0 -> AddWatchAsArrayAction.perform$lambda$0(baseExprDeref, watchesView, arg_0)));
        JComponent editorComponent = setArraySizeInplaceEditor.getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            String string3 = CidrDebuggerBundle.message("debugger.variables.viewAsArray.enterSize.prompt", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            String placeholder = string3;
            ((EditorTextField)editorComponent).setPlaceholder((CharSequence)placeholder);
            ((EditorTextField)editorComponent).setShowPlaceholderWhenFocused(true);
        }
        setArraySizeInplaceEditor.show();
    }

    private final XWatchesView getWatchesView(AnActionEvent e) {
        XDebugSessionTab tab;
        XDebugSession session;
        XWatchesView view = (XWatchesView)e.getData(XWatchesView.DATA_KEY);
        Project project = e.getProject();
        if (view == null && project != null && (session = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null && (tab = ((XDebugSessionImpl)session).getSessionTab()) != null) {
            return tab.getWatchesView();
        }
        return view;
    }

    private static final Unit perform$lambda$0(String $baseExprDeref, XWatchesView $watchesView, String size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        String viewAsArraySuffix = " @ " + size;
        String customInfo = Companion.makeViewAsArrayCustomInfo(viewAsArraySuffix);
        XExpressionImpl watchExpression = new XExpressionImpl($baseExprDeref + viewAsArraySuffix, null, customInfo, EvaluationMode.EXPRESSION);
        DebuggerUIUtil.invokeLater(() -> AddWatchAsArrayAction.perform$lambda$0$0($watchesView, watchExpression));
        return Unit.INSTANCE;
    }

    private static final void perform$lambda$0$0(XWatchesView $watchesView, XExpressionImpl $watchExpression) {
        $watchesView.addWatchExpression((XExpression)$watchExpression, -1, true);
    }

    @JvmStatic
    @Nullable
    public static final String getViewAsArraySuffix(@NotNull XExpression expr) {
        return Companion.getViewAsArraySuffix(expr);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/AddWatchAsArrayAction$Companion;", "", "<init>", "()V", "CUSTOM_INFO_MARKER", "", "makeViewAsArrayCustomInfo", "viewAsArraySuffix", "getViewAsArraySuffix", "expr", "Lcom/intellij/xdebugger/XExpression;", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String makeViewAsArrayCustomInfo(@NotNull String viewAsArraySuffix) {
            Intrinsics.checkNotNullParameter((Object)viewAsArraySuffix, (String)"viewAsArraySuffix");
            return AddWatchAsArrayAction.CUSTOM_INFO_MARKER + viewAsArraySuffix;
        }

        @JvmStatic
        @Nullable
        public final String getViewAsArraySuffix(@NotNull XExpression expr) {
            String customInfo;
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            String string = customInfo = expr.getCustomInfo();
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)AddWatchAsArrayAction.CUSTOM_INFO_MARKER, (boolean)false, (int)2, null) : false;
            if (bl) {
                String string2 = customInfo.substring(30);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return string2;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

