/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryViewPanel
implements ComponentContainer {
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileEditor myFileEditor;
    @NotNull
    private final GotoAddressPanel myGotoAddressPanel;

    private MemoryViewPanel(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull GotoAddressPanel gotoAddressPanel) {
        if (project == null) {
            MemoryViewPanel.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            MemoryViewPanel.$$$reportNull$$$0(1);
        }
        if (gotoAddressPanel == null) {
            MemoryViewPanel.$$$reportNull$$$0(2);
        }
        this.myComponent = new JPanel(new BorderLayout());
        this.myProject = project;
        this.myFileEditor = fileEditor;
        this.myGotoAddressPanel = gotoAddressPanel;
        this.myComponent.add((Component)((Object)this.myGotoAddressPanel), "First");
        this.myComponent.add(fileEditor.getComponent());
    }

    @Nullable
    public static MemoryViewPanel create(@NotNull Project project, @NotNull VirtualFile file) {
        List providers;
        if (project == null) {
            MemoryViewPanel.$$$reportNull$$$0(3);
        }
        if (file == null) {
            MemoryViewPanel.$$$reportNull$$$0(4);
        }
        if ((providers = FileEditorProviderManager.getInstance().getProviderList(project, file)).isEmpty()) {
            return null;
        }
        FileEditorProvider provider = (FileEditorProvider)providers.get(0);
        FileEditor fileEditor = provider.createEditor(project, file);
        GotoAddressPanel gotoAddressPanel = (GotoAddressPanel)((Object)GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY.get((UserDataHolder)fileEditor));
        if (gotoAddressPanel == null) {
            Disposer.dispose((Disposable)fileEditor);
            return null;
        }
        MemoryViewPanel memoryViewPanel = new MemoryViewPanel(project, fileEditor, gotoAddressPanel);
        Disposer.register((Disposable)memoryViewPanel, (Disposable)fileEditor);
        return memoryViewPanel;
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            MemoryViewPanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myGotoAddressPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public FileEditor getFileEditor() {
        FileEditor fileEditor = this.myFileEditor;
        if (fileEditor == null) {
            MemoryViewPanel.$$$reportNull$$$0(6);
        }
        return fileEditor;
    }

    @NotNull
    public GotoAddressPanel getGotoAddressPanel() {
        GotoAddressPanel gotoAddressPanel = this.myGotoAddressPanel;
        if (gotoAddressPanel == null) {
            MemoryViewPanel.$$$reportNull$$$0(7);
        }
        return gotoAddressPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoAddressPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/MemoryViewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/MemoryViewPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoAddressPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

