/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerArchitecture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.CidrInstructionsPatcher;
import com.jetbrains.cidr.execution.debugger.CidrSoftwareBreakpointsAdjuster;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLowLevelException;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0010\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\fH\u0002JA\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0010\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162 \b\u0002\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\"0!H\u0082\bJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0016J*\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u0018\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u000bJ\u0018\u0010.\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u000bJ\u0018\u0010/\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster;", "", "myProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "myArchitecture", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerArchitecture;", "myAdjustedSoftwareBreakpoints", "", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "adjustSoftwareBreakpoint", "Lcom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster$AdjustedCauseAndPlace;", "stopPlace", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "cause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "(Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getArchitecture", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "tryAdjustX86SoftwareBreakpoint", "tryAdjustAarch64SoftwareBreakpoint", "drainAdjustedBreakpointsInNonFrozenThread", "", "jumpOverSoftwareBreakpoint", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "thread", "softwareBreakpoint", "jumpOverSoftwareBreakpointInNonFrozenThreads", "isStoppablePlace", "Lkotlin/Function3;", "", "prepareForResume", "", "prepareForRunToPosition", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "file", "", "line", "", "prepareForStepOver", "resumptionThread", "prepareForStepInto", "prepareForStepOut", "AdjustedCauseAndPlace", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrSoftwareBreakpointsAdjuster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrSoftwareBreakpointsAdjuster.kt\ncom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 CidrSoftwareBreakpointsAdjuster.kt\ncom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster$jumpOverSoftwareBreakpointInNonFrozenThreads$1\n*L\n1#1,207:1\n137#1,9:234\n146#1,4:244\n141#1,9:248\n141#1,9:257\n141#1,9:266\n141#1,9:275\n1#2:208\n67#3,4:209\n67#3,4:213\n67#3,4:226\n67#3,4:230\n774#4:217\n865#4,2:218\n1634#4,3:220\n774#4:223\n865#4,2:224\n139#5:243\n*S KotlinDebug\n*F\n+ 1 CidrSoftwareBreakpointsAdjuster.kt\ncom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster\n*L\n153#1:234,9\n153#1:244,4\n157#1:248,9\n166#1:257,9\n190#1:266,9\n199#1:275,9\n70#1:209,4\n91#1:213,4\n118#1:226,4\n123#1:230,4\n104#1:217\n104#1:218,2\n104#1:220,3\n105#1:223\n105#1:224,2\n153#1:243\n*E\n"})
public final class CidrSoftwareBreakpointsAdjuster {
    @NotNull
    private final CidrDebugProcess myProcess;
    @Nullable
    private CidrDebuggerArchitecture myArchitecture;
    @NotNull
    private final List<Pair<LLThread, AddressRange>> myAdjustedSoftwareBreakpoints;

    public CidrSoftwareBreakpointsAdjuster(@NotNull CidrDebugProcess myProcess) {
        Intrinsics.checkNotNullParameter((Object)myProcess, (String)"myProcess");
        this.myProcess = myProcess;
        this.myAdjustedSoftwareBreakpoints = new ArrayList();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object adjustSoftwareBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull CidrSuspensionCause cause, @NotNull Continuation<? super AdjustedCauseAndPlace> $completion) {
        if (!($completion instanceof adjustSoftwareBreakpoint.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ CidrSoftwareBreakpointsAdjuster this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.adjustSoftwareBreakpoint(null, null, (Continuation<? super AdjustedCauseAndPlace>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!CidrLowLevelException.Companion.isSoftwareBreakpointException(cause.lowLevelException)) {
                    return new AdjustedCauseAndPlace(stopPlace, cause);
                }
                v0 = this.myProcess.postCommand((CidrDebugProcess.DebuggerCommand<AdjustedCauseAndPlace>)LambdaMetafactory.metafactory(null, null, null, (Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;)Ljava/lang/Object;, adjustSoftwareBreakpoint$lambda$0(com.jetbrains.cidr.execution.debugger.CidrSoftwareBreakpointsAdjuster com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver$StopPlace com.jetbrains.cidr.execution.debugger.CidrSuspensionCause com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver ), (Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;)Lcom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster$AdjustedCauseAndPlace;)((CidrSoftwareBreakpointsAdjuster)this, (DebuggerDriver.StopPlace)stopPlace, (CidrSuspensionCause)cause));
                Intrinsics.checkNotNullExpressionValue(v0, (String)"postCommand(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)stopPlace);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)cause);
                $continuation.label = 1;
                v1 = FutureKt.await((CompletionStage)v0, (Continuation)$continuation);
                if (v1 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                cause = (CidrSuspensionCause)$continuation.L$1;
                stopPlace = (DebuggerDriver.StopPlace)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                var4_7 = v1;
                Intrinsics.checkNotNullExpressionValue((Object)var4_7, (String)"await(...)");
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CidrDebuggerArchitecture getArchitecture(DebuggerDriver driver) {
        CidrDebuggerArchitecture cidrDebuggerArchitecture = this.myArchitecture;
        if (cidrDebuggerArchitecture == null) {
            CidrDebuggerArchitecture cidrDebuggerArchitecture2;
            CidrDebuggerArchitecture it = cidrDebuggerArchitecture2 = CidrDebuggerArchitecture.Companion.detectArchitectureByString(driver.getArchitecture());
            boolean bl = false;
            this.myArchitecture = it;
            cidrDebuggerArchitecture = cidrDebuggerArchitecture2;
        }
        return cidrDebuggerArchitecture;
    }

    private final AdjustedCauseAndPlace tryAdjustX86SoftwareBreakpoint(DebuggerDriver driver, DebuggerDriver.StopPlace stopPlace, CidrSuspensionCause cause) {
        byte[] softwareBreakpointInstruction;
        Address softwareBreakpointAddress = stopPlace.frame.getProgramCounter().minus(CidrInstructionsPatcher.Companion.getBYTECODE_X86_INT3().length);
        AddressRange softwareBreakpointAddressRange = AddressUtil.toRange(softwareBreakpointAddress, CidrInstructionsPatcher.Companion.getBYTECODE_X86_INT3().length);
        List<LLMemoryHunk> list = driver.dumpMemory(softwareBreakpointAddressRange);
        Intrinsics.checkNotNullExpressionValue(list, (String)"dumpMemory(...)");
        List<LLMemoryHunk> instructionInMemory = list;
        Object object = (LLMemoryHunk)CollectionsKt.singleOrNull(instructionInMemory);
        byte[] byArray = object != null && (object = ((LLMemoryHunk)object).getBytes()) != null ? CollectionsKt.toByteArray((Collection)((Collection)object)) : (softwareBreakpointInstruction = null);
        if (!Arrays.equals(CidrInstructionsPatcher.Companion.getBYTECODE_X86_INT3(), softwareBreakpointInstruction)) {
            return new AdjustedCauseAndPlace(stopPlace, cause);
        }
        Logger logger = CidrDebuggerLog.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl = false;
            logger2.trace("x86 software breakpoint hit at " + stopPlace.frame.getProgramCounter() + ", adjusting PC back to " + softwareBreakpointAddress);
        }
        DebuggerDriver.StopPlace stopPlace2 = driver.jumpToAddress(stopPlace.thread, softwareBreakpointAddress, false);
        Intrinsics.checkNotNullExpressionValue((Object)stopPlace2, (String)"jumpToAddress(...)");
        DebuggerDriver.StopPlace adjustedStopPlace = stopPlace2;
        CidrSuspensionCause adjustedCause = new CidrSuspensionCause(cause.causeType, cause.reason, adjustedStopPlace.frame.getFile(), adjustedStopPlace.frame.getHash(), adjustedStopPlace.frame.getLine(), softwareBreakpointAddress, cause.lowLevelException);
        this.myAdjustedSoftwareBreakpoints.add((Pair<LLThread, AddressRange>)TuplesKt.to((Object)adjustedStopPlace.thread, (Object)softwareBreakpointAddressRange));
        return new AdjustedCauseAndPlace(adjustedStopPlace, adjustedCause);
    }

    private final AdjustedCauseAndPlace tryAdjustAarch64SoftwareBreakpoint(DebuggerDriver driver, DebuggerDriver.StopPlace stopPlace, CidrSuspensionCause cause) {
        Object softwareBreakpointInstruction;
        Object object;
        AddressRange softwareBreakpointAddressRange;
        Address softwareBreakpointAddress;
        block6: {
            block5: {
                Address address = cause.address;
                Intrinsics.checkNotNullExpressionValue((Object)address, (String)"address");
                softwareBreakpointAddress = address;
                softwareBreakpointAddressRange = AddressUtil.toRange(softwareBreakpointAddress, 4);
                List<LLMemoryHunk> list = driver.dumpMemory(softwareBreakpointAddressRange);
                Intrinsics.checkNotNullExpressionValue(list, (String)"dumpMemory(...)");
                List<LLMemoryHunk> instructionInMemory = list;
                object = (LLMemoryHunk)CollectionsKt.singleOrNull(instructionInMemory);
                if (object == null || (object = ((LLMemoryHunk)object).getBytes()) == null) break block5;
                byte[] byArray = CollectionsKt.toByteArray((Collection)((Collection)object));
                object = byArray;
                if (byArray != null) break block6;
            }
            object = new byte[0];
        }
        if (CidrInstructionsPatcher.Companion.isBytecodeAarch64Brk((byte[])(softwareBreakpointInstruction = object))) {
            Logger logger = CidrDebuggerLog.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace("AArch64 software breakpoint hit at " + softwareBreakpointAddress + ", no PC adjustment needed");
            }
            this.myAdjustedSoftwareBreakpoints.add((Pair<LLThread, AddressRange>)TuplesKt.to((Object)stopPlace.thread, (Object)softwareBreakpointAddressRange));
        }
        return new AdjustedCauseAndPlace(stopPlace, cause);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<LLThread, AddressRange>> drainAdjustedBreakpointsInNonFrozenThread(DebuggerDriver driver) {
        void $this$filterTo$iv$iv;
        void destination$iv;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv2;
        if (this.myAdjustedSoftwareBreakpoints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<LLThread> list = driver.getThreads();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getThreads(...)");
        List<LLThread> allThreads = list;
        Iterable $this$filter$iv = allThreads;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            LLThread it = (LLThread)element$iv$iv;
            boolean bl = false;
            if (!it.isFrozen()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection $i$f$filter22 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            LLThread lLThread = (LLThread)item$iv;
            void var14_20 = destination$iv;
            boolean bl = false;
            var14_20.add(TuplesKt.to((Object)it.getId(), (Object)it.getTid()));
        }
        HashSet allFrozenThreadIds = (HashSet)destination$iv;
        Iterable $this$filter$iv2 = this.myAdjustedSoftwareBreakpoints;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!allFrozenThreadIds.contains(TuplesKt.to((Object)((LLThread)it.getFirst()).getId(), (Object)((LLThread)it.getFirst()).getTid())))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonFrozenThreads = (List)destination$iv$iv2;
        this.myAdjustedSoftwareBreakpoints.removeAll(nonFrozenThreads);
        return nonFrozenThreads;
    }

    private final Pair<LLFrame, DebuggerDriver.StopPlace> jumpOverSoftwareBreakpoint(DebuggerDriver driver, LLThread thread, AddressRange softwareBreakpoint) {
        try {
            LLFrame topFrame;
            List list = driver.getFrames((LLThread)thread, (int)0, (int)1).list;
            Intrinsics.checkNotNullExpressionValue(list, (String)"list");
            LLFrame lLFrame = topFrame = (LLFrame)CollectionsKt.firstOrNull(list);
            if (Intrinsics.areEqual((Object)(lLFrame != null ? lLFrame.getProgramCounter() : null), (Object)softwareBreakpoint.getStart())) {
                Logger logger = CidrDebuggerLog.LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv;
                    boolean bl = false;
                    logger2.trace("Jumping over software breakpoint at " + softwareBreakpoint);
                }
                Address jumpOverSoftwareBreakpoint = topFrame.getProgramCounter().plus(softwareBreakpoint.getSize());
                return TuplesKt.to((Object)topFrame, (Object)driver.jumpToAddress(thread, jumpOverSoftwareBreakpoint, false));
            }
            Logger logger = CidrDebuggerLog.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger3 = $this$trace$iv;
                boolean bl = false;
                LLFrame lLFrame2 = topFrame;
                logger3.trace("Thread program counter '" + (lLFrame2 != null ? lLFrame2.getProgramCounter() : null) + "' doesn't match software breakpoint address '" + softwareBreakpoint + "'");
            }
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.warnWithDebug("Failed to handle software breakpoint at " + softwareBreakpoint + ".", (Throwable)e);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warnWithDebug("Failed to handle software breakpoint at " + softwareBreakpoint + ".", (Throwable)e);
        }
        return null;
    }

    private final Pair<LLFrame, DebuggerDriver.StopPlace> jumpOverSoftwareBreakpointInNonFrozenThreads(DebuggerDriver driver, Function3<? super LLThread, ? super LLFrame, ? super DebuggerDriver.StopPlace, Boolean> isStoppablePlace) {
        boolean $i$f$jumpOverSoftwareBreakpointInNonFrozenThreads = false;
        List adjustedBreakpoints = this.drainAdjustedBreakpointsInNonFrozenThread(driver);
        Pair stoppableJumpedFromTo = null;
        for (Pair pair : adjustedBreakpoints) {
            Pair jumpedFromTo;
            AddressRange softwareBreakpoint;
            LLThread thread = (LLThread)pair.component1();
            if (this.jumpOverSoftwareBreakpoint(driver, thread, softwareBreakpoint = (AddressRange)pair.component2()) == null || !((Boolean)isStoppablePlace.invoke((Object)thread, jumpedFromTo.getFirst(), jumpedFromTo.getSecond())).booleanValue()) continue;
            stoppableJumpedFromTo = jumpedFromTo;
        }
        return stoppableJumpedFromTo;
    }

    static /* synthetic */ Pair jumpOverSoftwareBreakpointInNonFrozenThreads$default(CidrSoftwareBreakpointsAdjuster $this, DebuggerDriver driver, Function3 isStoppablePlace, int n, Object object) {
        if ((n & 2) != 0) {
            isStoppablePlace = jumpOverSoftwareBreakpointInNonFrozenThreads.1.INSTANCE;
        }
        boolean $i$f$jumpOverSoftwareBreakpointInNonFrozenThreads = false;
        List adjustedBreakpoints = $this.drainAdjustedBreakpointsInNonFrozenThread(driver);
        Pair stoppableJumpedFromTo = null;
        for (Pair pair : adjustedBreakpoints) {
            Pair jumpedFromTo;
            AddressRange softwareBreakpoint;
            LLThread thread = (LLThread)pair.component1();
            if ($this.jumpOverSoftwareBreakpoint(driver, thread, softwareBreakpoint = (AddressRange)pair.component2()) == null || !((Boolean)isStoppablePlace.invoke((Object)thread, jumpedFromTo.getFirst(), jumpedFromTo.getSecond())).booleanValue()) continue;
            stoppableJumpedFromTo = jumpedFromTo;
        }
        return stoppableJumpedFromTo;
    }

    /*
     * WARNING - void declaration
     */
    public final void prepareForResume(@NotNull DebuggerDriver driver) {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this;
        DebuggerDriver driver$iv = driver;
        boolean $i$f$jumpOverSoftwareBreakpointInNonFrozenThreads = false;
        List adjustedBreakpoints$iv = ((CidrSoftwareBreakpointsAdjuster)$this$iv).drainAdjustedBreakpointsInNonFrozenThread(driver$iv);
        Pair stoppableJumpedFromTo$iv = null;
        for (Pair pair : adjustedBreakpoints$iv) {
            Pair jumpedFromTo$iv;
            AddressRange softwareBreakpoint$iv;
            LLThread thread$iv = (LLThread)pair.component1();
            if (((CidrSoftwareBreakpointsAdjuster)$this$iv).jumpOverSoftwareBreakpoint(driver$iv, thread$iv, softwareBreakpoint$iv = (AddressRange)pair.component2()) == null) continue;
            Object object = jumpedFromTo$iv.getSecond();
            Object object2 = jumpedFromTo$iv.getFirst();
            LLThread lLThread = thread$iv;
            boolean bl = false;
            LLFrame cfr_ignored_0 = (LLFrame)object2;
            DebuggerDriver.StopPlace cfr_ignored_1 = (DebuggerDriver.StopPlace)object;
            if (!false) continue;
            stoppableJumpedFromTo$iv = jumpedFromTo$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DebuggerDriver.StopPlace prepareForRunToPosition(@NotNull DebuggerDriver driver, @Nullable Address address, @NotNull String file, int line) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this;
        DebuggerDriver driver$iv = driver;
        boolean $i$f$jumpOverSoftwareBreakpointInNonFrozenThreads = false;
        List adjustedBreakpoints$iv = ((CidrSoftwareBreakpointsAdjuster)this_$iv).drainAdjustedBreakpointsInNonFrozenThread(driver$iv);
        Pair stoppableJumpedFromTo$iv = null;
        for (Pair pair : adjustedBreakpoints$iv) {
            void jumpedTo;
            Pair jumpedFromTo$iv;
            AddressRange softwareBreakpoint$iv;
            LLThread thread$iv = (LLThread)pair.component1();
            if (((CidrSoftwareBreakpointsAdjuster)this_$iv).jumpOverSoftwareBreakpoint(driver$iv, thread$iv, softwareBreakpoint$iv = (AddressRange)pair.component2()) == null) continue;
            DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)jumpedFromTo$iv.getSecond();
            LLFrame cfr_ignored_0 = (LLFrame)jumpedFromTo$iv.getFirst();
            boolean bl = false;
            Address address2 = address;
            boolean bl2 = address2 != null ? Intrinsics.areEqual((Object)address2, (Object)jumpedTo.frame.getProgramCounter()) : jumpedTo.frame.getLine() == line && Intrinsics.areEqual((Object)jumpedTo.frame.getFile(), (Object)file);
            if (!bl2) continue;
            stoppableJumpedFromTo$iv = jumpedFromTo$iv;
        }
        Pair pair = stoppableJumpedFromTo$iv;
        return pair != null ? (DebuggerDriver.StopPlace)pair.getSecond() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DebuggerDriver.StopPlace prepareForStepOver(@NotNull DebuggerDriver driver, @NotNull LLThread resumptionThread) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)resumptionThread, (String)"resumptionThread");
        CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this;
        DebuggerDriver driver$iv = driver;
        boolean $i$f$jumpOverSoftwareBreakpointInNonFrozenThreads = false;
        List adjustedBreakpoints$iv = ((CidrSoftwareBreakpointsAdjuster)this_$iv).drainAdjustedBreakpointsInNonFrozenThread(driver$iv);
        Pair stoppableJumpedFromTo$iv = null;
        for (Pair pair : adjustedBreakpoints$iv) {
            boolean bl;
            Pair jumpedFromTo$iv;
            AddressRange softwareBreakpoint$iv;
            LLThread thread$iv = (LLThread)pair.component1();
            if (((CidrSoftwareBreakpointsAdjuster)this_$iv).jumpOverSoftwareBreakpoint(driver$iv, thread$iv, softwareBreakpoint$iv = (AddressRange)pair.component2()) == null) continue;
            DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)jumpedFromTo$iv.getSecond();
            LLFrame lLFrame = (LLFrame)jumpedFromTo$iv.getFirst();
            LLThread jumpedFromThread = thread$iv;
            boolean bl2 = false;
            if (resumptionThread.getId() != jumpedFromThread.getId() || !Intrinsics.areEqual((Object)resumptionThread.getTid(), (Object)jumpedFromThread.getTid())) {
                bl = false;
            } else {
                void jumpedFromFrame;
                void jumpedTo;
                LLFrame lLFrame2 = jumpedTo.frame;
                Intrinsics.checkNotNullExpressionValue((Object)lLFrame2, (String)"frame");
                bl = !CidrDebuggerUtilKt.isSameFunctionAndLineFrames((LLFrame)jumpedFromFrame, lLFrame2);
            }
            if (!bl) continue;
            stoppableJumpedFromTo$iv = jumpedFromTo$iv;
        }
        Pair pair = stoppableJumpedFromTo$iv;
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        LLFrame jumpedFrom = (LLFrame)pair2.component1();
        DebuggerDriver.StopPlace newStop = (DebuggerDriver.StopPlace)pair2.component2();
        if (newStop.frame.getInlined()) {
            LLFrame lLFrame = newStop.frame;
            Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"frame");
            if (!CidrDebuggerUtilKt.isSameFunctionFrames(lLFrame, jumpedFrom)) {
                LLFrame frame;
                DebuggerDriver.ResultList<LLFrame> nextFrame;
                int from = 1;
                do {
                    Intrinsics.checkNotNullExpressionValue(driver.getFrames(newStop.thread, from++, 1), (String)"getFrames(...)");
                    List list = nextFrame.list;
                    Intrinsics.checkNotNullExpressionValue(list, (String)"list");
                    if ((LLFrame)CollectionsKt.firstOrNull(list) == null) break;
                    if (!CidrDebuggerUtilKt.isSameFunctionFrames(frame, jumpedFrom)) continue;
                    return new DebuggerDriver.StopPlace(newStop.thread, frame, newStop.returnValue);
                } while (nextFrame.hasMore && frame.getInlined());
            }
        }
        return newStop;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DebuggerDriver.StopPlace prepareForStepInto(@NotNull DebuggerDriver driver, @NotNull LLThread resumptionThread) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)resumptionThread, (String)"resumptionThread");
        CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this;
        DebuggerDriver driver$iv = driver;
        boolean $i$f$jumpOverSoftwareBreakpointInNonFrozenThreads = false;
        List adjustedBreakpoints$iv = ((CidrSoftwareBreakpointsAdjuster)this_$iv).drainAdjustedBreakpointsInNonFrozenThread(driver$iv);
        Pair stoppableJumpedFromTo$iv = null;
        for (Pair pair : adjustedBreakpoints$iv) {
            boolean bl;
            Pair jumpedFromTo$iv;
            AddressRange softwareBreakpoint$iv;
            LLThread thread$iv = (LLThread)pair.component1();
            if (((CidrSoftwareBreakpointsAdjuster)this_$iv).jumpOverSoftwareBreakpoint(driver$iv, thread$iv, softwareBreakpoint$iv = (AddressRange)pair.component2()) == null) continue;
            DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)jumpedFromTo$iv.getSecond();
            LLFrame lLFrame = (LLFrame)jumpedFromTo$iv.getFirst();
            LLThread jumpedFromThread = thread$iv;
            boolean bl2 = false;
            if (resumptionThread.getId() != jumpedFromThread.getId() || !Intrinsics.areEqual((Object)resumptionThread.getTid(), (Object)jumpedFromThread.getTid())) {
                bl = false;
            } else {
                void jumpedFromFrame;
                void jumpedTo;
                LLFrame lLFrame2 = jumpedTo.frame;
                Intrinsics.checkNotNullExpressionValue((Object)lLFrame2, (String)"frame");
                bl = !CidrDebuggerUtilKt.isSameFunctionAndLineFrames((LLFrame)jumpedFromFrame, lLFrame2);
            }
            if (!bl) continue;
            stoppableJumpedFromTo$iv = jumpedFromTo$iv;
        }
        Pair pair = stoppableJumpedFromTo$iv;
        return pair != null ? (DebuggerDriver.StopPlace)pair.getSecond() : null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final DebuggerDriver.StopPlace prepareForStepOut(@NotNull DebuggerDriver driver, @NotNull LLThread resumptionThread) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)resumptionThread, (String)"resumptionThread");
        var4_3 = this;
        driver$iv = driver;
        $i$f$jumpOverSoftwareBreakpointInNonFrozenThreads = false;
        adjustedBreakpoints$iv = CidrSoftwareBreakpointsAdjuster.access$drainAdjustedBreakpointsInNonFrozenThread((CidrSoftwareBreakpointsAdjuster)this_$iv, driver$iv);
        stoppableJumpedFromTo$iv = null;
        for (Pair var10_9 : adjustedBreakpoints$iv) {
            block4: {
                block3: {
                    thread$iv = (LLThread)var10_9.component1();
                    if (CidrSoftwareBreakpointsAdjuster.access$jumpOverSoftwareBreakpoint((CidrSoftwareBreakpointsAdjuster)this_$iv, driver$iv, thread$iv, softwareBreakpoint$iv = (AddressRange)var10_9.component2()) == null) continue;
                    var14_13 = (DebuggerDriver.StopPlace)jumpedFromTo$iv.getSecond();
                    var15_14 = (LLFrame)jumpedFromTo$iv.getFirst();
                    jumpedFromThread = thread$iv;
                    $i$a$-jumpOverSoftwareBreakpointInNonFrozenThreads-CidrSoftwareBreakpointsAdjuster$prepareForStepOut$1 = false;
                    if (resumptionThread.getId() == jumpedFromThread.getId() && Intrinsics.areEqual((Object)resumptionThread.getTid(), (Object)jumpedFromThread.getTid())) break block3;
                    v0 = false;
                    break block4;
                }
                if (!jumpedFromFrame.getInlined()) ** GOTO lbl-1000
                v1 = jumpedTo.frame;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"frame");
                if (!CidrDebuggerUtilKt.isSameFunctionFrames((LLFrame)jumpedFromFrame, v1)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
            }
            if (!v0) continue;
            stoppableJumpedFromTo$iv = jumpedFromTo$iv;
        }
        var3_17 = stoppableJumpedFromTo$iv;
        return var3_17 != null ? (DebuggerDriver.StopPlace)var3_17.getSecond() : null;
    }

    private static final AdjustedCauseAndPlace adjustSoftwareBreakpoint$lambda$0(CidrSoftwareBreakpointsAdjuster this$0, DebuggerDriver.StopPlace $stopPlace, CidrSuspensionCause $cause, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        CidrDebuggerArchitecture architecture = this$0.getArchitecture(driver);
        return architecture.getFamily() == CidrDebuggerArchitecture.Family.X86 ? this$0.tryAdjustX86SoftwareBreakpoint(driver, $stopPlace, $cause) : (architecture == CidrDebuggerArchitecture.AARCH64 ? this$0.tryAdjustAarch64SoftwareBreakpoint(driver, $stopPlace, $cause) : new AdjustedCauseAndPlace($stopPlace, $cause));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster$AdjustedCauseAndPlace;", "", "adjustedStopPlace", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "adjustedCause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;)V", "getAdjustedStopPlace", "()Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "getAdjustedCause", "()Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.debugger.core"})
    public static final class AdjustedCauseAndPlace {
        @NotNull
        private final DebuggerDriver.StopPlace adjustedStopPlace;
        @NotNull
        private final CidrSuspensionCause adjustedCause;

        public AdjustedCauseAndPlace(@NotNull DebuggerDriver.StopPlace adjustedStopPlace, @NotNull CidrSuspensionCause adjustedCause) {
            Intrinsics.checkNotNullParameter((Object)adjustedStopPlace, (String)"adjustedStopPlace");
            Intrinsics.checkNotNullParameter((Object)adjustedCause, (String)"adjustedCause");
            this.adjustedStopPlace = adjustedStopPlace;
            this.adjustedCause = adjustedCause;
        }

        @NotNull
        public final DebuggerDriver.StopPlace getAdjustedStopPlace() {
            return this.adjustedStopPlace;
        }

        @NotNull
        public final CidrSuspensionCause getAdjustedCause() {
            return this.adjustedCause;
        }

        @NotNull
        public final DebuggerDriver.StopPlace component1() {
            return this.adjustedStopPlace;
        }

        @NotNull
        public final CidrSuspensionCause component2() {
            return this.adjustedCause;
        }

        @NotNull
        public final AdjustedCauseAndPlace copy(@NotNull DebuggerDriver.StopPlace adjustedStopPlace, @NotNull CidrSuspensionCause adjustedCause) {
            Intrinsics.checkNotNullParameter((Object)adjustedStopPlace, (String)"adjustedStopPlace");
            Intrinsics.checkNotNullParameter((Object)adjustedCause, (String)"adjustedCause");
            return new AdjustedCauseAndPlace(adjustedStopPlace, adjustedCause);
        }

        public static /* synthetic */ AdjustedCauseAndPlace copy$default(AdjustedCauseAndPlace adjustedCauseAndPlace, DebuggerDriver.StopPlace stopPlace, CidrSuspensionCause cidrSuspensionCause, int n, Object object) {
            if ((n & 1) != 0) {
                stopPlace = adjustedCauseAndPlace.adjustedStopPlace;
            }
            if ((n & 2) != 0) {
                cidrSuspensionCause = adjustedCauseAndPlace.adjustedCause;
            }
            return adjustedCauseAndPlace.copy(stopPlace, cidrSuspensionCause);
        }

        @NotNull
        public String toString() {
            return "AdjustedCauseAndPlace(adjustedStopPlace=" + this.adjustedStopPlace + ", adjustedCause=" + this.adjustedCause + ")";
        }

        public int hashCode() {
            int result = this.adjustedStopPlace.hashCode();
            result = result * 31 + this.adjustedCause.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdjustedCauseAndPlace)) {
                return false;
            }
            AdjustedCauseAndPlace adjustedCauseAndPlace = (AdjustedCauseAndPlace)other;
            if (!Intrinsics.areEqual((Object)this.adjustedStopPlace, (Object)adjustedCauseAndPlace.adjustedStopPlace)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.adjustedCause, (Object)adjustedCauseAndPlace.adjustedCause);
        }
    }
}

