/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.publishing;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.model.PublishableProjectModel;
import com.jetbrains.rider.model.PublishableProjectOutput;
import com.jetbrains.rider.model.PublishableProjectsModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.run.configurations.publishing.PublishAndUploadRunConfigurationType;
import com.jetbrains.rider.run.configurations.publishing.RiderContextPublishProvider;
import com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfiguration;
import com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfigurationFactory;
import com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfigurationSettingsBase;
import com.jetbrains.rider.run.configurations.publishing.providers.SettingsProvidersUtilKt;
import icons.RiderIcons;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0019\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/publishing/CustomServerContextPublishProvider;", "Lcom/jetbrains/rider/run/configurations/publishing/RiderContextPublishProvider;", "<init>", "()V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isProjectPublishable", "projectData", "Lcom/jetbrains/rider/model/PublishableProjectModel;", "solutionHasAnyPublishableProjects", "getConfigurationForNode", "Lkotlin/Pair;", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "intellij.rider.plugins.publish.custom.server"})
@SourceDebugExtension(value={"SMAP\nCustomServerContextPublishProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomServerContextPublishProvider.kt\ncom/jetbrains/rider/publishing/CustomServerContextPublishProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1740#2,3:62\n1761#2,3:65\n230#2,2:68\n*S KotlinDebug\n*F\n+ 1 CustomServerContextPublishProvider.kt\ncom/jetbrains/rider/publishing/CustomServerContextPublishProvider\n*L\n28#1:62,3\n34#1:65,3\n51#1:68,2\n*E\n"})
public final class CustomServerContextPublishProvider
implements RiderContextPublishProvider {
    @NotNull
    private final Icon icon;
    @NotNull
    private final String name;

    public CustomServerContextPublishProvider() {
        Icon icon = RiderIcons.Publish.PublishCustomServer;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PublishCustomServer");
        this.icon = icon;
        this.name = RiderBundle.message((String)"publish.to.custom.server.option", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Map.Entry projectData = RiderContextPublishProvider.Companion.getProjectData(project, entity);
        return projectData != null && this.isProjectPublishable(project, (PublishableProjectModel)projectData.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProjectPublishable(Project project, PublishableProjectModel projectData) {
        if (projectData.isDatabaseProject()) {
            return false;
        }
        if (projectData.isDotNetCore()) {
            PublishableProjectOutput it;
            Iterable $this$all$iv = projectData.getProjectOutputs();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                it = (PublishableProjectOutput)element$iv;
                boolean bl = false;
            } while (SettingsProvidersUtilKt.getSettingProvider((Project)project, (PublishableProjectModel)projectData, (String)it.getTfm()).isAvailableForDeployToServer());
            boolean bl = false;
            if (bl) return true;
        }
        if (!projectData.isWeb()) return false;
        if (!projectData.getHasWebPublishTarget()) return false;
        return true;
    }

    public boolean solutionHasAnyPublishableProjects(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$any$iv = PublishableProjectsModel_PregeneratedKt.getPublishableProjectsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getPublishableProjects().entrySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    if (!this.isProjectPublishable(project, (PublishableProjectModel)it.getValue())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Pair<RunConfiguration, ConfigurationFactory> getConfigurationForNode(@NotNull Project project, @NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Map.Entry projectData = RiderContextPublishProvider.Companion.getProjectData(project, entity);
        Object object = ArraysKt.single((Object[])((PublishAndUploadRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(PublishAndUploadRunConfigurationType.class)).getConfigurationFactories());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfigurationFactory<*>");
        PublishRunConfigurationFactory factory = (PublishRunConfigurationFactory)object;
        Object object2 = projectData;
        if (object2 == null || (object2 = (PublishableProjectModel)object2.getValue()) == null || (object2 = object2.getProjectName()) == null) {
            object2 = entity.getName();
        }
        PublishRunConfiguration configuration = new PublishRunConfiguration(project, factory, "Publish " + (String)object2 + " to custom server");
        if (projectData != null) {
            configuration.getSettings().setUuid((UUID)projectData.getKey());
        } else {
            Object element$iv2;
            PublishRunConfigurationSettingsBase publishRunConfigurationSettingsBase;
            block4: {
                void $this$first$iv;
                Iterable iterable = PublishableProjectsModel_PregeneratedKt.getPublishableProjectsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getPublishableProjects().entrySet();
                publishRunConfigurationSettingsBase = configuration.getSettings();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Map.Entry it = (Map.Entry)element$iv2;
                    boolean bl = false;
                    if (!this.isProjectPublishable(project, (PublishableProjectModel)it.getValue())) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            publishRunConfigurationSettingsBase.setUuid((UUID)((Map.Entry)element$iv2).getKey());
        }
        return new Pair((Object)configuration, (Object)factory);
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public String getName() {
        return this.name;
    }
}

