/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.protobuf.lang.lexer._StringLexer;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class StringLexer
extends FlexAdapter {
    private final _StringLexer lexer = (_StringLexer)this.getFlex();

    public StringLexer() {
        this(ProtoTokenTypes.STRING_LITERAL);
    }

    public StringLexer(IElementType literalType) {
        super((FlexLexer)new _StringLexer(literalType));
    }

    public CharSequence currentTokenValue() {
        CharSequence sequenceText = this.lexer.yytext();
        CharSequence valueText = sequenceText.subSequence(this.lexer.lastStringTokenPos, sequenceText.length());
        return switch (this.lexer.lastStringTokenType) {
            default -> throw new MatchException(null, null);
            case _StringLexer.TokenType.SIMPLE -> {
                switch (valueText.charAt(0)) {
                    case 'a': {
                        yield "\u0007";
                    }
                    case 'b': {
                        yield "\b";
                    }
                    case 'f': {
                        yield "\f";
                    }
                    case 'n': {
                        yield "\n";
                    }
                    case 'r': {
                        yield "\r";
                    }
                    case 't': {
                        yield "\t";
                    }
                    case 'v': {
                        yield "\u000b";
                    }
                    case '\\': {
                        yield "\\";
                    }
                    case '?': {
                        yield "?";
                    }
                    case '\'': {
                        yield "'";
                    }
                    case '\"': {
                        yield "\"";
                    }
                }
                yield "";
            }
            case _StringLexer.TokenType.OCTAL -> {
                int octValue = Integer.parseInt(valueText.toString(), 8);
                yield new String(Character.toChars(octValue));
            }
            case _StringLexer.TokenType.HEX -> {
                int hexValue = Integer.parseInt(valueText.toString(), 16);
                yield new String(Character.toChars(hexValue));
            }
            case _StringLexer.TokenType.INVALID, _StringLexer.TokenType.LITERAL -> valueText;
        };
    }

    public boolean isCurrentTokenLiteral() {
        return this.lexer.lastStringTokenType == _StringLexer.TokenType.LITERAL;
    }

    public boolean isCurrentTokenInvalid() {
        return this.lexer.lastStringTokenType == _StringLexer.TokenType.INVALID;
    }

    public boolean hasMoreTokens() {
        return this.getTokenType() != null;
    }

    public static Lexer mergingStringLexer(IElementType literalType) {
        return new MergingLexerAdapter((Lexer)new StringLexer(literalType), TokenSet.create((IElementType[])new IElementType[]{literalType}));
    }
}

