/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.valueAdjuster;

import com.intellij.openapi.diagnostic.Logger;

public interface Mapper<T> {
    public static final int SLIDER_MIN = 0;
    public static final int SLIDER_MAX = 100;

    public int getSliderValue(T var1);

    public T getRealValue(int var1);

    public static class LinearNumberMapper
    implements Mapper<Integer> {
        private static final Logger LOG = Logger.getInstance((String)LinearNumberMapper.class.getName());
        private final int myRealMax;
        private final int myRealMin;

        public LinearNumberMapper(int realMin, int realMax) {
            assert (realMin < realMax);
            this.myRealMax = realMax;
            this.myRealMin = realMin;
        }

        @Override
        public int getSliderValue(Integer realValue) {
            if (realValue < this.myRealMin) {
                LOG.warn("real value too small");
                realValue = this.myRealMin;
            }
            if (realValue > this.myRealMax) {
                LOG.warn("real value too big");
                realValue = this.myRealMax;
            }
            float ratio = 100.0f / (float)(this.myRealMax - this.myRealMin);
            return Math.round(0.0f + (float)(realValue - this.myRealMin) * ratio);
        }

        @Override
        public Integer getRealValue(int sliderValue) {
            if (sliderValue < 0) {
                LOG.warn("slider value too small");
                sliderValue = 0;
            }
            if (sliderValue > 100) {
                LOG.warn("slider value too big");
                sliderValue = 100;
            }
            float ratio = (float)(this.myRealMax - this.myRealMin) / 100.0f;
            return Math.round((float)this.myRealMin + (float)(sliderValue - 0) * ratio);
        }
    }
}

