/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.jetbrains.liveEdit.update.FileScriptProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;

public final class EffectiveFileScriptProcessor
extends FileScriptProcessor {
    private List<VirtualFile> effectiveFiles;
    private List<VirtualFile> transformedFiles;

    private EffectiveFileScriptProcessor(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
        if (debugProcess == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(0);
        }
        super(debugProcess);
    }

    @NotNull
    public static List<VirtualFile> getEffectiveFiles(@NotNull Collection<? extends VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm) {
        if (files == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(1);
        }
        if (debugProcess == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(2);
        }
        if (vm == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(3);
        }
        List<VirtualFile> list = EffectiveFileScriptProcessor.getEffective(files, debugProcess, vm).getEffectiveFiles();
        if (list == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static EffectiveFileScriptProcessor getEffective(@NotNull Collection<? extends VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm) {
        if (files == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(5);
        }
        if (debugProcess == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(6);
        }
        if (vm == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(7);
        }
        EffectiveFileScriptProcessor processor = new EffectiveFileScriptProcessor(debugProcess);
        for (VirtualFile virtualFile : files) {
            processor.reset(virtualFile);
            vm.getScriptManager().forEachScript((Processor)processor);
        }
        EffectiveFileScriptProcessor effectiveFileScriptProcessor = processor;
        if (effectiveFileScriptProcessor == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(8);
        }
        return effectiveFileScriptProcessor;
    }

    public boolean process(Script script) {
        if (this.isScriptFile(script.getUrl())) {
            if (this.effectiveFiles == null) {
                this.effectiveFiles = new SmartList();
            }
            this.effectiveFiles.add(this.file);
            return false;
        }
        if (this.isSourceFile(script)) {
            if (this.transformedFiles == null) {
                this.transformedFiles = new SmartList();
            }
            this.transformedFiles.add(this.file);
        }
        return true;
    }

    @NotNull
    public List<VirtualFile> getEffectiveFiles() {
        List<Object> list = this.effectiveFiles == null ? Collections.emptyList() : this.effectiveFiles;
        if (list == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getTransformedFiles() {
        List<Object> list = this.transformedFiles == null ? Collections.emptyList() : this.transformedFiles;
        if (list == null) {
            EffectiveFileScriptProcessor.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vm";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffective";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveFiles";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEffective";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

