/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.highlighting.ElementHighlighterOnCaretChangeBase;
import com.jetbrains.liveEdit.highlighting.LiveEditElementHighlightExecutor;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

final class ElementHighlighterCaretListener
extends ElementHighlighterOnCaretChangeBase
implements EditorFactoryListener,
Disposable {
    volatile WeakReference<Editor> editorRef;
    AtomicBoolean enabled = new AtomicBoolean(false);

    ElementHighlighterCaretListener() {
        super(new LiveEditElementHighlightExecutor());
    }

    public void dispose() {
        this.enabled.set(false);
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            ElementHighlighterCaretListener.$$$reportNull$$$0(0);
        }
        if (SoftReference.dereference(this.editorRef) == event.getEditor()) {
            this.editorRef = null;
        }
    }

    @Override
    public void caretPositionChanged(@NotNull CaretEvent e) {
        if (e == null) {
            ElementHighlighterCaretListener.$$$reportNull$$$0(1);
        }
        if (!this.enabled.get()) {
            return;
        }
        Editor editor = e.getEditor();
        if (editor.isOneLineMode()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null || !this.highlightExecutor.isHighlightingNeed()) {
            return;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file == null || file instanceof LightVirtualFile || !HtmlUtil.isHtmlFile((VirtualFile)file)) {
            return;
        }
        if (SoftReference.dereference(this.editorRef) != editor) {
            this.editorRef = new WeakReference<Editor>(editor);
        }
        super.caretPositionChanged(e);
    }

    void hideHighlighting() {
        XmlTag tag = this.highlightExecutor.getLastHighlightedTag();
        if (tag != null && !this.highlightExecutor.ignoreHighlight) {
            this.highlightExecutor.clearLastHighlightedTag();
            Project project = (Project)ReadAction.compute(() -> tag.getProject());
            ApplicationInspector.getInstance().hideHighlight(project);
        }
    }

    void hideAndIgnoreHighlightUntilElementChanged() {
        XmlTag tag = this.highlightExecutor.getLastHighlightedTag();
        if (tag == null || this.highlightExecutor.ignoreHighlight) {
            return;
        }
        if (!((Boolean)ReadAction.compute(() -> tag.isValid())).booleanValue()) {
            this.highlightExecutor.clearLastHighlightedTag();
            return;
        }
        ApplicationInspector.getInstance().hideHighlight(tag.getProject());
        this.highlightExecutor.ignoreHighlight = true;
    }

    @Override
    public void run() {
        Editor editor = (Editor)SoftReference.dereference(this.editorRef);
        if (editor == null || editor.isDisposed() || !editor.getContentComponent().hasFocus() && !ApplicationManager.getApplication().isUnitTestMode() || !this.highlightExecutor.isHighlightingNeed()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        this.highlightExecutor.highlight(editor, project, null);
    }

    void enable() {
        this.enabled.set(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/highlighting/ElementHighlighterCaretListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "editorReleased";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "caretPositionChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

