/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.intellij.util.SystemProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0000\u001a\u001c\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"TEXT_CONTENT_ID", "", "STRUCTURE_CONTENT_ID", "MAX_SIZE_FOR_HIGHLIGHTING", "", "getMAX_SIZE_FOR_HIGHLIGHTING", "()I", "appendAttributeValue", "", "value", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "convertLineSeparators", "intellij.js.liveEdit"})
public final class ElementsViewKt {
    @NotNull
    private static final String TEXT_CONTENT_ID = "wi.textView";
    @NotNull
    private static final String STRUCTURE_CONTENT_ID = "wi.structureView";
    private static final int MAX_SIZE_FOR_HIGHLIGHTING = SystemProperties.getIntProperty((String)"idea.live.edit.max.size.for.highlighting.kb", (int)100);

    public static final int getMAX_SIZE_FOR_HIGHLIGHTING() {
        return MAX_SIZE_FOR_HIGHLIGHTING;
    }

    public static final void appendAttributeValue(@Nullable String value, @NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        CharSequence charSequence = value;
        if (!(charSequence == null || charSequence.length() == 0)) {
            builder.append('=').append('\"');
            ElementsViewKt.convertLineSeparators(value, builder);
            builder.append('\"');
        }
    }

    public static final void convertLineSeparators(@NotNull String value, @NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        int prev = 32;
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (c == '\r') {
                builder.append('\n');
            } else if (c != '\n' || prev != 13) {
                builder.append(c);
            }
            prev = c;
        }
    }
}

