/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.LiveEditOptions;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

class LiveEditConfigurableUi
implements ConfigurableUi<LiveEditOptions> {
    private final JPanel panel;
    private final JCheckBox updateNodeCheckbox;
    private final JSpinner updateNodeAutoDelaySpinner;
    private final JCheckBox updateChromeCheckbox;
    private final JSpinner updateChromeAutoDelaySpinner;
    private final JRadioButton updateHtmlAndCss;
    private final JRadioButton updateHtmlCssAndJs;
    private final JCheckBox updateFilesToCompileCheckBox;
    private final JCheckBox elementHighlightingCheckBox;
    private final JCheckBox restartIfHotSwapFailedCheckBox;

    LiveEditConfigurableUi() {
        int vGap = JBUIScale.scale((int)2);
        this.panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, vGap, true, false));
        JPanel updateNodePanel = new JPanel(new FlowLayout(0, 0, 0));
        this.updateNodeCheckbox = new JCheckBox(LiveEditBundle.message("settings.update.node", new Object[0]) + " ");
        updateNodePanel.add(this.updateNodeCheckbox);
        this.updateNodeAutoDelaySpinner = LiveEditConfigurableUi.createDelaySpinner();
        updateNodePanel.add(this.updateNodeAutoDelaySpinner);
        updateNodePanel.add(new JLabel(" " + ApplicationBundle.message((String)"editbox.ms", (Object[])new Object[0])));
        ContextHelpLabel helpLabel = ContextHelpLabel.create((String)LiveEditBundle.message("settings.update.files.to.compile.tip", LiveEditBundle.message("settings.update.files.to.compile", new Object[0])));
        helpLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        updateNodePanel.add((Component)helpLabel);
        this.panel.add(updateNodePanel);
        JPanel updateChromePanel = new JPanel(new FlowLayout(0, 0, 0));
        updateChromePanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.updateChromeCheckbox = new JCheckBox(LiveEditBundle.message("settings.update.chrome", new Object[0]) + " ");
        updateChromePanel.add(this.updateChromeCheckbox);
        this.updateChromeAutoDelaySpinner = LiveEditConfigurableUi.createDelaySpinner();
        updateChromePanel.add(this.updateChromeAutoDelaySpinner);
        updateChromePanel.add(new JLabel(" " + ApplicationBundle.message((String)"editbox.ms", (Object[])new Object[0])));
        this.panel.add(updateChromePanel);
        int updateChromePanelOffset = UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.updateChromeCheckbox);
        if (updateChromePanelOffset == 0) {
            updateChromePanelOffset = 20;
        }
        JPanel updateChromeSettingsPanel = new JPanel(new FlowLayout(0, updateChromePanelOffset, 0));
        this.updateHtmlAndCss = new JRadioButton(LiveEditBundle.message("settings.update.html.and.css", new Object[0]), true);
        this.updateHtmlCssAndJs = new JRadioButton(LiveEditBundle.message("settings.update.html.css.and.js", new Object[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.updateHtmlAndCss);
        buttonGroup.add(this.updateHtmlCssAndJs);
        updateChromeSettingsPanel.add(this.updateHtmlAndCss);
        updateChromeSettingsPanel.add(this.updateHtmlCssAndJs);
        this.panel.add(updateChromeSettingsPanel);
        this.updateFilesToCompileCheckBox = new JCheckBox(LiveEditBundle.message("settings.update.files.to.compile", new Object[0]));
        this.updateFilesToCompileCheckBox.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.panel.add(this.updateFilesToCompileCheckBox);
        this.elementHighlightingCheckBox = this.addCheckboxWithTip("settings.highlight.on.caret", "settings.highlight.on.caret.tip");
        this.restartIfHotSwapFailedCheckBox = new JCheckBox(LiveEditBundle.message("settings.restart.if.hotswap.fails", new Object[0]));
        this.restartIfHotSwapFailedCheckBox.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.panel.add(this.restartIfHotSwapFailedCheckBox);
        ActionListener enabledUpdater = new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                LiveEditConfigurableUi.this.updateEnabled();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/liveEdit/LiveEditConfigurableUi$1", "actionPerformed"));
            }
        };
        this.updateNodeCheckbox.addActionListener(enabledUpdater);
        this.updateChromeCheckbox.addActionListener(enabledUpdater);
        this.updateEnabled();
    }

    private JCheckBox addCheckboxWithTip(@PropertyKey(resourceBundle="messages.LiveEditBundle") @PropertyKey(resourceBundle="messages.LiveEditBundle") String messageKey, @PropertyKey(resourceBundle="messages.LiveEditBundle") @PropertyKey(resourceBundle="messages.LiveEditBundle") String tipKey) {
        JCheckBox checkBox = new JCheckBox(LiveEditBundle.message(messageKey, new Object[0]));
        checkBox.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.panel.add(checkBox);
        JLabel elementHighlightingTip = new JLabel(LiveEditBundle.message(tipKey, new Object[0]));
        elementHighlightingTip.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        elementHighlightingTip.setForeground(UIUtil.getLabelDisabledForeground());
        int elementHighlightingOffset = UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)checkBox);
        if (elementHighlightingOffset == 0) {
            elementHighlightingOffset = 20;
        }
        elementHighlightingTip.setBorder((Border)JBUI.Borders.emptyLeft((int)elementHighlightingOffset));
        this.panel.add(elementHighlightingTip);
        return checkBox;
    }

    private static JBIntSpinner createDelaySpinner() {
        JBIntSpinner spinner = new JBIntSpinner(300, 0, 60000);
        ((SpinnerNumberModel)spinner.getModel()).setStepSize(50);
        return spinner;
    }

    private void updateEnabled() {
        this.updateNodeAutoDelaySpinner.setEnabled(this.updateNodeCheckbox.isSelected());
        this.updateChromeAutoDelaySpinner.setEnabled(this.updateChromeCheckbox.isSelected());
        this.updateHtmlAndCss.setEnabled(this.updateChromeCheckbox.isSelected());
        this.updateHtmlCssAndJs.setEnabled(this.updateChromeCheckbox.isSelected());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            LiveEditConfigurableUi.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private boolean isNodeAutoUpdate() {
        return this.updateNodeCheckbox.isSelected();
    }

    private int getNodeAutoDelay() {
        Object value = this.updateNodeAutoDelaySpinner.getValue();
        return value instanceof Number ? ((Number)value).intValue() : StringUtilRt.parseInt((String)((String)value), (int)600);
    }

    private boolean isChromeUpdateOnChanges() {
        return this.updateChromeCheckbox.isSelected();
    }

    private int getChromeAutoDelay() {
        Object value = this.updateChromeAutoDelaySpinner.getValue();
        return value instanceof Number ? ((Number)value).intValue() : StringUtilRt.parseInt((String)((String)value), (int)600);
    }

    private boolean isElementHighlighting() {
        return this.elementHighlightingCheckBox.isSelected();
    }

    private boolean isRestartIfHotSwapFailed() {
        return this.restartIfHotSwapFailedCheckBox.isSelected();
    }

    public void reset(@NotNull LiveEditOptions options) {
        if (options == null) {
            LiveEditConfigurableUi.$$$reportNull$$$0(1);
        }
        this.updateNodeCheckbox.setSelected(options.isNodeUpdateOnChanges());
        this.updateNodeAutoDelaySpinner.setValue(options.getNodeAutoDelay());
        this.updateChromeCheckbox.setSelected(options.isChromeUpdateOnChanges());
        this.updateChromeAutoDelaySpinner.setValue(options.getChromeAutoDelay());
        if (options.isChromeUpdateJSOnChanges()) {
            this.updateHtmlAndCss.setSelected(false);
            this.updateHtmlCssAndJs.setSelected(true);
        }
        this.updateFilesToCompileCheckBox.setSelected(options.isUpdateFilesToCompile());
        this.elementHighlightingCheckBox.setSelected(options.isElementHighlighting());
        this.restartIfHotSwapFailedCheckBox.setSelected(options.isRestartIfHotSwapFailed());
        this.updateEnabled();
    }

    public void apply(@NotNull LiveEditOptions options) {
        if (options == null) {
            LiveEditConfigurableUi.$$$reportNull$$$0(2);
        }
        options.setNodeUpdateOnChanges(this.isNodeAutoUpdate());
        options.setNodeAutoDelay(this.getNodeAutoDelay());
        options.setChromeUpdateOnChanges(this.isChromeUpdateOnChanges());
        options.setChromeAutoDelay(this.getChromeAutoDelay());
        options.setChromeUpdateJSOnChanges(this.updateHtmlCssAndJs.isSelected());
        options.setUpdateFilesToCompile(this.updateFilesToCompileCheckBox.isSelected());
        if (this.isElementHighlighting() != options.isElementHighlighting()) {
            options.setElementHighlighting(this.isElementHighlighting(), true);
        }
        options.setRestartIfHotSwapFailed(this.isRestartIfHotSwapFailed());
    }

    public boolean isModified(@NotNull LiveEditOptions options) {
        if (options == null) {
            LiveEditConfigurableUi.$$$reportNull$$$0(3);
        }
        return this.isNodeAutoUpdate() != options.isNodeUpdateOnChanges() || this.getNodeAutoDelay() != options.getNodeAutoDelay() || this.isChromeUpdateOnChanges() != options.isChromeUpdateOnChanges() || this.getChromeAutoDelay() != options.getChromeAutoDelay() || this.updateHtmlCssAndJs.isSelected() != options.isChromeUpdateJSOnChanges() || this.updateFilesToCompileCheckBox.isSelected() != options.isUpdateFilesToCompile() || this.isElementHighlighting() != options.isElementHighlighting() || this.isRestartIfHotSwapFailed() != options.isRestartIfHotSwapFailed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/LiveEditConfigurableUi";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/LiveEditConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

