/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.xcspec;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import com.jetbrains.cidr.xcode.xcspec.XCSpecDomainComposition;
import com.jetbrains.cidr.xcode.xcspec.XCSpecFile;
import com.jetbrains.cidr.xcode.xcspec.XCSpecProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XcodeExtensionsManager {
    private static final Pattern XCPLUGINDATA_PATTERN = Pattern.compile(".*\\.xcplugindata");
    private final Map<String, List<XCSpecProvider>> myXCSpecProviderMap = new HashMap<String, List<XCSpecProvider>>();
    private final Map<String, List<String>> myDomainCompositionMap = new HashMap<String, List<String>>();
    private final Map<String, Dictionary> myExtendedPlatformInfoMap = new HashMap<String, Dictionary>();

    public XcodeExtensionsManager() {
        this(true);
    }

    protected XcodeExtensionsManager(boolean mayStartProcessing) {
        if (mayStartProcessing) {
            this.init();
        }
    }

    protected void init() {
        for (File xcPluginDataFile : XcodeExtensionsManager.collectXCPluginDataFiles(XcodeBase.getInstance().getInstallation())) {
            try {
                List extensions = PlistDriver.readAnyFormat((File)xcPluginDataFile).getDictionary("plug-in", Dictionary.EMPTY_DICTIONARY).getDictionary("extensions", Dictionary.EMPTY_DICTIONARY).getObjects(Dictionary.class);
                for (Dictionary extension : extensions) {
                    String point = extension.getString("point");
                    if (point == null || this.processPluginExtension(point, extension, xcPluginDataFile) != Boolean.FALSE) continue;
                }
            }
            catch (InvalidSpecException | IOException e) {
                XCLog.LOG.warn(e);
            }
        }
    }

    @Nullable
    protected Boolean processPluginExtension(@NotNull String point, @NotNull Dictionary extensionDictionary, @NotNull File xcPluginDataFile) {
        if (point == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(0);
        }
        if (extensionDictionary == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(1);
        }
        if (xcPluginDataFile == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(2);
        }
        try {
            switch (point) {
                case "Xcode.XCSpecProvider": {
                    this.cacheXCSpecProvider(extensionDictionary, xcPluginDataFile.getParent().intern());
                    return true;
                }
                case "Xcode.XCSpecDomainComposition": {
                    this.cacheDomainComposition(extensionDictionary);
                    return true;
                }
                case "Xcode.IDEFoundation.ExtendedPlatformInfo": {
                    this.myExtendedPlatformInfoMap.put(extensionDictionary.getNotNullString("platform"), extensionDictionary);
                    return true;
                }
            }
        }
        catch (InvalidSpecException e) {
            XCLog.LOG.warn((Throwable)e);
            return true;
        }
        return null;
    }

    @NotNull
    public static XcodeExtensionsManager getInstance() {
        XcodeExtensionsManager xcodeExtensionsManager = (XcodeExtensionsManager)ApplicationManager.getApplication().getService(XcodeExtensionsManager.class);
        if (xcodeExtensionsManager == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(3);
        }
        return xcodeExtensionsManager;
    }

    @NotNull
    public List<XCSpecFile> getXCSpecFileList(@NotNull String domain) {
        if (domain == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(4);
        }
        ArrayList<XCSpecFile> result = new ArrayList<XCSpecFile>();
        LinkedHashSet<String> domains = new LinkedHashSet<String>();
        domains.add(domain);
        domains.addAll(this.getAllCompositionDomains(domain));
        for (String curDomain : domains) {
            List<XCSpecProvider> providers = this.myXCSpecProviderMap.get(curDomain);
            if (providers == null) continue;
            for (XCSpecProvider provider : providers) {
                for (String file : provider.getFiles()) {
                    result.add(new XCSpecFile(Path.of(file, new String[0]), curDomain));
                }
            }
        }
        ArrayList<XCSpecFile> arrayList = result;
        if (arrayList == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getCompositionDomains(@NotNull String domain) {
        List<String> domains;
        if (domain == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(6);
        }
        List<String> list = (domains = this.myDomainCompositionMap.get(domain)) != null ? Collections.unmodifiableList(domains) : ContainerUtil.emptyList();
        if (list == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<String> getAllCompositionDomains(@NotNull String domain) {
        if (domain == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(8);
        }
        LinkedHashSet<String> domains = new LinkedHashSet<String>();
        LinkedList<String> domainsToProcess = new LinkedList<String>();
        domainsToProcess.addLast(domain);
        while (!domainsToProcess.isEmpty()) {
            String curDomain = (String)domainsToProcess.removeFirst();
            for (String newDomain : this.getCompositionDomains(curDomain)) {
                if (!domains.add(newDomain)) continue;
                domainsToProcess.addFirst(newDomain);
            }
        }
        domains.add("default");
        List<String> list = List.copyOf(domains);
        if (list == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public String getExtendedPlatformInfo(@NotNull String platformId, @NotNull String key) {
        Dictionary dictionary;
        if (platformId == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(10);
        }
        if (key == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(11);
        }
        return (dictionary = this.myExtendedPlatformInfoMap.get(platformId)) == null ? null : dictionary.getString(key);
    }

    @NotNull
    private static Collection<File> collectXCPluginDataFiles(@NotNull XcodeInstallation installation) {
        if (installation == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(12);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File file : installation.getXcodePluginsFolders()) {
            File[] plugins = file.listFiles();
            if (plugins == null) continue;
            for (File plugin : plugins) {
                result.addAll(FileUtil.findFilesByMask((Pattern)XCPLUGINDATA_PATTERN, (File)new File(plugin, "Contents/Resources")));
                result.addAll(FileUtil.findFilesByMask((Pattern)XCPLUGINDATA_PATTERN, (File)new File(plugin, "Resources")));
            }
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private void cacheXCSpecProvider(@NotNull Dictionary extension, @NotNull String pluginContentPath) {
        if (extension == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(14);
        }
        if (pluginContentPath == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(15);
        }
        XCSpecProvider provider = new XCSpecProvider(extension, pluginContentPath);
        List xcSpecProviderList = this.myXCSpecProviderMap.computeIfAbsent(provider.getDomain(), domain -> new ArrayList());
        xcSpecProviderList.add(provider);
    }

    private void cacheDomainComposition(@NotNull Dictionary extension) throws InvalidSpecException {
        if (extension == null) {
            XcodeExtensionsManager.$$$reportNull$$$0(16);
        }
        XCSpecDomainComposition composition = new XCSpecDomainComposition(extension);
        List includeDomainList = this.myDomainCompositionMap.computeIfAbsent(composition.getDomain(), domain -> new ArrayList());
        includeDomainList.addAll(composition.getIncludedDomains());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionDictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xcPluginDataFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/xcspec/XcodeExtensionsManager";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installation";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginContentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/xcspec/XcodeExtensionsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXCSpecFileList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositionDomains";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCompositionDomains";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectXCPluginDataFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processPluginExtension";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getXCSpecFileList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCompositionDomains";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllCompositionDomains";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedPlatformInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectXCPluginDataFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cacheXCSpecProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cacheDomainComposition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 9, 13 -> new IllegalStateException(string);
        };
    }
}

