/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.xcspec;

import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XCSpecProvider {
    public static final String XCODE_EP_NAME = "Xcode.XCSpecProvider";
    @NotNull
    private String myDomain;
    @NotNull
    private List<String> myFiles;

    public XCSpecProvider(@NotNull Dictionary dictionary, @NotNull String pluginPath) throws InvalidSpecException {
        if (dictionary == null) {
            XCSpecProvider.$$$reportNull$$$0(0);
        }
        if (pluginPath == null) {
            XCSpecProvider.$$$reportNull$$$0(1);
        }
        if (!XCODE_EP_NAME.equals(dictionary.getString("point"))) {
            throw new InvalidSpecException("unexpected plist format: " + String.valueOf(dictionary));
        }
        this.myDomain = dictionary.getString("domain", "");
        if (this.myDomain.isEmpty()) {
            this.myDomain = "default";
        }
        this.myFiles = new ArrayList<String>();
        for (Dictionary file : dictionary.getAttributeList("file", Dictionary.class, Collections.emptyList())) {
            String name = file.getString("name");
            if (name != null) {
                this.myFiles.add(pluginPath + "/" + name);
                continue;
            }
            throw new InvalidSpecException("unexpected plist format: " + String.valueOf(dictionary));
        }
    }

    @NotNull
    public String getDomain() {
        String string = this.myDomain;
        if (string == null) {
            XCSpecProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<String> getFiles() {
        List<String> list = this.myFiles;
        if (list == null) {
            XCSpecProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/xcspec/XCSpecProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/xcspec/XCSpecProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomain";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

