/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.xcspec;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XCSpecDomainComposition {
    public static final String XCODE_EP_NAME = "Xcode.XCSpecDomainComposition";
    @NotNull
    private String myDomain;
    @NotNull
    private List<String> myIncludedDomains;

    public XCSpecDomainComposition(@NotNull Dictionary dictionary) throws InvalidSpecException {
        if (dictionary == null) {
            XCSpecDomainComposition.$$$reportNull$$$0(0);
        }
        if (!XCODE_EP_NAME.equals(dictionary.getString("point"))) {
            throw new InvalidSpecException("unexpected plist format: " + String.valueOf(dictionary));
        }
        this.myDomain = dictionary.getString("domain", "");
        if (StringUtil.isEmptyOrSpaces((String)this.myDomain)) {
            throw new InvalidSpecException("unexpected plist format: " + String.valueOf(dictionary));
        }
        this.myIncludedDomains = new ArrayList<String>();
        for (Dictionary file : dictionary.getAttributeList("include", Dictionary.class, Collections.emptyList())) {
            String name = file.getString("domain");
            if (name != null) {
                this.myIncludedDomains.add(name);
                continue;
            }
            throw new InvalidSpecException("unexpected plist format: " + String.valueOf(dictionary));
        }
    }

    @NotNull
    public String getDomain() {
        String string = this.myDomain;
        if (string == null) {
            XCSpecDomainComposition.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<String> getIncludedDomains() {
        List<String> list = this.myIncludedDomains;
        if (list == null) {
            XCSpecDomainComposition.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/xcspec/XCSpecDomainComposition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/xcspec/XCSpecDomainComposition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomain";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedDomains";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

