/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.pbxproj;

import com.intellij.util.JdomKt;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.NSPbxParser;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.plist.XMLPlistDriverImpl;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XMLPbxParser
extends XMLPlistDriverImpl<PBXDictionary> {
    private final boolean isPbxUserFile;
    private final CharSequence myText;
    private final PBXProjectFile myProjectFile;
    private final LinkedHashMap<PbxId, PBXObject> myFinalObjectsMap;
    private int myDepth = 0;
    private boolean isReadingObjectsSection = false;
    private final LinkedHashMap<PbxId, PBXObject> myObjectsMap = PBXProjectFile.createObjectsMap();

    XMLPbxParser(CharSequence text, boolean pbxuserFile, PBXProjectFile file, LinkedHashMap<PbxId, PBXObject> objectsMap) {
        this.isPbxUserFile = pbxuserFile;
        this.myText = text;
        this.myProjectFile = file;
        this.myFinalObjectsMap = objectsMap;
    }

    @NotNull
    public PBXDictionary parseFile() throws IOException, IllegalStateException {
        PBXDictionary result = (PBXDictionary)this.doRead(new XMLPlistDriverImpl.ElementLoader(){

            @NotNull
            public Element loadElement() throws JDOMException, IOException {
                Element element = JdomKt.loadElementAndKeepBoundaryWhitespace((CharSequence)XMLPbxParser.this.myText);
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/pbxproj/XMLPbxParser$1", "loadElement"));
            }
        });
        NSPbxParser.initObjectReferences((Object)result, this.myProjectFile, this.myObjectsMap);
        this.myFinalObjectsMap.putAll(this.myObjectsMap);
        PBXDictionary pBXDictionary = result;
        if (pBXDictionary == null) {
            XMLPbxParser.$$$reportNull$$$0(0);
        }
        return pBXDictionary;
    }

    @NotNull
    protected PBXDictionary createDict() {
        return new PBXDictionary(this.myProjectFile);
    }

    @NotNull
    protected PBXDictionary readDict(@NotNull String key, @NotNull Element dictElement) {
        if (key == null) {
            XMLPbxParser.$$$reportNull$$$0(1);
        }
        if (dictElement == null) {
            XMLPbxParser.$$$reportNull$$$0(2);
        }
        ++this.myDepth;
        boolean isThisObjectSession = false;
        if (!this.isPbxUserFile && this.myDepth == 2 && "objects".equals(key)) {
            isThisObjectSession = true;
            this.isReadingObjectsSection = true;
        }
        PBXDictionary result = (PBXDictionary)super.readDict(key, dictElement);
        if (this.myDepth == 3 && this.isReadingObjectsSection) {
            result = NSPbxParser.convertToObject(result, PbxId.fromString(key), PBXObject.getKind(result), this.myProjectFile, this.myObjectsMap);
        }
        if (isThisObjectSession) {
            this.isReadingObjectsSection = false;
        }
        --this.myDepth;
        PBXDictionary pBXDictionary = result;
        if (pBXDictionary == null) {
            XMLPbxParser.$$$reportNull$$$0(3);
        }
        return pBXDictionary;
    }

    @Nullable
    protected Object readBasicValue(@NotNull String type, @NotNull Element valueElement) {
        Object result;
        if (type == null) {
            XMLPbxParser.$$$reportNull$$$0(4);
        }
        if (valueElement == null) {
            XMLPbxParser.$$$reportNull$$$0(5);
        }
        return (result = super.readBasicValue(type, valueElement)) == null ? null : result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/pbxproj/XMLPbxParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/pbxproj/XMLPbxParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readDict";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readDict";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readBasicValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

