/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.pbxproj;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public final class PbxWriter {
    public static final Pattern QUOTED_VALUE_PATTERN = Pattern.compile("[\\w\\./$]+");
    private int indent = 0;
    private int indentsToWrite = 0;
    private final StringBuilder myBuilder = new StringBuilder();
    private static final Set<@NonNls String> myInlineSections = Set.of("PBXFileReference", "PBXBuildFile");

    private void indent() {
        ++this.indent;
        this.indentsToWrite = this.indent;
    }

    private void unindent() {
        --this.indent;
        this.indentsToWrite = this.indent;
    }

    private void rawWrite(@NonNls String str) {
        this.myBuilder.append(str);
    }

    private void write(@NonNls String str) {
        StringTokenizer t = new StringTokenizer(str, "\n", true);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if ("\n".equals(token)) {
                this.indentsToWrite = this.indent;
            } else {
                for (int i = 0; i < this.indentsToWrite; ++i) {
                    this.rawWrite("\t");
                }
                this.indentsToWrite = 0;
            }
            this.rawWrite(token);
        }
    }

    public String getResult() {
        return this.myBuilder.toString();
    }

    public void write(PBXProjectFile file) {
        this.write("// !$*UTF8*$!\n");
        this.write("{\n");
        this.indent();
        this.write("archiveVersion = " + file.getArchiveVersion() + ";\n");
        this.write("classes = {\n};\n");
        this.write("objectVersion = " + file.getObjectVersion() + ";\n");
        this.write("objects = {\n");
        this.writeSections(file);
        this.write("};\n");
        this.write("rootObject = " + PbxWriter.refText(file.getProjectObject(), false) + ";\n");
        this.unindent();
        this.write("}\n");
    }

    private static String refText(PBXObject obj, boolean debug) {
        String comment = debug ? null : obj.getComment();
        return PbxWriter.encodeName(obj.getId().asString()) + (String)(comment == null ? "" : " /* " + comment + " */");
    }

    private void writeSections(PBXProjectFile file) {
        MultiMap sections = new MultiMap();
        for (PBXObject object : file.getObjects()) {
            String kind = object.getKind();
            if (kind == null) {
                throw new RuntimeException("Unknown object: " + object.getDebugString());
            }
            sections.putValue((Object)kind, (Object)object);
        }
        ArrayList sectionsSorted = new ArrayList(sections.keySet());
        Collections.sort(sectionsSorted);
        for (String section : sectionsSorted) {
            this.rawWrite("\n/* Begin ");
            this.rawWrite(section);
            this.rawWrite(" section */\n");
            ArrayList<PBXObject> sortedObjects = new ArrayList<PBXObject>(sections.get((Object)section));
            sortedObjects.sort(PBXObject.ID_COMPARATOR);
            this.indent();
            for (PBXObject object : sortedObjects) {
                this.writeObject(object, false);
            }
            this.unindent();
            this.rawWrite("/* End ");
            this.rawWrite(section);
            this.rawWrite(" section */\n");
        }
    }

    public void writeObject(PBXObject object, boolean debug) {
        this.write(PbxWriter.refText(object, debug));
        this.write(" = ");
        this.writeObjectBody(object, debug);
        this.write(";\n");
    }

    private void writeObjectBody(PBXObject object, boolean debug) {
        String kind = object.getKind();
        boolean inline = kind == null || myInlineSections.contains(kind);
        this.writeObjectBody(object, inline, debug);
    }

    private void writeObjectBody(PBXObject object, boolean inline, boolean debug) {
        ArrayList attributes;
        boolean hasIsa;
        this.write("{");
        if (!inline) {
            this.write("\n");
            this.indent();
        }
        if (hasIsa = (attributes = new ArrayList(object.keySet())).remove("isa")) {
            this.writeAttribute(object, "isa", inline, debug);
        }
        Collections.sort(attributes);
        for (String attribute : attributes) {
            this.writeAttribute(object, attribute, inline, debug);
        }
        if (!inline) {
            this.unindent();
        }
        this.write("}");
    }

    private void writeAttribute(PBXObject object, @NonNls String attributeName, boolean inline, boolean debug) {
        this.write(PbxWriter.encodeName(attributeName));
        this.write(" = ");
        boolean resolveObjects = true;
        if ("remoteGlobalIDString".equals(attributeName) || object instanceof PBXProject && "attributes".equals(attributeName)) {
            resolveObjects = false;
        }
        this.writeValue(object.get(attributeName), inline, resolveObjects, debug);
        this.write(";");
        if (inline) {
            this.write(" ");
        } else {
            this.write("\n");
        }
    }

    private void writeValue(Object value, boolean inline, boolean resolveObjects, boolean debug) {
        if (value instanceof String) {
            String raw = (String)value;
            this.write(PbxWriter.encodeName(raw));
        } else if (value instanceof ObjectReference) {
            PBXObject pbxObject = ((ObjectReference)value).resolveObject();
            if (pbxObject != null && resolveObjects) {
                this.write(PbxWriter.refText(pbxObject, debug));
            } else {
                this.write(((ObjectReference)value).getId().asString());
            }
        } else if (value instanceof PBXObject) {
            this.writeObjectBody((PBXObject)((Object)value), inline, debug);
        } else if (value instanceof Collection) {
            this.write("(");
            if (!inline) {
                this.indent();
                this.write("\n");
            }
            for (Object item : (Collection)value) {
                this.writeValue(item, inline, resolveObjects, debug);
                this.write(",");
                if (inline) {
                    this.write(" ");
                    continue;
                }
                this.write("\n");
            }
            if (!inline) {
                this.unindent();
            }
            this.write(")");
        } else if (value instanceof Map) {
            this.write("{");
            if (!inline) {
                this.indent();
                this.write("\n");
            }
            Map map = (Map)value;
            ArrayList keys = new ArrayList(map.keySet());
            ContainerUtil.sort(keys);
            for (String key : keys) {
                this.write(PbxWriter.encodeName(key));
                this.write(" = ");
                this.writeValue(map.get(key), inline, resolveObjects, debug);
                this.write(";");
                if (inline) {
                    this.write(" ");
                    continue;
                }
                this.write("\n");
            }
            if (!inline) {
                this.unindent();
            }
            this.write("}");
        }
    }

    private static String encodeName(String raw) {
        if (QUOTED_VALUE_PATTERN.matcher(raw).matches() && !raw.contains("___")) {
            return raw;
        }
        int length = raw.length();
        return "\"" + String.valueOf(StringUtil.escapeStringCharacters((int)length, (String)raw, (String)"\"", (boolean)true, (boolean)false, (StringBuilder)new StringBuilder(length + 42))) + "\"";
    }
}

