/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.pbxproj;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Random;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PbxId {
    private static final String USER_PREFIX = StringUtil.toUpperCase((String)StringUtil.first((String)Integer.toHexString(SystemProperties.getUserName().hashCode()), (int)5, (boolean)false));
    @NonNls
    private static final String CHARS = "0123456789ABCDEF";
    private static final Random RANDOM = new Random();
    public static final PbxId NONE = PbxId.fromString("");
    public static final Comparator<PbxId> COMPARATOR = (o1, o2) -> {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        String s1 = o1.asString();
        String s2 = o2.asString();
        int n1 = s1.length();
        int n2 = s2.length();
        int min = Math.min(n1, n2);
        for (int i = 0; i < min; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) continue;
            if (c1 == '_') {
                return 1;
            }
            if (c2 == '_') {
                return -1;
            }
            return c1 - c2;
        }
        return n1 - n2;
    };
    @NotNull
    private final String text;

    private PbxId(@NotNull String text) {
        if (text == null) {
            PbxId.$$$reportNull$$$0(0);
        }
        this.text = text;
    }

    public static PbxId fromString(@NotNull String text) {
        if (text == null) {
            PbxId.$$$reportNull$$$0(1);
        }
        return new PbxId(text);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PbxId)) {
            return false;
        }
        return this.text.equals(((PbxId)o).text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @NotNull
    public String asString() {
        String string = this.text;
        if (string == null) {
            PbxId.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String toString() {
        return this.text;
    }

    public PbxId nextUniqueId() {
        return PbxId.fromString(StringUtil.toUpperCase((String)new BigInteger(this.text, 16).add(BigInteger.valueOf(1L)).toString(16)));
    }

    public static PbxId newUniqueId() {
        StringBuilder sb = new StringBuilder();
        sb.append(USER_PREFIX);
        int remaining = 24 - sb.length();
        for (int i = 0; i < remaining; ++i) {
            sb.append(CHARS.charAt(RANDOM.nextInt(CHARS.length())));
        }
        return PbxId.fromString(sb.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/pbxproj/PbxId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/pbxproj/PbxId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

