/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.pbxproj;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.xcode.SpecParser;
import com.jetbrains.cidr.xcode.SpecParsingException;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFactory;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.pbxproj.PbxLexer;
import com.jetbrains.cidr.xcode.pbxproj.PbxTokenType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NSPbxParser
extends SpecParser {
    private final boolean myPbxuserFile;
    private final PbxLexer myLexer;
    private final PBXProjectFile myFile;
    private final LinkedHashMap<PbxId, PBXObject> myFinalObjectsMap;
    private final LinkedHashMap<PbxId, PBXObject> myObjectsMap = PBXProjectFile.createObjectsMap();
    private int myDepth = 0;

    NSPbxParser(CharSequence text, boolean pbxuserFile, PBXProjectFile file, LinkedHashMap<PbxId, PBXObject> objectsMap) {
        this.myPbxuserFile = pbxuserFile;
        this.myLexer = new PbxLexer();
        this.myLexer.start(text);
        this.myFile = file;
        this.myFinalObjectsMap = objectsMap;
    }

    public PBXDictionary parseFile() {
        if (this.myLexer.getTokenType() != PbxTokenType.LBRACE) {
            this.myLexer.nextToken();
        }
        PBXDictionary result = this.parseObject(this.myPbxuserFile);
        if (this.myLexer.getTokenType() != null) {
            throw new SpecParsingException("Cannot parse to the end of file");
        }
        NSPbxParser.initObjectReferences((Object)result, this.myFile, this.myObjectsMap);
        this.myFinalObjectsMap.putAll(this.myObjectsMap);
        return result;
    }

    @NotNull
    static Object initObjectReferences(@NotNull Object object, @NotNull PBXProjectFile projectFile, @NotNull Map<PbxId, PBXObject> objects) {
        if (object == null) {
            NSPbxParser.$$$reportNull$$$0(0);
        }
        if (projectFile == null) {
            NSPbxParser.$$$reportNull$$$0(1);
        }
        if (objects == null) {
            NSPbxParser.$$$reportNull$$$0(2);
        }
        if (object instanceof String) {
            PbxId id = PbxId.fromString((String)object);
            if (objects.containsKey(id)) {
                return new ObjectReference(id, projectFile);
            }
        } else if (object instanceof PBXDictionary) {
            for (Map.Entry each : ((PBXDictionary)((Object)object)).entrySet()) {
                if ("name".equals(each.getKey())) continue;
                each.setValue(NSPbxParser.initObjectReferences(each.getValue(), projectFile, objects));
            }
        } else if (object instanceof ArrayList) {
            ArrayList list = (ArrayList)object;
            list.replaceAll(e -> NSPbxParser.initObjectReferences(e, projectFile, objects));
        }
        Object object2 = object;
        if (object2 == null) {
            NSPbxParser.$$$reportNull$$$0(3);
        }
        return object2;
    }

    private PBXDictionary parseObject(boolean isObjectsSection) {
        NSPbxParser.expectAndNext((PbxLexer)this.myLexer, (IElementType[])new IElementType[]{PbxTokenType.LBRACE});
        ++this.myDepth;
        PBXDictionary result = new PBXDictionary(this.myFile);
        while (this.myLexer.getTokenType() != PbxTokenType.RBRACE) {
            this.parseAttribute(result, isObjectsSection);
        }
        --this.myDepth;
        NSPbxParser.expectAndNext((PbxLexer)this.myLexer, (IElementType[])new IElementType[]{PbxTokenType.RBRACE});
        return result;
    }

    private void parseAttribute(PBXDictionary answer, boolean isObject) {
        String key;
        PbxId id = null;
        IElementType tt = this.myLexer.getTokenType();
        if (tt == PbxTokenType.VALUE || tt == PbxTokenType.STRING_LITERAL) {
            key = this.myLexer.getTokenText();
            if (tt == PbxTokenType.STRING_LITERAL) {
                key = StringUtil.unescapeStringCharacters((String)key.substring(1, key.length() - 1));
            }
            if (isObject) {
                id = PbxId.fromString(key);
            }
        } else {
            throw NSPbxParser.error((PbxLexer)this.myLexer, (String)"Object attribute key expected");
        }
        this.myLexer.nextTokenOrComment();
        if (this.myLexer.getTokenType() == PbxTokenType.COMMENT) {
            if (isObject) {
                this.myLexer.getTokenText();
            }
            this.myLexer.nextToken();
        }
        NSPbxParser.expectAndNext((PbxLexer)this.myLexer, (IElementType[])new IElementType[]{PbxTokenType.EQ});
        Object value = this.parseValue(!this.myPbxuserFile && this.myDepth == 1 && "objects".equals(key), isObject);
        NSPbxParser.expectAndNext((PbxLexer)this.myLexer, (IElementType[])new IElementType[]{PbxTokenType.SEMICOLON});
        if (isObject && value instanceof PBXDictionary) {
            PBXDictionary dict = (PBXDictionary)((Object)value);
            value = NSPbxParser.convertToObject(dict, id, PBXObject.getKind(dict), this.myFile, this.myObjectsMap);
        }
        answer.setAttribute(key, value);
    }

    @NotNull
    public static PBXObject convertToObject(@NotNull PBXDictionary from, @Nullable PbxId id, @Nullable @NonNls String kind, @NotNull PBXProjectFile file, @NotNull Map<PbxId, PBXObject> addTo) {
        PBXObject result;
        if (from == null) {
            NSPbxParser.$$$reportNull$$$0(4);
        }
        if (file == null) {
            NSPbxParser.$$$reportNull$$$0(5);
        }
        if (addTo == null) {
            NSPbxParser.$$$reportNull$$$0(6);
        }
        PBXObject pBXObject = result = kind == null ? new PBXObject(file) : PBXFactory.createObject(kind, file);
        if (!from.isEmpty()) {
            result.putAll((Map)((Object)from));
        }
        if (id != null) {
            result.setId(id);
            addTo.put(id, result);
        }
        PBXObject pBXObject2 = result;
        if (pBXObject2 == null) {
            NSPbxParser.$$$reportNull$$$0(7);
        }
        return pBXObject2;
    }

    private Object parseValue(boolean isObjectSection, boolean isObject) {
        IElementType tt = this.myLexer.getTokenType();
        if (tt == PbxTokenType.LBRACE) {
            return this.parseObject(isObjectSection);
        }
        if (!isObject) {
            if (tt == PbxTokenType.LPAR) {
                return this.parseList();
            }
            if (tt == PbxTokenType.VALUE) {
                String result = this.myLexer.getTokenText();
                this.myLexer.nextToken();
                return result;
            }
            if (tt == PbxTokenType.STRING_LITERAL) {
                String text = this.myLexer.getTokenText();
                this.myLexer.nextToken();
                try {
                    return StringUtil.unescapeStringCharacters((String)text.substring(1, text.length() - 1));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw NSPbxParser.error((PbxLexer)this.myLexer, (String)("cannot unescape string: " + text));
                }
            }
        }
        throw NSPbxParser.error((PbxLexer)this.myLexer, (String)"Cannot parse value, unexpected token type");
    }

    private Object parseList() {
        NSPbxParser.expectAndNext((PbxLexer)this.myLexer, (IElementType[])new IElementType[]{PbxTokenType.LPAR});
        ArrayList<Object> answer = new ArrayList<Object>();
        while (this.myLexer.getTokenType() != PbxTokenType.RPAR) {
            answer.add(this.parseValue(false, false));
            if (this.myLexer.getTokenType() != PbxTokenType.COMMA) continue;
            this.myLexer.nextToken();
        }
        NSPbxParser.expectAndNext((PbxLexer)this.myLexer, (IElementType[])new IElementType[]{PbxTokenType.RPAR});
        return answer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/pbxproj/NSPbxParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/pbxproj/NSPbxParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initObjectReferences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initObjectReferences";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

