/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.util.io.DigestUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class XcodeProjectsUtil {
    private static final Pattern ESCAPE_WHITESPACES_PATTERN = Pattern.compile("\\s+");

    private XcodeProjectsUtil() {
    }

    @NotNull
    public static String getEscapedProjectName(@NotNull String projectName) {
        if (projectName == null) {
            XcodeProjectsUtil.$$$reportNull$$$0(0);
        }
        String string = ESCAPE_WHITESPACES_PATTERN.matcher(projectName).replaceAll("_");
        if (string == null) {
            XcodeProjectsUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getUniqueProjectHash(@NotNull String fullPath) {
        if (fullPath == null) {
            XcodeProjectsUtil.$$$reportNull$$$0(2);
        }
        char[] resultStr = new char[28];
        byte[] c_path = fullPath.getBytes(StandardCharsets.UTF_8);
        byte[] digest = DigestUtil.md5().digest(c_path);
        BigInteger b26 = BigInteger.valueOf(26L);
        BigInteger startValue = XcodeProjectsUtil.fromDigest(digest, 8, 16);
        for (int index = 27; index >= 0; --index) {
            resultStr[index] = (char)(startValue.remainder(b26).byteValue() + 97);
            startValue = startValue.divide(b26);
            if (index != 14) continue;
            startValue = XcodeProjectsUtil.fromDigest(digest, 0, 8);
        }
        return new String(resultStr);
    }

    private static BigInteger fromDigest(byte[] digest, int from, int to) {
        return new BigInteger(1, Arrays.copyOfRange(digest, from, to));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/XcodeProjectsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/XcodeProjectsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEscapedProjectName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueProjectHash";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

