/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.xcode.model.XcodeProjectEvent;
import com.jetbrains.cidr.xcode.model.XcodeProjectListener;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class XcodeProjectTrackers {
    private static final Topic<XcodeProjectListener> TOPIC = Topic.create((String)"Xcode Project modifications", XcodeProjectListener.class);
    private final SimpleModificationTracker myProjectsTracker;
    private final SimpleModificationTracker myTargetsTracker;
    private final SimpleModificationTracker myReferencesTracker;
    private final SimpleModificationTracker myBuildFilesTracker;
    private final SimpleModificationTracker myBuildSettingsTracker;
    private final SimpleModificationTracker myBuildsTracker;
    private final SimpleModificationTracker myWorkspaceStateTracker;
    private final Project myProject;

    public static XcodeProjectTrackers getInstance(@NotNull Project project) {
        if (project == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(0);
        }
        return (XcodeProjectTrackers)project.getService(XcodeProjectTrackers.class);
    }

    public XcodeProjectTrackers(@NotNull Project project) {
        if (project == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(1);
        }
        this.myProjectsTracker = new SimpleModificationTracker();
        this.myTargetsTracker = new SimpleModificationTracker();
        this.myReferencesTracker = new SimpleModificationTracker();
        this.myBuildFilesTracker = new SimpleModificationTracker();
        this.myBuildSettingsTracker = new SimpleModificationTracker();
        this.myBuildsTracker = new SimpleModificationTracker();
        this.myWorkspaceStateTracker = new SimpleModificationTracker();
        this.myProject = project;
    }

    public static void subscribe(@NotNull MessageBusConnection connection, @NotNull XcodeProjectListener listener) {
        if (connection == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(3);
        }
        connection.subscribe(TOPIC, (Object)listener);
    }

    public void switchedOpenContainer() {
        this.getPublisher().switchedOpenContainer();
    }

    public void workspaceInitialized() {
        this.getPublisher().workspaceInitialized();
    }

    public void workspaceLoaded() {
        this.getPublisher().workspaceLoaded();
    }

    public void workspaceChanged(@NotNull XcodeProjectEvent event) {
        if (event == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(4);
        }
        if (event.getProjectsChanged()) {
            this.myProjectsTracker.incModificationCount();
        }
        if (event.getTargetsChanged()) {
            this.myTargetsTracker.incModificationCount();
        }
        if (event.getReferencesChanged()) {
            this.myReferencesTracker.incModificationCount();
        }
        if (event.getBuildFilesChanged()) {
            this.myBuildFilesTracker.incModificationCount();
        }
        if (event.getBuildSettingsChanged()) {
            this.myBuildSettingsTracker.incModificationCount();
        }
        if (event.getWorkspaceStateChanged()) {
            this.myWorkspaceStateTracker.incModificationCount();
        }
        this.getPublisher().workspaceChanged(event);
    }

    public void buildFinished() {
        this.myBuildsTracker.incModificationCount();
        this.getPublisher().buildFinished();
    }

    @NotNull
    public ModificationTracker getProjectsTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myProjectsTracker;
        if (simpleModificationTracker == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(5);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getTargetsTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myTargetsTracker;
        if (simpleModificationTracker == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(6);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getReferencesTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myReferencesTracker;
        if (simpleModificationTracker == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(7);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getBuildFilesTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myBuildFilesTracker;
        if (simpleModificationTracker == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(8);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getBuildSettingsTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myBuildSettingsTracker;
        if (simpleModificationTracker == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(9);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getWorkspaceStateTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myWorkspaceStateTracker;
        if (simpleModificationTracker == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(10);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getBuildsTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myBuildsTracker;
        if (simpleModificationTracker == null) {
            XcodeProjectTrackers.$$$reportNull$$$0(11);
        }
        return simpleModificationTracker;
    }

    private XcodeProjectListener getPublisher() {
        return (XcodeProjectListener)this.myProject.getMessageBus().syncPublisher(TOPIC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/XcodeProjectTrackers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/XcodeProjectTrackers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsTracker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsTracker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesTracker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFilesTracker";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettingsTracker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaceStateTracker";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildsTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "workspaceChanged";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

