/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XCConfigurationList
extends PBXObject {
    public XCConfigurationList(PBXProjectFile file) {
        super(file);
    }

    @Override
    public String getComment() {
        PBXProjectFile projectFile = this.getFile();
        PBXProject projectObject = projectFile.getProjectObject();
        XCConfigurationList projectList = projectObject.getBuildConfigurationList();
        if (projectList == this) {
            return String.format("Build configuration list for PBXProject \"%s\"", projectFile.getName());
        }
        for (PBXTarget each : projectObject.getTargets()) {
            if (each.getBuildConfigurationList() != this) continue;
            return "Build configuration list for " + each.getKind() + " \"" + each.getName() + "\"";
        }
        return null;
    }

    @NotNull
    public List<XCBuildConfiguration> getConfigurations() {
        List<XCBuildConfiguration> list = this.resolveAttributeList("buildConfigurations", XCBuildConfiguration.class);
        if (list == null) {
            XCConfigurationList.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public XCBuildConfiguration getDefaultConfiguration() {
        XCBuildConfiguration result;
        String name = (String)this.getAttribute("defaultConfigurationName", String.class);
        if (name != null && (result = this.findConfiguration(name)) != null) {
            return result;
        }
        List<XCBuildConfiguration> all = this.getConfigurations();
        return all.isEmpty() ? null : all.get(0);
    }

    @Nullable
    public XCBuildConfiguration findConfiguration(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (XCBuildConfiguration each : this.getConfigurations()) {
            if (!each.getName().equals(name)) continue;
            return each;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/model/XCConfigurationList", "getConfigurations"));
    }
}

