/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XCConfigParser;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSetting;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.model.PBXAggregateTarget;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XcodeProjectEvent;
import com.jetbrains.cidr.xcode.model.XcodeProjectTrackers;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XCBuildConfiguration
extends PBXObject
implements BuildSettingValuesProvider,
UserDataHolderEx {
    @NonNls
    public static final String BUILD_SETTINGS_ATTRIBUTE = "buildSettings";
    @NotNull
    private final BuildSettingValuesProvider myXCConfigValuesProvider;
    @NotNull
    private final UserDataHolderEx myDataHolder;

    public XCBuildConfiguration(@NotNull PBXProjectFile file) {
        if (file == null) {
            XCBuildConfiguration.$$$reportNull$$$0(0);
        }
        super(file);
        this.myDataHolder = new UserDataHolderBase();
        this.myXCConfigValuesProvider = new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = XCConfigParser.parseFile(XCBuildConfiguration.this.getFile(), XCBuildConfiguration.this.getXCConfigFile());
                if (dictionary == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/model/XCBuildConfiguration$1", "getDeclaredBuildSettingValues"));
            }
        };
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.getNotNullString("name");
        if (string == null) {
            XCBuildConfiguration.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isDebug() {
        return StringUtil.containsIgnoreCase((String)this.getName(), (String)"debug");
    }

    @Nullable
    public XCBuildConfiguration getBaseConfiguration() {
        XCBuildConfiguration result = this.getFile().getProjectObject().findBuildConfiguration(this.getName());
        return result == this ? null : result;
    }

    @Deprecated
    @Nullable
    public PBXTarget getTarget() {
        List<PBXTarget> targets = this.getTargets();
        if (targets.isEmpty()) {
            return null;
        }
        if (targets.size() == 1) {
            return targets.get(0);
        }
        return targets.stream().filter(target -> !(target instanceof PBXAggregateTarget)).findFirst().orElse((PBXTarget)((Object)ContainerUtil.getFirstItem(targets)));
    }

    @NotNull
    public List<PBXTarget> getTargets() {
        List<PBXTarget> list = this.getFile().findTargetsFor(this);
        if (list == null) {
            XCBuildConfiguration.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getFile().getProject();
        if (project == null) {
            XCBuildConfiguration.$$$reportNull$$$0(3);
        }
        return project;
    }

    public boolean setBuildSetting(@Nullable BuildSetting setting) {
        return this.setBuildSetting(setting, true);
    }

    public boolean setBuildSetting(@Nullable BuildSetting setting, boolean fireNotifications) {
        boolean result = this.doSetBuildSetting(setting);
        if (result && fireNotifications) {
            this.notifyBuildSettingsChanged();
        }
        return result;
    }

    private boolean doSetBuildSetting(@Nullable BuildSetting setting) {
        if (setting == null) {
            return false;
        }
        Dictionary buildSettings = this.getDictionary(BUILD_SETTINGS_ATTRIBUTE, null);
        if (buildSettings == null) {
            buildSettings = new PBXDictionary(this.getFile());
            this.setAttribute(BUILD_SETTINGS_ATTRIBUTE, buildSettings);
        }
        boolean existed = setting.getUnresolvedValueSource() != null;
        boolean definedHere = setting.isDefinedIn(this);
        boolean modified = setting.isModified();
        String key = setting.getName();
        Object value = setting.getUnresolvedValue();
        setting.reset();
        if (!existed && !modified) {
            return false;
        }
        if (definedHere && !modified) {
            return false;
        }
        if (!definedHere && value == null && !buildSettings.containsKey((Object)key)) {
            return false;
        }
        buildSettings.setAttribute(key, value);
        return true;
    }

    private void notifyBuildSettingsChanged() {
        XcodeProjectTrackers.getInstance(this.getProject()).workspaceChanged(XcodeProjectEvent.BUILD_SETTINGS_CHANGED);
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.getDictionary(BUILD_SETTINGS_ATTRIBUTE, EMPTY_DICTIONARY);
        if (dictionary == null) {
            XCBuildConfiguration.$$$reportNull$$$0(4);
        }
        return dictionary;
    }

    @Nullable
    public VirtualFile getXCConfigFile() {
        PBXFileReference fileRef = this.getXCConfigFileReference();
        BuildSettingsProvider settingsProvider = this.getFile().getBuildSettingsProvider();
        if (fileRef != null) {
            return fileRef.findFile(settingsProvider);
        }
        RelativeXCConfigFileReference rel = this.getRelativeXCConfigFileReference();
        VirtualFile anchor = rel == null ? null : rel.anchorRef().findFile(settingsProvider);
        return anchor == null ? null : anchor.findFileByRelativePath(rel.relativePath());
    }

    @Nullable
    public String getXCConfigFilePath() {
        PBXFileReference fileRef = this.getXCConfigFileReference();
        BuildSettingsProvider settingsProvider = this.getFile().getBuildSettingsProvider();
        if (fileRef != null) {
            return fileRef.resolvePath(settingsProvider);
        }
        RelativeXCConfigFileReference rel = this.getRelativeXCConfigFileReference();
        String anchor = rel == null ? null : rel.anchorRef().resolvePath(settingsProvider);
        return anchor == null ? null : PBXReference.resolvePath(anchor, rel.relativePath());
    }

    @Nullable
    private PBXFileReference getXCConfigFileReference() {
        return this.resolveAttribute("baseConfigurationReference", PBXFileReference.class);
    }

    @Nullable
    private RelativeXCConfigFileReference getRelativeXCConfigFileReference() {
        String relativePath = this.getString("baseConfigurationReferenceRelativePath");
        PBXGroup anchorRef = relativePath == null ? null : this.resolveAttribute("baseConfigurationReferenceAnchor", PBXGroup.class);
        return anchorRef == null ? null : new RelativeXCConfigFileReference(relativePath, anchorRef);
    }

    @NotNull
    public BuildSettingValuesProvider getXCConfigBuildSettingValuesProvider() {
        BuildSettingValuesProvider buildSettingValuesProvider = this.myXCConfigValuesProvider;
        if (buildSettingValuesProvider == null) {
            XCBuildConfiguration.$$$reportNull$$$0(5);
        }
        return buildSettingValuesProvider;
    }

    @Override
    @NonNls
    public String toString() {
        List<PBXTarget> targets = this.getTargets();
        return (!targets.isEmpty() ? StringUtil.join(targets, target -> target.getName(), (String)",") : "(null)") + " - " + this.getName();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            XCBuildConfiguration.$$$reportNull$$$0(6);
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            XCBuildConfiguration.$$$reportNull$$$0(7);
        }
        this.myDataHolder.putUserData(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            XCBuildConfiguration.$$$reportNull$$$0(8);
        }
        return this.myDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            XCBuildConfiguration.$$$reportNull$$$0(9);
        }
        if (value == null) {
            XCBuildConfiguration.$$$reportNull$$$0(10);
        }
        Object object = this.myDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            XCBuildConfiguration.$$$reportNull$$$0(11);
        }
        return (T)object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/XCBuildConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/XCBuildConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXCConfigBuildSettingValuesProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 11 -> new IllegalStateException(string);
        };
    }

    private record RelativeXCConfigFileReference(@NotNull String relativePath, @NotNull PBXGroup anchorRef) {
        @NotNull
        private final String relativePath;
        @NotNull
        private final PBXGroup anchorRef;

        private RelativeXCConfigFileReference(@NotNull String relativePath, @NotNull PBXGroup anchorRef) {
            if (relativePath == null) {
                RelativeXCConfigFileReference.$$$reportNull$$$0(0);
            }
            if (anchorRef == null) {
                RelativeXCConfigFileReference.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String relativePath() {
            String string = this.relativePath;
            if (string == null) {
                RelativeXCConfigFileReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public PBXGroup anchorRef() {
            PBXGroup pBXGroup = this.anchorRef;
            if (pBXGroup == null) {
                RelativeXCConfigFileReference.$$$reportNull$$$0(3);
            }
            return pBXGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchorRef";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/XCBuildConfiguration$RelativeXCConfigFileReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/XCBuildConfiguration$RelativeXCConfigFileReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "relativePath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anchorRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

