/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.frameworks.AppleFileTypeManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXBuildRule;
import com.jetbrains.cidr.xcode.model.PBXContainerItem;
import com.jetbrains.cidr.xcode.model.PBXCopyFilesBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFileSystemSynchronizedRootGroup;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PBXTargetDependency;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCConfigurationList;
import com.jetbrains.cidr.xcode.model.XCSwiftPackageProductDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXTarget
extends PBXContainerItem {
    public static final PBXTarget[] EMPTY_ARRAY = new PBXTarget[0];

    public PBXTarget(PBXProjectFile file) {
        super(file);
    }

    public boolean isExecutable() {
        return false;
    }

    public boolean isTool() {
        return false;
    }

    public boolean isApplication() {
        return false;
    }

    public boolean isApplicationExtension() {
        return false;
    }

    public boolean isFramework() {
        return false;
    }

    public boolean isStaticLibrary() {
        return false;
    }

    public boolean isXCTestTests() {
        return false;
    }

    public boolean isXCUITestTests() {
        return false;
    }

    public boolean isAnyXCTestTests() {
        return this.isXCTestTests() || this.isXCUITestTests();
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = (String)this.getNotNullAttribute("name", String.class);
        if (string == null) {
            PBXTarget.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getProjectName() {
        String string = this.getFile().getName();
        if (string == null) {
            PBXTarget.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public String getProductName() {
        String string = (String)this.getNotNullAttribute("productName", String.class);
        if (string == null) {
            PBXTarget.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public XCConfigurationList getBuildConfigurationList() {
        XCConfigurationList xCConfigurationList = this.resolveNotNullAttribute("buildConfigurationList", XCConfigurationList.class);
        if (xCConfigurationList == null) {
            PBXTarget.$$$reportNull$$$0(3);
        }
        return xCConfigurationList;
    }

    @NotNull
    public List<XCBuildConfiguration> getBuildConfigurations() {
        List<XCBuildConfiguration> list = this.getBuildConfigurationList().getConfigurations();
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public XCBuildConfiguration findBuildConfiguration(@Nullable String name) {
        return this.getBuildConfigurationList().findConfiguration(name);
    }

    @Nullable
    public XCBuildConfiguration getPreferredConfiguration() {
        XCBuildConfiguration def = this.getBuildConfigurationList().getDefaultConfiguration();
        if (def != null && def.isDebug()) {
            return def;
        }
        for (XCBuildConfiguration each : this.getBuildConfigurations()) {
            if (!each.isDebug()) continue;
            return each;
        }
        return def;
    }

    @NotNull
    public List<PBXTargetDependency> getDependencies() {
        List<PBXTargetDependency> list = this.resolveAttributeList("dependencies", PBXTargetDependency.class);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<PBXTarget> getResolvedDependencies() {
        List list = ContainerUtil.mapNotNull(this.getDependencies(), (Function)((NullableFunction)each -> each.resolveTarget()));
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private PBXDictionary getTargetAttributes() {
        return this.getFile().getProjectObject().getTargetAttributes(this);
    }

    @Nullable
    public PBXTarget getTestHost() {
        PBXDictionary targetAttributes = this.getTargetAttributes();
        return targetAttributes != null ? targetAttributes.resolveAttribute("TestTargetID", PBXTarget.class) : null;
    }

    @NotNull
    public List<PBXBuildRule> getBuildRules() {
        List<PBXBuildRule> list = this.resolveAttributeList("buildRules", PBXBuildRule.class);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildPhase> getBuildPhases() {
        List<PBXBuildPhase> list = this.resolveAttributeList("buildPhases", PBXBuildPhase.class);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public PBXBuildPhase getBuildPhase(@Nullable PBXBuildPhase.PhaseType type) {
        return (PBXBuildPhase)((Object)ContainerUtil.getFirstItem(this.getBuildPhases(type)));
    }

    @NotNull
    public List<PBXBuildPhase> getBuildPhases(@Nullable PBXBuildPhase.PhaseType type) {
        List<PBXBuildPhase> list = this.getBuildPhases(type, null);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildPhase> getBuildPhases(@Nullable PBXBuildPhase.PhaseType type, @Nullable Condition<PBXBuildPhase> condition) {
        SmartList result = new SmartList();
        for (PBXBuildPhase each : this.getBuildPhases()) {
            if (type != null && !type.equals(each.getType()) || condition != null && !condition.value((Object)each)) continue;
            result.add(each);
        }
        List<PBXBuildPhase> list = Collections.unmodifiableList(result);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildPhase> getCopyFilesPhases(@Nullable PBXCopyFilesBuildPhase.DestinationType destination) {
        List<PBXBuildPhase> list = this.getBuildPhases(PBXBuildPhase.Type.COPY_FILES, PBXTarget.getCopyPhaseCondition(destination));
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<XCSwiftPackageProductDependency> getSwiftPackageProductDependencies() {
        List<XCSwiftPackageProductDependency> list = this.resolveAttributeList("packageProductDependencies", XCSwiftPackageProductDependency.class);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static Condition<PBXBuildPhase> getCopyPhaseCondition(@Nullable PBXCopyFilesBuildPhase.DestinationType destination) {
        return destination == null ? null : phase -> phase instanceof PBXCopyFilesBuildPhase && destination.equals((Object)((PBXCopyFilesBuildPhase)((Object)phase)).getDestinationType());
    }

    @NotNull
    public List<PBXBuildFile> getBuildFiles(@Nullable PBXBuildPhase.PhaseType type) {
        List<PBXBuildFile> list = this.getBuildFiles(type, null);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildFile> getBuildFiles(@Nullable PBXBuildPhase.PhaseType type, @Nullable Condition<PBXBuildPhase> phaseCondition) {
        List list = ContainerUtil.flatMap(this.getBuildPhases(type, phaseCondition), phase -> phase.getFiles());
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<PBXReference> getSources() {
        return this.collectPhaseReferences(PBXBuildPhase.Type.SOURCES, null, null);
    }

    @NotNull
    public List<VirtualFile> getSourceFiles() {
        List<VirtualFile> list = this.getSourceFiles(null);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getSourceFiles(@Nullable BuildSettingsProvider provider) {
        List explicitSources = ContainerUtil.mapNotNull(this.getSources(), reference -> provider == null ? reference.findFile() : reference.findFile(provider));
        List list = ContainerUtil.concat((List)explicitSources, this.getSourceFilesUnderSynchronizedGroups());
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private List<VirtualFile> getSourceFilesUnderSynchronizedGroups() {
        AppleFileTypeManager fileTypeManager = AppleFileTypeManager.getInstance();
        List list = ContainerUtil.filter((Collection)this.getFile().getTargetToSynchronizedFilesMap().getOrDefault((Object)this, Collections.emptyList()), file -> fileTypeManager.isSourceCodeFile(file.getName()) && !fileTypeManager.isHeaderFile(file.getName()));
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(17);
        }
        return list;
    }

    public List<PBXReference> getHeaders(boolean includeProjectHeaders) {
        return this.collectPhaseReferences(PBXBuildPhase.Type.HEADERS, null, (Condition<Pair<PBXBuildFile, PBXReference>>)(includeProjectHeaders ? null : pair -> {
            @NonNls String attributes = ((PBXBuildFile)((Object)((Object)pair.first))).getStringSetting("ATTRIBUTES");
            return attributes != null && (attributes.contains("Public") || attributes.contains("Private"));
        }));
    }

    public List<PBXReference> getCopyFiles() {
        return this.getCopyFiles(null);
    }

    public List<PBXReference> getCopyFiles(@Nullable PBXCopyFilesBuildPhase.DestinationType destination) {
        return this.collectPhaseReferences(PBXBuildPhase.Type.COPY_FILES, PBXTarget.getCopyPhaseCondition(destination), null);
    }

    @NotNull
    public List<PBXReference> getFrameworksAndLibraries() {
        return this.collectPhaseReferences(PBXBuildPhase.Type.FRAMEWORKS, null, null);
    }

    @NotNull
    public List<PBXReference> getFrameworks() {
        return this.collectPhaseReferences(PBXBuildPhase.Type.FRAMEWORKS, null, (Condition<Pair<PBXBuildFile, PBXReference>>)((Condition)buildFileAndReference -> ((PBXReference)((Object)((Object)buildFileAndReference.second))).isFramework()));
    }

    @NotNull
    public List<PBXFileSystemSynchronizedRootGroup> getSynchronizedGroups() {
        List<PBXFileSystemSynchronizedRootGroup> list = this.resolveAttributeList("fileSystemSynchronizedGroups", PBXFileSystemSynchronizedRootGroup.class);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private List<PBXReference> collectPhaseReferences(@Nullable PBXBuildPhase.PhaseType type, @Nullable Condition<PBXBuildPhase> phaseCondition, @Nullable Condition<Pair<PBXBuildFile, PBXReference>> condition) {
        List<PBXBuildFile> buildFiles = this.getBuildFiles(type, phaseCondition);
        ArrayList<PBXReference> result = new ArrayList<PBXReference>(buildFiles.size());
        for (PBXBuildFile eachBuildFile : buildFiles) {
            PBXReference ref = eachBuildFile.getFileRef();
            if (ref == null || condition != null && !condition.value((Object)Pair.create((Object)((Object)eachBuildFile), (Object)((Object)ref)))) continue;
            result.add(ref);
        }
        List<PBXReference> list = Collections.unmodifiableList(result);
        if (list == null) {
            PBXTarget.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    public AppleBuildSystem.Type getBuildSystem() {
        return null;
    }

    @Override
    public boolean accept(@NotNull PbxObjectVisitor visitor) {
        if (visitor == null) {
            PBXTarget.$$$reportNull$$$0(20);
        }
        return visitor.visitTarget(this);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.getName();
        if (string == null) {
            PBXTarget.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXTarget";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurationList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildRules";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildPhases";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyFilesPhases";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwiftPackageProductDependencies";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFilesUnderSynchronizedGroups";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynchronizedGroups";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPhaseReferences";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXTarget";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 20 -> new IllegalArgumentException(string);
        };
    }
}

