/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsResolver;
import com.jetbrains.cidr.xcode.model.PBXBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PBXShellScriptBuildPhase
extends PBXBuildPhase {
    public PBXShellScriptBuildPhase(PBXProjectFile file) {
        super(file, PBXBuildPhase.Type.SHELL_SCRIPT);
    }

    @NotNull
    public String getName() {
        String string = this.getString("name", "");
        if (string == null) {
            PBXShellScriptBuildPhase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public @Unmodifiable List<File> getInputFilesList(@NotNull BuildSettingsResolver resolver) {
        if (resolver == null) {
            PBXShellScriptBuildPhase.$$$reportNull$$$0(1);
        }
        List paths = this.getAttributeList("inputFileListPaths", String.class, Collections.emptyList());
        List list = ContainerUtil.map((Collection)paths, path -> new File(resolver.resolvePath((String)path)));
        if (list == null) {
            PBXShellScriptBuildPhase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public String getShellScript(@Nullable BuildSettingsResolver resolver) {
        Object script = this.getAttribute("shellScript", Object.class, null);
        String shellScript = null;
        if (script == null) {
            return "";
        }
        if (script instanceof String) {
            String scriptString = (String)script;
            shellScript = StringUtil.unquoteString((String)scriptString.trim());
        } else if (script instanceof List) {
            List scriptStrings = (List)script;
            for (Object each : scriptStrings) {
                this.checked(each, String.class);
            }
            shellScript = StringUtil.unquoteString((String)StringUtil.join((Iterable)scriptStrings, (String)"\n"));
        }
        if (shellScript == null) {
            XCLog.LOG.error("Unknown shell script type: " + String.valueOf(script.getClass()) + "\nAttribute contents:\n" + String.valueOf(script));
            return "";
        }
        String string = resolver != null ? resolver.resolvePath(shellScript) : shellScript;
        if (string == null) {
            PBXShellScriptBuildPhase.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXShellScriptBuildPhase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXShellScriptBuildPhase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilesList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellScript";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilesList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

