/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiAwareObject;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.XcodeCoreBundle;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleFileTypeManager;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXCompositeGroup;
import com.jetbrains.cidr.xcode.model.PBXContainerItem;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXNativeTarget;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReferenceBuildSettingProvider;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.model.XcodeProjectTrackers;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.Normalizer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class PBXReference
extends PBXContainerItem
implements PsiAwareObject {
    private static final Key<UpdatingEncodingState> UPDATING_ENCODING_FROM_MODEL = Key.create((String)(PBXReference.class.getSimpleName() + ".UPDATING_ENCODING_FROM_MODEL"));
    private static final ReadWriteLock ourReadWriteLock = new ReentrantReadWriteLock();
    public static final long DEFAULT_ENCODING = 4L;
    @NonNls
    public static final String SOURCE_TREE_ABSOLUTE = "<absolute>";
    @NonNls
    public static final String SOURCE_TREE_GROUP = "<group>";
    @NonNls
    public static final String SOURCE_TREE_SOURCE_ROOT = "SOURCE_ROOT";
    @NonNls
    public static final String SOURCE_TREE_SDKROOT = "SDKROOT";
    @NonNls
    public static final String SOURCE_TREE_DEVELOPER_DIR = "DEVELOPER_DIR";
    @NonNls
    public static final String SOURCE_TREE_BUILT_PRODUCTS_DIR = "BUILT_PRODUCTS_DIR";
    private CachedResolve myCachedResolve;
    private final CachedValue<String> myCachedRealPath;
    private static final ConcurrentMap<Long, Charset> ourCachedCharsets = new ConcurrentHashMap<Long, Charset>();

    public PBXReference(PBXProjectFile file) {
        super(file);
        XcodeProjectTrackers xcodeTrackers = XcodeProjectTrackers.getInstance(file.getProject());
        this.myCachedRealPath = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.computeRealPath(), (Collection)ContainerUtil.concat(List.of(xcodeTrackers.getReferencesTracker(), xcodeTrackers.getBuildSettingsTracker(), this.myAttributesModificationTracker), PBXReferenceBuildSettingProvider.Companion.getModificationTrackers(file.getProject()))));
    }

    @NotNull
    protected SimpleModificationTracker createAttributesModificationTracker() {
        return new SimpleModificationTracker();
    }

    @Override
    public String getComment() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        name = this.getPath();
        if (name != null) {
            return name;
        }
        return null;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String name = this.getName();
        if (name != null) {
            String string = name;
            if (string == null) {
                PBXReference.$$$reportNull$$$0(0);
            }
            return string;
        }
        name = this.getPath();
        String string = name != null ? name : XcodeCoreBundle.message("xcode.model.unnamed", new Object[0]);
        if (string == null) {
            PBXReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @Nullable
    @NlsSafe
    public String getName() {
        return this.getString("name");
    }

    @Deprecated
    @Nullable
    @NlsSafe
    public String getPath() {
        return this.getString("path");
    }

    @Nullable
    @VisibleForTesting
    public String computeRealPath() {
        PBXNativeTarget ownerTarget = this.findOwnerTarget();
        if (ownerTarget != null) {
            BuildSettingsProvider buildSettingsProvider = PBXReferenceBuildSettingProvider.Companion.getBuildSettings(this, ownerTarget);
            if (buildSettingsProvider == null) {
                return this.getPath();
            }
            String fullName = buildSettingsProvider.getBuildSetting("FULL_PRODUCT_NAME").getString();
            if (fullName != null) {
                return fullName;
            }
        }
        return this.getPath();
    }

    @Nullable
    public String getFileName() {
        String path = this.getPath();
        return path == null ? this.getName() : new File(path).getName();
    }

    @Override
    public boolean accept(@NotNull PbxObjectVisitor visitor) {
        if (visitor == null) {
            PBXReference.$$$reportNull$$$0(2);
        }
        return visitor.visitReference(this);
    }

    @Nullable
    public String getSourceTree() {
        return this.getString("sourceTree");
    }

    @Nullable
    public String getFileTypeId() {
        String explicit = this.getExplicitFileType();
        return explicit != null ? explicit : this.getString("lastKnownFileType");
    }

    @Nullable
    private String getExplicitFileType() {
        return this.getString("explicitFileType");
    }

    @Nullable
    public AppleFileType getFileType() {
        return AppleFileTypeManager.getInstance().findFileTypeById(this.getFileTypeId());
    }

    public boolean isFramework() {
        AppleFileType type = this.getFileType();
        return type != null && type.isFrameworkWrapper();
    }

    public boolean isLinkedProject() {
        AppleFileType type = this.getFileType();
        return type != null && type.isProjectWrapper();
    }

    @Nullable
    public Long getFileEncoding() {
        String encoding = this.getString("fileEncoding");
        if (encoding != null) {
            try {
                return Long.parseLong(encoding);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Charset getSuitableCharset() {
        AppleFileType type = this.getFileType();
        if (type == null || !type.isTextFile()) {
            return null;
        }
        Long encoding = this.getFileEncoding();
        if (encoding == null) {
            return null;
        }
        return ourCachedCharsets.computeIfAbsent(encoding, fileEncoding -> {
            String name = Foundation.getEncodingName((long)fileEncoding);
            try {
                return name == null ? null : Charset.forName(name);
            }
            catch (UnsupportedCharsetException e) {
                return null;
            }
        });
    }

    @Nullable
    public PBXProjectFile getLinkedProject() {
        if (!this.isLinkedProject()) {
            return null;
        }
        CoreXcodeWorkspace workspace = CoreXcodeWorkspace.getInstance(this.getFile().getProject());
        return workspace != null ? workspace.findProject(this.findFile()) : null;
    }

    @Nullable
    public PBXGroup getParent() {
        return this.getFile().resolveParentObject(this);
    }

    public boolean isDescendantOf(@Nullable PBXReference ancestor) {
        if (!(ancestor instanceof PBXGroup)) {
            return false;
        }
        for (PBXReference directParent = this; directParent != null; directParent = directParent.getParent()) {
            if (ancestor != directParent) continue;
            return true;
        }
        return false;
    }

    @Nullable
    @NlsSafe
    public String resolvePath() {
        return this.resolvePath(this.getBuildSettingsProvider());
    }

    @Nullable
    public String resolvePath(@Nullable BuildSettingsProvider buildSettingsProvider) {
        String path = (String)this.myCachedRealPath.getValue();
        String tree = this.getSourceTree();
        if (tree == null) {
            return null;
        }
        if (SOURCE_TREE_ABSOLUTE.equals(tree)) {
            return path;
        }
        String treeDir = this.resolveSourceTree(tree, buildSettingsProvider);
        if (treeDir == null) {
            return null;
        }
        if (path == null) {
            return treeDir;
        }
        return PBXReference.resolvePath(treeDir, path);
    }

    @Nullable
    public static String resolvePath(@NotNull String treeDir, @NotNull String path) {
        if (treeDir == null) {
            PBXReference.$$$reportNull$$$0(3);
        }
        if (path == null) {
            PBXReference.$$$reportNull$$$0(4);
        }
        File treeDirFile = new File(treeDir);
        while (path.startsWith("..")) {
            if ((treeDirFile = treeDirFile.getParentFile()) == null) {
                return null;
            }
            path = path.substring("..".length());
            path = StringUtil.trimStart((String)path, (String)"/");
        }
        String result = new File(treeDirFile, path).getPath();
        return Normalizer.normalize(result, Normalizer.Form.NFC);
    }

    @Nullable
    public String resolveSourceTree(@NotNull String sourceTree, @Nullable BuildSettingsProvider buildSettingsProvider) {
        if (sourceTree == null) {
            PBXReference.$$$reportNull$$$0(5);
        }
        if (SOURCE_TREE_ABSOLUTE.equals(sourceTree)) {
            return null;
        }
        if (SOURCE_TREE_GROUP.equals(sourceTree)) {
            PBXGroup group = this.getParent();
            return group != null ? group.resolvePath(buildSettingsProvider) : this.getFile().getBaseDir().getPath();
        }
        if (SOURCE_TREE_SOURCE_ROOT.equals(sourceTree)) {
            return this.getFile().getBaseDir().getPath();
        }
        if (SOURCE_TREE_SDKROOT.equals(sourceTree)) {
            AppleSdk sdk = buildSettingsProvider == null ? null : buildSettingsProvider.getBuildSetting(sourceTree).getSdk();
            return sdk == null ? null : sdk.getRoot().toString();
        }
        return buildSettingsProvider == null ? null : buildSettingsProvider.getBuildSetting(sourceTree).getAbsolutePath();
    }

    @Nullable
    public VirtualFile findFile() {
        return this.findFile(this.getBuildSettingsProvider());
    }

    @Nullable
    public PsiElement findElement(@NotNull Project project) {
        if (project == null) {
            PBXReference.$$$reportNull$$$0(6);
        }
        return this.findPsiElement();
    }

    @Nullable
    public PsiFileSystemItem findPsiElement() {
        return this.findPsiElementFromVirtualFile();
    }

    @Nullable
    protected final PsiFileSystemItem findPsiElementFromVirtualFile() {
        VirtualFile file = this.findFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getFile().getProject());
        return file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
    }

    @Nullable
    public PBXReference findPhysicalParent() {
        PBXReference result;
        PBXGroup mainGroup = this.getFile().getProjectObject().getMainGroup();
        for (result = this; result != null && result.getPath() == null; result = result.getParent()) {
            if (!result.equals((Object)mainGroup)) continue;
            return result;
        }
        return result;
    }

    @Nullable
    public VirtualFile findFile(@Nullable BuildSettingsProvider buildSettingsProvider) {
        return this.doFindFile(buildSettingsProvider, false);
    }

    @Nullable
    public VirtualFile refreshAndFindFile() {
        return this.refreshAndFindFile((BuildSettingsProvider)ReadAction.compute(() -> this.getBuildSettingsProvider()));
    }

    @Nullable
    public VirtualFile refreshAndFindFile(@Nullable BuildSettingsProvider buildSettingsProvider) {
        return this.doFindFile(buildSettingsProvider, true);
    }

    @Nullable
    private VirtualFile doFindFile(@Nullable BuildSettingsProvider buildSettingsProvider, boolean refresh) {
        VirtualFile resolvedFile;
        long count = this.checkResolveCacheIsUpToDate(buildSettingsProvider);
        CachedResolve cachedResolve = this.myCachedResolve;
        if (cachedResolve != null) {
            return cachedResolve.getResolvedFile();
        }
        String path = (String)ReadAction.compute(() -> this.resolvePath(buildSettingsProvider));
        VirtualFile virtualFile = path == null ? null : (resolvedFile = refresh ? StandardFileSystems.local().refreshAndFindFileByPath(path) : StandardFileSystems.local().findFileByPath(path));
        if (resolvedFile != null) {
            ReadAction.run(() -> this.updateEncoding(resolvedFile));
        }
        this.myCachedResolve = new CachedResolve(count, buildSettingsProvider, resolvedFile);
        return resolvedFile;
    }

    private long checkResolveCacheIsUpToDate(@Nullable BuildSettingsProvider buildSettingsProvider) {
        long count = PsiManager.getInstance((Project)this.getFile().getProject()).getModificationTracker().getModificationCount();
        CachedResolve cachedResolve = this.myCachedResolve;
        if (cachedResolve == null) {
            return count;
        }
        if (cachedResolve.getModificationStamp() != count || cachedResolve.getBuildSettingsProvider() != buildSettingsProvider || cachedResolve.getResolvedFile() != null && !cachedResolve.getResolvedFile().isValid()) {
            this.myCachedResolve = null;
        }
        return count;
    }

    @NotNull
    public <T extends PBXTarget> List<T> findTargets(@Nullable Class<T> clazz) {
        List<T> list = this.getFile().getTargetsFor(this, clazz);
        if (list == null) {
            PBXReference.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildFile> findBuildFiles() {
        List<PBXBuildFile> list = this.getFile().getBuildFilesFor(this);
        if (list == null) {
            PBXReference.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public PBXNativeTarget findTargetForProduct(@Nullable BuildSettingsProvider settingsProvider) {
        return this.getFile().findTargetForProduct(this, settingsProvider);
    }

    @NotNull
    private BuildSettingsProvider getBuildSettingsProvider() {
        CoreXcodeWorkspace workspace = CoreXcodeWorkspace.getInstance(this.getFile().getProject());
        BuildSettingsProvider provider = workspace != null ? workspace.getPreferredBuildSettingsProvider(this) : null;
        BuildSettingsProvider buildSettingsProvider = provider != null ? provider : this.getFile().getBuildSettingsProvider();
        if (buildSettingsProvider == null) {
            PBXReference.$$$reportNull$$$0(9);
        }
        return buildSettingsProvider;
    }

    public boolean isDirectoryRef() {
        return this instanceof PBXFileReference && "folder".equals(this.getFileTypeId());
    }

    public boolean isProductReference() {
        return null != this.findOwnerTarget();
    }

    @Nullable
    public PBXNativeTarget findOwnerTarget() {
        return (PBXNativeTarget)((Object)ContainerUtil.findLast(this.getFile().getTargets(PBXNativeTarget.class), target -> target.getProductReference() == this));
    }

    public boolean isAssetCatalog() {
        if (!(this instanceof PBXFileReference)) {
            return false;
        }
        VirtualFile file = this.findFile();
        return file != null && file.isDirectory() && (FileUtilRt.extensionEquals((String)file.getName(), (String)"xcassets") || "folder.assetcatalog".equals(this.getExplicitFileType()));
    }

    @NotNull
    public static PBXReference effectiveTargetMember(@NotNull PBXReference ref) {
        if (ref == null) {
            PBXReference.$$$reportNull$$$0(10);
        }
        if (ref instanceof PBXCompositeGroup) {
            PBXReference pBXReference = ref;
            if (pBXReference == null) {
                PBXReference.$$$reportNull$$$0(11);
            }
            return pBXReference;
        }
        PBXGroup parent = ref.getParent();
        if (parent instanceof PBXCompositeGroup) {
            PBXGroup pBXGroup = parent;
            if (pBXGroup == null) {
                PBXReference.$$$reportNull$$$0(12);
            }
            return pBXGroup;
        }
        PBXReference pBXReference = ref;
        if (pBXReference == null) {
            PBXReference.$$$reportNull$$$0(13);
        }
        return pBXReference;
    }

    public boolean isPhysical() {
        return !this.isVirtual();
    }

    public boolean isVirtual() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEncoding(@NotNull VirtualFile file) {
        Charset suitable;
        UpdatingEncodingState state;
        if (file == null) {
            PBXReference.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.getFileEncoding() == null) {
            return;
        }
        Project project = this.getFile().getProject();
        ourReadWriteLock.readLock().lock();
        try {
            state = (UpdatingEncodingState)file.getUserData(UPDATING_ENCODING_FROM_MODEL);
            if (state != null && state.isDifferentProject(project)) {
                return;
            }
            suitable = this.getSuitableCharset();
        }
        finally {
            ourReadWriteLock.readLock().unlock();
        }
        if (suitable == null) {
            return;
        }
        ourReadWriteLock.writeLock().lock();
        try {
            state = (UpdatingEncodingState)file.getUserData(UPDATING_ENCODING_FROM_MODEL);
            if (state != null && state.isDifferentProject(project)) {
                return;
            }
            file.setCharset(suitable, state == null ? () -> file.putUserData(UPDATING_ENCODING_FROM_MODEL, (Object)new UpdatingEncodingState(project)) : () -> ++state.myEventCount);
            LoadTextUtil.clearCharsetAutoDetectionReason((VirtualFile)file);
        }
        finally {
            ourReadWriteLock.writeLock().unlock();
        }
    }

    @Nullable
    public static UpdatingEncodingState clearUpdatingEncodingFromModel(@NotNull VirtualFile file) {
        if (file == null) {
            PBXReference.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        UpdatingEncodingState model = (UpdatingEncodingState)file.getUserData(UPDATING_ENCODING_FROM_MODEL);
        if (model == null) {
            return null;
        }
        if (--model.myEventCount == 0) {
            file.putUserData(UPDATING_ENCODING_FROM_MODEL, null);
        }
        return model;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 10, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBuildFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettingsProvider";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "effectiveTargetMember";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceTree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "effectiveTargetMember";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateEncoding";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clearUpdatingEncodingFromModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 10, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    private static final class CachedResolve {
        private final long modificationStamp;
        @Nullable
        private final BuildSettingsProvider buildSettingsProvider;
        @Nullable
        private final VirtualFile resolvedFile;

        private CachedResolve(long modificationStamp, @Nullable BuildSettingsProvider buildSettingsProvider, @Nullable VirtualFile resolvedFile) {
            this.modificationStamp = modificationStamp;
            this.resolvedFile = resolvedFile;
            this.buildSettingsProvider = buildSettingsProvider;
        }

        public long getModificationStamp() {
            return this.modificationStamp;
        }

        @Nullable
        public BuildSettingsProvider getBuildSettingsProvider() {
            return this.buildSettingsProvider;
        }

        @Nullable
        public VirtualFile getResolvedFile() {
            return this.resolvedFile;
        }
    }

    public static final class UpdatingEncodingState
    implements Disposable {
        @Nullable
        private volatile Project myProject;
        private volatile int myEventCount;

        private UpdatingEncodingState(@NotNull Project project) {
            if (project == null) {
                UpdatingEncodingState.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myEventCount = 1;
            Disposer.register((Disposable)project, (Disposable)this);
        }

        public boolean isDifferentProject(@NotNull Project project) {
            if (project == null) {
                UpdatingEncodingState.$$$reportNull$$$0(1);
            }
            return this.myProject != project;
        }

        public void dispose() {
            this.myProject = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXReference$UpdatingEncodingState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDifferentProject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

