/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleFileTypeManager;
import com.jetbrains.cidr.xcode.frameworks.AppleLanguage;
import com.jetbrains.cidr.xcode.frameworks.ApplePackageType;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleProductType;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSetting;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsResolver;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.FileRefTree;
import com.jetbrains.cidr.xcode.model.Notifications;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXCompositeGroup;
import com.jetbrains.cidr.xcode.model.PBXContainerItemProxy;
import com.jetbrains.cidr.xcode.model.PBXCopyFilesBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXFileSystemSynchronizedRootGroup;
import com.jetbrains.cidr.xcode.model.PBXFrameworksBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXHeadersBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXLegacyTarget;
import com.jetbrains.cidr.xcode.model.PBXNativeTarget;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PBXReferenceProxy;
import com.jetbrains.cidr.xcode.model.PBXResourcesBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXRezBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXShellScriptBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXSourcesBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.PBXTargetDependency;
import com.jetbrains.cidr.xcode.model.PBXVariantGroup;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCConfigurationList;
import com.jetbrains.cidr.xcode.model.XCCoreBuildSettings;
import com.jetbrains.cidr.xcode.model.XCRemoteSwiftPackageReference;
import com.jetbrains.cidr.xcode.model.XCSwiftPackageProductDependency;
import com.jetbrains.cidr.xcode.model.XCVersionGroup;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PBXProjectFileManipulator {
    private static final Logger LOG = Logger.getInstance(PBXProjectFileManipulator.class);
    private final PBXProjectFile myProjectFile;
    @Nullable
    private Notifications myNotifications;
    private final boolean autoFireNotifications;

    PBXProjectFileManipulator(@NotNull PBXProjectFile projectFile, boolean fireNotificationsAutomatically) {
        if (projectFile == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(0);
        }
        this.myProjectFile = projectFile;
        this.autoFireNotifications = fireNotificationsAutomatically;
        this.myProjectFile.setTargetCacheDisabled(!this.autoFireNotifications);
    }

    @NotNull
    public static PBXProjectFile createNewProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull VirtualFile pbxProjectFile, @Nullable PbxId initialId, @Nullable String projectName) {
        if (project == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(2);
        }
        if (pbxProjectFile == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(3);
        }
        PBXProjectFile projectFile = new PBXProjectFile(project, baseDir, pbxProjectFile, initialId, projectName);
        projectFile.setArchiveVersion(1);
        projectFile.setObjectVersion(46);
        PBXProject projectObject = new PBXProject(projectFile);
        projectFile.addObject(projectObject, null);
        projectFile.setProjectObject(projectObject);
        projectObject.setAttribute("projectDirPath", "");
        projectObject.setAttribute("projectRoot", "");
        projectFile.finishLoading();
        projectFile.lock();
        XCConfigurationList configurationList = new XCConfigurationList(projectFile);
        configurationList.setAttribute("buildConfigurations", Collections.emptyList());
        configurationList.setAttribute("defaultConfigurationIsVisible", "0");
        configurationList.setAttribute("defaultConfigurationName", "Release");
        projectFile.addObject(configurationList, null);
        projectObject.setAttribute("buildConfigurationList", configurationList.createReference());
        projectObject.setAttribute("compatibilityVersion", "Xcode 3.2");
        projectObject.setAttribute("developmentRegion", "English");
        projectObject.setAttribute("hasScannedForEncodings", "0");
        ArrayList<String> knownRegions = new ArrayList<String>();
        knownRegions.add("en");
        projectObject.setAttribute("knownRegions", knownRegions);
        PBXGroup newMainGroup = new PBXGroup(projectFile);
        newMainGroup.setAttribute("children", Collections.emptyList());
        newMainGroup.setAttribute("sourceTree", "<group>");
        projectFile.addObject(newMainGroup, null);
        projectObject.setAttribute("mainGroup", newMainGroup.createReference());
        PBXGroup productsGroup = projectFile.getManipulator().addGroup("<group>", "Products", null);
        projectObject.setAttribute("productRefGroup", productsGroup.createReference());
        projectObject.setAttribute("targets", Collections.emptyList());
        PBXProjectFile pBXProjectFile = projectFile;
        if (pBXProjectFile == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(4);
        }
        return pBXProjectFile;
    }

    @NotNull
    public AddResult addFile(@NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup parentGroup, boolean isGroup) {
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(5);
        }
        if (parentGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(6);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(7);
        }
        AddResult addResult = this.addFile(path, targets, parentGroup, isGroup, null, null, true);
        if (addResult == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(8);
        }
        return addResult;
    }

    @NotNull
    public AddResult addFile(@NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup parentGroup, boolean isGroup, @Nullable String sourceTree, @Nullable PBXBuildPhase.PhaseType buildPhaseType, boolean setFileEncoding) {
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(9);
        }
        if (parentGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(10);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(11);
        }
        AddResult result = this.addFile(this.getPendingNotifications(), path, targets, parentGroup, isGroup, sourceTree, buildPhaseType, setFileEncoding, null);
        this.autoFirePendingNotifications();
        AddResult addResult = result;
        if (addResult == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(12);
        }
        return addResult;
    }

    @NotNull
    private AddResult addFile(@NotNull Notifications notifications, @NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup parentGroup, boolean isGroup, @Nullable String sourceTree, @Nullable PBXBuildPhase.PhaseType buildPhaseType, boolean setFileEncoding, @Nullable Collection<PBXBuildFile> buildFilePrototypes) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(13);
        }
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(14);
        }
        if (parentGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(15);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(16);
        }
        File file = new File(path);
        AppleFileType type = AppleFileTypeManager.getInstance().findFileTypeByFilename(file.getName());
        boolean childrenAlreadyProcessed = false;
        if (file.isDirectory()) {
            if (type != null && "wrapper.xcdatamodeld".equals(type.getId())) {
                return new AddResult(this.addCoreDataModel(notifications, path, targets, parentGroup, sourceTree, buildFilePrototypes), type, true);
            }
            if (isGroup) {
                PBXGroup group = this.addGroup(null, file.getName(), file.getPath(), parentGroup);
                return new AddResult(group, type, false);
            }
            childrenAlreadyProcessed = true;
        }
        PBXReference reference = this.addFileInternal(notifications, path, targets, parentGroup, sourceTree, buildPhaseType, setFileEncoding, buildFilePrototypes);
        return new AddResult(reference, type, childrenAlreadyProcessed);
    }

    @NotNull
    private PBXReference addFileInternal(@NotNull Notifications notifications, @NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup group, @Nullable String sourceTree, @Nullable PBXBuildPhase.PhaseType buildPhaseType) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(17);
        }
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(18);
        }
        if (group == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(19);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(20);
        }
        return this.addFileInternal(notifications, path, targets, group, sourceTree, buildPhaseType, true);
    }

    @NotNull
    private PBXReference addFileInternal(@NotNull Notifications notifications, @NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup group, @Nullable String sourceTree, @Nullable PBXBuildPhase.PhaseType buildPhaseType, boolean setFileEncoding) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(21);
        }
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(22);
        }
        if (group == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(23);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(24);
        }
        return this.addFileInternal(notifications, path, targets, group, sourceTree, buildPhaseType, setFileEncoding, null);
    }

    @NotNull
    private PBXReference addFileInternal(@NotNull Notifications notifications, @NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup group, @Nullable String sourceTree, @Nullable PBXBuildPhase.PhaseType buildPhaseType, boolean setFileEncoding, @Nullable Collection<PBXBuildFile> buildFilePrototypes) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(25);
        }
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(26);
        }
        if (group == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(27);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(28);
        }
        LOG.assertTrue(group.getFile() == this.myProjectFile);
        Path file = Path.of(path, new String[0]);
        PBXFileReference reference = new PBXFileReference(this.myProjectFile);
        String fileTypeId = AppleFileTypeManager.getInstance().getSuitableFileTypeIdByFile(file);
        reference.setAttribute("lastKnownFileType", fileTypeId);
        this.addReference(notifications, reference, file.toFile(), group, targets, sourceTree, buildPhaseType, setFileEncoding, buildFilePrototypes);
        PBXFileReference pBXFileReference = reference;
        if (pBXFileReference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(29);
        }
        return pBXFileReference;
    }

    @NotNull
    private static String pathFromGroupPath(@NotNull String path, @NotNull String parentGroupFilePath) {
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(30);
        }
        if (parentGroupFilePath == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(31);
        }
        String relativePath = FileUtil.isAbsolute((String)path) ? FileUtil.getRelativePath((String)parentGroupFilePath, (String)path, (char)File.separatorChar) : path;
        File relativeFile = relativePath == null ? null : new File(parentGroupFilePath, relativePath);
        String string = relativeFile == null ? path : relativeFile.getPath();
        if (string == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public PBXReference addCoreDataModel(@NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup group, @Nullable String sourceTree) {
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(33);
        }
        if (group == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(34);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(35);
        }
        PBXReference result = this.addCoreDataModel(this.getPendingNotifications(), path, targets, group, sourceTree, null);
        this.autoFirePendingNotifications();
        PBXReference pBXReference = result;
        if (pBXReference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(36);
        }
        return pBXReference;
    }

    @NotNull
    private PBXReference addCoreDataModel(@NotNull Notifications notifications, @NotNull String path, @NotNull PBXTarget[] targets, @NotNull PBXGroup group, @Nullable String sourceTree, @Nullable Collection<PBXBuildFile> buildFileProtoTypes) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(37);
        }
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(38);
        }
        if (group == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(39);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(40);
        }
        LOG.assertTrue(group.getFile() == this.myProjectFile);
        Path file = Path.of(path, new String[0]);
        LOG.assertTrue(Files.isDirectory(file, new LinkOption[0]));
        String fileTypeId = AppleFileTypeManager.getInstance().getSuitableFileTypeIdByFile(file);
        LOG.assertTrue("wrapper.xcdatamodeld".equals(fileTypeId));
        XCVersionGroup reference = new XCVersionGroup(this.myProjectFile);
        if (sourceTree == null) {
            sourceTree = "<group>";
        }
        this.addReference(notifications, reference, file.toFile(), group, targets, sourceTree, null, false, buildFileProtoTypes);
        String groupPath = reference.resolvePath();
        try (Stream<Path> children = PBXProjectFileManipulator.coreDataModelVersions(file);){
            children.forEach(child -> {
                Path childFile = groupPath == null ? child : Path.of(groupPath, new String[0]).resolve((Path)child);
                this.addFileInternal(notifications, childFile.toString(), PBXTarget.EMPTY_ARRAY, reference, "<group>", null, false);
            });
        }
        XCVersionGroup xCVersionGroup = reference;
        if (xCVersionGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(41);
        }
        return xCVersionGroup;
    }

    @NotNull
    private static Stream<Path> coreDataModelVersions(@NotNull Path file) {
        Stream<Path> stream;
        if (file == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(42);
        }
        assert (Files.isDirectory(file, new LinkOption[0]));
        try {
            stream = Files.list(file).filter(path -> path.getFileName().toString().endsWith(".xcdatamodel")).map(path -> file.relativize((Path)path));
        }
        catch (IOException e) {
            XCLog.LOG.warn((Throwable)e);
            Stream<Path> stream2 = Stream.empty();
            if (stream2 == null) {
                PBXProjectFileManipulator.$$$reportNull$$$0(44);
            }
            return stream2;
        }
        if (stream == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(43);
        }
        return stream;
    }

    private void addReference(@NotNull Notifications notifications, @NotNull PBXReference reference, @NotNull File file, @NotNull PBXGroup group, PBXTarget[] targets, @Nullable String sourceTree, PBXBuildPhase.PhaseType buildPhase, boolean setFileEncoding, @Nullable Collection<PBXBuildFile> buildFilePrototypes) {
        PBXReference referenceForTargets;
        PBXGroup actualGroup;
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(45);
        }
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(46);
        }
        if (file == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(47);
        }
        if (group == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(48);
        }
        String parentName = file.getParentFile().getName();
        String fileName = file.getName();
        String filePath = file.getPath();
        if (FileUtilRt.extensionEquals((String)parentName, (String)"lproj")) {
            boolean isNewVariantGroup = true;
            PBXCompositeGroup variantGroup = new PBXVariantGroup(this.myProjectFile);
            for (PBXReference ref : group.getChildren()) {
                if (!(ref instanceof PBXVariantGroup) || !fileName.equals(ref.getName())) continue;
                variantGroup = (PBXCompositeGroup)ref;
                isNewVariantGroup = false;
                break;
            }
            if (isNewVariantGroup) {
                variantGroup.setAttribute("sourceTree", "<group>");
                PBXProjectFileManipulator.addObject(variantGroup, group, notifications);
            }
            actualGroup = variantGroup;
            referenceForTargets = isNewVariantGroup ? variantGroup : null;
        } else {
            actualGroup = group;
            referenceForTargets = reference;
        }
        this.updateNamePathSourceTree(reference, actualGroup, fileName, filePath, sourceTree);
        if (setFileEncoding && AppleFileTypeManager.getInstance().isTextFile(fileName)) {
            reference.setAttribute("fileEncoding", String.valueOf(4L));
        }
        PBXProjectFileManipulator.addObject(reference, actualGroup, notifications);
        if (actualGroup instanceof XCVersionGroup) {
            actualGroup.setAttribute("currentVersion", reference.createReference());
            actualGroup.setAttribute("versionGroupType", reference.getAttribute("lastKnownFileType", String.class));
        }
        notifications.referencesChanged();
        if (referenceForTargets != null) {
            this.addToTargets(notifications, Arrays.asList(targets), referenceForTargets, buildPhase, buildFilePrototypes);
        }
    }

    private static void addObject(@NotNull PBXObject object, @NotNull Notifications notifications) {
        if (object == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(49);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(50);
        }
        PBXProjectFileManipulator.addObject(object, null, notifications);
    }

    private static void addObject(@NotNull PBXObject object, @Nullable PBXGroup group, @NotNull Notifications notifications) {
        if (object == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(51);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(52);
        }
        object.getFile().addObject(object, group);
        PBXProjectFileManipulator.invalidateIncludes(object, notifications);
        PBXProjectFileManipulator.checkProjectRoots(object, notifications);
    }

    private void doRemoveObjects(@NotNull Collection<? extends PBXObject> objects, @NotNull Notifications notifications) {
        if (objects == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(53);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(54);
        }
        for (PBXObject pBXObject : objects) {
            PBXProjectFileManipulator.checkProjectRoots(pBXObject, notifications);
            PBXProjectFileManipulator.invalidateIncludes(pBXObject, notifications);
        }
        this.myProjectFile.removeObjects(objects);
    }

    private static void invalidateIncludes(@NotNull PBXObject ref, @NotNull Notifications notifications) {
        String fileName;
        if (ref == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(55);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(56);
        }
        if (ref instanceof PBXFileReference && (fileName = ((PBXFileReference)ref).getFileName()) != null) {
            notifications.addInvalidatedFile(fileName);
        }
    }

    private static void checkProjectRoots(@NotNull PBXObject object, @NotNull Notifications notifications) {
        if (object == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(57);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(58);
        }
        if (notifications.didChangeReference(object) || !(object instanceof PBXReference)) {
            return;
        }
        PBXReference ref = (PBXReference)object;
        if (ref.getPath() == null) {
            return;
        }
        notifications.addChangedReference(ref);
    }

    @NotNull
    public List<CopyResult> deepCopyReferences(@NotNull List<CopyInfo> copyInfos, @NotNull PBXGroup dstGroup, boolean deleteSource) {
        if (copyInfos == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(59);
        }
        if (dstGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(60);
        }
        LOG.assertTrue(dstGroup.getFile() == this.myProjectFile);
        Notifications notifications = this.getPendingNotifications();
        ArrayList<CopyResult> results = new ArrayList<CopyResult>();
        ArrayList<Pair> manipulators = new ArrayList<Pair>();
        manipulators.add(Pair.create((Object)this.myProjectFile, (Object)this));
        for (CopyInfo copyInfo : copyInfos) {
            PBXReference srcRef = copyInfo.getReference();
            CopyResult result = this.doDeepCopyReference(copyInfo, dstGroup, notifications);
            results.add(result);
            boolean ok = result.getReference() != null;
            if (!ok || !deleteSource) continue;
            PBXProjectFile srcProjectFile = srcRef.getFile();
            PBXProjectFileManipulator manipulator = null;
            for (Pair pm : manipulators) {
                if (pm.first != srcProjectFile) continue;
                manipulator = (PBXProjectFileManipulator)pm.second;
                break;
            }
            if (manipulator == null) {
                manipulator = srcProjectFile.getManipulator(false);
                manipulators.add(Pair.create((Object)srcProjectFile, (Object)manipulator));
            }
            manipulator.doRemoveReferences(Collections.singletonList(srcRef), notifications);
        }
        for (Pair pm : manipulators) {
            PBXProjectFileManipulator m = (PBXProjectFileManipulator)pm.second;
            if (m == this) {
                m.autoFirePendingNotifications();
                continue;
            }
            m.firePendingNotifications();
        }
        ArrayList<CopyResult> arrayList = results;
        if (arrayList == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    @NotNull
    private CopyResult doDeepCopyReference(@NotNull CopyInfo copyInfo, @NotNull PBXGroup dstGroup, @NotNull Notifications notifications) {
        PBXReference srcRef;
        if (copyInfo == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(62);
        }
        if (dstGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(63);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(64);
        }
        if (dstGroup.isDescendantOf(srcRef = copyInfo.getReference())) {
            return new CopyResult(null, "Trying to copy reference to its descendant");
        }
        ReferenceCopier copier = new ReferenceCopier(dstGroup, copyInfo.getPathProvider(), copyInfo.getTargetProvider(), notifications);
        PBXReference result = null;
        String errorMessage = null;
        if (srcRef.accept(copier)) {
            result = copier.getResult();
            LOG.assertTrue(result != null);
        } else {
            errorMessage = copier.getErrorMessage();
            LOG.assertTrue(errorMessage != null);
        }
        return new CopyResult(result, errorMessage);
    }

    public void changeTargets(@NotNull PBXReference reference, @NotNull List<PBXTarget> removeFrom, @NotNull List<PBXTarget> addTo) {
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(65);
        }
        if (removeFrom == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(66);
        }
        if (addTo == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(67);
        }
        LOG.assertTrue(reference.getFile() == this.myProjectFile);
        Notifications notifications = this.getPendingNotifications();
        ArrayList<PBXBuildFile> buildFiles = new ArrayList<PBXBuildFile>(reference.findBuildFiles());
        this.removeFromTargets(buildFiles, removeFrom, notifications);
        this.addToTargets(notifications, addTo, reference, null, null);
        this.autoFirePendingNotifications();
    }

    public void removeFromTargets(@NotNull List<PBXBuildFile> buildFiles, @NotNull List<PBXTarget> removeFrom) {
        if (buildFiles == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(68);
        }
        if (removeFrom == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(69);
        }
        this.removeFromTargets(buildFiles, removeFrom, this.getPendingNotifications());
        this.autoFirePendingNotifications();
    }

    private void removeFromTargets(@NotNull List<PBXBuildFile> buildFiles, @NotNull List<PBXTarget> removeFrom, @NotNull Notifications notifications) {
        if (buildFiles == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(70);
        }
        if (removeFrom == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(71);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(72);
        }
        HashSet<PBXTarget> removeFromSet = new HashSet<PBXTarget>(removeFrom);
        ArrayList<PBXBuildFile> buildFileToRemove = new ArrayList<PBXBuildFile>();
        for (PBXBuildFile buildFile : buildFiles) {
            PBXTarget target = buildFile.getTarget();
            if (target == null || !removeFromSet.contains((Object)target)) continue;
            buildFileToRemove.add(buildFile);
        }
        if (!buildFileToRemove.isEmpty()) {
            this.doRemoveObjects(buildFileToRemove, notifications);
            notifications.buildFilesChanged();
        }
    }

    @Nullable
    public static PBXBuildPhase.PhaseType getSuitableBuildPhaseType(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        AppleFileType type = AppleFileTypeManager.getInstance().findFileTypeByFilename(fileName);
        if (type != null && !type.getId().equals("sourcecode.glsl")) {
            if (type.isSourceCode()) {
                return type.isHeader() ? PBXBuildPhase.Type.HEADERS : PBXBuildPhase.Type.SOURCES;
            }
            if (type.isFrameworkWrapper() || type.isLibrary()) {
                return PBXBuildPhase.Type.FRAMEWORKS;
            }
            if (AppleLanguage.findById(type.getLanguage()) == AppleLanguage.REZ) {
                return PBXBuildPhase.Type.REZ;
            }
        }
        return PBXBuildPhase.Type.RESOURCES;
    }

    private void addToTargets(@NotNull Notifications notifications, @NotNull Collection<PBXTarget> addToSet, @NotNull PBXReference reference, @Nullable PBXBuildPhase.PhaseType type, @Nullable Collection<PBXBuildFile> prototypes) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(73);
        }
        if (addToSet == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(74);
        }
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(75);
        }
        for (PBXTarget target : new LinkedHashSet<PBXTarget>(addToSet)) {
            this.addToTarget(notifications, target, reference, type, prototypes);
        }
    }

    public void addToTarget(@NotNull PBXTarget target, @NotNull PBXReference reference, @Nullable PBXBuildPhase.PhaseType type) {
        if (target == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(76);
        }
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(77);
        }
        this.addToTarget(this.getPendingNotifications(), target, reference, type, null);
        this.autoFirePendingNotifications();
    }

    private void addToTarget(@NotNull Notifications notifications, @NotNull PBXTarget target, @NotNull PBXReference reference, @Nullable PBXBuildPhase.PhaseType type, @Nullable Collection<PBXBuildFile> prototypes) {
        PBXBuildPhase phase;
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(78);
        }
        if (target == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(79);
        }
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(80);
        }
        if (type == null) {
            type = PBXProjectFileManipulator.getSuitableBuildPhaseType(reference.getFileName());
        }
        PBXBuildPhase pBXBuildPhase = phase = type == null ? null : target.getBuildPhase(type);
        if (phase != null) {
            this.addToBuildPhase(notifications, target, phase, reference, prototypes);
        }
    }

    public PBXBuildFile addToBuildPhase(@NotNull PBXTarget target, @NotNull PBXBuildPhase phase, @NotNull PBXReference reference) {
        if (target == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(81);
        }
        if (phase == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(82);
        }
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(83);
        }
        PBXBuildFile file = this.addToBuildPhase(this.getPendingNotifications(), target, phase, reference, null);
        this.autoFirePendingNotifications();
        return file;
    }

    private PBXBuildFile addToBuildPhase(@NotNull Notifications notifications, @NotNull PBXTarget target, @NotNull PBXBuildPhase phase, @NotNull PBXReference reference, @Nullable Collection<PBXBuildFile> prototypes) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(84);
        }
        if (target == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(85);
        }
        if (phase == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(86);
        }
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(87);
        }
        LOG.assertTrue(target.getFile() == this.myProjectFile);
        LOG.assertTrue(reference.getFile() == this.myProjectFile);
        PBXBuildFile buildFile = new PBXBuildFile(this.myProjectFile);
        PBXBuildFile prototype = PBXProjectFileManipulator.findPrototypeInPhase(phase.getType(), prototypes);
        if (prototype != null) {
            buildFile.putAll((Map)((Object)prototype));
        }
        buildFile.setAttribute("fileRef", reference.createReference());
        PBXProjectFileManipulator.addObject(buildFile, notifications);
        phase.addFile(buildFile.createReference());
        this.myProjectFile.updateBuildFile(reference, buildFile, target, phase);
        if (phase.getType() == PBXBuildPhase.Type.FRAMEWORKS) {
            notifications.buildSettingsChanged();
        } else {
            notifications.buildFilesChanged();
        }
        return buildFile;
    }

    @Nullable
    private static PBXBuildFile findPrototypeInPhase(@NotNull PBXBuildPhase.PhaseType phaseType, @Nullable Collection<PBXBuildFile> prototypes) {
        if (phaseType == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(88);
        }
        if (prototypes == null) {
            return null;
        }
        for (PBXBuildFile proto : prototypes) {
            PBXBuildPhase phase = proto.getPhase();
            if (phase == null || !phaseType.equals(phase.getType())) continue;
            return proto;
        }
        return null;
    }

    private void updateNamePathSourceTree(@NotNull PBXReference reference, @Nullable PBXReference parent, @Nullable String name, @Nullable String path, @Nullable String sourceTree) {
        AppleFileType type;
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(89);
        }
        LOG.assertTrue(name != null || path != null);
        path = path == null ? null : FileUtil.toCanonicalPath((String)path);
        String resolvedName = name;
        if (path != null && parent instanceof PBXVariantGroup) {
            String parentFileName = new File(path).getParentFile().getName();
            resolvedName = FileUtilRt.getNameWithoutExtension((String)parentFileName);
            parent.setAttribute("name", new File(path).getName());
        }
        String resolvedPath = path;
        String resolvedSourceTree = sourceTree;
        if (path != null && parent != null) {
            PathInfo pathInfo = this.resolvePathAgainstSourceTree(parent, path, sourceTree);
            resolvedSourceTree = pathInfo.getSourceTree();
            resolvedPath = pathInfo.getPath();
            if (resolvedName == null) {
                resolvedName = new File(path).getName();
            }
        }
        if (resolvedName != null && !resolvedName.equals(resolvedPath)) {
            reference.setAttribute("name", resolvedName);
        } else {
            reference.setAttribute("name", null);
        }
        if (resolvedPath != null && !resolvedPath.equals(".")) {
            reference.setAttribute("path", resolvedPath);
        } else {
            reference.setAttribute("path", null);
        }
        LOG.assertTrue(resolvedSourceTree != null);
        reference.setAttribute("sourceTree", resolvedSourceTree);
        if (reference.getAttribute("lastKnownFileType", null) != null && (type = reference.getFileType()) != null && !type.isFolder()) {
            String t = AppleFileTypeManager.getInstance().getSuitableFileTypeIdByFilename(reference.getFileName(), false);
            reference.setAttribute("lastKnownFileType", t);
        }
    }

    @NotNull
    private PathInfo resolvePathAgainstSourceTree(@NotNull PBXReference parent, @NotNull String path, @Nullable String sourceTree) {
        if (parent == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(90);
        }
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(91);
        }
        if ("SDKROOT".equals(sourceTree) || "DEVELOPER_DIR".equals(sourceTree) || "BUILT_PRODUCTS_DIR".equals(sourceTree)) {
            return new PathInfo(sourceTree, path);
        }
        if ("SOURCE_ROOT".equals(sourceTree)) {
            if (FileUtil.isAbsolute((String)path)) {
                File srcRootFile = new File(this.myProjectFile.getBaseDir().getPath());
                return PBXProjectFileManipulator.buildRelativePath(new File(path), srcRootFile, "SOURCE_ROOT");
            }
            return new PathInfo(sourceTree, path);
        }
        if ("<absolute>".equals(sourceTree)) {
            LOG.assertTrue(FileUtil.isAbsolute((String)path));
            return new PathInfo(sourceTree, path);
        }
        String parentPath = parent.resolvePath();
        if (parentPath == null) {
            LOG.assertTrue(FileUtil.isAbsolute((String)path));
            return new PathInfo("<absolute>", path);
        }
        boolean forceGroupTree = "<group>".equals(sourceTree);
        if (forceGroupTree) {
            path = PBXProjectFileManipulator.pathFromGroupPath(path, parentPath);
        }
        File parentFile = new File(parentPath);
        File refFile = new File(path);
        String string = sourceTree = sourceTree == null ? "<group>" : sourceTree;
        if (forceGroupTree || VfsUtilCore.isAncestor((File)parentFile, (File)refFile, (boolean)false)) {
            return PBXProjectFileManipulator.buildRelativePath(refFile, parentFile, sourceTree);
        }
        File srcRootFile = new File(this.myProjectFile.getBaseDir().getPath());
        if (VfsUtilCore.isAncestor((File)srcRootFile, (File)refFile, (boolean)true)) {
            return PBXProjectFileManipulator.buildRelativePath(new File(path), srcRootFile, "SOURCE_ROOT");
        }
        return PBXProjectFileManipulator.buildRelativePath(refFile, parentFile, sourceTree);
    }

    public PBXBuildPhase addBuildPhase(@NotNull PBXBuildPhase.PhaseType type, @NotNull Map<String, Object> properties, @Nullable PBXTarget target) {
        if (type == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(92);
        }
        if (properties == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(93);
        }
        return this.addBuildPhase(type, properties, target, -1);
    }

    public PBXBuildPhase addBuildPhase(@NotNull PBXBuildPhase.PhaseType type, @NotNull Map<String, Object> properties, @Nullable PBXTarget target, int index) {
        PBXBuildPhase phase;
        PBXBuildPhase.Type phaseType;
        if (type == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(94);
        }
        if (properties == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(95);
        }
        if ((phaseType = PBXBuildPhase.Type.typeFromName(type.getName())) != null) {
            phase = switch (phaseType) {
                case PBXBuildPhase.Type.COPY_FILES -> new PBXCopyFilesBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.FRAMEWORKS -> new PBXFrameworksBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.HEADERS -> new PBXHeadersBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.RESOURCES -> new PBXResourcesBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.REZ -> new PBXRezBuildPhase(this.myProjectFile);
                case PBXBuildPhase.Type.SHELL_SCRIPT -> {
                    PBXShellScriptBuildPhase buildPhase = new PBXShellScriptBuildPhase(this.myProjectFile);
                    buildPhase.setAttribute("inputPaths", new ArrayList());
                    buildPhase.setAttribute("outputPaths", new ArrayList());
                    yield buildPhase;
                }
                default -> new PBXSourcesBuildPhase(this.myProjectFile);
            };
        } else {
            phase = new PBXBuildPhase(this.myProjectFile, type);
        }
        phase.setAttribute("runOnlyForDeploymentPostprocessing", "0");
        for (String property : properties.keySet()) {
            Object value = properties.get(property);
            if (value instanceof List) {
                ArrayList<ObjectReference> refs = new ArrayList<ObjectReference>();
                for (Object item : (List)value) {
                    if (item instanceof PbxId) {
                        refs.add(new ObjectReference((PbxId)item, this.myProjectFile));
                        continue;
                    }
                    if (!(item instanceof String)) continue;
                    refs.add((ObjectReference)item);
                }
                phase.setAttribute(property, refs);
                continue;
            }
            phase.setAttribute(property, String.valueOf(value));
        }
        PBXBuildPhase object = phase;
        PBXProjectFileManipulator.addObject(object, this.getPendingNotifications());
        if (target != null) {
            if (index < 0) {
                target.addToAttributeList("buildPhases", phase.createReference());
            } else {
                target.addToAttributeList("buildPhases", phase.createReference(), index);
            }
        }
        return phase;
    }

    public <T extends PBXBuildPhase> void changeBuildPhase(@NotNull T phase, @NotNull Consumer<T> manipulation) {
        if (phase == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(96);
        }
        if (manipulation == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(97);
        }
        manipulation.accept(phase);
        this.getPendingNotifications().targetsChanged();
        this.autoFirePendingNotifications();
    }

    @NotNull
    private PBXGroup addMainGroup(@NotNull Notifications notifications) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(98);
        }
        PBXGroup newMainGroup = new PBXGroup(this.myProjectFile);
        newMainGroup.setAttribute("children", Collections.emptyList());
        newMainGroup.setAttribute("sourceTree", "<group>");
        PBXProjectFileManipulator.addObject(newMainGroup, notifications);
        this.myProjectFile.getProjectObject().setAttribute("mainGroup", newMainGroup.createReference());
        PBXGroup pBXGroup = newMainGroup;
        if (pBXGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(99);
        }
        return pBXGroup;
    }

    @NotNull
    public PBXGroup addGroup(@Nullable @NonNls String sourceTree, @Nullable @NonNls String name, @Nullable String path) {
        PBXGroup pBXGroup = this.addGroup(sourceTree, name, path, null);
        if (pBXGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(100);
        }
        return pBXGroup;
    }

    @NotNull
    private PBXGroup addGroup(@NotNull Notifications notifications, @Nullable @NonNls String sourceTree, @Nullable @NonNls String name, @Nullable @NonNls String path) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(101);
        }
        return this.addGroup(notifications, sourceTree, name, path, null, true, false);
    }

    @NotNull
    public PBXGroup addGroup(@Nullable String sourceTree, @Nullable @NonNls String name, @Nullable @NonNls String path, @Nullable PBXGroup parent) {
        PBXGroup pBXGroup = this.addGroup(sourceTree, name, path, parent, false);
        if (pBXGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(102);
        }
        return pBXGroup;
    }

    @NotNull
    private PBXGroup addGroup(@NotNull Notifications notifications, @Nullable @NonNls String sourceTree, @Nullable @NonNls String name, @Nullable @NonNls String path, @Nullable PBXGroup parent) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(103);
        }
        return this.addGroup(notifications, sourceTree, name, path, parent, true, false);
    }

    @NotNull
    public PBXGroup addGroup(@Nullable @NonNls String sourceTree, @Nullable @NonNls String name, @Nullable @NonNls String path, @Nullable PBXGroup parent, boolean forceAdd) {
        PBXGroup group = this.addGroup(this.getPendingNotifications(), sourceTree, name, path, parent, true, forceAdd);
        this.autoFirePendingNotifications();
        PBXGroup pBXGroup = group;
        if (pBXGroup == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(104);
        }
        return pBXGroup;
    }

    @NotNull
    private PBXGroup addGroup(@NotNull Notifications notifications, @Nullable @NonNls String sourceTree, @Nullable @NonNls String name, @Nullable @NonNls String path, @Nullable PBXGroup parent, boolean appendToChildren, boolean forceAdd) {
        ObjectReference productRefGroup;
        PBXGroup actualParent;
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(105);
        }
        if (parent != null) {
            LOG.assertTrue(parent.getFile() == this.myProjectFile);
        }
        PBXProject projectObject = this.myProjectFile.getProjectObject();
        PBXGroup mainGroup = projectObject.getMainGroup();
        if (parent == null && mainGroup == null) {
            mainGroup = this.addMainGroup(notifications);
        }
        PBXGroup pBXGroup = actualParent = parent == null ? mainGroup : parent;
        if (!forceAdd) {
            List<PBXReference> _children = actualParent.resolveAttributeList("children", PBXReference.class);
            for (PBXReference reference : _children) {
                if (!(reference instanceof PBXGroup) || !reference.getDisplayName().equals(name == null ? path : name)) continue;
                PBXGroup pBXGroup2 = (PBXGroup)reference;
                if (pBXGroup2 == null) {
                    PBXProjectFileManipulator.$$$reportNull$$$0(106);
                }
                return pBXGroup2;
            }
        }
        PBXGroup pbxGroup = new PBXGroup(this.myProjectFile);
        pbxGroup.setAttribute("children", Collections.emptyList());
        this.updateNamePathSourceTree(pbxGroup, actualParent, name, path, sourceTree);
        PBXProjectFileManipulator.addObject(pbxGroup, appendToChildren ? actualParent : null, notifications);
        if ("Products".equals(name) && ((productRefGroup = (ObjectReference)projectObject.getAttribute("productRefGroup", ObjectReference.class)) == null || productRefGroup.resolveObject() == null)) {
            projectObject.setAttribute("productRefGroup", pbxGroup.createReference());
        }
        notifications.referencesChanged();
        PBXGroup pBXGroup3 = pbxGroup;
        if (pBXGroup3 == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(107);
        }
        return pBXGroup3;
    }

    public void addFramework(@NotNull String name, @Nullable PBXTarget targetOrNullForAll) {
        PBXTarget[] pBXTargetArray;
        if (name == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(108);
        }
        if (targetOrNullForAll != null) {
            PBXTarget[] pBXTargetArray2 = new PBXTarget[1];
            pBXTargetArray = pBXTargetArray2;
            pBXTargetArray2[0] = targetOrNullForAll;
        } else {
            pBXTargetArray = this.getAllTargets();
        }
        PBXTarget[] targets = pBXTargetArray;
        this.addFrameworkOrLibrary(name + ".framework", targets);
    }

    public void addFrameworkOrLibrary(@NotNull String nameWithExtension, @NotNull PBXTarget[] targets) {
        if (nameWithExtension == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(109);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(110);
        }
        this.addFrameworkOrLibrary(null, nameWithExtension, targets);
    }

    public void addFrameworkOrLibrary(@Nullable VirtualFile file, @NotNull String nameWithExtension, @NotNull PBXTarget[] targets) {
        if (nameWithExtension == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(111);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(112);
        }
        Notifications notifications = this.getPendingNotifications();
        PBXGroup group = this.addGroup(notifications, "<group>", "Frameworks", null);
        this.doAddFramework(notifications, nameWithExtension, file, targets, group);
        this.autoFirePendingNotifications();
    }

    public void addOtherFramework(@NotNull String name) {
        if (name == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(113);
        }
        Notifications notifications = this.getPendingNotifications();
        PBXGroup group = this.myProjectFile.findGroupByName("Other Frameworks");
        if (group == null) {
            PBXGroup frameworks = this.myProjectFile.findGroupByName("Frameworks");
            if (frameworks == null) {
                frameworks = this.addGroup(notifications, "<group>", "Frameworks", null);
            }
            group = this.addGroup(notifications, "<group>", "Other Frameworks", null, frameworks);
        }
        this.doAddFramework(notifications, name + ".framework", null, PBXTarget.EMPTY_ARRAY, group);
        this.autoFirePendingNotifications();
    }

    private void doAddFramework(@NotNull Notifications notifications, @NotNull String nameWithExtension, @Nullable VirtualFile file, @NotNull PBXTarget[] targets, @NotNull PBXGroup group) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(114);
        }
        if (nameWithExtension == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(115);
        }
        if (group == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(116);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(117);
        }
        List<PBXReference> children = group.resolveAttributeList("children", PBXReference.class);
        PBXReference existing = null;
        if (file == null || file.getName().endsWith(".framework") || file.getName().endsWith(".dylib")) {
            for (PBXReference child : children) {
                if (!nameWithExtension.equals(child.getName())) continue;
                existing = child;
                break;
            }
        }
        if (existing != null) {
            this.addToTargets(notifications, Arrays.asList(targets), existing, PBXBuildPhase.Type.FRAMEWORKS, null);
        } else {
            Couple<String> pair;
            Couple<String> couple = pair = file != null ? Couple.of((Object)file.getPath(), (Object)"<absolute>") : this.findFrameworkOrLibraryPath(targets, nameWithExtension);
            if (pair != null) {
                this.addFileInternal(notifications, (String)pair.getFirst(), targets, group, (String)pair.getSecond(), PBXBuildPhase.Type.FRAMEWORKS);
            } else if (nameWithExtension.endsWith(".framework")) {
                @NonNls String path = String.format("Library/Frameworks/%s", nameWithExtension);
                this.addFileInternal(notifications, path, targets, group, "DEVELOPER_DIR", PBXBuildPhase.Type.FRAMEWORKS);
            }
        }
    }

    @NotNull
    public PBXReference addLinkedProject(@NotNull PBXProjectFile another) {
        if (another == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(118);
        }
        LOG.assertTrue(another != this.myProjectFile);
        VirtualFile virtualFile = another.getPBXProjFile().getParent();
        PBXProject projectObject = this.myProjectFile.getProjectObject();
        Notifications notifications = this.getPendingNotifications();
        PBXGroup mainGroup = projectObject.getMainGroup();
        if (mainGroup == null) {
            mainGroup = this.addMainGroup(notifications);
        }
        PBXReference projectReference = this.addFileInternal(notifications, virtualFile.getPath(), PBXTarget.EMPTY_ARRAY, mainGroup, "<group>", null);
        PBXGroup products = this.addGroup(notifications, "<group>", "Products", null, projectObject.getMainGroup(), false, true);
        List<Map> projectReferences = projectObject.getAttributeListForModification("projectReferences", Map.class);
        PBXDictionary referenceInfo = new PBXDictionary(this.myProjectFile);
        referenceInfo.put("ProductGroup", products.createReference());
        referenceInfo.put("ProjectRef", projectReference.createReference());
        projectReferences.add((Map)((Object)referenceInfo));
        projectObject.setAttribute("projectReferences", projectReferences);
        List targets = another.getTargets(null);
        for (PBXTarget target : targets) {
            PBXContainerItemProxy itemProxy = new PBXContainerItemProxy(this.myProjectFile);
            PBXFileReference productReference = target.resolveAttribute("productReference", PBXFileReference.class);
            if (productReference == null) continue;
            itemProxy.setAttribute("containerPortal", projectReference.createReference());
            itemProxy.setAttribute("proxyType", "2");
            itemProxy.setAttribute("remoteGlobalIDString", productReference.createReference());
            itemProxy.setAttribute("remoteInfo", target.getDisplayName());
            PBXProjectFileManipulator.addObject(itemProxy, notifications);
            PBXReferenceProxy referenceProxy = new PBXReferenceProxy(this.myProjectFile);
            referenceProxy.setAttribute("fileType", productReference.getAttribute("explicitFileType", String.class));
            referenceProxy.setAttribute("path", productReference.getAttribute("path", String.class));
            referenceProxy.setAttribute("remoteRef", itemProxy.createReference());
            referenceProxy.setAttribute("sourceTree", productReference.getAttribute("sourceTree", String.class));
            PBXProjectFileManipulator.addObject(referenceProxy, products, notifications);
        }
        PBXProjectFileManipulator.appendLinkedProjectEvents(notifications);
        this.autoFirePendingNotifications();
        PBXReference pBXReference = projectReference;
        if (pBXReference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(119);
        }
        return pBXReference;
    }

    @Nullable
    private Couple<String> findFrameworkOrLibraryPath(@NotNull PBXTarget[] targets, @NotNull String nameWithExtension) {
        String frameworkPath;
        if (nameWithExtension == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(120);
        }
        if (targets == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(121);
        }
        if ((frameworkPath = this.findFrameworkOrLibraryPath((AppleSdk)null, nameWithExtension)) != null) {
            return Couple.of((Object)frameworkPath, (Object)"DEVELOPER_DIR");
        }
        for (PBXTarget target : targets) {
            for (XCBuildConfiguration buildConfiguration : target.getBuildConfigurations()) {
                AppleSdk baseSdk = XCCoreBuildSettings.getRawCoreBuildSettings(buildConfiguration).getBaseSdk();
                if (baseSdk == null || (frameworkPath = this.findFrameworkOrLibraryPath(baseSdk, nameWithExtension)) == null) continue;
                return Couple.of((Object)frameworkPath, (Object)"SDKROOT");
            }
        }
        for (AppleSdk sdk : AppleSdkManager.getInstance().getSdks()) {
            frameworkPath = this.findFrameworkOrLibraryPath(sdk, nameWithExtension);
            if (frameworkPath == null) continue;
            return Couple.of((Object)frameworkPath, (Object)"SDKROOT");
        }
        return null;
    }

    @Nullable
    private String findFrameworkOrLibraryPath(@Nullable AppleSdk sdk, final @NotNull String nameWithExtension) {
        String rootPath;
        if (nameWithExtension == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(122);
        }
        CommonProcessors.FindFirstProcessor<VirtualFile> finder = new CommonProcessors.FindFirstProcessor<VirtualFile>(this){

            protected boolean accept(VirtualFile virtualFile) {
                return virtualFile.getName().equals(nameWithExtension);
            }
        };
        if (sdk != null) {
            rootPath = sdk.getHomePath();
            sdk.processFrameworkFiles((Processor<VirtualFile>)finder);
            sdk.processLibraryFiles((Processor<VirtualFile>)finder);
        } else {
            BuildSettingsProvider settingsProvider = this.myProjectFile.getBuildSettingsProvider();
            rootPath = settingsProvider.getBuildSetting("DEVELOPER_DIR").getAbsolutePath();
            AppleSdk.processDeveloperFrameworkFiles(settingsProvider, (Processor<VirtualFile>)finder);
        }
        if (finder.isFound() && rootPath != null) {
            VirtualFile file = (VirtualFile)finder.getFoundValue();
            String substring = file.getPath().substring(rootPath.length());
            return substring.charAt(0) == '/' ? substring.substring(1) : substring;
        }
        return null;
    }

    @TestOnly
    @NotNull
    public XCSwiftPackageProductDependency createSwiftPackageProductDependency(@Nullable XCRemoteSwiftPackageReference packageReference, @NotNull String name) {
        if (name == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(123);
        }
        Notifications notifications = this.getPendingNotifications();
        XCSwiftPackageProductDependency dependency = new XCSwiftPackageProductDependency(this.myProjectFile);
        if (packageReference != null) {
            dependency.setAttribute("package", packageReference.createReference());
        }
        dependency.setAttribute("productName", name);
        PBXProjectFileManipulator.addObject(dependency, notifications);
        this.autoFirePendingNotifications();
        XCSwiftPackageProductDependency xCSwiftPackageProductDependency = dependency;
        if (xCSwiftPackageProductDependency == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(124);
        }
        return xCSwiftPackageProductDependency;
    }

    @TestOnly
    public void addSwiftPackageProductDependency(@NotNull PBXTarget addTo, @NotNull XCSwiftPackageProductDependency dependency) {
        if (addTo == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(125);
        }
        if (dependency == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(126);
        }
        this.getPendingNotifications().buildSettingsChanged();
        addTo.addToAttributeList("packageProductDependencies", dependency.createReference());
        this.autoFirePendingNotifications();
    }

    @TestOnly
    public void removeSwiftPackageProductTargetDependency(@NotNull PBXTarget removeFrom, @NotNull XCSwiftPackageProductDependency swiftProductDependency) {
        if (removeFrom == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(127);
        }
        if (swiftProductDependency == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(128);
        }
        this.getPendingNotifications().buildSettingsChanged();
        removeFrom.removeFromAttributeList("packageProductDependencies", swiftProductDependency.createReference());
        this.autoFirePendingNotifications();
    }

    @NotNull
    public PBXTarget addNativeTarget(@NotNull String name, @NotNull String productTypeId, @NotNull Map<String, Object> buildSettings, @Nullable ApplePlatform platform) {
        PBXFileReference productReference;
        String productReferenceName;
        ApplePackageType packageType;
        if (name == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(129);
        }
        if (productTypeId == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(130);
        }
        if (buildSettings == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(131);
        }
        Notifications notifications = this.getPendingNotifications();
        PBXNativeTarget target = new PBXNativeTarget(this.myProjectFile);
        target.setAttribute("productType", productTypeId);
        AppleProductType productType = platform == null ? null : platform.findProductType(productTypeId);
        ApplePackageType applePackageType = packageType = productType == null ? null : productType.getDefaultPackageType();
        if (packageType != null) {
            productReferenceName = packageType.getProductReferenceName();
            if (productReferenceName != null) {
                productReference = new PBXFileReference(this.myProjectFile);
                PBXGroup products = this.addGroup(notifications, "<group>", "Products", null);
                PBXProjectFileManipulator.addObject(productReference, products, notifications);
                target.setAttribute("productReference", productReference.createReference());
            } else {
                productReference = null;
            }
        } else {
            productReference = null;
            productReferenceName = null;
        }
        this.initTarget(name, target, () -> {
            if (productReference != null) {
                productReference.setAttribute("explicitFileType", packageType.getProductReferenceFileType());
                productReference.setAttribute("includeInIndex", "0");
                productReference.setAttribute("path", BuildSettingsResolver.resolveValue(productReferenceName, this.myProjectFile, target, buildSettings, platform));
                productReference.setAttribute("sourceTree", "BUILT_PRODUCTS_DIR");
            }
        }, notifications);
        this.autoFirePendingNotifications();
        PBXNativeTarget pBXNativeTarget = target;
        if (pBXNativeTarget == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(132);
        }
        return pBXNativeTarget;
    }

    @NotNull
    public PBXTarget addLegacyTarget(@NotNull String name, @NotNull String buildToolPath, @NotNull String buildToolArgsString) {
        if (name == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(133);
        }
        if (buildToolPath == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(134);
        }
        if (buildToolArgsString == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(135);
        }
        Notifications notifications = this.getPendingNotifications();
        PBXLegacyTarget target = new PBXLegacyTarget(this.myProjectFile);
        target.setAttribute("buildToolPath", buildToolPath);
        target.setAttribute("buildArgumentsString", buildToolArgsString);
        target.setAttribute("passBuildSettingsInEnvironment", "1");
        this.initTarget(name, target, null, notifications);
        this.autoFirePendingNotifications();
        PBXLegacyTarget pBXLegacyTarget = target;
        if (pBXLegacyTarget == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(136);
        }
        return pBXLegacyTarget;
    }

    private void initTarget(@NotNull String name, @NotNull PBXTarget target, @Nullable Runnable postConfigure, @NotNull Notifications notifications) {
        if (name == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(137);
        }
        if (target == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(138);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(139);
        }
        XCConfigurationList configurationList = new XCConfigurationList(this.myProjectFile);
        configurationList.setAttribute("buildConfigurations", Collections.emptyList());
        configurationList.setAttribute("defaultConfigurationIsVisible", "0");
        PBXProjectFileManipulator.addObject(configurationList, notifications);
        target.setAttribute("buildConfigurationList", configurationList.createReference());
        target.setAttribute("buildPhases", Collections.emptyList());
        target.setAttribute("buildRules", Collections.emptyList());
        target.setAttribute("dependencies", Collections.emptyList());
        target.setAttribute("name", name);
        target.setAttribute("productName", name);
        PBXProjectFileManipulator.addObject(target, notifications);
        this.myProjectFile.getProjectObject().addToAttributeList("targets", target.createReference());
        if (postConfigure != null) {
            postConfigure.run();
        }
        notifications.referencesChanged();
        notifications.targetsChanged();
    }

    public void removeTarget(@NotNull PBXTarget targetToRemove) {
        CoreXcodeWorkspace workspace;
        if (targetToRemove == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(140);
        }
        List<Object> projects = (workspace = CoreXcodeWorkspace.getInstance(this.myProjectFile.getProject())) != null ? workspace.getAllProjects() : Collections.emptyList();
        for (PBXProjectFile pBXProjectFile : projects) {
            if (pBXProjectFile == this.myProjectFile) continue;
            Iterator<PBXTargetDependency> foreignManipulator = pBXProjectFile.getManipulator(false);
            for (PBXTargetDependency eachForeignDependency : PBXProjectFileManipulator.findTargetDependenciesInProject(pBXProjectFile, targetToRemove)) {
                ((PBXProjectFileManipulator)((Object)foreignManipulator)).doRemoveTargetDependency(eachForeignDependency, ((PBXProjectFileManipulator)((Object)foreignManipulator)).getPendingNotifications());
            }
            ((PBXProjectFileManipulator)((Object)foreignManipulator)).firePendingNotifications();
        }
        ArrayList<PBXObject> objectsToRemove = new ArrayList<PBXObject>();
        ArrayList<PBXReference> arrayList = new ArrayList<PBXReference>();
        objectsToRemove.add(targetToRemove);
        objectsToRemove.addAll(targetToRemove.getBuildConfigurationList().getConfigurations());
        objectsToRemove.add(targetToRemove.getBuildConfigurationList());
        for (PBXBuildPhase eachPhase : targetToRemove.getBuildPhases()) {
            objectsToRemove.addAll(eachPhase.getFiles());
            objectsToRemove.add(eachPhase);
        }
        objectsToRemove.addAll(targetToRemove.getBuildRules());
        for (PBXTargetDependency eachDependency : targetToRemove.getDependencies()) {
            PBXProjectFileManipulator.collectTargetDependencyToRemove(eachDependency, objectsToRemove);
        }
        for (PBXTargetDependency each : PBXProjectFileManipulator.findTargetDependenciesInProject(targetToRemove.getFile(), targetToRemove)) {
            PBXProjectFileManipulator.collectTargetDependencyToRemove(each, objectsToRemove);
        }
        if (targetToRemove instanceof PBXNativeTarget) {
            arrayList.add(((PBXNativeTarget)targetToRemove).getProductReference());
        }
        Collections.reverse(objectsToRemove);
        Notifications notifications = this.getPendingNotifications();
        this.doRemoveReferences(arrayList, notifications);
        this.doRemoveObjects(objectsToRemove, notifications);
        this.autoFirePendingNotifications();
    }

    private static List<PBXTargetDependency> findTargetDependenciesInProject(@NotNull PBXProjectFile projectFile, @NotNull PBXTarget onTarget) {
        if (projectFile == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(141);
        }
        if (onTarget == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(142);
        }
        SmartList result = new SmartList();
        for (PBXTarget eachOtherTarget : projectFile.getTargets(null)) {
            if (eachOtherTarget == onTarget) continue;
            for (PBXTargetDependency eachOtherDependency : eachOtherTarget.getDependencies()) {
                if (eachOtherDependency.resolveTarget() != onTarget) continue;
                result.add(eachOtherDependency);
            }
        }
        return result;
    }

    @NotNull
    public PBXTargetDependency addTargetDependency(@NotNull PBXTarget addTo, @NotNull PBXTarget dependency) {
        if (addTo == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(143);
        }
        if (dependency == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(144);
        }
        Notifications notifications = this.getPendingNotifications();
        PBXContainerItemProxy targetProxy = new PBXContainerItemProxy(this.myProjectFile);
        PBXObject containerPortal = null;
        PBXProjectFile dependencyProject = dependency.getFile();
        if (dependencyProject == this.myProjectFile) {
            containerPortal = this.myProjectFile.getProjectObject();
        } else {
            for (PBXReference eachRef : this.myProjectFile.findReferences(dependencyProject.getXcodeProjFile())) {
                if (!eachRef.isLinkedProject()) continue;
                containerPortal = eachRef;
                break;
            }
            if (containerPortal == null) {
                throw new RuntimeException("Project " + String.valueOf(dependencyProject) + "should be linked to " + String.valueOf(this.myProjectFile) + " first");
            }
        }
        targetProxy.setAttribute("containerPortal", containerPortal.createReference());
        targetProxy.setAttribute("proxyType", "1");
        targetProxy.setAttribute("remoteGlobalIDString", dependency.getId().asString());
        targetProxy.setAttribute("remoteInfo", dependency.getName());
        PBXProjectFileManipulator.addObject(targetProxy, notifications);
        PBXTargetDependency targetDependency = new PBXTargetDependency(this.myProjectFile);
        targetDependency.setAttribute("target", dependency.createReference());
        targetDependency.setAttribute("targetProxy", targetProxy.createReference());
        PBXProjectFileManipulator.addObject(targetDependency, notifications);
        addTo.addToAttributeList("dependencies", targetDependency.createReference());
        notifications.referencesChanged();
        this.autoFirePendingNotifications();
        PBXTargetDependency pBXTargetDependency = targetDependency;
        if (pBXTargetDependency == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(145);
        }
        return pBXTargetDependency;
    }

    public void removeTargetDependency(@NotNull PBXTargetDependency dependency) {
        if (dependency == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(146);
        }
        Notifications notifications = this.getPendingNotifications();
        this.doRemoveTargetDependency(dependency, notifications);
        this.autoFirePendingNotifications();
    }

    private void doRemoveTargetDependency(@NotNull PBXTargetDependency dependency, @NotNull Notifications notifications) {
        if (dependency == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(147);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(148);
        }
        ArrayList<PBXObject> toRemove = new ArrayList<PBXObject>();
        PBXProjectFileManipulator.collectTargetDependencyToRemove(dependency, toRemove);
        this.doRemoveObjects(toRemove, notifications);
    }

    private static void collectTargetDependencyToRemove(PBXTargetDependency dependency, List<PBXObject> toRemove) {
        toRemove.add(dependency);
        ContainerUtil.addIfNotNull(toRemove, (Object)((Object)dependency.getTargetProxy()));
    }

    public void addProductDependency(@NotNull PBXTarget addTo, @NotNull PBXTarget dependency) {
        PBXFileReference productReference;
        if (addTo == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(149);
        }
        if (dependency == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(150);
        }
        LOG.assertTrue((productReference = dependency.resolveAttribute("productReference", PBXFileReference.class)) != null, (Object)("Unable to find reference in target: " + String.valueOf((Object)dependency)));
        this.addToTargets(this.getPendingNotifications(), Collections.singleton(addTo), productReference, null, null);
        this.autoFirePendingNotifications();
    }

    @NotNull
    public XCBuildConfiguration addConfiguration(@NotNull String name, @NotNull Map<String, Object> map, @Nullable PBXTarget target) {
        if (name == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(151);
        }
        if (map == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(152);
        }
        Notifications notifications = this.getPendingNotifications();
        XCBuildConfiguration configuration = new XCBuildConfiguration(this.myProjectFile);
        PBXObject buildSettings = new PBXObject(this.myProjectFile);
        buildSettings.putAll(map);
        configuration.setAttribute("buildSettings", (Object)buildSettings);
        configuration.setAttribute("name", name);
        PBXProjectFileManipulator.addObject(configuration, notifications);
        XCConfigurationList list = target == null ? this.myProjectFile.getProjectObject().getBuildConfigurationList() : target.getBuildConfigurationList();
        list.addToAttributeList("buildConfigurations", configuration.createReference());
        notifications.referencesChanged();
        notifications.targetsChanged();
        this.autoFirePendingNotifications();
        XCBuildConfiguration xCBuildConfiguration = configuration;
        if (xCBuildConfiguration == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(153);
        }
        return xCBuildConfiguration;
    }

    @Nullable
    private PBXTarget findTarget(@Nullable String targetName) {
        return this.myProjectFile.findTarget(targetName, null);
    }

    @NotNull
    public PBXTarget[] getAllTargets() {
        List<PBXTarget> targets = this.myProjectFile.getTargets(null);
        PBXTarget[] pBXTargetArray = targets.toArray(PBXTarget.EMPTY_ARRAY);
        if (pBXTargetArray == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(154);
        }
        return pBXTargetArray;
    }

    @NotNull
    private static PathInfo buildRelativePath(@NotNull File file, @NotNull File groupPath, @NotNull String sourceTree) {
        if (file == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(155);
        }
        if (groupPath == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(156);
        }
        if (sourceTree == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(157);
        }
        if (!VfsUtilCore.isAncestor((File)groupPath, (File)file, (boolean)true) && file.getPath().startsWith("..")) {
            return new PathInfo(sourceTree, file.getPath());
        }
        String path = FileUtil.getRelativePath((String)groupPath.getAbsolutePath(), (String)file.getAbsolutePath(), (char)File.separatorChar);
        LOG.assertTrue(path != null, (Object)String.format("Unable to find relative path (base='%s', file='%s')", groupPath.getPath(), file.getPath()));
        return new PathInfo(sourceTree, path);
    }

    public void updateEncodings(@NotNull Collection<String> paths) {
        if (paths == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(158);
        }
        this.doProcessReferences(paths, (PairProcessor<PBXReference, String>)((PairProcessor)(ref, path) -> {
            PBXProjectFileManipulator.updateEncoding(ref, path);
            return false;
        }), false);
    }

    private static void updateEncoding(@NotNull PBXReference ref, @NotNull String path) {
        VirtualFile file;
        if (ref == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(159);
        }
        if (path == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(160);
        }
        if ((file = StandardFileSystems.local().findFileByPath(path)) == null) {
            return;
        }
        Charset charset = file.getCharset();
        long encoding = Foundation.getEncodingCode((String)charset.name());
        ref.setAttribute("fileEncoding", encoding == -1L ? null : String.valueOf(encoding));
    }

    public void rename(@NotNull PBXReference ref, @NotNull String oldFilePath, @NotNull String newPath, @NotNull String newFileName) {
        if (ref == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(161);
        }
        if (oldFilePath == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(162);
        }
        if (newPath == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(163);
        }
        if (newFileName == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(164);
        }
        HashMap<PBXReference, FSMoveInfo> info = new HashMap<PBXReference, FSMoveInfo>();
        info.put(ref, new FSMoveInfo(newPath, newFileName));
        this.rename(this.getPendingNotifications(), oldFilePath, newPath, info);
        this.autoFirePendingNotifications();
    }

    public void rename(@NotNull Collection<Couple<String>> renames) {
        if (renames == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(165);
        }
        Notifications notifications = this.getPendingNotifications();
        for (Couple<String> rename : renames) {
            this.rename(notifications, (String)rename.first, (String)rename.second, Collections.emptyMap());
        }
        this.autoFirePendingNotifications();
    }

    public void setBuildSetting(@NotNull XCBuildConfiguration buildConfiguration, @Nullable BuildSetting setting) {
        if (buildConfiguration == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(166);
        }
        if (buildConfiguration.setBuildSetting(setting, false)) {
            this.getPendingNotifications().buildSettingsChanged();
        }
    }

    private void rename(@NotNull Notifications notifications, @NotNull String oldPath, @NotNull String newPath, @NotNull Map<PBXReference, FSMoveInfo> mandatoryUpdates) {
        FileRefTree st;
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(167);
        }
        if (oldPath == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(168);
        }
        if (newPath == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(169);
        }
        if (mandatoryUpdates == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(170);
        }
        if ((st = (FileRefTree)this.myProjectFile.getFileRefTree().getSubTree(oldPath, false)) == null) {
            return;
        }
        HashMap<PBXReference, FSMoveInfo> refsToInfo = new HashMap<PBXReference, FSMoveInfo>(mandatoryUpdates);
        FileRefTree.Processor processor = subTree -> {
            for (PBXReference ref : subTree.getReferences()) {
                String newRefPath;
                String oldRefPath;
                if (refsToInfo.containsKey((Object)ref) || (oldRefPath = ref.resolvePath()) == null || !FileUtil.isAncestor((String)oldPath, (String)oldRefPath, (boolean)false) || oldRefPath.equals(newRefPath = StringUtil.replace((String)oldRefPath, (String)oldPath, (String)newPath, (boolean)true))) continue;
                String oldName = ref.getName();
                String newName = PBXProjectFileManipulator.isNameDerivedFromPath(ref, oldName) ? null : oldName;
                refsToInfo.put(ref, new FSMoveInfo(newRefPath, newName));
            }
            return true;
        };
        if (!oldPath.equals(newPath)) {
            st.processRecursively(processor);
        }
        if (refsToInfo.isEmpty()) {
            return;
        }
        for (PBXReference ref : new ArrayList(refsToInfo.keySet())) {
            if (!(ref instanceof PBXGroup)) continue;
            for (PBXReference child : ((PBXGroup)ref).getChildren()) {
                String childRelativePath;
                if (!"<group>".equals(child.getSourceTree()) || refsToInfo.containsKey((Object)child) || (childRelativePath = FileUtil.toCanonicalPath((String)child.getPath())) == null || !childRelativePath.startsWith("..")) continue;
                String childPath = child.resolvePath();
                LOG.assertTrue(childPath != null);
                refsToInfo.put(child, new FSMoveInfo(childPath, null));
            }
        }
        List<PBXReference> sortedRefs = PBXProjectFileManipulator.sortInParentChildOrder(refsToInfo.keySet());
        for (PBXReference ref : sortedRefs) {
            FSMoveInfo info = (FSMoveInfo)refsToInfo.get((Object)ref);
            this.updateNamePathSourceTree(ref, ref.getParent(), info.newName, info.newPath, ref.getSourceTree());
        }
        notifications.referencesChanged();
    }

    private static List<PBXReference> sortInParentChildOrder(@NotNull Collection<PBXReference> refs) {
        if (refs == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(171);
        }
        ArrayList<PBXReference> sortedRefs = new ArrayList<PBXReference>();
        HashSet<PBXReference> refsSet = new HashSet<PBXReference>(refs);
        HashSet<PBXReference> visited = new HashSet<PBXReference>();
        for (PBXReference reference : refs) {
            PBXProjectFileManipulator.traverseToParent(reference, refsSet, visited, sortedRefs);
        }
        return sortedRefs;
    }

    private static void traverseToParent(@Nullable PBXReference ref, @NotNull Set<PBXReference> all, @NotNull Set<PBXReference> visited, @NotNull List<PBXReference> sorted) {
        if (all == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(172);
        }
        if (visited == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(173);
        }
        if (sorted == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(174);
        }
        if (ref == null) {
            return;
        }
        if (visited.contains((Object)ref)) {
            return;
        }
        PBXProjectFileManipulator.traverseToParent(ref.getParent(), all, visited, sorted);
        if (all.contains((Object)ref)) {
            sorted.add(ref);
        }
        visited.add(ref);
    }

    public void remove(String ... paths) {
        if (paths == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(175);
        }
        this.remove(Arrays.asList(paths));
    }

    public void remove(@NotNull Collection<String> paths) {
        if (paths == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(176);
        }
        this.remove(paths, false);
    }

    public void remove(@NotNull Collection<String> paths, boolean deep) {
        if (paths == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(177);
        }
        ArrayList<PBXReference> references = new ArrayList<PBXReference>();
        this.gatherReferencesForPaths(paths, references, deep);
        this.removeReferences(references);
    }

    public void gatherReferencesForPaths(@NotNull Collection<String> paths, @NotNull Collection<PBXReference> references, boolean deep) {
        if (paths == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(178);
        }
        if (references == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(179);
        }
        this.doProcessReferences(paths, (PairProcessor<PBXReference, String>)((PairProcessor)(reference, v) -> {
            references.add((PBXReference)((Object)reference));
            return true;
        }), deep);
    }

    private void doProcessReferences(Collection<String> paths, PairProcessor<PBXReference, String> processor, boolean deep) {
        if (paths.isEmpty()) {
            return;
        }
        FileRefTree frt = this.myProjectFile.getFileRefTree();
        HashSet<String> processedPaths = new HashSet<String>(paths.size());
        for (String path : paths) {
            if (processedPaths.contains(path)) continue;
            processedPaths.add(path);
            FileRefTree st = (FileRefTree)frt.getSubTree(path, false);
            if (st == null) continue;
            st.processRecursively(subTree -> {
                for (PBXReference reference : subTree.getReferences()) {
                    processor.process((Object)reference, (Object)path);
                }
                return deep;
            });
        }
    }

    private static boolean isNameDerivedFromPath(@NotNull PBXReference reference, @Nullable String name) {
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(180);
        }
        if (name == null) {
            return false;
        }
        String refPath = reference.getPath();
        return refPath != null && Path.of(refPath, new String[0]).endsWith(name);
    }

    public void removeReference(@NotNull PBXReference reference) {
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(181);
        }
        this.removeReferences(Collections.singletonList(reference));
    }

    public void removeReferences(@NotNull List<PBXReference> references) {
        if (references == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(182);
        }
        Notifications notifications = this.getPendingNotifications();
        this.doRemoveReferences(references, notifications);
        this.autoFirePendingNotifications();
    }

    private void doRemoveReferences(@NotNull List<PBXReference> references, @NotNull Notifications notifications) {
        if (references == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(183);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(184);
        }
        LinkedHashSet<PBXReference> refsToRemove = new LinkedHashSet<PBXReference>();
        for (PBXReference reference : references) {
            this.gatherReferencesToRemove(reference, refsToRemove, notifications);
        }
        this.doRemoveGenericReferences(refsToRemove, notifications);
    }

    private void gatherReferencesToRemove(@NotNull PBXReference reference, @NotNull Set<PBXReference> refsToRemove, @NotNull Notifications notifications) {
        if (reference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(185);
        }
        if (refsToRemove == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(186);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(187);
        }
        LOG.assertTrue(reference.getFile() == this.myProjectFile);
        if (refsToRemove.contains((Object)reference)) {
            return;
        }
        if (reference.isLinkedProject()) {
            this.doRemoveLinkedProject(reference, notifications);
        } else if (reference instanceof PBXGroup) {
            for (PBXReference child : ((PBXGroup)reference).getChildren()) {
                this.gatherReferencesToRemove(child, refsToRemove, notifications);
            }
            refsToRemove.add(reference);
        } else {
            refsToRemove.add(reference);
        }
    }

    private void doRemoveGenericReferences(@NotNull Collection<? extends PBXReference> references, @NotNull Notifications notifications) {
        if (references == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(188);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(189);
        }
        if (references.isEmpty()) {
            return;
        }
        boolean buildFilesChanged = false;
        LinkedList<PBXVariantGroup> variantGroups = null;
        for (PBXReference pBXReference : references) {
            PBXGroup parent;
            LOG.assertTrue(pBXReference.getFile() == this.myProjectFile);
            if (!buildFilesChanged && !pBXReference.findBuildFiles().isEmpty()) {
                buildFilesChanged = true;
            }
            if (!((parent = pBXReference.getParent()) instanceof PBXVariantGroup)) continue;
            if (variantGroups == null) {
                variantGroups = new LinkedList<PBXVariantGroup>();
            }
            variantGroups.add((PBXVariantGroup)parent);
        }
        this.doRemoveObjects(references, notifications);
        if (buildFilesChanged) {
            notifications.buildFilesChanged();
        }
        notifications.referencesChanged();
        if (variantGroups == null) {
            return;
        }
        Iterator iterator = variantGroups.iterator();
        while (iterator.hasNext()) {
            PBXVariantGroup pBXVariantGroup = (PBXVariantGroup)((Object)iterator.next());
            if (pBXVariantGroup.getChildren().isEmpty()) continue;
            iterator.remove();
        }
        this.doRemoveGenericReferences((Collection<? extends PBXReference>)variantGroups, notifications);
    }

    public void removeLinkedProject(@NotNull PBXReference projectReference) {
        if (projectReference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(190);
        }
        LOG.assertTrue(projectReference.isLinkedProject());
        this.removeReference(projectReference);
    }

    private void doRemoveLinkedProject(@NotNull PBXReference projectReference, @NotNull Notifications notifications) {
        if (projectReference == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(191);
        }
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(192);
        }
        LOG.assertTrue(projectReference.isLinkedProject());
        boolean removedLinkedProject = false;
        for (PBXContainerItemProxy eachPortal : this.myProjectFile.getObjectsReferencing(projectReference.getId(), PBXContainerItemProxy.class)) {
            ArrayList<PBXObject> objects = new ArrayList<PBXObject>(this.myProjectFile.getObjectsReferencing(eachPortal.getId(), PBXObject.class));
            objects.add(eachPortal);
            this.doRemoveObjects(objects, notifications);
            removedLinkedProject = true;
        }
        PBXProject projectObject = this.myProjectFile.getProjectObject();
        List<Map> referencesList = projectObject.getAttributeListForModification("projectReferences", Map.class);
        ArrayList<PBXReference> refsToRemove = new ArrayList<PBXReference>();
        for (Map eachReference : referencesList) {
            PBXObject group;
            Object ref = eachReference.get("ProjectRef");
            if (!(ref instanceof ObjectReference) || !projectReference.getId().equals(((ObjectReference)ref).getId())) continue;
            Object groupRef = eachReference.get("ProductGroup");
            if (groupRef instanceof ObjectReference && (group = ((ObjectReference)groupRef).resolveObject()) instanceof PBXGroup) {
                refsToRemove.add((PBXReference)group);
            }
            referencesList.remove(eachReference);
            removedLinkedProject = true;
            break;
        }
        if (referencesList.isEmpty()) {
            projectObject.remove("projectReferences");
        } else {
            projectObject.setAttribute("projectReferences", referencesList);
        }
        this.doRemoveReferences(refsToRemove, notifications);
        this.doRemoveGenericReferences(Collections.singletonList(projectReference), notifications);
        if (removedLinkedProject) {
            PBXProjectFileManipulator.appendLinkedProjectEvents(notifications);
        }
    }

    private static void appendLinkedProjectEvents(@NotNull Notifications notifications) {
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(193);
        }
        notifications.projectsChanged();
        notifications.targetsChanged();
        notifications.referencesChanged();
        notifications.buildFilesChanged();
    }

    @NotNull
    private Notifications getPendingNotifications() {
        if (this.myNotifications == null) {
            this.myNotifications = new Notifications();
        }
        Notifications notifications = this.myNotifications;
        if (notifications == null) {
            PBXProjectFileManipulator.$$$reportNull$$$0(194);
        }
        return notifications;
    }

    private void autoFirePendingNotifications() {
        if (this.autoFireNotifications) {
            this.firePendingNotifications();
        }
    }

    public void firePendingNotifications() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myNotifications != null) {
            CoreXcodeWorkspace workspace = CoreXcodeWorkspace.getInstance(this.myProjectFile.getProject());
            if (workspace != null) {
                workspace.fireProjectChangedNotifications(this.myNotifications);
            }
            this.myNotifications = null;
        }
        this.myProjectFile.setTargetCacheDisabled(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 12, 29, 32, 36, 41, 43, 44, 61, 99, 100, 102, 104, 106, 107, 119, 124, 132, 136, 145, 153, 154, 194 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pbxProjectFile";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 44: 
            case 61: 
            case 99: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 119: 
            case 124: 
            case 132: 
            case 136: 
            case 145: 
            case 153: 
            case 154: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 91: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentGroup";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 35: 
            case 40: 
            case 110: 
            case 112: 
            case 117: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 37: 
            case 45: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 64: 
            case 72: 
            case 73: 
            case 78: 
            case 84: 
            case 98: 
            case 101: 
            case 103: 
            case 105: 
            case 114: 
            case 139: 
            case 148: 
            case 167: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notifications";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 34: 
            case 39: 
            case 48: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentGroupFilePath";
                break;
            }
            case 42: 
            case 47: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 46: 
            case 65: 
            case 75: 
            case 77: 
            case 80: 
            case 83: 
            case 87: 
            case 89: 
            case 180: 
            case 181: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 49: 
            case 51: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 55: 
            case 159: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyInfos";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstGroup";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyInfo";
                break;
            }
            case 66: 
            case 69: 
            case 71: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeFrom";
                break;
            }
            case 67: 
            case 125: 
            case 143: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addTo";
                break;
            }
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFiles";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addToSet";
                break;
            }
            case 76: 
            case 79: 
            case 81: 
            case 85: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 82: 
            case 86: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phaseType";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manipulation";
                break;
            }
            case 108: 
            case 113: 
            case 123: 
            case 129: 
            case 133: 
            case 137: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 109: 
            case 111: 
            case 115: 
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameWithExtension";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 126: 
            case 144: 
            case 146: 
            case 147: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "swiftProductDependency";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productTypeId";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSettings";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildToolPath";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildToolArgsString";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetToRemove";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTarget";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTree";
                break;
            }
            case 158: 
            case 175: 
            case 176: 
            case 177: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFilePath";
                break;
            }
            case 163: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildConfiguration";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mandatoryUpdates";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorted";
                break;
            }
            case 179: 
            case 182: 
            case 183: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsToRemove";
                break;
            }
            case 190: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewProject";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addFile";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addFileInternal";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "pathFromGroupPath";
                break;
            }
            case 36: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addCoreDataModel";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "coreDataModelVersions";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopyReferences";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "addMainGroup";
                break;
            }
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "addGroup";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "addLinkedProject";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwiftPackageProductDependency";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "addNativeTarget";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "addLegacyTarget";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "addTargetDependency";
                break;
            }
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "addConfiguration";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTargets";
                break;
            }
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNewProject";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 44: 
            case 61: 
            case 99: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 119: 
            case 124: 
            case 132: 
            case 136: 
            case 145: 
            case 153: 
            case 154: 
            case 194: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addFileInternal";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "pathFromGroupPath";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addCoreDataModel";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "coreDataModelVersions";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addReference";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addObject";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveObjects";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIncludes";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkProjectRoots";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "deepCopyReferences";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "doDeepCopyReference";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "changeTargets";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "removeFromTargets";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addToTargets";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addToTarget";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "addToBuildPhase";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "findPrototypeInPhase";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "updateNamePathSourceTree";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "resolvePathAgainstSourceTree";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addBuildPhase";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "changeBuildPhase";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "addMainGroup";
                break;
            }
            case 101: 
            case 103: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "addFramework";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "addFrameworkOrLibrary";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "addOtherFramework";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "doAddFramework";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "addLinkedProject";
                break;
            }
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkOrLibraryPath";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "createSwiftPackageProductDependency";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "addSwiftPackageProductDependency";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "removeSwiftPackageProductTargetDependency";
                break;
            }
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "addNativeTarget";
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "addLegacyTarget";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "initTarget";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "removeTarget";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "findTargetDependenciesInProject";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "addTargetDependency";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "removeTargetDependency";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveTargetDependency";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "addProductDependency";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
            case 155: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "buildRelativePath";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "updateEncodings";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "updateEncoding";
                break;
            }
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "setBuildSetting";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "sortInParentChildOrder";
                break;
            }
            case 172: 
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "traverseToParent";
                break;
            }
            case 175: 
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "gatherReferencesForPaths";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "isNameDerivedFromPath";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "removeReference";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "removeReferences";
                break;
            }
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveReferences";
                break;
            }
            case 185: 
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "gatherReferencesToRemove";
                break;
            }
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveGenericReferences";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "removeLinkedProject";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveLinkedProject";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "appendLinkedProjectEvents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 12, 29, 32, 36, 41, 43, 44, 61, 99, 100, 102, 104, 106, 107, 119, 124, 132, 136, 145, 153, 154, 194 -> new IllegalStateException(string);
        };
    }

    public static class AddResult
    extends Trinity<PBXReference, AppleFileType, Boolean> {
        public AddResult(@NotNull PBXReference ref, @Nullable AppleFileType type, Boolean childrenProcessed) {
            if (ref == null) {
                AddResult.$$$reportNull$$$0(0);
            }
            super((Object)ref, (Object)type, (Object)childrenProcessed);
        }

        @NotNull
        public PBXReference getReference() {
            PBXReference pBXReference = (PBXReference)((Object)this.first);
            if (pBXReference == null) {
                AddResult.$$$reportNull$$$0(1);
            }
            return pBXReference;
        }

        @Nullable
        public AppleFileType getFileType() {
            return (AppleFileType)this.second;
        }

        public boolean areChildrenProcessed() {
            return (Boolean)this.third;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$AddResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$AddResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class CopyInfo {
        @NotNull
        private final PBXReference myReference;
        @NotNull
        private final ReferencePathProvider pathProvider;
        @NotNull
        private final ReferenceTargetProvider targetProvider;

        public CopyInfo(@NotNull PBXReference reference, @NotNull ReferencePathProvider pathProvider, @NotNull ReferenceTargetProvider targetProvider) {
            if (reference == null) {
                CopyInfo.$$$reportNull$$$0(0);
            }
            if (pathProvider == null) {
                CopyInfo.$$$reportNull$$$0(1);
            }
            if (targetProvider == null) {
                CopyInfo.$$$reportNull$$$0(2);
            }
            this.myReference = reference;
            this.pathProvider = pathProvider;
            this.targetProvider = targetProvider;
        }

        @NotNull
        public PBXReference getReference() {
            PBXReference pBXReference = this.myReference;
            if (pBXReference == null) {
                CopyInfo.$$$reportNull$$$0(3);
            }
            return pBXReference;
        }

        @NotNull
        public ReferencePathProvider getPathProvider() {
            ReferencePathProvider referencePathProvider = this.pathProvider;
            if (referencePathProvider == null) {
                CopyInfo.$$$reportNull$$$0(4);
            }
            return referencePathProvider;
        }

        @NotNull
        public ReferenceTargetProvider getTargetProvider() {
            ReferenceTargetProvider referenceTargetProvider = this.targetProvider;
            if (referenceTargetProvider == null) {
                CopyInfo.$$$reportNull$$$0(5);
            }
            return referenceTargetProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetProvider";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$CopyInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$CopyInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class CopyResult {
        @Nullable
        PBXReference myReference;
        @Nullable
        @NonNls
        String myErrorMessage;

        public CopyResult(@Nullable PBXReference reference, @Nullable @NonNls String errorMessage) {
            this.myReference = reference;
            this.myErrorMessage = errorMessage;
        }

        @Nullable
        public PBXReference getReference() {
            return this.myReference;
        }

        @Nullable
        @NonNls
        public String getErrorMessage() {
            return this.myErrorMessage;
        }
    }

    private class ReferenceCopier
    extends PbxObjectVisitor {
        @NotNull
        private final ReferenceTargetProvider myTargetProvider;
        @NotNull
        private final ReferencePathProvider myPathProvider;
        @NotNull
        private final Notifications myNotifications;
        @Nullable
        PBXReference myResult;
        @Nullable
        @NonNls
        String myErrorMessage;
        @NotNull
        PBXGroup myCurrentGroup;

        ReferenceCopier(@NotNull PBXGroup dstGroup, @NotNull ReferencePathProvider pathProvider, @NotNull ReferenceTargetProvider targetProvider, Notifications notifications) {
            if (dstGroup == null) {
                ReferenceCopier.$$$reportNull$$$0(0);
            }
            if (pathProvider == null) {
                ReferenceCopier.$$$reportNull$$$0(1);
            }
            if (targetProvider == null) {
                ReferenceCopier.$$$reportNull$$$0(2);
            }
            if (notifications == null) {
                ReferenceCopier.$$$reportNull$$$0(3);
            }
            this.myCurrentGroup = dstGroup;
            this.myTargetProvider = targetProvider;
            this.myPathProvider = pathProvider;
            this.myNotifications = notifications;
        }

        @Nullable
        public PBXReference getResult() {
            return this.myResult;
        }

        @Nullable
        @NonNls
        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        @Nullable
        private String getNewPath(@NotNull PBXReference reference) {
            if (reference == null) {
                ReferenceCopier.$$$reportNull$$$0(4);
            }
            return this.myPathProvider.getNewPath(reference);
        }

        private void updateResultIfRequired(@NotNull PBXReference result) {
            if (result == null) {
                ReferenceCopier.$$$reportNull$$$0(5);
            }
            if (this.myResult == null) {
                this.myResult = result;
            }
        }

        @Override
        public boolean visitObject(@NotNull PBXObject object) {
            if (object == null) {
                ReferenceCopier.$$$reportNull$$$0(6);
            }
            return this.fail(object);
        }

        private boolean fail(@NotNull PBXObject object) {
            if (object == null) {
                ReferenceCopier.$$$reportNull$$$0(7);
            }
            return this.fail("unexpected object to copy: " + String.valueOf((Object)object));
        }

        private boolean fail(@NotNull @NonNls String message) {
            if (message == null) {
                ReferenceCopier.$$$reportNull$$$0(8);
            }
            LOG.error(message);
            this.myResult = null;
            this.myErrorMessage = "Error occurred while preparing to copy objects: " + message;
            return false;
        }

        @Override
        public boolean visitFile(@NotNull PBXFileReference reference) {
            if (reference == null) {
                ReferenceCopier.$$$reportNull$$$0(9);
            }
            return this.addAsFile(reference);
        }

        @Override
        public boolean visitReferenceProxy(@NotNull PBXReferenceProxy proxy) {
            if (proxy == null) {
                ReferenceCopier.$$$reportNull$$$0(10);
            }
            return this.fail(proxy);
        }

        @Override
        public boolean visitGroup(@NotNull PBXGroup group) {
            if (group == null) {
                ReferenceCopier.$$$reportNull$$$0(11);
            }
            if (group.isMainGroup()) {
                return this.fail("copying of projects is not supported");
            }
            String name = group.getName();
            String oldPath = group.resolvePath();
            LOG.assertTrue(oldPath != null);
            String newPath = this.getNewPath(group);
            if (newPath == null) {
                return this.fail("can't find new path for " + String.valueOf((Object)group));
            }
            PBXGroup newGroup = PBXProjectFileManipulator.this.addGroup(this.myNotifications, null, name, newPath, this.myCurrentGroup, true, true);
            this.updateResultIfRequired(newGroup);
            for (PBXReference reference : group.getChildren()) {
                this.myCurrentGroup = newGroup;
                if (reference.accept(this)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean visitCompositeGroup(@NotNull PBXCompositeGroup group) {
            if (group == null) {
                ReferenceCopier.$$$reportNull$$$0(12);
            }
            return this.fail(group);
        }

        @Override
        public boolean visitSynchronizedRootGroup(@NotNull PBXFileSystemSynchronizedRootGroup group) {
            if (group == null) {
                ReferenceCopier.$$$reportNull$$$0(13);
            }
            return this.fail(group);
        }

        @Override
        public boolean visitVariantGroup(@NotNull PBXVariantGroup variantGroup) {
            if (variantGroup == null) {
                ReferenceCopier.$$$reportNull$$$0(14);
            }
            for (PBXReference reference : variantGroup.getChildren()) {
                if (reference.accept(this)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean visitVersionGroup(@NotNull XCVersionGroup versionGroup) {
            if (versionGroup == null) {
                ReferenceCopier.$$$reportNull$$$0(15);
            }
            return this.addAsFile(versionGroup);
        }

        private boolean addAsFile(@NotNull PBXReference reference) {
            List<PBXBuildFile> buildFilePrototypes;
            PBXTarget[] targets;
            String path;
            if (reference == null) {
                ReferenceCopier.$$$reportNull$$$0(16);
            }
            if ((path = this.getNewPath(reference)) == null) {
                return this.fail("can't find new path for " + String.valueOf((Object)reference));
            }
            PBXGroup parent = reference.getParent();
            if (parent instanceof PBXVariantGroup) {
                targets = this.myTargetProvider.getNewTargets(parent);
                buildFilePrototypes = parent.findBuildFiles();
            } else {
                targets = this.myTargetProvider.getNewTargets(reference);
                buildFilePrototypes = reference.findBuildFiles();
            }
            AddResult result = PBXProjectFileManipulator.this.addFile(this.myNotifications, path, targets, this.myCurrentGroup, false, null, null, true, buildFilePrototypes);
            this.updateResultIfRequired(result.getReference());
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dstGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notifications";
                    break;
                }
                case 4: 
                case 9: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "proxy";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variantGroup";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionGroup";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceCopier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNewPath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateResultIfRequired";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitObject";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fail";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceProxy";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitGroup";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCompositeGroup";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedRootGroup";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariantGroup";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVersionGroup";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAsFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ReferencePathProvider {
        private static final ReferencePathProvider ID = new ReferencePathProvider(){

            @Override
            @Nullable
            public String getNewPath(@NotNull PBXReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                return reference.resolvePath();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferencePathProvider$1", "getNewPath"));
            }
        };

        public static ReferencePathProvider id() {
            return ID;
        }

        public static ReferencePathProvider forCopying(final @NotNull String srcPath, final @NotNull String dstPath) {
            if (srcPath == null) {
                ReferencePathProvider.$$$reportNull$$$0(0);
            }
            if (dstPath == null) {
                ReferencePathProvider.$$$reportNull$$$0(1);
            }
            return new ReferencePathProvider(){

                @Override
                @Nullable
                public String getNewPath(@NotNull PBXReference reference) {
                    String path;
                    if (reference == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((path = reference.resolvePath()) != null && FileUtil.isAncestor((String)srcPath, (String)path, (boolean)false)) {
                        char separator = File.separatorChar;
                        String relativePath = FileUtil.getRelativePath((String)srcPath, (String)path, (char)separator);
                        LOG.assertTrue(relativePath != null);
                        path = FileUtil.toCanonicalPath((String)new File(dstPath, relativePath).getPath(), (char)separator);
                    }
                    return path;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferencePathProvider$2", "getNewPath"));
                }
            };
        }

        @Nullable
        public abstract String getNewPath(@NotNull PBXReference var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "srcPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dstPath";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferencePathProvider";
            objectArray[2] = "forCopying";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ReferenceTargetProvider {
        private static final ReferenceTargetProvider ID = new ReferenceTargetProvider(){

            @Override
            @NotNull
            public PBXTarget[] getNewTargets(@NotNull PBXReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                List<PBXTarget> targets = reference.findTargets(null);
                PBXTarget[] pBXTargetArray = targets.toArray(PBXTarget.EMPTY_ARRAY);
                if (pBXTargetArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pBXTargetArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNewTargets";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getNewTargets";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };

        public static ReferenceTargetProvider id() {
            return ID;
        }

        public static ReferenceTargetProvider forTargets(final @NotNull PBXTarget[] targets) {
            if (targets == null) {
                ReferenceTargetProvider.$$$reportNull$$$0(0);
            }
            return new ReferenceTargetProvider(){

                @Override
                @NotNull
                public PBXTarget[] getNewTargets(@NotNull PBXReference reference) {
                    if (reference == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (targets == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return targets;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNewTargets";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNewTargets";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @NotNull
        public abstract PBXTarget[] getNewTargets(@NotNull PBXReference var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceTargetProvider", "forTargets"));
        }
    }

    private static class PathInfo {
        private final String mySourceTree;
        private final String myPath;

        PathInfo(@NotNull @NonNls String sourceTree, @NotNull @NonNls String path) {
            if (sourceTree == null) {
                PathInfo.$$$reportNull$$$0(0);
            }
            if (path == null) {
                PathInfo.$$$reportNull$$$0(1);
            }
            this.mySourceTree = sourceTree;
            this.myPath = path;
        }

        @NotNull
        @NonNls
        public String getSourceTree() {
            String string = this.mySourceTree;
            if (string == null) {
                PathInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                PathInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceTree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$PathInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$PathInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceTree";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FSMoveInfo {
        @NotNull
        final String newPath;
        @Nullable
        final String newName;

        private FSMoveInfo(@NotNull String newPath, @Nullable String newName) {
            if (newPath == null) {
                FSMoveInfo.$$$reportNull$$$0(0);
            }
            this.newPath = newPath;
            this.newName = newName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPath", "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$FSMoveInfo", "<init>"));
        }
    }

    public static class ReferenceRemover {
        @NotNull
        private final HashMap<PBXProjectFile, List<PBXReference>> myMap = new LinkedHashMap<PBXProjectFile, List<PBXReference>>();

        public void addReferencesForPaths(PBXProjectFile projectFile, Collection<String> pathsToRemove) {
            List<PBXReference> refs = this.getReferences(projectFile);
            projectFile.getManipulator().gatherReferencesForPaths(pathsToRemove, refs, false);
        }

        @NotNull
        private List<PBXReference> getReferences(@NotNull PBXProjectFile projectFile) {
            if (projectFile == null) {
                ReferenceRemover.$$$reportNull$$$0(0);
            }
            List list = this.myMap.computeIfAbsent(projectFile, k -> new ArrayList());
            if (list == null) {
                ReferenceRemover.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void addReference(@NotNull PBXReference ref) {
            if (ref == null) {
                ReferenceRemover.$$$reportNull$$$0(2);
            }
            this.getReferences(ref.getFile()).add(ref);
        }

        public void removeAllReferences() {
            for (PBXProjectFile projectFile : this.myMap.keySet()) {
                projectFile.getManipulator().removeReferences(this.getReferences(projectFile));
            }
        }

        public void gatherAllReferences(@NotNull Collection<PBXReference> remove) {
            if (remove == null) {
                ReferenceRemover.$$$reportNull$$$0(3);
            }
            for (PBXProjectFile projectFile : this.myMap.keySet()) {
                remove.addAll(this.getReferences(projectFile));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceRemover";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remove";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFileManipulator$ReferenceRemover";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferences";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "gatherAllReferences";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

