/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.RWAList;
import com.jetbrains.cidr.xcode.RWAMap;
import com.jetbrains.cidr.xcode.RWASet;
import com.jetbrains.cidr.xcode.RWASupport;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleFileTypeManager;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.CachingBuildSettingsResolver;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.FileRefTree;
import com.jetbrains.cidr.xcode.model.IncompatibleVersionException;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXFileSystemSynchronizedRootGroup;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXNativeTarget;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProject;
import com.jetbrains.cidr.xcode.model.PBXProjectFileManipulator;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.PBXUserFile;
import com.jetbrains.cidr.xcode.model.ProjectFilesChanges;
import com.jetbrains.cidr.xcode.model.RWAChecker;
import com.jetbrains.cidr.xcode.model.SynchronizedRootsTree;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCContainer;
import com.jetbrains.cidr.xcode.model.XCLoadable;
import com.jetbrains.cidr.xcode.model.XCLocalSwiftPackageReference;
import com.jetbrains.cidr.xcode.model.XCRemoteSwiftPackageReference;
import com.jetbrains.cidr.xcode.model.XCSwiftPackageProductDependency;
import com.jetbrains.cidr.xcode.model.XcodeProjectTrackers;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.pbxproj.PbxReader;
import com.jetbrains.cidr.xcode.pbxproj.PbxWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class PBXProjectFile
implements XCContainer,
XCLoadable,
UserDataHolderEx {
    public static final String PROJECT_FILE = "project.pbxproj";
    public static final Comparator<PBXProjectFile> COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myProjectRoot;
    @NotNull
    private final VirtualFile myPBXProjFile;
    private volatile int myArchiveVersion;
    private volatile int myObjectVersion;
    @NotNull
    private VirtualFile myBaseDir;
    private volatile PBXProject myProjectObject;
    private final RWAMap<PbxId, PBXObject> myObjects;
    private final PBXUserFile myUserFile;
    @NotNull
    private final RWAChecker myRWAChecker;
    @NotNull
    private final BuildSettingsProvider myBuildSettingsProvider;
    private final Object myCacheLock;
    @NotNull
    private volatile ReferencesCache myCache;
    private final Object myBuildFilesCacheLock;
    @NotNull
    private volatile BuildFilesCache myBuildFilesCache;
    @NotNull
    private final MyCacheModificationTracker myTargetCacheTracker;
    @NotNull
    private final CachedValue<List<PBXTarget>> myTargetsCache;
    @Nullable
    private volatile PbxId myCurrentIdInTests;
    @Nullable
    private final String myPredefinedProjectNameInTests;
    @NotNull
    private final Function<PBXReference, List<PBXBuildFile>> myBuildFilesFunction;
    @NotNull
    private final UserDataHolderEx myDataHolder;

    public PBXProjectFile(@NotNull Project project, @NotNull VirtualFile projectRoot, @NotNull VirtualFile pbxprojFile) {
        if (project == null) {
            PBXProjectFile.$$$reportNull$$$0(0);
        }
        if (projectRoot == null) {
            PBXProjectFile.$$$reportNull$$$0(1);
        }
        if (pbxprojFile == null) {
            PBXProjectFile.$$$reportNull$$$0(2);
        }
        this(project, projectRoot, pbxprojFile, null, null);
    }

    public PBXProjectFile(@NotNull Project project, @NotNull VirtualFile projectRoot, @NotNull VirtualFile pbxprojFile, @Nullable PbxId initialId, @Nullable String projectName) {
        if (project == null) {
            PBXProjectFile.$$$reportNull$$$0(3);
        }
        if (projectRoot == null) {
            PBXProjectFile.$$$reportNull$$$0(4);
        }
        if (pbxprojFile == null) {
            PBXProjectFile.$$$reportNull$$$0(5);
        }
        this.myArchiveVersion = 1;
        this.myObjectVersion = 45;
        this.myRWAChecker = new RWAChecker();
        this.myCacheLock = new Object();
        this.myCache = new ReferencesCache();
        this.myBuildFilesCacheLock = new Object();
        this.myBuildFilesCache = new BuildFilesCache();
        this.myTargetCacheTracker = new MyCacheModificationTracker();
        this.myBuildFilesFunction = reference -> this.getBuildFilesFor((PBXReference)((Object)reference));
        this.myDataHolder = new UserDataHolderBase();
        this.myProject = project;
        this.myProjectRoot = projectRoot;
        this.myPBXProjFile = pbxprojFile;
        this.myObjects = this.createRWAObjectsMap();
        this.myUserFile = new PBXUserFile(this);
        this.myBuildSettingsProvider = new CachingBuildSettingsResolver(project){

            @Override
            @NotNull
            protected PBXProjectFile getProjectFile() {
                PBXProjectFile pBXProjectFile = PBXProjectFile.this;
                if (pBXProjectFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                return pBXProjectFile;
            }

            @Override
            protected PBXTarget getTarget() {
                return null;
            }

            @Override
            protected XCBuildConfiguration getBuildConfiguration() {
                return null;
            }

            @Override
            protected AppleSdk getSdk() {
                return null;
            }

            @Override
            @Nullable
            protected Set<ArchitectureValue> getArchitectures() {
                return null;
            }

            @Override
            protected boolean areSdkAndArchitectureOverridden() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/model/PBXProjectFile$1", "getProjectFile"));
            }
        };
        this.myCurrentIdInTests = initialId;
        this.myPredefinedProjectNameInTests = projectName;
        XcodeProjectTrackers modificationTrackers = XcodeProjectTrackers.getInstance(this.myProject);
        this.myTargetsCache = new CachedValueImpl(() -> new CachedValueProvider.Result(this.getProjectObject().getTargets(), new Object[]{this.myTargetCacheTracker, modificationTrackers.getProjectsTracker(), modificationTrackers.getBuildSettingsTracker(), modificationTrackers.getWorkspaceStateTracker(), modificationTrackers.getTargetsTracker()}));
    }

    @NotNull
    RWAMap<PbxId, PBXObject> createRWAObjectsMap() {
        return new RWAMap<PbxId, PBXObject>(PBXProjectFile.createObjectsMap(), this.myRWAChecker);
    }

    @NotNull
    public static LinkedHashMap<PbxId, PBXObject> createObjectsMap() {
        return new LinkedHashMap<PbxId, PBXObject>();
    }

    @NotNull
    RWASupport.Checker getRWAChecker() {
        RWAChecker rWAChecker = this.myRWAChecker;
        if (rWAChecker == null) {
            PBXProjectFile.$$$reportNull$$$0(6);
        }
        return rWAChecker;
    }

    @NonNls
    public String getXCodeURL() {
        return "x-xcodeproj:" + this.myPBXProjFile.getPath();
    }

    @Override
    public void load(@NotNull ProjectFilesChanges changes) throws IOException {
        boolean shouldComputeBuildSettings;
        if (changes == null) {
            PBXProjectFile.$$$reportNull$$$0(7);
        }
        boolean firstLoad = this.myProjectObject == null;
        CharSequence text = PBXProjectFile.loadFile(this.myPBXProjFile);
        List<Object> buildSettingsBefore = Collections.emptyList();
        boolean bl = shouldComputeBuildSettings = !firstLoad && !changes.areBuildSettingsChanged();
        if (shouldComputeBuildSettings) {
            buildSettingsBefore = this.collectBuildSettingsValues();
        }
        this.parsePbxProjectContext(text);
        this.myUserFile.load();
        this.finishLoading();
        if (shouldComputeBuildSettings) {
            boolean sameSettings = buildSettingsBefore.equals(this.collectBuildSettingsValues());
            changes.addBuildSettingsChange(!sameSettings);
        }
    }

    @NotNull
    public static CharSequence loadFile(VirtualFile file) throws IOException {
        if (!file.isValid() || file.isDirectory()) {
            throw new IOException("File not found: " + String.valueOf(file));
        }
        byte @NotNull [] fileContents = file.getInputStream().readAllBytes();
        CharSequence text = LoadTextUtil.getTextByBinaryPresentation((byte[])fileContents, (VirtualFile)file);
        if (text.isEmpty()) {
            throw new IOException("Project file is empty: " + String.valueOf(file));
        }
        CharSequence charSequence = text;
        if (charSequence == null) {
            PBXProjectFile.$$$reportNull$$$0(8);
        }
        return charSequence;
    }

    @Override
    public void checkCompatibility() throws IncompatibleVersionException {
        String compatibility = this.getProjectObject().getString("compatibilityVersion", "unknown");
        if (this.myArchiveVersion != 1 || this.myObjectVersion < 45) {
            throw new IncompatibleVersionException("Unsupported project format: '" + compatibility + "' (archiveVersion = " + this.myArchiveVersion + ", objectVersion = " + this.myObjectVersion + ").\nOnly 'Xcode 3.2' or newer format is supported. Please convert it with Xcode.");
        }
    }

    @NotNull
    private List<Object> collectBuildSettingsValues() {
        Collection<XCBuildConfiguration> configurations = this.getObjects(XCBuildConfiguration.class);
        HashMap<PbxId, List<Dictionary>> configurationsSettings = new HashMap<PbxId, List<Dictionary>>(configurations.size());
        for (XCBuildConfiguration each : configurations) {
            configurationsSettings.put(each.getId(), Arrays.asList(each.getDeclaredBuildSettingValues(), each.getXCConfigBuildSettingValuesProvider().getDeclaredBuildSettingValues()));
        }
        List<Object> list = Arrays.asList(this.getProjectObject().getUserBuildSettings(), configurationsSettings);
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(9);
        }
        return list;
    }

    @TestOnly
    public void parseInTests(@NotNull CharSequence text) throws IOException {
        if (text == null) {
            PBXProjectFile.$$$reportNull$$$0(10);
        }
        this.parsePbxProjectContext(text);
        this.finishLoading();
    }

    private void parsePbxProjectContext(@NotNull CharSequence text) throws IOException {
        if (text == null) {
            PBXProjectFile.$$$reportNull$$$0(11);
        }
        LinkedHashMap<PbxId, PBXObject> objects = PBXProjectFile.createObjectsMap();
        PBXDictionary fileObject = PbxReader.readFile(false, text, this, objects);
        try {
            this.setArchiveVersion(Integer.parseInt((String)fileObject.getAttribute("archiveVersion", String.class)));
            this.setObjectVersion(Integer.parseInt((String)fileObject.getAttribute("objectVersion", String.class)));
        }
        catch (NumberFormatException e) {
            throw new InvalidSpecException((Throwable)e);
        }
        this.myObjects.clear();
        this.myObjects.putAll((Map<PbxId, PBXObject>)objects);
        this.resetReferencesCache();
        this.setProjectObject(fileObject.resolveNotNullAttribute("rootObject", PBXProject.class));
    }

    void finishLoading() {
        this.myBaseDir = this.resolveBaseDir();
        this.removeBrokenBuildFiles();
        this.myRWAChecker.resetModified();
        this.myUserFile.finishLoading();
    }

    private void removeBrokenBuildFiles() {
        ArrayList<PBXBuildFile> toRemove = new ArrayList<PBXBuildFile>();
        for (PBXBuildFile each : this.getObjects(PBXBuildFile.class)) {
            if (each.getFileRefId() != null || this.isXCSwiftPackageProductDependency(each)) continue;
            toRemove.add(each);
        }
        this.removeObjects(toRemove);
    }

    private boolean isXCSwiftPackageProductDependency(@NotNull PBXBuildFile each) {
        PbxId pbxId;
        if (each == null) {
            PBXProjectFile.$$$reportNull$$$0(12);
        }
        return (pbxId = each.getProductRefId()) != null && this.findById(pbxId) instanceof XCSwiftPackageProductDependency;
    }

    @Override
    public void lock() {
        this.myRWAChecker.lock();
        this.myUserFile.lock();
    }

    @NotNull
    private VirtualFile resolveBaseDir() {
        String path = this.myProjectObject.getString("projectDirPath");
        if (path != null && !StringUtil.isEmptyOrSpaces((String)path)) {
            VirtualFile result;
            if (!FileUtil.isAbsolute((String)path)) {
                path = new File(this.myProjectRoot.getPath(), path).getPath();
            }
            if ((result = StandardFileSystems.local().refreshAndFindFileByPath(path)) != null) {
                VirtualFile virtualFile = result;
                if (virtualFile == null) {
                    PBXProjectFile.$$$reportNull$$$0(13);
                }
                return virtualFile;
            }
        }
        VirtualFile virtualFile = this.myProjectRoot;
        if (virtualFile == null) {
            PBXProjectFile.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    @NotNull
    public PBXProjectFileManipulator getManipulator() {
        PBXProjectFileManipulator pBXProjectFileManipulator = this.getManipulator(true);
        if (pBXProjectFileManipulator == null) {
            PBXProjectFile.$$$reportNull$$$0(15);
        }
        return pBXProjectFileManipulator;
    }

    @NotNull
    public PBXProjectFileManipulator getManipulator(boolean fireNotificationsAutomatically) {
        return new PBXProjectFileManipulator(this, fireNotificationsAutomatically);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PBXProjectFile.$$$reportNull$$$0(16);
        }
        return project;
    }

    @NotNull
    public BuildSettingsProvider getBuildSettingsProvider() {
        BuildSettingsProvider buildSettingsProvider = this.myBuildSettingsProvider;
        if (buildSettingsProvider == null) {
            PBXProjectFile.$$$reportNull$$$0(17);
        }
        return buildSettingsProvider;
    }

    void setProjectObject(@NotNull PBXProject project) {
        if (project == null) {
            PBXProjectFile.$$$reportNull$$$0(18);
        }
        this.myProjectObject = project;
        this.myTargetCacheTracker.incModificationCount();
    }

    void setTargetCacheDisabled(boolean disabled) {
        this.myTargetCacheTracker.setDisabled(disabled);
        this.myTargetCacheTracker.incModificationCount();
    }

    @NotNull
    public PBXProject getProjectObject() {
        PBXProject pBXProject = this.myProjectObject;
        if (pBXProject == null) {
            PBXProjectFile.$$$reportNull$$$0(19);
        }
        return pBXProject;
    }

    public int getArchiveVersion() {
        return this.myArchiveVersion;
    }

    void setArchiveVersion(int version) {
        this.myArchiveVersion = version;
    }

    public int getObjectVersion() {
        return this.myObjectVersion;
    }

    void setObjectVersion(int i) {
        this.myObjectVersion = i;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myPredefinedProjectNameInTests != null ? this.myPredefinedProjectNameInTests : this.getXcodeProjFile().getNameWithoutExtension();
        if (string == null) {
            PBXProjectFile.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getLoadableRootFile() {
        VirtualFile virtualFile = this.getXcodeProjFile();
        if (virtualFile == null) {
            PBXProjectFile.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getLoadableDataFile() {
        VirtualFile virtualFile = this.getPBXProjFile();
        if (virtualFile == null) {
            PBXProjectFile.$$$reportNull$$$0(22);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getPBXProjFile() {
        VirtualFile virtualFile = this.myPBXProjFile;
        if (virtualFile == null) {
            PBXProjectFile.$$$reportNull$$$0(23);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getXcodeProjFile() {
        VirtualFile virtualFile = this.myPBXProjFile.getParent();
        if (virtualFile == null) {
            PBXProjectFile.$$$reportNull$$$0(24);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getBaseDir() {
        VirtualFile virtualFile = this.myBaseDir;
        if (virtualFile == null) {
            PBXProjectFile.$$$reportNull$$$0(25);
        }
        return virtualFile;
    }

    @NotNull
    public String getXcodeProjFileName() {
        String string = this.getXcodeProjFile().getName();
        if (string == null) {
            PBXProjectFile.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @NotNull
    public File getContainerBaseDir() {
        return new File(this.getBaseDir().getPath());
    }

    @Override
    @NotNull
    public File getUserDataDir() {
        File file = XCContainer.Helper.getUserDataDir(this.getXcodeProjFile());
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(27);
        }
        return file;
    }

    @Override
    @NotNull
    public File getSharedDataDir() {
        File file = XCContainer.Helper.getSharedDataDir(this.getXcodeProjFile());
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(28);
        }
        return file;
    }

    @NotNull
    public PBXUserFile getUserFile() {
        PBXUserFile pBXUserFile = this.myUserFile;
        if (pBXUserFile == null) {
            PBXProjectFile.$$$reportNull$$$0(29);
        }
        return pBXUserFile;
    }

    @NotNull
    public PbxId generateNextId() {
        if (this.myCurrentIdInTests != null && ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCurrentIdInTests = this.myCurrentIdInTests.nextUniqueId();
            if (this.myCurrentIdInTests == null) {
                PBXProjectFile.$$$reportNull$$$0(30);
            }
            return this.myCurrentIdInTests;
        }
        PbxId pbxId = PbxId.newUniqueId();
        if (pbxId == null) {
            PBXProjectFile.$$$reportNull$$$0(31);
        }
        return pbxId;
    }

    @TestOnly
    public void setCurrentIdInTests(@Nullable PbxId id) {
        this.myCurrentIdInTests = id;
    }

    @NotNull
    public Collection<PBXObject> getObjects() {
        Collection<PBXObject> collection = this.getObjects(null);
        if (collection == null) {
            PBXProjectFile.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @NotNull
    public <T extends PBXObject> Collection<T> getObjects(@Nullable Class<T> klass) {
        if (klass == null) {
            Collection<PBXObject> collection = Collections.unmodifiableCollection(this.myObjects.values());
            if (collection == null) {
                PBXProjectFile.$$$reportNull$$$0(33);
            }
            return collection;
        }
        SmartList answer = new SmartList();
        for (PBXObject pbxObject : this.myObjects.values()) {
            if (!klass.isInstance((Object)pbxObject)) continue;
            answer.add(pbxObject);
        }
        Collection collection = Collections.unmodifiableCollection(answer);
        if (collection == null) {
            PBXProjectFile.$$$reportNull$$$0(34);
        }
        return collection;
    }

    @NotNull
    public <T extends PBXObject> Collection<T> getObjectsReferencing(@Nullable PbxId id, @Nullable Class<T> klass) {
        if (id == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PBXProjectFile.$$$reportNull$$$0(35);
            }
            return list;
        }
        SmartList answer = new SmartList();
        for (PBXObject each : this.getObjects(klass)) {
            for (Object eachValue : each.values()) {
                if (!(eachValue instanceof ObjectReference) || !id.equals(((ObjectReference)eachValue).getId())) continue;
                answer.add(each);
            }
        }
        Collection collection = Collections.unmodifiableCollection(answer);
        if (collection == null) {
            PBXProjectFile.$$$reportNull$$$0(36);
        }
        return collection;
    }

    @Nullable
    public PBXObject findById(@Nullable PbxId id) {
        return id == null ? null : this.myObjects.get(id);
    }

    public void regenerateIds(@Nullable PbxId fromId) {
        TreeSet<PbxId> sortedIds = new TreeSet<PbxId>(PbxId.COMPARATOR);
        HashMap<PbxId, PbxId> oldToNewMap = new HashMap<PbxId, PbxId>();
        sortedIds.addAll(this.myObjects.keySet());
        PbxId newId = fromId == null ? PbxId.newUniqueId() : fromId;
        for (PbxId oldId : sortedIds) {
            newId = newId.nextUniqueId();
            PBXObject object = this.myObjects.remove(oldId);
            object.setId(newId);
            this.myObjects.put(newId, object);
            oldToNewMap.put(oldId, newId);
        }
        for (PBXObject eachObject : this.myObjects.values()) {
            eachObject.convertReferences(oldToNewMap.keySet(), (Function<PbxId, PbxId>)((Function)id -> (PbxId)oldToNewMap.get(id)));
        }
        this.resetReferencesCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObject(@NotNull PBXObject object, @Nullable PBXGroup group) {
        PbxId id;
        if (object == null) {
            PBXProjectFile.$$$reportNull$$$0(37);
        }
        this.myRWAChecker.checkWrite();
        if (object.getId() != PbxId.NONE) {
            throw new RuntimeException("Cannot add already added object:\n" + object.getDebugString());
        }
        while (this.myObjects.containsKey(id = this.generateNextId())) {
        }
        object.setId(id);
        this.myObjects.put(id, object);
        Object object2 = this.myCacheLock;
        synchronized (object2) {
            if (object instanceof PBXReference) {
                PBXReference ref = (PBXReference)object;
                if (group != null) {
                    group.appendChild(ref.createReference());
                }
                if (ref.isLinkedProject()) {
                    this.myCache.myDirectlyLinkedProjects = null;
                }
                if (this.myCache.myReferenceToParentGroupMap != null && group != null) {
                    this.myCache.myReferenceToParentGroupMap.put(ref, group);
                }
                VirtualFile foundFile = null;
                if (this.myCache.myFileCachesBuilt) {
                    foundFile = ref.refreshAndFindFile();
                }
                if (this.myCache.myFileCachesBuilt) {
                    PBXProjectFile.addRefToCaches(ref, foundFile, this.myCache.myReferences, this.myCache.myFileReferences, this.myCache.myLocalSwiftPackageReferences, this.myCache.myRemoteSwiftPackageReferences, this.myCache.myAllProjectFiles, this.myCache.myReferenceToCacheEntryMap, this.myCache.myPathToReferencesMap, this.myCache.myFileToReferencesMap, this.myCache.myFileNameToFileMap, this.myCache.myFileToAssociatedFilesMap, this.myCache.myFileToAssociatedRootMap, this.myCache.myFileRefTree, this.myCache.mySynchronizedRootsTree);
                }
            }
            this.resetTargetConfigCachesOnChange(object);
        }
    }

    private void resetTargetConfigCachesOnChange(@NotNull PBXObject object) {
        if (object == null) {
            PBXProjectFile.$$$reportNull$$$0(38);
        }
        if (object instanceof PBXTarget) {
            this.myTargetCacheTracker.incModificationCount();
            this.myCache.myConfigToTargetMap = null;
            this.myCache.myNameToTargetMap = null;
        } else if (object instanceof XCBuildConfiguration) {
            this.myCache.myConfigToTargetMap = null;
            this.myCache.myNameToTargetMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBuildFile(@NotNull PBXReference ref, @NotNull PBXBuildFile buildFile, @NotNull PBXTarget target, @NotNull PBXBuildPhase phase) {
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(39);
        }
        if (buildFile == null) {
            PBXProjectFile.$$$reportNull$$$0(40);
        }
        if (target == null) {
            PBXProjectFile.$$$reportNull$$$0(41);
        }
        if (phase == null) {
            PBXProjectFile.$$$reportNull$$$0(42);
        }
        Object object = this.myBuildFilesCacheLock;
        synchronized (object) {
            RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> buildFileToTargetAndPhase;
            RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> referenceToTargetMap;
            RWAMap<PbxId, List<PBXBuildFile>> referenceToBuildFileMap = this.myBuildFilesCache.myReferenceIdToBuildFilesMap;
            if (referenceToBuildFileMap != null) {
                List<PBXBuildFile> buildFiles = referenceToBuildFileMap.get(ref.getId());
                if (buildFiles == null) {
                    buildFiles = new RWAList<PBXBuildFile>((List<PBXBuildFile>)new SmartList(), (RWASupport.Checker)this.myRWAChecker);
                    referenceToBuildFileMap.put(ref.getId(), buildFiles);
                }
                buildFiles.add(buildFile);
            }
            if ((referenceToTargetMap = this.myBuildFilesCache.myReferenceIdToTargetsAndConfigsMap) != null) {
                Pair<List<PBXTarget>, List<XCBuildConfiguration>> current = referenceToTargetMap.remove(ref.getId());
                if (current != null) {
                    HashSet existingTargetsSet = new HashSet((Collection)current.first);
                    for (PBXTarget each : this.getTargets(null)) {
                        if (each != target && !existingTargetsSet.contains((Object)each)) continue;
                        this.addRefTarget(ref, each, each.getBuildConfigurations(), referenceToTargetMap, false);
                    }
                    referenceToTargetMap.put(ref.getId(), this.convertToRWA(referenceToTargetMap.get(ref.getId())));
                } else {
                    this.addRefTarget(ref, target, target.getBuildConfigurations(), referenceToTargetMap, true);
                }
            }
            if ((buildFileToTargetAndPhase = this.myBuildFilesCache.myBuildFileToTargetAndPhase) != null) {
                buildFileToTargetAndPhase.put(buildFile, (Pair<PBXTarget, PBXBuildPhase>)Pair.create((Object)((Object)target), (Object)((Object)phase)));
            }
        }
    }

    void removeObjects(@NotNull Collection<? extends PBXObject> objects) {
        if (objects == null) {
            PBXProjectFile.$$$reportNull$$$0(43);
        }
        HashSet<PbxId> removed = new HashSet<PbxId>();
        this.doRemoveObjects(objects, removed);
        Function remover = id -> null;
        for (PBXObject object : this.myObjects.values()) {
            object.convertReferences(removed, (Function<PbxId, PbxId>)remover);
        }
    }

    private void doRemoveObjects(Collection<? extends PBXObject> objects, Set<PbxId> removed) {
        this.myRWAChecker.checkWrite();
        HashSet<PbxId> removedRefIds = new HashSet<PbxId>();
        for (PBXObject pBXObject : objects) {
            this.doRemoveObject(pBXObject.getId(), removed, removedRefIds);
        }
        this.doRemoveBuildFilesForReferences(removedRefIds, removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveObject(@NotNull PbxId id, @NotNull Set<PbxId> removed, @NotNull Set<PbxId> removedRefIds) {
        PBXObject object;
        if (id == null) {
            PBXProjectFile.$$$reportNull$$$0(44);
        }
        if (removed == null) {
            PBXProjectFile.$$$reportNull$$$0(45);
        }
        if (removedRefIds == null) {
            PBXProjectFile.$$$reportNull$$$0(46);
        }
        if ((object = this.doRemoveObjectInternal(id, removed)) == null) {
            return;
        }
        Object object2 = this.myCacheLock;
        synchronized (object2) {
            Object object3 = this.myBuildFilesCacheLock;
            synchronized (object3) {
                if (object instanceof PBXReference) {
                    PBXReference ref = (PBXReference)object;
                    removedRefIds.add(id);
                    if (ref.isLinkedProject()) {
                        this.myCache.myDirectlyLinkedProjects = null;
                    }
                    this.removeRefFromCaches(ref);
                } else if (object instanceof PBXBuildFile) {
                    PBXBuildFile buildFile = (PBXBuildFile)object;
                    if (this.myBuildFilesCache.myBuildFileCacheBuilt) {
                        PbxId refId;
                        List<PBXBuildFile> bfs;
                        RWAMap<PbxId, List<PBXBuildFile>> referenceIdToBuildFilesMap = this.myBuildFilesCache.myReferenceIdToBuildFilesMap;
                        RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> refIdToTargetsAndConfigs = this.myBuildFilesCache.myReferenceIdToTargetsAndConfigsMap;
                        PBXTarget cachedTarget = null;
                        Pair<PBXTarget, PBXBuildPhase> targetAndPhase = this.myBuildFilesCache.myBuildFileToTargetAndPhase.remove((Object)buildFile);
                        if (targetAndPhase != null) {
                            cachedTarget = (PBXTarget)((Object)targetAndPhase.first);
                        }
                        if ((bfs = referenceIdToBuildFilesMap.get(refId = buildFile.getFileRefId())) != null) {
                            bfs.remove((Object)buildFile);
                            if (bfs.isEmpty()) {
                                referenceIdToBuildFilesMap.remove(refId);
                            }
                        }
                        if (cachedTarget != null) {
                            Pair<List<PBXTarget>, List<XCBuildConfiguration>> targetAndConfigs = refIdToTargetsAndConfigs.get(refId);
                            ((List)targetAndConfigs.first).remove((Object)cachedTarget);
                            if (((List)targetAndConfigs.first).isEmpty()) {
                                refIdToTargetsAndConfigs.remove(refId);
                            } else {
                                ((List)targetAndConfigs.second).removeAll(cachedTarget.getBuildConfigurations());
                            }
                        }
                    }
                }
                this.resetTargetConfigCachesOnChange(object);
            }
        }
    }

    private PBXObject doRemoveObjectInternal(PbxId id, Set<PbxId> removed) {
        removed.add(id);
        return this.myObjects.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveBuildFilesForReferences(@NotNull Set<PbxId> removedRefIds, @NotNull Set<PbxId> removedObjectIds) {
        if (removedRefIds == null) {
            PBXProjectFile.$$$reportNull$$$0(47);
        }
        if (removedObjectIds == null) {
            PBXProjectFile.$$$reportNull$$$0(48);
        }
        if (removedRefIds.isEmpty()) {
            return;
        }
        Object object = this.myBuildFilesCacheLock;
        synchronized (object) {
            RWAMap<PbxId, List<PBXBuildFile>> refIdToBuildFilesMap = this.myBuildFilesCache.myReferenceIdToBuildFilesMap;
            if (refIdToBuildFilesMap != null) {
                RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> refIdToTargetsAndConfigs = this.myBuildFilesCache.myReferenceIdToTargetsAndConfigsMap;
                RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> buildFileToTargetAndPhase = this.myBuildFilesCache.myBuildFileToTargetAndPhase;
                for (PbxId refId : removedRefIds) {
                    refIdToTargetsAndConfigs.remove(refId);
                    List<PBXBuildFile> buildFiles = refIdToBuildFilesMap.remove(refId);
                    if (buildFiles == null) continue;
                    for (PBXBuildFile buildFile : buildFiles) {
                        buildFileToTargetAndPhase.remove((Object)buildFile);
                        this.doRemoveObjectInternal(buildFile.getId(), removedObjectIds);
                    }
                }
            } else {
                for (PBXBuildFile buildFile : this.getObjects(PBXBuildFile.class)) {
                    if (!removedRefIds.contains(buildFile.getFileRefId())) continue;
                    this.doRemoveObjectInternal(buildFile.getId(), removedObjectIds);
                }
            }
        }
    }

    public Collection<VirtualFile> getFiles() {
        this.initFileMaps();
        return Collections.unmodifiableCollection(this.myCache.myAllProjectFiles.keySet());
    }

    public Collection<PBXReference> getAllReferences() {
        this.initFileMaps();
        return Collections.unmodifiableCollection(this.myCache.myReferences);
    }

    public Collection<PBXFileReference> getFileReferences() {
        this.initFileMaps();
        return Collections.unmodifiableCollection(this.myCache.myFileReferences);
    }

    public Collection<XCLocalSwiftPackageReference> getLocalSwiftPackageReferences() {
        this.initFileMaps();
        RWASet<XCLocalSwiftPackageReference> references = this.myCache.myLocalSwiftPackageReferences;
        return references != null ? Collections.unmodifiableCollection(references) : Collections.emptyList();
    }

    public Collection<XCRemoteSwiftPackageReference> getRemoteSwiftPackageReferences() {
        this.initFileMaps();
        RWASet<XCRemoteSwiftPackageReference> references = this.myCache.myRemoteSwiftPackageReferences;
        return references != null ? Collections.unmodifiableCollection(references) : Collections.emptyList();
    }

    public Collection<VirtualFile> getAssociatedFileRoots() {
        this.initFileMaps();
        return Collections.unmodifiableCollection(this.myCache.myFileToAssociatedRootMap.keySet());
    }

    public FileRefTree getFileRefTree() {
        this.initFileMaps();
        return this.myCache.myFileRefTree;
    }

    public SynchronizedRootsTree getSynchronizedRootsTree() {
        this.initFileMaps();
        return this.myCache.mySynchronizedRootsTree;
    }

    public Map<VirtualFile, List<PBXTarget>> getSynchronizedFileToTargetsMap() {
        this.initFileMaps();
        return this.myCache.mySynchronizedFileToTargetsMap;
    }

    public Map<PBXTarget, List<VirtualFile>> getTargetToSynchronizedFilesMap() {
        this.initFileMaps();
        return this.myCache.myTargetToSynchronizedFilesMap;
    }

    public Map<VirtualFile, List<Pair<PBXTarget, String>>> getSynchronizedFileToCompilerArgumentsMap() {
        this.initFileMaps();
        return this.myCache.mySynchronizedFileToCompilerArgumentsMap;
    }

    public boolean containsFile(@Nullable VirtualFile file) {
        return file != null && this.getFiles().contains(file);
    }

    @NotNull
    public List<VirtualFile> findFilesByName(@Nullable String name) {
        List<VirtualFile> files = name == null ? null : this.getFileNameToFilesMap().get(name);
        List<Object> list = files == null ? Collections.emptyList() : Collections.unmodifiableList(files);
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(49);
        }
        return list;
    }

    @NotNull
    public List<PBXReference> findReferences(@Nullable Path path) {
        List<PBXReference> references = path == null ? null : this.getPathToReferencesMap().get(path);
        List<Object> list = references == null ? Collections.emptyList() : Collections.unmodifiableList(references);
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public List<PBXReference> findReferences(@Nullable VirtualFile file) {
        List<PBXReference> references = file == null ? null : this.getFileToReferencesMap().get(file);
        List<Object> list = references == null ? Collections.emptyList() : Collections.unmodifiableList(references);
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    public <T extends PBXTarget> List<T> getTargets(@Nullable Class<T> clazz) {
        return PBXProjectFile.selectTargets((List)this.myTargetsCache.getValue(), clazz);
    }

    @NotNull
    public <T extends PBXTarget> List<T> getTargetsFor(@Nullable VirtualFile file, @Nullable Class<T> targetClass, boolean effectiveValues) {
        List list = ContainerUtil.concat(PBXProjectFile.selectTargets(this.getTargetsForVFileInSyncGroup(file), targetClass), (List)ContainerUtil.flatMap(this.findReferences(file), reference -> this.getTargetsFor(effectiveValues ? PBXReference.effectiveTargetMember(reference) : reference, targetClass)));
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(52);
        }
        return list;
    }

    private List<PBXTarget> getTargetsForVFileInSyncGroup(@Nullable VirtualFile file) {
        return this.getSynchronizedFileToTargetsMap().getOrDefault(file, Collections.emptyList());
    }

    @NotNull
    public <T extends PBXTarget> List<T> getTargetsFor(@Nullable PBXReference ref, @Nullable Class<T> targetClass) {
        Pair<List<PBXTarget>, List<XCBuildConfiguration>> result;
        Pair<List<PBXTarget>, List<XCBuildConfiguration>> pair = result = ref == null ? null : this.getRefIdToTargetsAndConfigsMap().get(ref.getId());
        if (result == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PBXProjectFile.$$$reportNull$$$0(53);
            }
            return list;
        }
        return PBXProjectFile.selectTargets((List)result.first, targetClass);
    }

    @NotNull
    static <T extends PBXTarget> List<T> selectTargets(@NotNull List<PBXTarget> all, @Nullable Class<T> clazz) {
        if (all == null) {
            PBXProjectFile.$$$reportNull$$$0(54);
        }
        if (clazz == null) {
            List<PBXTarget> list = all;
            if (list == null) {
                PBXProjectFile.$$$reportNull$$$0(55);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (PBXTarget each : all) {
            if (!clazz.isInstance((Object)each)) continue;
            result.add(each);
        }
        List list = Collections.unmodifiableList(result);
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(56);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends PBXTarget> T findTarget(@Nullable String name, @Nullable Class<T> clazz) {
        if (name == null) {
            return null;
        }
        MostlySingularMultiMap map = this.myCache.myNameToTargetMap;
        if (map == null) {
            Object object = this.myCacheLock;
            synchronized (object) {
                map = this.myCache.myNameToTargetMap;
                if (map == null) {
                    map = new MostlySingularMultiMap();
                    for (PBXTarget each : this.getTargets(null)) {
                        map.add((Object)each.getName(), (Object)each);
                    }
                    this.myCache.myNameToTargetMap = map;
                }
            }
        }
        Iterable targets = map.get((Object)name);
        return (T)((Object)(clazz == null ? (PBXTarget)((Object)CollectionsKt.firstOrNull((Iterable)targets)) : (PBXTarget)((Object)ContainerUtil.findInstance((Iterable)targets, clazz))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PBXTarget> findTargetsFor(@Nullable XCBuildConfiguration config) {
        if (config == null) {
            List<PBXTarget> list = Collections.emptyList();
            if (list == null) {
                PBXProjectFile.$$$reportNull$$$0(57);
            }
            return list;
        }
        MostlySingularMultiMap map = this.myCache.myConfigToTargetMap;
        if (map == null) {
            Object object = this.myCacheLock;
            synchronized (object) {
                map = this.myCache.myConfigToTargetMap;
                if (map == null) {
                    map = new MostlySingularMultiMap();
                    for (PBXTarget eachTarget : this.getTargets(null)) {
                        for (XCBuildConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                            map.add((Object)eachConfig, (Object)eachTarget);
                        }
                    }
                    this.myCache.myConfigToTargetMap = map;
                }
            }
        }
        List list = (List)map.get((Object)config);
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(58);
        }
        return list;
    }

    @Nullable
    public PBXNativeTarget findTargetForProduct(@NotNull PBXReference productFileRef, @Nullable BuildSettingsProvider settingsProvider) {
        if (productFileRef == null) {
            PBXProjectFile.$$$reportNull$$$0(59);
        }
        return (PBXNativeTarget)((Object)ContainerUtil.find(this.getTargets(PBXNativeTarget.class), target -> {
            PBXFileReference productReference = target.getProductReference();
            if (productReference == null) {
                return false;
            }
            if (productFileRef.equals((Object)productReference)) {
                return true;
            }
            VirtualFile foundFile = productFileRef.findFile(settingsProvider);
            if (foundFile != null && foundFile.equals(productReference.findFile(settingsProvider))) {
                return true;
            }
            String foundFilePath = productFileRef.resolvePath(settingsProvider);
            return foundFilePath != null && FileUtil.pathsEqual((String)foundFilePath, (String)productReference.resolvePath(settingsProvider));
        }));
    }

    @NotNull
    public List<PBXBuildFile> getBuildFilesFor(@Nullable VirtualFile file) {
        List list = ContainerUtil.flatMap(this.findReferences(file), this.myBuildFilesFunction);
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(60);
        }
        return list;
    }

    @NotNull
    public List<PBXBuildFile> getBuildFilesFor(@Nullable PBXReference ref) {
        List<PBXBuildFile> files = ref == null ? null : this.getBuildFilesMap().get(ref.getId());
        List<Object> list = files == null ? Collections.emptyList() : Collections.unmodifiableList(files);
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(61);
        }
        return list;
    }

    @Nullable
    public @Unmodifiable Collection<AppleFileType> getTargetSourceFileTypes(@Nullable PBXTarget target) {
        return target == null ? null : this.getTargetToSourceFileTypesMap().get((Object)target);
    }

    @Nullable
    public Pair<PBXTarget, PBXBuildPhase> getTargetAndPhase(@Nullable PBXBuildFile buildFile) {
        return buildFile == null ? null : this.getBuildFileToTargetMap().get((Object)buildFile);
    }

    @NotNull
    private RWAMap<Path, List<PBXReference>> getPathToReferencesMap() {
        this.initFileMaps();
        RWAMap<Path, List<PBXReference>> rWAMap = this.myCache.myPathToReferencesMap;
        if (rWAMap == null) {
            PBXProjectFile.$$$reportNull$$$0(62);
        }
        return rWAMap;
    }

    @NotNull
    private RWAMap<VirtualFile, List<PBXReference>> getFileToReferencesMap() {
        this.initFileMaps();
        RWAMap<VirtualFile, List<PBXReference>> rWAMap = this.myCache.myFileToReferencesMap;
        if (rWAMap == null) {
            PBXProjectFile.$$$reportNull$$$0(63);
        }
        return rWAMap;
    }

    @NotNull
    private RWAMap<String, List<VirtualFile>> getFileNameToFilesMap() {
        this.initFileMaps();
        RWAMap<String, List<VirtualFile>> rWAMap = this.myCache.myFileNameToFileMap;
        if (rWAMap == null) {
            PBXProjectFile.$$$reportNull$$$0(64);
        }
        return rWAMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFileMaps() {
        this.myRWAChecker.checkRead();
        if (!this.myCache.myFileCachesBuilt) {
            Object object = this.myCacheLock;
            synchronized (object) {
                if (!this.myCache.myFileCachesBuilt) {
                    HashSet<PBXReference> refs = new HashSet<PBXReference>();
                    HashSet<PBXFileReference> fileRefs = new HashSet<PBXFileReference>();
                    HashSet<XCLocalSwiftPackageReference> localSwiftPackageRefs = new HashSet<XCLocalSwiftPackageReference>();
                    HashSet<XCRemoteSwiftPackageReference> remoteSwiftPackageRefs = new HashSet<XCRemoteSwiftPackageReference>();
                    HashMap<PBXReference, ReferenceCacheEntry> refToCacheEntry = new HashMap<PBXReference, ReferenceCacheEntry>();
                    HashMap<Path, List<PBXReference>> pathToRef = new HashMap<Path, List<PBXReference>>();
                    HashMap<VirtualFile, List<PBXReference>> fileToRef = new HashMap<VirtualFile, List<PBXReference>>();
                    HashMap<String, List<VirtualFile>> nameToFile = new HashMap<String, List<VirtualFile>>();
                    LinkedHashMap<VirtualFile, Integer> allFiles = new LinkedHashMap<VirtualFile, Integer>();
                    HashMap<VirtualFile, Collection<VirtualFile>> assocFilesMap = new HashMap<VirtualFile, Collection<VirtualFile>>();
                    HashMap<VirtualFile, List<PBXReference>> assocFileRoots = new HashMap<VirtualFile, List<PBXReference>>();
                    FileRefTree fileRefTree = new FileRefTree();
                    SynchronizedRootsTree synchronizedRootsTree = new SynchronizedRootsTree();
                    for (PBXReference ref : this.getObjects(PBXReference.class)) {
                        VirtualFile file = ref.findFile();
                        PBXProjectFile.addRefToCaches(ref, file, refs, fileRefs, localSwiftPackageRefs, remoteSwiftPackageRefs, allFiles, refToCacheEntry, pathToRef, fileToRef, nameToFile, assocFilesMap, assocFileRoots, fileRefTree, synchronizedRootsTree);
                    }
                    HashMap<VirtualFile, List<PBXTarget>> fileToTargetMap = new HashMap<VirtualFile, List<PBXTarget>>();
                    HashMap<PBXTarget, List<VirtualFile>> targetToFilesMap = new HashMap<PBXTarget, List<VirtualFile>>();
                    HashMap<VirtualFile, List<Pair<PBXTarget, String>>> fileToCompilerArgumentsMap = new HashMap<VirtualFile, List<Pair<PBXTarget, String>>>();
                    this.processSynchronizedRoots(nameToFile, allFiles, fileToTargetMap, targetToFilesMap, fileToCompilerArgumentsMap);
                    this.myCache.myAllProjectFiles = new RWAMap<VirtualFile, Integer>(allFiles, this.myRWAChecker);
                    this.myCache.myReferences = new RWASet<PBXReference>((Set<PBXReference>)refs, (RWASupport.Checker)this.myRWAChecker);
                    this.myCache.myReferenceToCacheEntryMap = new RWAMap<PBXReference, ReferenceCacheEntry>(refToCacheEntry, this.myRWAChecker);
                    this.myCache.myFileReferences = new RWASet<PBXFileReference>((Set<PBXFileReference>)fileRefs, (RWASupport.Checker)this.myRWAChecker);
                    this.myCache.myLocalSwiftPackageReferences = new RWASet<XCLocalSwiftPackageReference>((Set<XCLocalSwiftPackageReference>)localSwiftPackageRefs, (RWASupport.Checker)this.myRWAChecker);
                    this.myCache.myRemoteSwiftPackageReferences = new RWASet<XCRemoteSwiftPackageReference>((Set<XCRemoteSwiftPackageReference>)remoteSwiftPackageRefs, (RWASupport.Checker)this.myRWAChecker);
                    this.myCache.myPathToReferencesMap = new RWAMap<Path, List<PBXReference>>(pathToRef, this.myRWAChecker);
                    this.myCache.myFileToReferencesMap = new RWAMap<VirtualFile, List<PBXReference>>(fileToRef, this.myRWAChecker);
                    this.myCache.myFileNameToFileMap = new RWAMap<String, List<VirtualFile>>(nameToFile, this.myRWAChecker);
                    this.myCache.myFileToAssociatedFilesMap = new RWAMap<VirtualFile, Collection<VirtualFile>>(assocFilesMap, this.myRWAChecker);
                    this.myCache.myFileToAssociatedRootMap = new RWAMap<VirtualFile, List<PBXReference>>(assocFileRoots, this.myRWAChecker);
                    this.myCache.myFileRefTree = fileRefTree;
                    this.myCache.mySynchronizedRootsTree = synchronizedRootsTree;
                    this.myCache.mySynchronizedFileToTargetsMap = new RWAMap<VirtualFile, List<PBXTarget>>(fileToTargetMap, this.myRWAChecker);
                    this.myCache.myTargetToSynchronizedFilesMap = new RWAMap<PBXTarget, List<VirtualFile>>(targetToFilesMap, this.myRWAChecker);
                    this.myCache.mySynchronizedFileToCompilerArgumentsMap = new RWAMap<VirtualFile, List<Pair<PBXTarget, String>>>(fileToCompilerArgumentsMap, this.myRWAChecker);
                    this.myCache.myFileCachesBuilt = true;
                }
            }
        }
    }

    private static void addRefToCaches(@NotNull PBXReference ref, @Nullable VirtualFile file, @NotNull Set<PBXReference> allRefsCache, @NotNull Set<PBXFileReference> allFileRefsCache, @NotNull Set<XCLocalSwiftPackageReference> localSwiftPackageRefs, @NotNull Set<XCRemoteSwiftPackageReference> remoteSwiftPackageRefs, @NotNull Map<VirtualFile, Integer> allFiles, @NotNull Map<PBXReference, ReferenceCacheEntry> refToCacheEntryCache, @NotNull Map<Path, List<PBXReference>> pathToRefsCache, @NotNull Map<VirtualFile, List<PBXReference>> fileToRefsCache, @NotNull Map<String, List<VirtualFile>> nameToFileCache, @NotNull Map<VirtualFile, Collection<VirtualFile>> assocFilesMapCache, @NotNull Map<VirtualFile, List<PBXReference>> assocFileRootsCache, @NotNull FileRefTree fileRefTree, @NotNull SynchronizedRootsTree synchronizedRootsTree) {
        String path;
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(65);
        }
        if (allRefsCache == null) {
            PBXProjectFile.$$$reportNull$$$0(66);
        }
        if (allFileRefsCache == null) {
            PBXProjectFile.$$$reportNull$$$0(67);
        }
        if (localSwiftPackageRefs == null) {
            PBXProjectFile.$$$reportNull$$$0(68);
        }
        if (remoteSwiftPackageRefs == null) {
            PBXProjectFile.$$$reportNull$$$0(69);
        }
        if (allFiles == null) {
            PBXProjectFile.$$$reportNull$$$0(70);
        }
        if (refToCacheEntryCache == null) {
            PBXProjectFile.$$$reportNull$$$0(71);
        }
        if (pathToRefsCache == null) {
            PBXProjectFile.$$$reportNull$$$0(72);
        }
        if (fileToRefsCache == null) {
            PBXProjectFile.$$$reportNull$$$0(73);
        }
        if (nameToFileCache == null) {
            PBXProjectFile.$$$reportNull$$$0(74);
        }
        if (assocFilesMapCache == null) {
            PBXProjectFile.$$$reportNull$$$0(75);
        }
        if (assocFileRootsCache == null) {
            PBXProjectFile.$$$reportNull$$$0(76);
        }
        if (fileRefTree == null) {
            PBXProjectFile.$$$reportNull$$$0(77);
        }
        if (synchronizedRootsTree == null) {
            PBXProjectFile.$$$reportNull$$$0(78);
        }
        allRefsCache.add(ref);
        if (ref instanceof PBXFileReference) {
            allFileRefsCache.add((PBXFileReference)ref);
        }
        if (ref instanceof XCLocalSwiftPackageReference) {
            localSwiftPackageRefs.add((XCLocalSwiftPackageReference)ref);
        }
        if (ref instanceof XCRemoteSwiftPackageReference) {
            remoteSwiftPackageRefs.add((XCRemoteSwiftPackageReference)ref);
        }
        if (file != null) {
            PBXProjectFile.addToNameToFileMap(nameToFileCache, file);
            PBXProjectFile.addToPathToRefMap(pathToRefsCache, ref, file);
            PBXProjectFile.addToFileToRefMap(fileToRefsCache, allFiles, ref, file);
            PBXProjectFile.handleAssociatedRootAddition(ref, file, allFiles, assocFileRootsCache, assocFilesMapCache, fileRefTree);
        }
        String string = path = file == null ? ref.resolvePath() : file.getPath();
        if (path != null) {
            if (ref instanceof PBXFileSystemSynchronizedRootGroup) {
                PBXFileSystemSynchronizedRootGroup syncGroup = (PBXFileSystemSynchronizedRootGroup)ref;
                synchronizedRootsTree.registerRoot(path, syncGroup);
            }
            fileRefTree.addReference(path, ref);
        }
        refToCacheEntryCache.put(ref, new ReferenceCacheEntry(file, path));
    }

    private void processSynchronizedRoots(final @NotNull Map<String, List<VirtualFile>> nameToFile, final @NotNull Map<VirtualFile, Integer> allFiles, final @NotNull Map<VirtualFile, List<PBXTarget>> fileToTargetMap, final @NotNull Map<PBXTarget, List<VirtualFile>> targetToFilesMap, final @NotNull Map<VirtualFile, List<Pair<PBXTarget, String>>> fileToCompilerArgumentsMap) {
        if (nameToFile == null) {
            PBXProjectFile.$$$reportNull$$$0(79);
        }
        if (allFiles == null) {
            PBXProjectFile.$$$reportNull$$$0(80);
        }
        if (fileToTargetMap == null) {
            PBXProjectFile.$$$reportNull$$$0(81);
        }
        if (targetToFilesMap == null) {
            PBXProjectFile.$$$reportNull$$$0(82);
        }
        if (fileToCompilerArgumentsMap == null) {
            PBXProjectFile.$$$reportNull$$$0(83);
        }
        this.getObjects(PBXFileSystemSynchronizedRootGroup.class).forEach(group -> {
            final Set owningTargets = CollectionsKt.toSet((Iterable)CollectionsKt.filter(this.getTargets(PBXTarget.class), target -> target.getSynchronizedGroups().contains(group)));
            final VirtualFile groupRoot = group.findFile();
            if (groupRoot == null) {
                return;
            }
            final HashMap<String, List<PBXTarget>> excludedPaths = new HashMap<String, List<PBXTarget>>();
            final HashMap<String, List<PBXTarget>> reassignedPaths = new HashMap<String, List<PBXTarget>>();
            final HashMap<String, List<Pair<PBXTarget, String>>> compilerArgumentsMap = new HashMap<String, List<Pair<PBXTarget, String>>>();
            PBXProjectFile.buildExclusionAndReassignmentMaps(group, owningTargets, excludedPaths, reassignedPaths, compilerArgumentsMap);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)groupRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(this, new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    if (file == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (groupRoot.equals(file)) {
                        VirtualFileVisitor.Result result = CONTINUE;
                        if (result == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return result;
                    }
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)groupRoot, (char)'/');
                    Collection excludedTargets = excludedPaths.getOrDefault(relativePath, Collections.emptyList());
                    Collection reassignedTargets = reassignedPaths.getOrDefault(relativePath, Collections.emptyList());
                    List effectiveTargets = CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)owningTargets, (Iterable)excludedTargets), (Iterable)reassignedTargets);
                    for (Pair argumentForTarget : compilerArgumentsMap.getOrDefault(relativePath, Collections.emptyList())) {
                        PBXProjectFile.addToListMap(fileToCompilerArgumentsMap, file, argumentForTarget);
                    }
                    if (!effectiveTargets.isEmpty()) {
                        effectiveTargets.forEach(target -> {
                            PBXProjectFile.addToListMap(fileToTargetMap, file, target);
                            PBXProjectFile.addToListMap(targetToFilesMap, target, file);
                        });
                        if (!allFiles.containsKey(file)) {
                            PBXProjectFile.addToCountingSet(allFiles, file);
                        }
                        PBXProjectFile.addToNameToFileMap(nameToFile, file);
                    }
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFile$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFile$2";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            });
        });
    }

    private static void buildExclusionAndReassignmentMaps(@NotNull PBXFileSystemSynchronizedRootGroup group, @NotNull Set<PBXTarget> owningTargets, @NotNull Map<String, List<PBXTarget>> excludedPaths, @NotNull Map<String, List<PBXTarget>> reassignedPaths, @NotNull Map<String, List<Pair<PBXTarget, String>>> compilerArgumentsMap) {
        if (group == null) {
            PBXProjectFile.$$$reportNull$$$0(84);
        }
        if (owningTargets == null) {
            PBXProjectFile.$$$reportNull$$$0(85);
        }
        if (excludedPaths == null) {
            PBXProjectFile.$$$reportNull$$$0(86);
        }
        if (reassignedPaths == null) {
            PBXProjectFile.$$$reportNull$$$0(87);
        }
        if (compilerArgumentsMap == null) {
            PBXProjectFile.$$$reportNull$$$0(88);
        }
        group.getExceptionSets().forEach(exceptionSet -> {
            PBXTarget exceptionTarget = exceptionSet.getTarget();
            if (exceptionTarget == null) {
                return;
            }
            for (Map.Entry<String, String> entry : exceptionSet.getAdditionalCompilerFlagsByRelativePath().entrySet()) {
                PBXProjectFile.addToListMap(compilerArgumentsMap, entry.getKey(), Pair.create((Object)((Object)exceptionTarget), (Object)entry.getValue()));
            }
            List<@NotNull String> membershipExceptions = exceptionSet.getMembershipExceptions();
            if (owningTargets.contains((Object)exceptionTarget)) {
                membershipExceptions.forEach(exceptionPath -> PBXProjectFile.addToListMap(excludedPaths, exceptionPath, exceptionTarget));
            } else {
                membershipExceptions.forEach(exceptionPath -> PBXProjectFile.addToListMap(reassignedPaths, exceptionPath, exceptionTarget));
            }
        });
    }

    private void removeRefFromCaches(@NotNull PBXReference ref) {
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(89);
        }
        if (this.myCache.myFileCachesBuilt) {
            String syncPath;
            VirtualFile file;
            @NotNull RWAMap<String, List<VirtualFile>> fileNameToFile = this.myCache.myFileNameToFileMap;
            @NotNull RWAMap<VirtualFile, Integer> allFiles = this.myCache.myAllProjectFiles;
            @NotNull RWAMap<VirtualFile, Collection<VirtualFile>> rootToAssociatedFilesMap = this.myCache.myFileToAssociatedFilesMap;
            @NotNull RWAMap<PBXReference, ReferenceCacheEntry> refToCacheEntryMap = this.myCache.myReferenceToCacheEntryMap;
            @NotNull FileRefTree fileRefTree = this.myCache.myFileRefTree;
            ReferenceCacheEntry cacheEntry = refToCacheEntryMap.get((Object)ref);
            String path = cacheEntry == null ? null : cacheEntry.path;
            VirtualFile virtualFile = file = cacheEntry == null ? null : cacheEntry.file;
            if (ref instanceof PBXFileReference) {
                this.myCache.myFileReferences.remove((Object)ref);
            }
            if (ref instanceof PBXFileSystemSynchronizedRootGroup && (syncPath = ref.resolvePath()) != null) {
                this.myCache.mySynchronizedRootsTree.unregisterRoot(syncPath, (PBXFileSystemSynchronizedRootGroup)ref);
            }
            this.myCache.myReferences.remove((Object)ref);
            if (file != null) {
                PBXProjectFile.removeFromListMap(this.myCache.myFileToReferencesMap, file, ref);
                PBXProjectFile.removeFromCountingSet(allFiles, file);
                PBXProjectFile.removeFromNameToFileMap(fileNameToFile, file);
                PBXProjectFile.handleAssociatedRootRemoval(ref, file, allFiles, this.myCache.myFileToAssociatedRootMap, rootToAssociatedFilesMap, fileRefTree);
            }
            if (path != null) {
                fileRefTree.removeReference(path, ref);
            }
            refToCacheEntryMap.remove((Object)ref);
        }
        if (this.myCache.myReferenceToParentGroupMap != null) {
            this.myCache.myReferenceToParentGroupMap.remove((Object)ref);
        }
    }

    private static void handleAssociatedRootAddition(@NotNull PBXReference ref, final @NotNull VirtualFile file, final @NotNull Map<VirtualFile, Integer> allFiles, @NotNull Map<VirtualFile, List<PBXReference>> associatedRootMap, @NotNull Map<VirtualFile, Collection<VirtualFile>> rootToAssociatedFilesMap, final @NotNull FileRefTree fileRefTree) {
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(90);
        }
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(91);
        }
        if (allFiles == null) {
            PBXProjectFile.$$$reportNull$$$0(92);
        }
        if (associatedRootMap == null) {
            PBXProjectFile.$$$reportNull$$$0(93);
        }
        if (rootToAssociatedFilesMap == null) {
            PBXProjectFile.$$$reportNull$$$0(94);
        }
        if (fileRefTree == null) {
            PBXProjectFile.$$$reportNull$$$0(95);
        }
        if (!PBXProjectFile.isAssociatedFileRoot(ref, file)) {
            return;
        }
        List<PBXReference> roots = associatedRootMap.get(file);
        boolean noPreviousRoots = roots == null || roots.isEmpty();
        PBXProjectFile.addToListMap(associatedRootMap, file, ref);
        if (noPreviousRoots) {
            final ArrayList assocFiles = new ArrayList();
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile f) {
                    if (f == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!file.equals(f) && !allFiles.containsKey(f)) {
                        String path = f.getPath();
                        fileRefTree.incAssociatedFiles(path);
                        PBXProjectFile.addToCountingSet(allFiles, f);
                        assocFiles.add(f);
                    }
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "f";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFile$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFile$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            assocFiles.trimToSize();
            rootToAssociatedFilesMap.put(file, assocFiles);
        }
    }

    private static void handleAssociatedRootRemoval(@NotNull PBXReference ref, @NotNull VirtualFile file, @NotNull Map<VirtualFile, Integer> allFiles, @NotNull Map<VirtualFile, List<PBXReference>> associatedRootMap, @NotNull Map<VirtualFile, Collection<VirtualFile>> rootToAssociatedFilesMap, @NotNull FileRefTree fileRefTree) {
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(96);
        }
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(97);
        }
        if (allFiles == null) {
            PBXProjectFile.$$$reportNull$$$0(98);
        }
        if (associatedRootMap == null) {
            PBXProjectFile.$$$reportNull$$$0(99);
        }
        if (rootToAssociatedFilesMap == null) {
            PBXProjectFile.$$$reportNull$$$0(100);
        }
        if (fileRefTree == null) {
            PBXProjectFile.$$$reportNull$$$0(101);
        }
        if (PBXProjectFile.removeFromListMap(associatedRootMap, file, ref) == 0) {
            Collection<VirtualFile> associatedFiles = rootToAssociatedFilesMap.get(file);
            if (associatedFiles != null) {
                for (VirtualFile associatedFile : associatedFiles) {
                    PBXProjectFile.removeFromCountingSet(allFiles, associatedFile);
                    String path = associatedFile.getPath();
                    fileRefTree.decAssociatedFiles(path);
                }
            }
            rootToAssociatedFilesMap.remove(file);
        }
    }

    private static void addToNameToFileMap(@NotNull Map<String, List<VirtualFile>> nameToFile, @NotNull VirtualFile file) {
        if (nameToFile == null) {
            PBXProjectFile.$$$reportNull$$$0(102);
        }
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(103);
        }
        PBXProjectFile.addToListMap(nameToFile, file.getName(), file);
    }

    private static void removeFromNameToFileMap(@NotNull Map<String, List<VirtualFile>> nameToFile, @NotNull VirtualFile file) {
        if (nameToFile == null) {
            PBXProjectFile.$$$reportNull$$$0(104);
        }
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(105);
        }
        PBXProjectFile.removeFromListMap(nameToFile, file.getName(), file);
    }

    private static <T> void addToCountingSet(@NotNull Map<T, Integer> map, @NotNull T key) {
        Integer count;
        if (map == null) {
            PBXProjectFile.$$$reportNull$$$0(106);
        }
        if (key == null) {
            PBXProjectFile.$$$reportNull$$$0(107);
        }
        map.put(key, ((count = map.get(key)) == null ? 0 : count) + 1);
    }

    private static <T> void removeFromCountingSet(@NotNull Map<T, Integer> map, @NotNull T key) {
        Integer count;
        if (map == null) {
            PBXProjectFile.$$$reportNull$$$0(108);
        }
        if (key == null) {
            PBXProjectFile.$$$reportNull$$$0(109);
        }
        if ((count = map.get(key)) == null) {
            return;
        }
        if (count <= 1) {
            map.remove(key);
        } else {
            map.put(key, count - 1);
        }
    }

    private static <K, V> void addToListMap(@NotNull Map<K, List<V>> map, @NotNull K key, @NotNull V value) {
        SmartList list;
        if (map == null) {
            PBXProjectFile.$$$reportNull$$$0(110);
        }
        if (key == null) {
            PBXProjectFile.$$$reportNull$$$0(111);
        }
        if (value == null) {
            PBXProjectFile.$$$reportNull$$$0(112);
        }
        if ((list = map.get(key)) == null) {
            list = new SmartList();
            map.put(key, (List<SmartList>)list);
        }
        list.add(value);
    }

    private static <K, V> int removeFromListMap(@NotNull Map<K, List<V>> map, @NotNull K key, @NotNull V value) {
        List<V> list;
        if (map == null) {
            PBXProjectFile.$$$reportNull$$$0(113);
        }
        if (key == null) {
            PBXProjectFile.$$$reportNull$$$0(114);
        }
        if (value == null) {
            PBXProjectFile.$$$reportNull$$$0(115);
        }
        if ((list = map.get(key)) == null) {
            return 0;
        }
        list.remove(value);
        if (list.isEmpty()) {
            map.remove(key);
            return 0;
        }
        return list.size();
    }

    private static void addToPathToRefMap(@NotNull Map<Path, List<PBXReference>> pathToRefs, @NotNull PBXReference ref, @NotNull VirtualFile file) {
        if (pathToRefs == null) {
            PBXProjectFile.$$$reportNull$$$0(116);
        }
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(117);
        }
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(118);
        }
        PBXProjectFile.addToListMap(pathToRefs, file.toNioPath(), ref);
    }

    private static void addToFileToRefMap(@NotNull Map<VirtualFile, List<PBXReference>> fileToRefs, @NotNull Map<VirtualFile, Integer> allFiles, @NotNull PBXReference ref, @NotNull VirtualFile file) {
        if (fileToRefs == null) {
            PBXProjectFile.$$$reportNull$$$0(119);
        }
        if (allFiles == null) {
            PBXProjectFile.$$$reportNull$$$0(120);
        }
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(121);
        }
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(122);
        }
        PBXProjectFile.addToListMap(fileToRefs, file, ref);
        PBXProjectFile.addToCountingSet(allFiles, file);
    }

    private static boolean isAssociatedFileRoot(@NotNull PBXReference ref, @NotNull VirtualFile file) {
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(123);
        }
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(124);
        }
        return PBXProjectFile.isCoreDataModelPackage(ref, file) || ref.isDirectoryRef() || ref.isAssetCatalog();
    }

    private static boolean isCoreDataModelPackage(@NotNull PBXReference ref, @NotNull VirtualFile file) {
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(125);
        }
        if (file == null) {
            PBXProjectFile.$$$reportNull$$$0(126);
        }
        return ref instanceof PBXFileReference && file.isDirectory() && "xcdatamodel".equals(file.getExtension());
    }

    @NotNull
    private RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> getRefIdToTargetsAndConfigsMap() {
        this.initBuildFilesMap();
        RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> rWAMap = this.myBuildFilesCache.myReferenceIdToTargetsAndConfigsMap;
        if (rWAMap == null) {
            PBXProjectFile.$$$reportNull$$$0(127);
        }
        return rWAMap;
    }

    @NotNull
    private Map<PbxId, List<PBXBuildFile>> getBuildFilesMap() {
        this.initBuildFilesMap();
        RWAMap<PbxId, List<PBXBuildFile>> rWAMap = this.myBuildFilesCache.myReferenceIdToBuildFilesMap;
        if (rWAMap == null) {
            PBXProjectFile.$$$reportNull$$$0(128);
        }
        return rWAMap;
    }

    @NotNull
    private RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> getBuildFileToTargetMap() {
        this.initBuildFilesMap();
        RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> rWAMap = this.myBuildFilesCache.myBuildFileToTargetAndPhase;
        if (rWAMap == null) {
            PBXProjectFile.$$$reportNull$$$0(129);
        }
        return rWAMap;
    }

    private @NotNull RWAMap<PBXTarget, @Unmodifiable Collection<AppleFileType>> getTargetToSourceFileTypesMap() {
        this.initBuildFilesMap();
        RWAMap<PBXTarget, Collection<AppleFileType>> rWAMap = this.myBuildFilesCache.myTargetToSourceFileTypesMap;
        if (rWAMap == null) {
            PBXProjectFile.$$$reportNull$$$0(130);
        }
        return rWAMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBuildFilesMap() {
        this.myRWAChecker.checkRead();
        if (!this.myBuildFilesCache.myBuildFileCacheBuilt) {
            Object object = this.myBuildFilesCacheLock;
            synchronized (object) {
                if (!this.myBuildFilesCache.myBuildFileCacheBuilt) {
                    MultiMap buildFiles = new MultiMap();
                    for (PBXBuildFile buildFile : this.getObjects(PBXBuildFile.class)) {
                        PBXReference ref = buildFile.getFileRef();
                        if (ref == null) continue;
                        buildFiles.putValue((Object)ref, (Object)buildFile);
                    }
                    HashMap refToBuildFiles = new HashMap();
                    HashMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> refIdToTargetsAndConfigs = new HashMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>>();
                    HashMap<PBXTarget, @Unmodifiable Set<AppleFileType>> targetToSourceFileTypes = new HashMap<PBXTarget, Set<AppleFileType>>();
                    for (PBXReference reference : buildFiles.keySet()) {
                        refToBuildFiles.put(reference.getId(), new RWAList(new ArrayList(buildFiles.get((Object)reference)), (RWASupport.Checker)this.myRWAChecker));
                    }
                    HashMap<PBXBuildFile, Pair> fileToTarget = new HashMap<PBXBuildFile, Pair>();
                    for (PBXTarget pBXTarget : this.getTargets(null)) {
                        List<XCBuildConfiguration> configurations = pBXTarget.getBuildConfigurations();
                        for (PBXBuildPhase phase : pBXTarget.getBuildPhases()) {
                            for (PBXBuildFile eachFile : phase.getFiles()) {
                                PBXReference ref = eachFile.getFileRef();
                                if (ref != null) {
                                    this.addRefTarget(ref, pBXTarget, configurations, refIdToTargetsAndConfigs, false);
                                }
                                fileToTarget.put(eachFile, Pair.create((Object)((Object)pBXTarget), (Object)((Object)phase)));
                            }
                        }
                        targetToSourceFileTypes.put(pBXTarget, PBXProjectFile.getSourceFileTypes(pBXTarget));
                    }
                    for (Map.Entry entry : refIdToTargetsAndConfigs.entrySet()) {
                        entry.setValue(this.convertToRWA((Pair<List<PBXTarget>, List<XCBuildConfiguration>>)((Pair)entry.getValue())));
                    }
                    this.myBuildFilesCache.myReferenceIdToBuildFilesMap = new RWAMap(refToBuildFiles, this.myRWAChecker);
                    this.myBuildFilesCache.myReferenceIdToTargetsAndConfigsMap = new RWAMap(refIdToTargetsAndConfigs, this.myRWAChecker);
                    this.myBuildFilesCache.myBuildFileToTargetAndPhase = new RWAMap(fileToTarget, this.myRWAChecker);
                    this.myBuildFilesCache.myTargetToSourceFileTypesMap = new RWAMap(targetToSourceFileTypes, this.myRWAChecker);
                    this.myBuildFilesCache.myBuildFileCacheBuilt = true;
                }
            }
        }
    }

    @NotNull
    private static @Unmodifiable Set<AppleFileType> getSourceFileTypes(@NotNull PBXTarget target) {
        if (target == null) {
            PBXProjectFile.$$$reportNull$$$0(131);
        }
        Set set = ContainerUtil.map2SetNotNull(target.getSources(), reference -> AppleFileTypeManager.getInstance().findFileTypeByFilename(reference.getFileName()));
        if (set == null) {
            PBXProjectFile.$$$reportNull$$$0(132);
        }
        return set;
    }

    private void addRefTarget(@NotNull PBXReference ref, @NotNull PBXTarget target, @NotNull List<XCBuildConfiguration> configurations, @NotNull Map<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> cache, boolean rwa) {
        Pair pair;
        if (ref == null) {
            PBXProjectFile.$$$reportNull$$$0(133);
        }
        if (target == null) {
            PBXProjectFile.$$$reportNull$$$0(134);
        }
        if (configurations == null) {
            PBXProjectFile.$$$reportNull$$$0(135);
        }
        if (cache == null) {
            PBXProjectFile.$$$reportNull$$$0(136);
        }
        if ((pair = cache.get(ref.getId())) == null) {
            Object targets = new SmartList();
            List allConfigurations = new ArrayList(configurations.size());
            if (rwa) {
                targets = new RWAList(targets, (RWASupport.Checker)this.myRWAChecker);
                allConfigurations = new RWAList(allConfigurations, (RWASupport.Checker)this.myRWAChecker);
            }
            pair = Pair.create((Object)targets, allConfigurations);
            cache.put(ref.getId(), (Pair<List<PBXTarget>, List<XCBuildConfiguration>>)pair);
        }
        ((List)pair.first).add(target);
        ((List)pair.second).addAll(configurations);
    }

    private Pair<List<PBXTarget>, List<XCBuildConfiguration>> convertToRWA(Pair<List<PBXTarget>, List<XCBuildConfiguration>> from) {
        return new Pair(new RWAList((List)from.first, (RWASupport.Checker)this.myRWAChecker), new RWAList((List)from.second, (RWASupport.Checker)this.myRWAChecker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    @NotNull
    public List<PBXProjectFile> getDirectlyLinkedProjects() {
        this.myRWAChecker.checkRead();
        Object object = this.myCacheLock;
        // MONITORENTER : object
        ImmutableList directlyLinkedProjects = this.myCache.myDirectlyLinkedProjects;
        ImmutableList immutableList = directlyLinkedProjects != null ? directlyLinkedProjects : (this.myCache.myDirectlyLinkedProjects = ImmutableList.copyOf(this.collectDirectlyLinkedProjects()));
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        PBXProjectFile.$$$reportNull$$$0(137);
        return immutableList;
    }

    @NotNull
    private Set<PBXProjectFile> collectDirectlyLinkedProjects() {
        CoreXcodeWorkspace workspace = CoreXcodeWorkspace.getInstance(this.getProject());
        if (workspace == null) {
            Set<PBXProjectFile> set = Collections.emptySet();
            if (set == null) {
                PBXProjectFile.$$$reportNull$$$0(138);
            }
            return set;
        }
        LinkedHashSet<PBXProjectFile> directlyLinkedProjects = new LinkedHashSet<PBXProjectFile>();
        for (Pair<VirtualFile, String> each : this.getDirectlyLinkedProjectFilesWithPaths()) {
            ContainerUtil.addIfNotNull(directlyLinkedProjects, (Object)workspace.findProject((VirtualFile)each.first));
        }
        LinkedHashSet<PBXProjectFile> linkedHashSet = directlyLinkedProjects;
        if (linkedHashSet == null) {
            PBXProjectFile.$$$reportNull$$$0(139);
        }
        return linkedHashSet;
    }

    @NotNull
    public List<Pair<VirtualFile, String>> getDirectlyLinkedProjectFilesWithPaths() {
        LinkedHashSet result = new LinkedHashSet();
        for (PBXReference pBXReference : this.getObjects(PBXFileReference.class)) {
            VirtualFile file;
            String path;
            if (!pBXReference.isLinkedProject() || (path = (file = pBXReference.findFile(this.getBuildSettingsProvider())) != null ? file.getPath() : pBXReference.resolvePath(this.getBuildSettingsProvider())) == null) continue;
            ContainerUtil.addIfNotNull(result, (Object)Pair.create((Object)file, (Object)path));
        }
        List<Pair<VirtualFile, String>> list = Collections.unmodifiableList(new SmartList(result));
        if (list == null) {
            PBXProjectFile.$$$reportNull$$$0(140);
        }
        return list;
    }

    @Nullable
    public PBXGroup findGroupByName(@Nullable @NonNls String name) {
        return PBXProjectFile.findGroupByName(name, this.getProjectObject().getMainGroup());
    }

    @Nullable
    private static PBXGroup findGroupByName(@Nullable String name, @Nullable PBXGroup from) {
        if (name == null || from == null) {
            return null;
        }
        if (name.equals(from.getDisplayName())) {
            return from;
        }
        for (PBXReference each : from.getChildren()) {
            PBXGroup group;
            if (!(each instanceof PBXGroup) || (group = PBXProjectFile.findGroupByName(name, (PBXGroup)each)) == null) continue;
            return group;
        }
        return null;
    }

    @Nullable
    public PBXGroup findGroupByPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        File baseDir = new File(this.getBaseDir().getPath());
        do {
            PBXGroup result;
            if ((result = PBXProjectFile.doFindGroupByPath(file.getPath(), this.getProjectObject().getMainGroup())) == null) continue;
            return result;
        } while ((file = file.getParentFile()) != null && VfsUtilCore.isAncestor((File)baseDir, (File)file, (boolean)true));
        return null;
    }

    @Nullable
    private static PBXGroup doFindGroupByPath(@Nullable String path, @Nullable PBXGroup from) {
        String groupPath;
        if (path == null || from == null) {
            return null;
        }
        if (from.isPhysical() && (groupPath = from.resolvePath()) != null && FileUtil.pathsEqual((String)groupPath, (String)path)) {
            return from;
        }
        for (PBXReference each : from.getChildren()) {
            PBXGroup result;
            if (!(each instanceof PBXGroup) || (result = PBXProjectFile.doFindGroupByPath(path, (PBXGroup)each)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    PBXGroup resolveParentObject(@Nullable PBXReference object) {
        return object == null ? null : this.getParentsMap().get((Object)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<PBXReference, PBXGroup> getParentsMap() {
        this.myRWAChecker.checkRead();
        if (this.myCache.myReferenceToParentGroupMap == null) {
            Object object = this.myCacheLock;
            synchronized (object) {
                if (this.myCache.myReferenceToParentGroupMap == null) {
                    HashMap<PBXReference, PBXGroup> parentsMap = new HashMap<PBXReference, PBXGroup>();
                    for (PBXGroup group : this.getObjects(PBXGroup.class)) {
                        for (PBXReference child : group.getChildren()) {
                            parentsMap.put(child, group);
                        }
                    }
                    this.myCache.myReferenceToParentGroupMap = new RWAMap(parentsMap, this.myRWAChecker);
                }
            }
        }
        RWAMap<PBXReference, PBXGroup> rWAMap = this.myCache.myReferenceToParentGroupMap;
        if (rWAMap == null) {
            PBXProjectFile.$$$reportNull$$$0(141);
        }
        return rWAMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetReferencesCache() {
        Object object = this.myCacheLock;
        synchronized (object) {
            Object object2 = this.myBuildFilesCacheLock;
            synchronized (object2) {
                this.myCache = new ReferencesCache();
                this.myBuildFilesCache = new BuildFilesCache();
            }
        }
    }

    public boolean isModified() {
        this.myRWAChecker.checkRead();
        return this.myRWAChecker.isModified() || this.myUserFile.isModified();
    }

    public void save() throws IOException {
        this.save(false);
    }

    public boolean ensureProjectFileWritableIfNeeded(boolean alsoSaveIfNotModified) {
        if (alsoSaveIfNotModified || this.myRWAChecker.isModified()) {
            CoreXcodeWorkspace workspace = CoreXcodeWorkspace.getInstance(this.myProject);
            return workspace != null ? workspace.ensureFilesWritable(this.myPBXProjFile) : this.myPBXProjFile.isWritable();
        }
        return true;
    }

    @Nullable
    public SavingContext prepareForSaving(boolean alsoSaveIfNotModified) throws IOException {
        this.myRWAChecker.checkRead();
        this.myRWAChecker.assertLocked();
        if (alsoSaveIfNotModified || this.myRWAChecker.isModified()) {
            if (!this.myPBXProjFile.isWritable()) {
                throw new IOException("File is read-only");
            }
            String text = this.buildFileText();
            long lastModified = VfsUtilCore.virtualToIoFile((VirtualFile)this.myPBXProjFile).lastModified();
            return new SavingContext(text, this.myPBXProjFile.getCharset(), lastModified);
        }
        return null;
    }

    public void doSaveProject(@NotNull SavingContext context) throws IOException {
        if (context == null) {
            PBXProjectFile.$$$reportNull$$$0(142);
        }
        String text = context.text;
        long lastModified = context.lastModified;
        this.myPBXProjFile.setBinaryContent(text.getBytes(context.charset), -1L, System.currentTimeMillis() - lastModified < 1000L ? lastModified + 1000L : -1L);
        this.myRWAChecker.resetModified();
    }

    public void save(boolean alsoSaveIfNotModified) throws IOException {
        this.ensureProjectFileWritableIfNeeded(alsoSaveIfNotModified);
        SavingContext context = (SavingContext)ReadAction.compute(() -> this.prepareForSaving(alsoSaveIfNotModified));
        if (context != null) {
            WriteAction.runAndWait(() -> this.doSaveProject(context));
        }
    }

    public String buildFileText() {
        PbxWriter writer = new PbxWriter();
        writer.write(this);
        return writer.getResult();
    }

    public String toString() {
        return this.getName();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            PBXProjectFile.$$$reportNull$$$0(143);
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            PBXProjectFile.$$$reportNull$$$0(144);
        }
        this.myDataHolder.putUserData(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            PBXProjectFile.$$$reportNull$$$0(145);
        }
        return this.myDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            PBXProjectFile.$$$reportNull$$$0(146);
        }
        if (value == null) {
            PBXProjectFile.$$$reportNull$$$0(147);
        }
        Object object = this.myDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            PBXProjectFile.$$$reportNull$$$0(148);
        }
        return (T)object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 49, 50, 51, 52, 53, 55, 56, 57, 58, 60, 61, 62, 63, 64, 127, 128, 129, 130, 132, 137, 138, 139, 140, 141, 148 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoot";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pbxprojFile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProjectFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 39: 
            case 65: 
            case 89: 
            case 90: 
            case 96: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 41: 
            case 131: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedRefIds";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedObjectIds";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productFileRef";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRefsCache";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFileRefsCache";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSwiftPackageRefs";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSwiftPackageRefs";
                break;
            }
            case 70: 
            case 80: 
            case 92: 
            case 98: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refToCacheEntryCache";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToRefsCache";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRefsCache";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToFileCache";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocFilesMapCache";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocFileRootsCache";
                break;
            }
            case 77: 
            case 95: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRefTree";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "synchronizedRootsTree";
                break;
            }
            case 79: 
            case 102: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToFile";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToTargetMap";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetToFilesMap";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCompilerArgumentsMap";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owningTargets";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPaths";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reassignedPaths";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerArgumentsMap";
                break;
            }
            case 91: 
            case 97: 
            case 103: 
            case 105: 
            case 118: 
            case 122: 
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 93: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associatedRootMap";
                break;
            }
            case 94: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootToAssociatedFilesMap";
                break;
            }
            case 106: 
            case 108: 
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 107: 
            case 109: 
            case 111: 
            case 114: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 112: 
            case 115: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToRefs";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRefs";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRWAChecker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBuildSettingsValues";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBaseDir";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getManipulator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettingsProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectObject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadableRootFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadableDataFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPBXProjFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeProjFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDir";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeProjFileName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDataDir";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedDataDir";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFile";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNextId";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsReferencing";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByName";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsFor";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "selectTargets";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargetsFor";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFilesFor";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToReferencesMap";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToReferencesMap";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToFilesMap";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefIdToTargetsAndConfigsMap";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFilesMap";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFileToTargetMap";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetToSourceFileTypesMap";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileTypes";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectlyLinkedProjects";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDirectlyLinkedProjects";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectlyLinkedProjectFilesWithPaths";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentsMap";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 148: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseInTests";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parsePbxProjectContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isXCSwiftPackageProductDependency";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setProjectObject";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addObject";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resetTargetConfigCachesOnChange";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateBuildFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeObjects";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveObject";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveBuildFilesForReferences";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findTargetForProduct";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addRefToCaches";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "processSynchronizedRoots";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "buildExclusionAndReassignmentMaps";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "removeRefFromCaches";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "handleAssociatedRootAddition";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "handleAssociatedRootRemoval";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "addToNameToFileMap";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "removeFromNameToFileMap";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "addToCountingSet";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "removeFromCountingSet";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "addToListMap";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "removeFromListMap";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "addToPathToRefMap";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "addToFileToRefMap";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedFileRoot";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isCoreDataModelPackage";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileTypes";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "addRefTarget";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "doSaveProject";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 49, 50, 51, 52, 53, 55, 56, 57, 58, 60, 61, 62, 63, 64, 127, 128, 129, 130, 132, 137, 138, 139, 140, 141, 148 -> new IllegalStateException(string);
        };
    }

    private static final class ReferencesCache {
        @Nullable
        private volatile RWAMap<PBXReference, PBXGroup> myReferenceToParentGroupMap = null;
        private volatile boolean myFileCachesBuilt;
        @Nullable
        private volatile RWASet<PBXReference> myReferences = null;
        @Nullable
        private volatile RWASet<PBXFileReference> myFileReferences = null;
        @Nullable
        private volatile RWASet<XCLocalSwiftPackageReference> myLocalSwiftPackageReferences = null;
        @Nullable
        private volatile RWASet<XCRemoteSwiftPackageReference> myRemoteSwiftPackageReferences = null;
        @Nullable
        private volatile MostlySingularMultiMap<XCBuildConfiguration, PBXTarget> myConfigToTargetMap;
        @Nullable
        private volatile MostlySingularMultiMap<String, PBXTarget> myNameToTargetMap;
        @Nullable
        private volatile RWAMap<PBXReference, ReferenceCacheEntry> myReferenceToCacheEntryMap = null;
        @Nullable
        private volatile RWAMap<Path, List<PBXReference>> myPathToReferencesMap = null;
        @Nullable
        private volatile RWAMap<VirtualFile, List<PBXReference>> myFileToReferencesMap = null;
        @Nullable
        private volatile RWAMap<String, List<VirtualFile>> myFileNameToFileMap = null;
        @Nullable
        private volatile RWAMap<VirtualFile, Integer> myAllProjectFiles = null;
        @Nullable
        private volatile RWAMap<VirtualFile, Collection<VirtualFile>> myFileToAssociatedFilesMap;
        @Nullable
        private volatile RWAMap<VirtualFile, List<PBXReference>> myFileToAssociatedRootMap;
        @Nullable
        private volatile FileRefTree myFileRefTree;
        @Nullable
        private volatile SynchronizedRootsTree mySynchronizedRootsTree;
        @Nullable
        private volatile Map<VirtualFile, List<PBXTarget>> mySynchronizedFileToTargetsMap = null;
        @Nullable
        private volatile Map<VirtualFile, List<Pair<PBXTarget, String>>> mySynchronizedFileToCompilerArgumentsMap = null;
        @Nullable
        private volatile Map<PBXTarget, List<VirtualFile>> myTargetToSynchronizedFilesMap = null;
        @Nullable
        private List<PBXProjectFile> myDirectlyLinkedProjects = null;

        private ReferencesCache() {
        }
    }

    private static final class BuildFilesCache {
        private volatile boolean myBuildFileCacheBuilt;
        @Nullable
        private volatile RWAMap<PbxId, List<PBXBuildFile>> myReferenceIdToBuildFilesMap;
        @Nullable
        private volatile RWAMap<PbxId, Pair<List<PBXTarget>, List<XCBuildConfiguration>>> myReferenceIdToTargetsAndConfigsMap;
        @Nullable
        private volatile RWAMap<PBXBuildFile, Pair<PBXTarget, PBXBuildPhase>> myBuildFileToTargetAndPhase;
        @Nullable
        private volatile RWAMap<PBXTarget, Collection<AppleFileType>> myTargetToSourceFileTypesMap;

        private BuildFilesCache() {
        }
    }

    private static class MyCacheModificationTracker
    extends SimpleModificationTracker {
        private boolean myIsDisabled = false;

        private MyCacheModificationTracker() {
        }

        public void setDisabled(boolean disabled) {
            XCLog.LOG.assertTrue(!this.myIsDisabled || !disabled, (Object)"Caching is already disabled");
            this.myIsDisabled = disabled;
        }

        public long getModificationCount() {
            if (this.myIsDisabled) {
                this.incModificationCount();
            }
            return super.getModificationCount();
        }
    }

    private static class ReferenceCacheEntry {
        @Nullable
        VirtualFile file;
        @Nullable
        String path;

        ReferenceCacheEntry(@Nullable VirtualFile file, @Nullable String path) {
            this.file = file;
            this.path = path;
        }
    }

    public static class SavingContext {
        @NotNull
        String text;
        @NotNull
        Charset charset;
        long lastModified;

        SavingContext(@NotNull String text, @NotNull Charset charset, long lastModified) {
            if (text == null) {
                SavingContext.$$$reportNull$$$0(0);
            }
            if (charset == null) {
                SavingContext.$$$reportNull$$$0(1);
            }
            this.text = text;
            this.charset = charset;
            this.lastModified = lastModified;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/xcode/model/PBXProjectFile$SavingContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

