/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXGroup;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCConfigurationList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXProject
extends PBXObject {
    public PBXProject(PBXProjectFile file) {
        super(file);
    }

    @Override
    public String getComment() {
        return "Project object";
    }

    @Nullable
    public PBXGroup getMainGroup() {
        return this.resolveAttribute("mainGroup", PBXGroup.class);
    }

    @NotNull
    public XCConfigurationList getBuildConfigurationList() {
        XCConfigurationList xCConfigurationList = this.resolveNotNullAttribute("buildConfigurationList", XCConfigurationList.class);
        if (xCConfigurationList == null) {
            PBXProject.$$$reportNull$$$0(0);
        }
        return xCConfigurationList;
    }

    @NotNull
    public List<XCBuildConfiguration> getBuildConfigurations() {
        List<XCBuildConfiguration> list = this.getBuildConfigurationList().getConfigurations();
        if (list == null) {
            PBXProject.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public XCBuildConfiguration findBuildConfiguration(@Nullable String name) {
        return this.getBuildConfigurationList().findConfiguration(name);
    }

    @NotNull
    public List<PBXTarget> getTargets() {
        List<PBXTarget> list = this.resolveAttributeList("targets", PBXTarget.class);
        if (list == null) {
            PBXProject.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Dictionary getUserBuildSettings() {
        PBXObject ex = this.getUserExtension();
        Dictionary dictionary = ex == null ? Dictionary.EMPTY_DICTIONARY : ex.getDictionary("userBuildSettings", Dictionary.EMPTY_DICTIONARY);
        if (dictionary == null) {
            PBXProject.$$$reportNull$$$0(3);
        }
        return dictionary;
    }

    @Nullable
    public String getOrganizationName() {
        return this.getProjectAttributes().tryGetString("ORGANIZATIONNAME");
    }

    public void setOrganizationName(@Nullable String organizationName) {
        this.setProjectAttribute("ORGANIZATIONNAME", organizationName);
    }

    @Nullable
    public String getClassPrefix() {
        return this.getProjectAttributes().tryGetString("CLASSPREFIX");
    }

    public void setClassPrefix(@Nullable String prefix) {
        this.setProjectAttribute("CLASSPREFIX", prefix);
    }

    @NotNull
    private Dictionary getProjectAttributes() {
        Dictionary dictionary = this.getDictionary("attributes", Dictionary.EMPTY_DICTIONARY);
        if (dictionary == null) {
            PBXProject.$$$reportNull$$$0(4);
        }
        return dictionary;
    }

    private void setProjectAttribute(@NotNull String attribute, @Nullable Object value) {
        if (attribute == null) {
            PBXProject.$$$reportNull$$$0(5);
        }
        Dictionary attributes = this.getDictionary("attributes", new PBXDictionary(this.getFile()));
        attributes.setAttribute(attribute, value);
        this.setAttribute("attributes", attributes.isEmpty() ? null : attributes);
    }

    @Nullable
    private PBXDictionary getAllTargetAttributes() {
        return (PBXDictionary)((Object)this.getProjectAttributes().getAttribute("TargetAttributes", PBXDictionary.class));
    }

    @Nullable
    PBXDictionary getTargetAttributes(@NotNull PBXTarget target) {
        PBXDictionary targetAttributes;
        if (target == null) {
            PBXProject.$$$reportNull$$$0(6);
        }
        return (targetAttributes = this.getAllTargetAttributes()) != null ? (PBXDictionary)((Object)targetAttributes.getAttribute(target.getId().asString(), PBXDictionary.class)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXProject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurationList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserBuildSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectAttributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProjectAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

