/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.jetbrains.cidr.xcode.model.PBXDictionary;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import com.jetbrains.cidr.xcode.pbxproj.PbxWriter;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXObject
extends PBXDictionary {
    public static final Comparator<PBXObject> ID_COMPARATOR = (o1, o2) -> PbxId.COMPARATOR.compare(o1 == null ? null : o1.getId(), o2 == null ? null : o2.getId());
    @NotNull
    private final PBXProjectFile myFile;
    @NotNull
    private volatile PbxId myId;
    private int hashCodeCache;

    public PBXObject(@NotNull PBXProjectFile file) {
        if (file == null) {
            PBXObject.$$$reportNull$$$0(0);
        }
        super(file);
        this.myId = PbxId.NONE;
        this.hashCodeCache = -1;
        this.myFile = file;
        Class<?> aClass = ((Object)((Object)this)).getClass();
        if (aClass != PBXObject.class) {
            this.setAttribute("isa", aClass.getSimpleName());
        }
    }

    @NotNull
    public PBXProjectFile getFile() {
        PBXProjectFile pBXProjectFile = this.myFile;
        if (pBXProjectFile == null) {
            PBXObject.$$$reportNull$$$0(1);
        }
        return pBXProjectFile;
    }

    @Nullable
    public String getKind() {
        return PBXObject.getKind(this);
    }

    @Nullable
    public static String getKind(@Nullable PBXDictionary dict) {
        return dict == null ? null : (String)dict.getAttribute("isa", String.class);
    }

    @NotNull
    public PbxId getId() {
        PbxId pbxId = this.myId;
        if (pbxId == null) {
            PBXObject.$$$reportNull$$$0(2);
        }
        return pbxId;
    }

    public void setId(@NotNull PbxId id) {
        if (id == null) {
            PBXObject.$$$reportNull$$$0(3);
        }
        this.myId = id;
    }

    @Nullable
    @NonNls
    public String getComment() {
        String result = this.getString("name", null);
        if (result == null) {
            result = this.getString("isa", null);
        }
        return result;
    }

    @NotNull
    public ObjectReference createReference() {
        return new ObjectReference(this.myId, this.myFile);
    }

    public boolean accept(@NotNull PbxObjectVisitor visitor) {
        if (visitor == null) {
            PBXObject.$$$reportNull$$$0(4);
        }
        return visitor.visitObject(this);
    }

    @Nullable
    public PBXObject getUserExtension() {
        return this.myFile.getUserFile().findExtensionFor(this);
    }

    public String toString() {
        return this.getDebugString();
    }

    @NotNull
    public String getDebugString() {
        PbxWriter w = new PbxWriter();
        w.writeObject(this, true);
        String string = w.getResult();
        if (string == null) {
            PBXObject.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.hashCodeCache == -1 ? (this.hashCodeCache = System.identityHashCode((Object)this)) : this.hashCodeCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }
}

