/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.xcode.frameworks.ApplePackageType;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleProductType;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXNativeTarget
extends PBXTarget
implements UserDataHolderEx {
    @NotNull
    private final UserDataHolderEx myDataHolder = new UserDataHolderBase();

    public PBXNativeTarget(PBXProjectFile file) {
        super(file);
    }

    @Nullable
    public AppleProductType getProductType(@Nullable ApplePlatform platform) {
        return platform == null ? null : platform.findProductType(this.getProductTypeId());
    }

    @Nullable
    public ApplePackageType getPackageType(@Nullable ApplePlatform platform) {
        AppleProductType productType = this.getProductType(platform);
        return productType == null ? null : productType.getDefaultPackageType();
    }

    @Nullable
    public String getProductTypeId() {
        return (String)this.getAttribute("productType", String.class);
    }

    @Nullable
    public PBXFileReference getProductReference() {
        return this.resolveAttribute("productReference", PBXFileReference.class);
    }

    @Override
    public boolean isExecutable() {
        return this.isTool() || this.isApplication();
    }

    @Override
    public boolean isTool() {
        String id = this.getProductTypeId();
        return id != null && id.startsWith("com.apple.product-type.tool");
    }

    @Override
    public boolean isApplication() {
        String id = this.getProductTypeId();
        return id != null && id.startsWith("com.apple.product-type.application");
    }

    @Override
    public boolean isApplicationExtension() {
        String id = this.getProductTypeId();
        return id != null && (id.startsWith("com.apple.product-type.app-extension") || id.startsWith("com.apple.product-type.tv-app-extension"));
    }

    @Override
    public boolean isFramework() {
        String id = this.getProductTypeId();
        return id != null && id.startsWith("com.apple.product-type.framework");
    }

    @Override
    public boolean isStaticLibrary() {
        return "com.apple.product-type.library.static".equals(this.getProductTypeId());
    }

    @Override
    public boolean isXCTestTests() {
        if ("com.apple.product-type.bundle.unit-test".equals(this.getProductTypeId())) {
            return true;
        }
        if (!"com.apple.product-type.bundle".equals(this.getProductTypeId())) {
            return false;
        }
        PBXFileReference productRef = this.getProductReference();
        return productRef != null && productRef.getDisplayName().endsWith(".xctest");
    }

    @Override
    public boolean isXCUITestTests() {
        return "com.apple.product-type.bundle.ui-testing".equals(this.getProductTypeId());
    }

    @Override
    @Nullable
    public AppleBuildSystem.Type getBuildSystem() {
        return AppleBuildSystem.Type.NATIVE;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            PBXNativeTarget.$$$reportNull$$$0(0);
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            PBXNativeTarget.$$$reportNull$$$0(1);
        }
        this.myDataHolder.putUserData(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            PBXNativeTarget.$$$reportNull$$$0(2);
        }
        return this.myDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            PBXNativeTarget.$$$reportNull$$$0(3);
        }
        if (value == null) {
            PBXNativeTarget.$$$reportNull$$$0(4);
        }
        Object object = this.myDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            PBXNativeTarget.$$$reportNull$$$0(5);
        }
        return (T)object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXNativeTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXNativeTarget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

