/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.Processor;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PbxGroupPsiElement;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXGroup
extends PBXReference {
    private PbxGroupPsiElement myGroupPsiElement;

    public PBXGroup(PBXProjectFile file) {
        super(file);
    }

    @NotNull
    public List<PBXReference> getChildren() {
        List<PBXReference> list = this.resolveAttributeList("children", PBXReference.class);
        if (list == null) {
            PBXGroup.$$$reportNull$$$0(0);
        }
        return list;
    }

    public boolean processWithChildren(Processor<PBXReference> processor) {
        for (PBXReference reference : this.getChildren()) {
            if (!(reference instanceof PBXGroup ? !((PBXGroup)reference).processWithChildren(processor) : !processor.process((Object)reference))) continue;
            return false;
        }
        return processor.process((Object)this);
    }

    protected void appendChild(@NotNull ObjectReference reference) {
        if (reference == null) {
            PBXGroup.$$$reportNull$$$0(1);
        }
        this.addToAttributeList("children", reference);
    }

    @Override
    public boolean accept(@NotNull PbxObjectVisitor visitor) {
        if (visitor == null) {
            PBXGroup.$$$reportNull$$$0(2);
        }
        return visitor.visitGroup(this);
    }

    public boolean isSynchronizedRootGroup() {
        return false;
    }

    @Override
    public String toString() {
        String comment = this.getComment();
        return comment == null ? "<group>" : comment;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        PBXProjectFile projectFile = this.getFile();
        String string = this.isMainGroup() ? projectFile.getName() : super.getDisplayName();
        if (string == null) {
            PBXGroup.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isMainGroup() {
        PBXProjectFile projectFile = this.getFile();
        return this.equals((Object)projectFile.getProjectObject().getMainGroup());
    }

    @Override
    public PsiFileSystemItem findPsiElement() {
        return this.getGroupPsiElement();
    }

    public PbxGroupPsiElement getGroupPsiElement() {
        if (this.myGroupPsiElement == null) {
            this.myGroupPsiElement = new PbxGroupPsiElement(this);
        }
        return this.myGroupPsiElement;
    }

    @Nullable
    public PsiDirectory getDirectoryPsiElement() {
        PsiFileSystemItem result = this.findPsiElementFromVirtualFile();
        return result instanceof PsiDirectory ? (PsiDirectory)result : null;
    }

    @Override
    public boolean isVirtual() {
        if (this.isMainGroup() || this.isSynchronizedRootGroup()) {
            return false;
        }
        PBXGroup parent = this.getParent();
        return this.getPath() == null || parent != null && ((PBXReference)parent).isVirtual();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendChild";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

