/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.RWAMap;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PBXDictionary
extends Dictionary {
    public PBXDictionary(@NotNull PBXProjectFile file) {
        if (file == null) {
            PBXDictionary.$$$reportNull$$$0(0);
        }
        super(() -> new RWAMap(file.getRWAChecker()));
    }

    protected boolean isValidAttribute(@Nullable Object value) {
        return value == null || value instanceof String || value instanceof ObjectReference || value instanceof List || value instanceof PBXDictionary;
    }

    @Nullable
    public Object get(@NotNull Object key) {
        Object result;
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(1);
        }
        if ((result = super.get(key)) instanceof List) {
            return Collections.unmodifiableList((List)result);
        }
        return result;
    }

    @NotNull
    public <T> List<T> getAttributeListForModification(@NotNull @NonNls String key, @Nullable Class<T> clazz) {
        ArrayList result;
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(2);
        }
        ArrayList arrayList = (result = this.getNullableAttributeListForModification(key, clazz)) == null ? new ArrayList() : result;
        if (arrayList == null) {
            PBXDictionary.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public <T> List<T> getNullableAttributeListForModification(@NotNull @NonNls String key, @Nullable Class<T> clazz) {
        List result;
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(4);
        }
        return (result = this.getAttributeList(key, clazz, null)) == null ? null : (result instanceof ArrayList ? result : new ArrayList(result));
    }

    public <T> void addToAttributeList(@NotNull @NonNls String key, @NotNull T value) {
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(5);
        }
        if (value == null) {
            PBXDictionary.$$$reportNull$$$0(6);
        }
        this.checkAttribute(value);
        List<T> list = this.getAttributeListForModification(key, null);
        list.add(value);
        this.setAttribute(key, list, false);
    }

    public <T> void addToAttributeList(@NotNull @NonNls String key, @NotNull T value, int index) {
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(7);
        }
        if (value == null) {
            PBXDictionary.$$$reportNull$$$0(8);
        }
        this.checkAttribute(value);
        List<T> list = this.getAttributeListForModification(key, null);
        list.add(index, value);
        this.setAttribute(key, list, false);
    }

    public <T> void removeFromAttributeList(@NotNull @NonNls String key, @NotNull T value) {
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(9);
        }
        if (value == null) {
            PBXDictionary.$$$reportNull$$$0(10);
        }
        this.removeAllFromAttributeList(key, Collections.singleton(value));
    }

    public <T> void removeAllFromAttributeList(@NotNull @NonNls String key, @NotNull Collection<T> values) {
        List<T> list;
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(11);
        }
        if (values == null) {
            PBXDictionary.$$$reportNull$$$0(12);
        }
        if ((list = this.getNullableAttributeListForModification(key, null)) == null) {
            return;
        }
        list.removeAll(values);
        this.setAttribute(key, list, false);
    }

    public <T> void removeFromAttributeList(@NotNull @NonNls String key, @Nullable Class<T> clazz, @NotNull Condition<T> condition) {
        List<T> list;
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(13);
        }
        if (condition == null) {
            PBXDictionary.$$$reportNull$$$0(14);
        }
        if ((list = this.getNullableAttributeListForModification(key, null)) == null) {
            return;
        }
        boolean changed = false;
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (clazz != null && !clazz.isInstance(next) || !condition.value(next)) continue;
            iterator.remove();
            changed = true;
        }
        if (changed) {
            this.setAttribute(key, list, false);
        }
    }

    @Nullable
    public <T extends PBXObject> T resolveAttribute(@NotNull @NonNls String key, @Nullable Class<T> clazz) {
        Object ref;
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(15);
        }
        if ((ref = this.getAttribute(key, null)) == null || ref instanceof String) {
            return null;
        }
        ObjectReference objectReference = (ObjectReference)this.checked(ref, ObjectReference.class);
        return (T)((Object)(objectReference == null ? null : (PBXObject)((Object)this.checked((Object)objectReference.resolveObject(), clazz))));
    }

    @NotNull
    public <T extends PBXObject> T resolveNotNullAttribute(@NotNull @NonNls String key, @Nullable Class<T> clazz) {
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(16);
        }
        PBXObject pBXObject = (PBXObject)((Object)this.notNull(key, this.resolveAttribute(key, clazz)));
        if (pBXObject == null) {
            PBXDictionary.$$$reportNull$$$0(17);
        }
        return (T)((Object)pBXObject);
    }

    @NotNull
    public <T extends PBXObject> @Unmodifiable List<T> resolveAttributeList(@NotNull @NonNls String key, @Nullable Class<T> clazz) {
        List refs;
        if (key == null) {
            PBXDictionary.$$$reportNull$$$0(18);
        }
        if ((refs = this.getAttributeList(key, null, null)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PBXDictionary.$$$reportNull$$$0(19);
            }
            return list;
        }
        ArrayList<PBXObject> result = new ArrayList<PBXObject>(refs.size());
        for (Object each : refs) {
            ObjectReference objectReference;
            PBXObject resolved;
            if (each instanceof String || (resolved = (objectReference = (ObjectReference)this.checked(each, ObjectReference.class)) == null ? null : (PBXObject)((Object)this.checked((Object)objectReference.resolveObject(), clazz))) == null) continue;
            result.add(resolved);
        }
        List list = Collections.unmodifiableList(result);
        if (list == null) {
            PBXDictionary.$$$reportNull$$$0(20);
        }
        return list;
    }

    public void convertReferences(@NotNull Collection<PbxId> ids, @NotNull Function<PbxId, PbxId> converter) {
        if (ids == null) {
            PBXDictionary.$$$reportNull$$$0(21);
        }
        if (converter == null) {
            PBXDictionary.$$$reportNull$$$0(22);
        }
        if (ids.isEmpty()) {
            return;
        }
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry eachEntry = (Map.Entry)it.next();
            Object each = eachEntry.getValue();
            if (each instanceof ObjectReference && ids.contains(((ObjectReference)each).getId())) {
                PbxId converted = (PbxId)converter.fun((Object)((ObjectReference)each).getId());
                if (converted == null) {
                    it.remove();
                    continue;
                }
                eachEntry.setValue(new ObjectReference(converted, ((ObjectReference)each).getFile()));
                continue;
            }
            if (each instanceof List) {
                List modified = PBXDictionary.convertReferencesFromList((List)each, ids, converter);
                if (modified == null) continue;
                eachEntry.setValue(modified);
                continue;
            }
            if (!(each instanceof PBXObject)) continue;
            ((PBXObject)((Object)each)).convertReferences(ids, converter);
        }
    }

    @Nullable
    private static List convertReferencesFromList(List list, @NotNull Collection<PbxId> ids, @NotNull Function<PbxId, PbxId> converter) {
        if (ids == null) {
            PBXDictionary.$$$reportNull$$$0(23);
        }
        if (converter == null) {
            PBXDictionary.$$$reportNull$$$0(24);
        }
        ListIterator<Object> it = list.listIterator();
        ArrayList modified = null;
        while (it.hasNext()) {
            Object each = it.next();
            if (each instanceof ObjectReference && ids.contains(((ObjectReference)each).getId())) {
                PbxId converted;
                if (modified == null) {
                    modified = new ArrayList(list);
                    it = modified.listIterator(it.previousIndex());
                    it.next();
                }
                if ((converted = (PbxId)converter.fun((Object)((ObjectReference)each).getId())) == null) {
                    it.remove();
                    continue;
                }
                it.set(new ObjectReference(converted, ((ObjectReference)each).getFile()));
                continue;
            }
            if (each instanceof List) {
                List removed = PBXDictionary.convertReferencesFromList((List)each, ids, converter);
                if (removed == null) continue;
                if (modified == null) {
                    modified = new ArrayList(list);
                    it = modified.listIterator(it.previousIndex());
                    it.next();
                }
                it.set(removed);
                continue;
            }
            if (!(each instanceof PBXObject)) continue;
            ((PBXObject)((Object)each)).convertReferences(ids, converter);
        }
        return modified;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 17, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXDictionary";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXDictionary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeListForModification";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNotNullAttribute";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAttributeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeListForModification";
                break;
            }
            case 3: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNullableAttributeListForModification";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToAttributeList";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeFromAttributeList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeAllFromAttributeList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveAttribute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveNotNullAttribute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveAttributeList";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertReferences";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "convertReferencesFromList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 17, 19, 20 -> new IllegalStateException(string);
        };
    }
}

