/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.PBXContainerItem;
import com.jetbrains.cidr.xcode.model.PBXFileReference;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXContainerItemProxy
extends PBXContainerItem {
    public PBXContainerItemProxy(PBXProjectFile file) {
        super(file);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = (String)this.getNotNullAttribute("remoteInfo", String.class);
        if (string == null) {
            PBXContainerItemProxy.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PbxId getGlobalId() {
        Object idOrObject = this.getNotNullAttribute("remoteGlobalIDString", null);
        if (idOrObject instanceof String) {
            PbxId pbxId = PbxId.fromString((String)idOrObject);
            if (pbxId == null) {
                PBXContainerItemProxy.$$$reportNull$$$0(1);
            }
            return pbxId;
        }
        PbxId pbxId = this.resolveNotNullAttribute("remoteGlobalIDString", PBXObject.class).getId();
        if (pbxId == null) {
            PBXContainerItemProxy.$$$reportNull$$$0(2);
        }
        return pbxId;
    }

    @Nullable
    public PBXObject getContainerPortal() {
        return this.resolveAttribute("containerPortal", PBXObject.class);
    }

    @Nullable
    public PBXContainerItem resolve() {
        PBXObject portal = this.getContainerPortal();
        if (portal == this.getFile().getProjectObject()) {
            return (PBXContainerItem)this.getFile().findById(this.getGlobalId());
        }
        if (portal instanceof PBXFileReference) {
            VirtualFile foreignProjectBaseDir = ((PBXFileReference)portal).findFile();
            if (foreignProjectBaseDir == null) {
                return null;
            }
            CoreXcodeWorkspace workspace = CoreXcodeWorkspace.getInstance(this.getFile().getProject());
            if (workspace == null) {
                return null;
            }
            PBXProjectFile foreignProject = workspace.findProject(foreignProjectBaseDir);
            if (foreignProject == null) {
                return null;
            }
            return (PBXContainerItem)foreignProject.findById(this.getGlobalId());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/xcode/model/PBXContainerItemProxy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

