/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.xcode.model.PBXBuildFile;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXBuildPhase
extends PBXObject {
    @NotNull
    private final PhaseType myType;

    public PBXBuildPhase(PBXProjectFile file, @NotNull PhaseType type) {
        if (type == null) {
            PBXBuildPhase.$$$reportNull$$$0(0);
        }
        super(file);
        this.myType = type;
        if (((Object)((Object)this)).getClass() == PBXBuildPhase.class) {
            this.setAttribute("isa", String.format("PBX%sBuildPhase", type.getName()));
        }
    }

    @Override
    public String getComment() {
        String name = this.getString("name", null);
        return name == null ? this.myType.getName() : name;
    }

    @NotNull
    public PhaseType getType() {
        PhaseType phaseType = this.myType;
        if (phaseType == null) {
            PBXBuildPhase.$$$reportNull$$$0(1);
        }
        return phaseType;
    }

    @NotNull
    public List<PBXBuildFile> getFiles() {
        List<PBXBuildFile> list = this.resolveAttributeList("files", PBXBuildFile.class);
        if (list == null) {
            PBXBuildPhase.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void addFile(@NotNull ObjectReference file) {
        if (file == null) {
            PBXBuildPhase.$$$reportNull$$$0(3);
        }
        this.addToAttributeList("files", file);
    }

    public void removeFile(@NotNull PbxId id) {
        if (id == null) {
            PBXBuildPhase.$$$reportNull$$$0(4);
        }
        this.removeFromAttributeList("files", ObjectReference.class, each -> id.equals(each.getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static interface PhaseType {
        @NotNull
        @NlsSafe
        public String getName();
    }

    private static class UnknownPhaseType
    implements PhaseType {
        @NotNull
        private final String myName;

        UnknownPhaseType(@NotNull String name) {
            if (name == null) {
                UnknownPhaseType.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                UnknownPhaseType.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnknownPhaseType type = (UnknownPhaseType)o;
            return this.myName.equals(type.myName);
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase$UnknownPhaseType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase$UnknownPhaseType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static enum Type implements PhaseType
    {
        COPY_FILES("CopyFiles"),
        FRAMEWORKS("Frameworks"),
        HEADERS("Headers"),
        RESOURCES("Resources"),
        SHELL_SCRIPT("ShellScript"),
        APPLE_SCRIPT("AppleScript"),
        SOURCES("Sources"),
        REZ("Rez");

        @NotNull
        @NonNls
        private final String myName;

        private Type(String name) {
            if (name == null) {
                Type.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Type.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public static Type typeFromName(@NotNull String name) {
            if (name == null) {
                Type.$$$reportNull$$$0(2);
            }
            for (Type type : Type.values()) {
                if (!name.equals(type.myName)) continue;
                return type;
            }
            return null;
        }

        public static PhaseType fromName(@NotNull String name) {
            if (name == null) {
                Type.$$$reportNull$$$0(3);
            }
            for (Type type : Type.values()) {
                if (!name.equals(type.myName)) continue;
                return type;
            }
            return new UnknownPhaseType(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase$Type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXBuildPhase$Type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "typeFromName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

