/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.model;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.model.PBXBuildPhase;
import com.jetbrains.cidr.xcode.model.PBXObject;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXReference;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.PbxObjectVisitor;
import com.jetbrains.cidr.xcode.pbxproj.ObjectReference;
import com.jetbrains.cidr.xcode.pbxproj.PbxId;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBXBuildFile
extends PBXObject {
    public PBXBuildFile(PBXProjectFile file) {
        super(file);
    }

    @Override
    public String getComment() {
        String refName;
        PBXReference ref = this.getFileRef();
        PBXReference productRef = this.getProductRef();
        PBXBuildPhase phase = this.getPhase();
        if (ref == null && productRef == null || phase == null) {
            return super.getComment();
        }
        String string = refName = ref != null ? ref.getComment() : productRef.getComment();
        if (refName == null) {
            return null;
        }
        return refName + " in " + phase.getComment();
    }

    @Nullable
    public PBXReference getFileRef() {
        return this.resolveAttribute("fileRef", PBXReference.class);
    }

    @Nullable
    public PBXReference getProductRef() {
        return (PBXReference)((Object)this.resolveAttribute("productRef", null));
    }

    @Nullable
    public PbxId getFileRefId() {
        Object ref = this.getAttribute("fileRef", null);
        return ref instanceof ObjectReference ? ((ObjectReference)ref).getId() : null;
    }

    @Nullable
    public PbxId getProductRefId() {
        Object ref = this.getAttribute("productRef", null);
        return ref instanceof ObjectReference ? ((ObjectReference)ref).getId() : null;
    }

    @Nullable
    public VirtualFile findFile() {
        PBXReference ref = this.getFileRef();
        return ref == null ? null : ref.findFile();
    }

    @Nullable
    public PBXTarget getTarget() {
        return (PBXTarget)((Object)Pair.getFirst(this.getTargetAndPhase()));
    }

    @Nullable
    public PBXBuildPhase getPhase() {
        return (PBXBuildPhase)((Object)Pair.getSecond(this.getTargetAndPhase()));
    }

    @Nullable
    public PBXBuildPhase.PhaseType getPhaseType() {
        PBXBuildPhase phase = this.getPhase();
        return phase == null ? null : phase.getType();
    }

    @Nullable
    public Pair<PBXTarget, PBXBuildPhase> getTargetAndPhase() {
        return this.getFile().getTargetAndPhase(this);
    }

    @Nullable
    public Object getSetting(@NotNull @NonNls String settingName) {
        if (settingName == null) {
            PBXBuildFile.$$$reportNull$$$0(0);
        }
        return this.getDictionary("settings", Dictionary.EMPTY_DICTIONARY).get((Object)settingName);
    }

    @Nullable
    public String getStringSetting(@NotNull @NonNls String settingName) {
        Object setting;
        if (settingName == null) {
            PBXBuildFile.$$$reportNull$$$0(1);
        }
        return (setting = this.getSetting(settingName)) == null ? null : setting.toString();
    }

    @Override
    public boolean accept(@NotNull PbxObjectVisitor visitor) {
        if (visitor == null) {
            PBXBuildFile.$$$reportNull$$$0(2);
        }
        return visitor.visitBuildFile(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/xcode/model/PBXBuildFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSetting";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringSetting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

