/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSelector;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValueWithSource;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsResolver;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.ResolvingContext;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.XcodeProjectTrackers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachingBuildSettingsResolver
extends BuildSettingsResolver {
    @NotNull
    private final CachedValue<BuildSettingSelector> mySelectorCache;
    @NotNull
    private final CachedValue<BuildSettingSelector> myArchSelectorCache;
    @NotNull
    private final CachedValue<BuildSettingsResolver.BuildSettingSpecsTables> mySettingSpecsCache;
    @NotNull
    private final CachedValue<BuildSettingsResolver.BuildSettingSpecsTables> mySdkSettingSpecsCache;
    @NotNull
    private final CachedValue<Map<CacheKey, String>> myResolvedValuesCache;
    @NotNull
    private final CachedValue<Map<String, Ref<BuildSettingValueWithSource>>> myUnresolvedValuesCache;
    @NotNull
    private final CachedValue<Map<String, List<BuildSettingsResolver.VariableMatch>>> myExtractedVariablesCache;

    protected CachingBuildSettingsResolver(@NotNull Project project) {
        Object[] objectArray;
        XcodeProjectTrackers trackers;
        if (project == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(0);
        }
        CoreXcodeWorkspace workspace = CoreXcodeWorkspace.getInstance(project);
        XcodeProjectTrackers xcodeProjectTrackers = trackers = workspace != null ? XcodeProjectTrackers.getInstance(project) : null;
        if (trackers != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = trackers.getBuildSettingsTracker();
            objectArray = objectArray2;
            objectArray2[1] = trackers.getReferencesTracker();
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = ModificationTracker.NEVER_CHANGED;
        }
        Object[] cacheDeps = objectArray;
        this.mySelectorCache = CachingBuildSettingsResolver.cached(project, cacheDeps, () -> BuildSettingSelector.sdk(this.getSdk()).and(BuildSettingSelector.arch(this.getArchitectures())));
        this.myArchSelectorCache = CachingBuildSettingsResolver.cached(project, cacheDeps, () -> BuildSettingSelector.sdk(this.getSdk()));
        this.mySettingSpecsCache = this.createCachedSpecs(project, cacheDeps, null);
        this.mySdkSettingSpecsCache = this.createCachedSpecs(project, cacheDeps, "SDKROOT");
        this.myResolvedValuesCache = CachingBuildSettingsResolver.cached(project, cacheDeps, () -> new ConcurrentHashMap());
        this.myUnresolvedValuesCache = CachingBuildSettingsResolver.cached(project, cacheDeps, () -> new ConcurrentHashMap());
        this.myExtractedVariablesCache = CachingBuildSettingsResolver.cached(project, new Object[]{ModificationTracker.NEVER_CHANGED}, () -> new ConcurrentHashMap());
    }

    @NotNull
    private static <T> CachedValue<T> cached(@NotNull Project project, @NotNull @NotNull Object @NotNull [] cacheTrackers, @NotNull Computable<T> computable) {
        if (project == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(1);
        }
        if (computable == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(2);
        }
        if (cacheTrackers == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(3);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)computable.compute(), (Object[])cacheTrackers), false);
        if (cachedValue == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(4);
        }
        return cachedValue;
    }

    private CachedValue<BuildSettingsResolver.BuildSettingSpecsTables> createCachedSpecs(@NotNull Project project, @NotNull @NotNull Object @NotNull [] cacheTrackers, @Nullable String forSetting) {
        if (project == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(5);
        }
        if (cacheTrackers == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(6);
        }
        return CachingBuildSettingsResolver.cached(project, cacheTrackers, () -> this.getSpecsTables(forSetting));
    }

    @Override
    @NotNull
    protected String doResolveValue(@Nullable String settingName, @NotNull String value, @NotNull ResolvingContext context) {
        String result;
        CacheKey cacheKey;
        if (value == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(7);
        }
        if (context == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(8);
        }
        if (settingName == null) {
            String string = super.doResolveValue(null, value, context);
            if (string == null) {
                CachingBuildSettingsResolver.$$$reportNull$$$0(9);
            }
            return string;
        }
        boolean isTopLevelResolve = context.isTopLevelResolve(settingName);
        if (isTopLevelResolve) {
            cacheKey = new CacheKey(settingName, context.getResolveKind(), context.shouldEscapeInGroup());
            result = (String)((Map)this.myResolvedValuesCache.getValue()).get(cacheKey);
            if (result != null) {
                String string = result;
                if (string == null) {
                    CachingBuildSettingsResolver.$$$reportNull$$$0(10);
                }
                return string;
            }
        } else {
            cacheKey = null;
        }
        result = super.doResolveValue(settingName, value, context);
        if (isTopLevelResolve) {
            ((Map)this.myResolvedValuesCache.getValue()).put(cacheKey, result);
        }
        String string = result;
        if (string == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    protected List<BuildSettingsResolver.VariableMatch> extractVariables(@NotNull String value) {
        List<BuildSettingsResolver.VariableMatch> result;
        if (value == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(12);
        }
        if ((result = (List<BuildSettingsResolver.VariableMatch>)((Map)this.myExtractedVariablesCache.getValue()).get(value)) == null) {
            result = super.extractVariables(value);
            ((Map)this.myExtractedVariablesCache.getValue()).put(value, result);
        }
        List<BuildSettingsResolver.VariableMatch> list = result;
        if (list == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @Nullable
    protected BuildSettingValueWithSource doGetUnresolvedValueWithSource(@NotNull String settingName, @NotNull ResolvingContext context) {
        BuildSettingValueWithSource valueWithSource;
        boolean isTopLevelResolve;
        if (settingName == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(14);
        }
        if (context == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(15);
        }
        if ((isTopLevelResolve = context.isTopLevelGetValue(settingName)) && (valueWithSource = (Ref)((Map)this.myUnresolvedValuesCache.getValue()).get(settingName)) != null) {
            return (BuildSettingValueWithSource)valueWithSource.get();
        }
        valueWithSource = super.doGetUnresolvedValueWithSource(settingName, context);
        if (isTopLevelResolve) {
            ((Map)this.myUnresolvedValuesCache.getValue()).put(settingName, Ref.create((Object)valueWithSource));
        }
        return valueWithSource;
    }

    @Override
    @NotNull
    protected BuildSettingsResolver.BuildSettingSpecsTables getSpecsTables(@NotNull ResolvingContext context) {
        if (context == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(16);
        }
        BuildSettingsResolver.BuildSettingSpecsTables buildSettingSpecsTables = !this.areSdkAndArchitectureOverridden() && context.isGettingValueOrResolving("SDKROOT") ? (BuildSettingsResolver.BuildSettingSpecsTables)this.mySdkSettingSpecsCache.getValue() : (BuildSettingsResolver.BuildSettingSpecsTables)this.mySettingSpecsCache.getValue();
        if (buildSettingSpecsTables == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(17);
        }
        return buildSettingSpecsTables;
    }

    @Override
    @NotNull
    protected final BuildSettingSelector getSelector(@NotNull ResolvingContext context) {
        if (context == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(18);
        }
        BuildSettingSelector buildSettingSelector = context.isGettingValueOrResolving("ARCHS") ? (BuildSettingSelector)this.myArchSelectorCache.getValue() : (BuildSettingSelector)this.mySelectorCache.getValue();
        if (buildSettingSelector == null) {
            CachingBuildSettingsResolver.$$$reportNull$$$0(19);
        }
        return buildSettingSelector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 11, 13, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheTrackers";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/CachingBuildSettingsResolver";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/CachingBuildSettingsResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cached";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVariables";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecsTables";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cached";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCachedSpecs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doResolveValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractVariables";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGetUnresolvedValueWithSource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSpecsTables";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSelector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 11, 13, 17, 19 -> new IllegalStateException(string);
        };
    }

    private record CacheKey(String settingName, @NotNull ResolvingContext.ResolveKind kind, boolean shouldEscape) {
        @NotNull
        private final ResolvingContext.ResolveKind kind;

        private CacheKey(String settingName, @NotNull ResolvingContext.ResolveKind kind, boolean shouldEscape) {
            if (kind == null) {
                CacheKey.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public ResolvingContext.ResolveKind kind() {
            ResolvingContext.ResolveKind resolveKind = this.kind;
            if (resolveKind == null) {
                CacheKey.$$$reportNull$$$0(1);
            }
            return resolveKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/CachingBuildSettingsResolver$CacheKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/CachingBuildSettingsResolver$CacheKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

