/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleCompiler;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptions;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a!\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"collectConfigurationCompilers", "", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler;", "configuration", "Lcom/jetbrains/cidr/xcode/model/XCBuildConfiguration;", "sdk", "Lcom/jetbrains/cidr/xcode/frameworks/AppleSdk;", "loadDescriptionsLayout", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions;", "layoutFiles", "", "Ljava/nio/file/Path;", "([Ljava/nio/file/Path;)Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions;", "intellij.cidr.xcodeModel.core"})
@SourceDebugExtension(value={"SMAP\nBuildSettingsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSettingsUtil.kt\ncom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class BuildSettingsUtilKt {
    @NotNull
    public static final Collection<AppleCompiler> collectConfigurationCompilers(@NotNull XCBuildConfiguration configuration, @NotNull AppleSdk sdk) {
        List<PBXTarget> list;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        List<PBXTarget> it = list = configuration.getTargets();
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        List<PBXTarget> list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<PBXTarget> targets = list2;
        String domain = sdk.getPlatform().getDomain();
        AppleCompiler clangCompiler = sdk.getPlatform().findCompiler("com.apple.compilers.llvm.clang.1_0", domain);
        AppleCompiler clangAnalyzer = sdk.getPlatform().findCompiler("com.apple.compilers.llvm.clang.1_0.analyzer", domain);
        AppleCompiler osaCompiler = sdk.getPlatform().findCompiler("com.apple.compilers.osacompile", domain);
        LinkedHashSet<AppleCompiler> result = new LinkedHashSet<AppleCompiler>();
        Object[] objectArray = new AppleCompiler[]{clangCompiler, clangAnalyzer, osaCompiler};
        ContainerUtil.addAllNotNull((Collection)result, (Object[])objectArray);
        PBXProjectFile pBXProjectFile = configuration.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)pBXProjectFile, (String)"getFile(...)");
        PBXProjectFile project = pBXProjectFile;
        Set fileTypes = SequencesKt.toSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)targets), arg_0 -> BuildSettingsUtilKt.collectConfigurationCompilers$lambda$1(project, arg_0))));
        for (AppleFileType fileType : fileTypes) {
            result.addAll(sdk.getPlatform().findCompilersForFileType(fileType, domain));
        }
        return result;
    }

    @Nullable
    public static final BuildSettingDescriptions loadDescriptionsLayout(Path ... layoutFiles) {
        Intrinsics.checkNotNullParameter((Object)layoutFiles, (String)"layoutFiles");
        for (Path each : layoutFiles) {
            if (!Files.exists(each, new LinkOption[0]) || Files.isDirectory(each, new LinkOption[0])) continue;
            try {
                return new BuildSettingDescriptions(each);
            }
            catch (IOException e) {
                XCLog.LOG.warn("Cannot read build settings layout file: " + each, (Throwable)e);
            }
        }
        return null;
    }

    private static final Collection collectConfigurationCompilers$lambda$1(PBXProjectFile $project, PBXTarget it) {
        return $project.getTargetSourceFileTypes(it);
    }
}

