/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.frameworks.AppleArchitecture;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.ArchitectureValues;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSetting;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingEntry;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingFormat;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSelector;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValueWithSource;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsUtilKt;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.CachingBuildSettingsResolver;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.ResolvingContext;
import com.jetbrains.cidr.xcode.model.BuildLocationPaths;
import com.jetbrains.cidr.xcode.model.CoreXcodeWorkspace;
import com.jetbrains.cidr.xcode.model.PBXNativeTarget;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import com.jetbrains.cidr.xcode.model.PBXTarget;
import com.jetbrains.cidr.xcode.model.XCBuildConfiguration;
import com.jetbrains.cidr.xcode.model.XCCoreBuildSettings;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BuildSettingsResolver
implements BuildSettingsProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + BuildSettingsResolver.class.getPackage().getName()));
    private static final Pattern CONDITIONS_PATTERN = Pattern.compile("(\\w+)=([\\w\\?\\*\\.]+)");
    private static final BuildSettingValuesProvider NO_MORE_PROVIDERS = new BuildSettingValuesProvider(){

        @Override
        @NotNull
        public Dictionary getDeclaredBuildSettingValues() {
            throw new UnsupportedOperationException();
        }
    };

    @Override
    @NotNull
    public BuildSetting getBuildSetting(@NonNls @NotNull String settingName) {
        if (settingName == null) {
            BuildSettingsResolver.$$$reportNull$$$0(0);
        }
        PBXProjectFile projectFile = this.getProjectFile();
        return new BuildSetting(settingName, this, projectFile.getBaseDir().getPath());
    }

    @NotNull
    public static String resolveValue(@NotNull String value, final @NotNull PBXProjectFile file, final @Nullable PBXTarget target, final @NotNull Map<String, Object> configurationSettings, final @Nullable ApplePlatform platform) {
        if (value == null) {
            BuildSettingsResolver.$$$reportNull$$$0(1);
        }
        if (file == null) {
            BuildSettingsResolver.$$$reportNull$$$0(2);
        }
        if (configurationSettings == null) {
            BuildSettingsResolver.$$$reportNull$$$0(3);
        }
        String string = new CachingBuildSettingsResolver(file.getProject()){

            @Override
            @NotNull
            protected PBXProjectFile getProjectFile() {
                PBXProjectFile pBXProjectFile = file;
                if (pBXProjectFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                return pBXProjectFile;
            }

            @Override
            @Nullable
            protected PBXTarget getTarget() {
                return target;
            }

            @Override
            @Nullable
            protected XCBuildConfiguration getBuildConfiguration() {
                return null;
            }

            @Override
            @Nullable
            protected ApplePlatform getPlatform() {
                return platform;
            }

            @Override
            @Nullable
            protected AppleSdk getSdk() {
                return null;
            }

            @Override
            @Nullable
            protected Set<ArchitectureValue> getArchitectures() {
                return null;
            }

            @Override
            @NotNull
            protected Map<String, Object> getAdditionalConfigurationSettings() {
                Map map = configurationSettings;
                if (map == null) {
                    2.$$$reportNull$$$0(1);
                }
                return map;
            }

            @Override
            protected boolean areSdkAndArchitectureOverridden() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProjectFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAdditionalConfigurationSettings";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }.resolveText(value);
        if (string == null) {
            BuildSettingsResolver.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String resolveText(@NotNull String text) {
        if (text == null) {
            BuildSettingsResolver.$$$reportNull$$$0(5);
        }
        String string = this.doResolveValue(null, text, new ResolvingContext(ResolvingContext.ResolveKind.STRING));
        if (string == null) {
            BuildSettingsResolver.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String resolvePath(@NotNull String text) {
        if (text == null) {
            BuildSettingsResolver.$$$reportNull$$$0(7);
        }
        String string = this.doResolveValue(null, text, new ResolvingContext(ResolvingContext.ResolveKind.PATH));
        if (string == null) {
            BuildSettingsResolver.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Contract(value="_, null, _ -> null")
    public String resolveValue(@NotNull String settingName, @Nullable String value, @NotNull ResolvingContext context) {
        if (settingName == null) {
            BuildSettingsResolver.$$$reportNull$$$0(9);
        }
        if (context == null) {
            BuildSettingsResolver.$$$reportNull$$$0(10);
        }
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return value == null ? null : this.doResolveValue(settingName, value, context);
    }

    @NotNull
    protected String doResolveValue(@Nullable String settingName, @NotNull String value, @NotNull ResolvingContext context) {
        PBXTarget target;
        AppleSdk sdk;
        AppleSdk sdk2;
        boolean changed;
        if (value == null) {
            BuildSettingsResolver.$$$reportNull$$$0(11);
        }
        if (context == null) {
            BuildSettingsResolver.$$$reportNull$$$0(12);
        }
        do {
            StringBuilder result = new StringBuilder();
            int lastAppendPosition = 0;
            for (VariableMatch m : this.extractVariables(value)) {
                @NonNls String name = m.name;
                if ("inherited".equals(name)) {
                    name = settingName;
                }
                String resolved = name == null ? null : this.getBuildSetting(name).getString(context.childContext(m.partOfGroup));
                LOG.assertTrue(m.qualifiers != null);
                for (String each : m.qualifiers) {
                    resolved = BuildSettingFormat.convert(resolved, each);
                }
                if (resolved != null && m.partOfGroup && context.shouldEscapeInGroup()) {
                    if (m.currentlyInQuotes) {
                        resolved = StringUtil.escapeChar((String)resolved, (char)m.escapeChar);
                    } else if (StringUtil.containsWhitespaces((CharSequence)resolved)) {
                        resolved = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeQuotes((String)resolved));
                    }
                }
                result.append(value, lastAppendPosition, m.variableStart);
                if (resolved != null) {
                    result.append(resolved);
                }
                lastAppendPosition = m.variableEnd;
            }
            result.append(value, lastAppendPosition, value.length());
            String resolved = result.toString();
            changed = !resolved.equals(value);
            value = resolved;
        } while (changed);
        if (("VALID_ARCHS".equals(settingName) || !this.areArchitecturesOverridden() && "ARCHS".equals(settingName)) && (sdk2 = this.getSdk()) != null && sdk2.getPlatformType().isSimulator()) {
            List validArchs = ContainerUtil.map(BuildSetting.splitString(value), ArchitectureValue::new);
            Set<ArchitectureValue> validSimulatorArchs = ArchitectureValues.getSimulatorBuildArchs(validArchs);
            value = BuildSetting.convertToString(validSimulatorArchs);
        }
        if ("TEST_HOST".equals(settingName) && (sdk = this.getSdk()) != null && sdk.isMacCatalyst() && (target = this.getTarget()) != null && target.isAnyXCTestTests()) {
            String ending;
            List path;
            String testHostValue = value;
            String builtProductsDirPath = this.getBuildSetting("BUILT_PRODUCTS_DIR").getString(context.childContext(false));
            if (builtProductsDirPath != null && FileUtil.startsWith((String)testHostValue, (String)builtProductsDirPath) && (path = ContainerUtil.filter((Collection)FileUtil.splitPath((String)(ending = testHostValue.substring(builtProductsDirPath.length()))), StringUtil::isNotEmpty)).size() == 2) {
                value = FileUtil.join((String[])new String[]{builtProductsDirPath, (String)path.get(0), "Contents", "MacOS", (String)path.get(1)});
            }
        }
        String string = value;
        if (string == null) {
            BuildSettingsResolver.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    protected List<VariableMatch> extractVariables(@NotNull String value) {
        if (value == null) {
            BuildSettingsResolver.$$$reportNull$$$0(14);
        }
        Matcher quotationMatcher = null;
        IntRange quotedRange = null;
        Matcher m = BuildSetting.VariableExtractor.PATTERN.matcher(value);
        ArrayList<VariableMatch> matches = new ArrayList<VariableMatch>();
        while (m.find()) {
            if (quotationMatcher == null) {
                quotationMatcher = BuildSetting.QuotationExtractor.PATTERN.matcher(value);
                quotedRange = BuildSetting.QuotationExtractor.findRange(quotationMatcher);
            }
            boolean currentlyInQuotes = false;
            while (quotedRange != null) {
                if (quotedRange.getEndInclusive() >= m.start()) {
                    if (quotedRange.getStart() > m.end()) break;
                    currentlyInQuotes = true;
                    break;
                }
                quotedRange = BuildSetting.QuotationExtractor.findRange(quotationMatcher);
            }
            matches.add(new VariableMatch(value, m, currentlyInQuotes, currentlyInQuotes ? (char)BuildSetting.QuotationExtractor.getChar(quotationMatcher) : (char)' '));
        }
        ArrayList<VariableMatch> arrayList = matches;
        if (arrayList == null) {
            BuildSettingsResolver.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @RequiresReadLock
    @Nullable
    public BuildSettingValueWithSource getUnresolvedValueWithSource(@NotNull String settingName, @NotNull ResolvingContext context) {
        if (settingName == null) {
            BuildSettingsResolver.$$$reportNull$$$0(16);
        }
        if (context == null) {
            BuildSettingsResolver.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.softAssertReadAccess();
        ProgressManager.checkCanceled();
        BuildSettingValueWithSource result = this.doGetUnresolvedValueWithSource(settingName, context, true);
        if (result != null && "SDKROOT".equals(settingName) && context.getResolveKind() == ResolvingContext.ResolveKind.PATH) {
            AppleSdk sdk = AppleSdkManager.getInstance().findSdkBySettingValue(String.valueOf(result.value));
            result = sdk == null ? null : new BuildSettingValueWithSource(sdk.getHomePath(), result.source);
        }
        return result;
    }

    @Nullable
    private BuildSettingValueWithSource doGetUnresolvedValueWithSource(@NotNull String settingName, @NotNull ResolvingContext context, boolean includeOverrides) {
        BuildSettingValueWithSource result;
        XCBuildConfiguration config;
        if (settingName == null) {
            BuildSettingsResolver.$$$reportNull$$$0(18);
        }
        if (context == null) {
            BuildSettingsResolver.$$$reportNull$$$0(19);
        }
        if (this.areSdkAndArchitectureOverridden() && (config = this.getBuildConfiguration()) != null) {
            if ("SDKROOT".equals(settingName)) {
                AppleSdk sdk = this.getSdk();
                return sdk == null ? null : new BuildSettingValueWithSource(sdk.getName(), config);
            }
            if (this.areArchitecturesOverridden()) {
                if ("arch".equals(settingName)) {
                    String firstArch = BuildSettingsResolver.getFirstArchID(this.getArchitectures());
                    return firstArch == null ? null : new BuildSettingValueWithSource(firstArch, config);
                }
                if ("ARCHS".equals(settingName)) {
                    Set<ArchitectureValue> architectures = this.getArchitectures();
                    return architectures == null ? null : new BuildSettingValueWithSource(ContainerUtil.map(architectures, ArchitectureValue::getId), config);
                }
            }
        }
        if (includeOverrides && (result = this.handleOverriddenSettings(settingName, context)) != null) {
            return result;
        }
        BuildSettingValueWithSource valueWithSource = this.doGetUnresolvedValueWithSource(settingName, context);
        context.setValueSource(settingName, valueWithSource == null ? NO_MORE_PROVIDERS : valueWithSource.source);
        return valueWithSource;
    }

    @Nullable
    protected BuildSettingValueWithSource doGetUnresolvedValueWithSource(@NotNull String settingName, @NotNull ResolvingContext context) {
        if (settingName == null) {
            BuildSettingsResolver.$$$reportNull$$$0(20);
        }
        if (context == null) {
            BuildSettingsResolver.$$$reportNull$$$0(21);
        }
        LinkedHashMap<BuildSettingEntry, BuildSettingValuesProvider> entries = new LinkedHashMap<BuildSettingEntry, BuildSettingValuesProvider>();
        BuildSettingSpecsTables tables = this.getSpecsTables(context);
        BuildSettingValuesProvider lastSource = context.getValueSource(settingName);
        if (lastSource != NO_MORE_PROVIDERS) {
            boolean startLooking = lastSource == null;
            for (Pair each : tables) {
                BuildSettingValuesProvider source = (BuildSettingValuesProvider)each.first;
                MostlySingularMultiMap settingEntries = (MostlySingularMultiMap)each.second;
                if (startLooking && settingEntries.containsKey((Object)settingName)) {
                    for (BuildSettingEntry eachValue : settingEntries.get((Object)settingName)) {
                        if (entries.containsKey(eachValue)) continue;
                        entries.put(eachValue, source);
                    }
                    lastSource = source;
                    continue;
                }
                if (source != lastSource) continue;
                startLooking = true;
            }
        }
        BuildSettingEntry entry = BuildSettingsResolver.haveConditions(entries.keySet()) && !context.isGettingValueOrResolving("SDKROOT") ? this.getSelector(context).select(entries.keySet()) : (BuildSettingEntry)ContainerUtil.getFirstItem(entries.keySet(), null);
        return entry == null ? null : new BuildSettingValueWithSource(entry.getValue(), (BuildSettingValuesProvider)entries.get(entry));
    }

    @Nullable
    private BuildSettingValueWithSource handleOverriddenSettings(@NotNull String settingName, @NotNull ResolvingContext context) {
        XCBuildConfiguration config;
        if (settingName == null) {
            BuildSettingsResolver.$$$reportNull$$$0(22);
        }
        if (context == null) {
            BuildSettingsResolver.$$$reportNull$$$0(23);
        }
        if ((config = this.getBuildConfiguration()) != null) {
            PBXTarget target = this.getTarget();
            if (target != null && "TARGET_BUILD_DIR".equals(settingName) && target.isAnyXCTestTests()) {
                boolean isMacOS;
                File testHost = XCCoreBuildSettings.getRawCoreBuildSettings(config).getBuildSetting("TEST_HOST").getAbsoluteFile();
                AppleSdk sdk = this.getSdk();
                boolean bl = isMacOS = sdk != null && sdk.getPlatform().isMacOS();
                if (testHost != null) {
                    @NonNls Object relativePlugInsPath = "../PlugIns";
                    if (isMacOS) {
                        relativePlugInsPath = "../" + (String)relativePlugInsPath;
                    }
                    return new BuildSettingValueWithSource("$(TEST_HOST)/" + (String)relativePlugInsPath, config);
                }
                if (target.isXCUITestTests()) {
                    String runnerPath = "$(CONFIGURATION_BUILD_DIR)/$(TARGET_NAME)-Runner.app/";
                    return new BuildSettingValueWithSource(runnerPath + (isMacOS ? "Contents/" : "") + "PlugIns", config);
                }
            }
            if ("ARCHS_STANDARD".equals(settingName)) {
                BuildSettingValueWithSource result;
                AppleSdk sdk = this.getSdk();
                BuildSettingValueWithSource buildSettingValueWithSource = result = sdk != null ? this.doGetUnresolvedValueWithSource(settingName, context, false) : null;
                if (result != null) {
                    String deploymentTarget = this.getBuildSetting(XCCoreBuildSettings.getDeploymentTargetSettingName(sdk)).getString(context);
                    if (deploymentTarget == null) {
                        LOG.warn("Detected recursion when resolving deployment target for ARCHS_STANDARD");
                    } else {
                        ApplePlatform platform = this.getPlatform();
                        if (platform != null && result.value instanceof List) {
                            List archs = ((List)result.value).stream().map(platform::findArchitectureById).filter(Objects::nonNull).filter(it -> it.matchesDeploymentTarget(deploymentTarget)).map(AppleArchitecture::getId).collect(Collectors.toList());
                            return new BuildSettingValueWithSource(archs, result.source);
                        }
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static String getFirstArchID(@Nullable Collection<ArchitectureValue> archs) {
        ArchitectureValue realArch = archs == null ? null : (ArchitectureValue)ContainerUtil.getFirstItem(archs);
        return null != realArch ? realArch.getId() : null;
    }

    private static boolean haveConditions(Collection<BuildSettingEntry> values) {
        if (values.isEmpty()) {
            return false;
        }
        if (values.size() > 1) {
            return true;
        }
        BuildSettingEntry first = values.iterator().next();
        return !first.getConditions().isEmpty();
    }

    @NotNull
    protected BuildSettingSpecsTables getSpecsTables(@NotNull ResolvingContext context) {
        if (context == null) {
            BuildSettingsResolver.$$$reportNull$$$0(24);
        }
        String forSetting = !this.areSdkAndArchitectureOverridden() && context.isGettingValueOrResolving("SDKROOT") ? "SDKROOT" : null;
        BuildSettingSpecsTables buildSettingSpecsTables = this.getSpecsTables(forSetting);
        if (buildSettingSpecsTables == null) {
            BuildSettingsResolver.$$$reportNull$$$0(25);
        }
        return buildSettingSpecsTables;
    }

    @NotNull
    protected BuildSettingSpecsTables getSpecsTables(@Nullable String forSetting) {
        List<BuildSettingValuesProvider> providers = this.getValueProviders(forSetting);
        BuildSettingSpecsTables tables = new BuildSettingSpecsTables(providers.size());
        for (BuildSettingValuesProvider eachProvider : providers) {
            tables.add(Pair.create((Object)eachProvider, BuildSettingsResolver.convertValuesToSpecs(eachProvider)));
        }
        BuildSettingSpecsTables buildSettingSpecsTables = tables;
        if (buildSettingSpecsTables == null) {
            BuildSettingsResolver.$$$reportNull$$$0(26);
        }
        return buildSettingSpecsTables;
    }

    @NotNull
    protected BuildSettingSelector getSelector(@NotNull ResolvingContext context) {
        if (context == null) {
            BuildSettingsResolver.$$$reportNull$$$0(27);
        }
        BuildSettingSelector buildSettingSelector = context.isGettingValueOrResolving("ARCHS") ? BuildSettingSelector.sdk(this.getSdk()) : BuildSettingSelector.sdk(this.getSdk()).and(BuildSettingSelector.arch(this.getArchitectures()));
        if (buildSettingSelector == null) {
            BuildSettingsResolver.$$$reportNull$$$0(28);
        }
        return buildSettingSelector;
    }

    private static MostlySingularMultiMap<String, BuildSettingEntry> convertValuesToSpecs(@NotNull BuildSettingValuesProvider provider) {
        if (provider == null) {
            BuildSettingsResolver.$$$reportNull$$$0(29);
        }
        MostlySingularMultiMap result = new MostlySingularMultiMap();
        for (Map.Entry each : provider.getDeclaredBuildSettingValues().entrySet()) {
            String name = (String)each.getKey();
            Set<BuildSettingEntry.ConditionSpec> conditions = Collections.emptySet();
            int endOfName = name.indexOf("[");
            if (endOfName != -1) {
                conditions = new HashSet(3);
                String selectors = name.substring(endOfName);
                name = name.substring(0, endOfName);
                Matcher m = CONDITIONS_PATTERN.matcher(selectors);
                while (m.find()) {
                    conditions.add(new BuildSettingEntry.ConditionSpec(m.group(1), m.group(2)));
                }
            }
            result.add((Object)name, (Object)new BuildSettingEntry(name, conditions, each.getValue()));
        }
        return result;
    }

    @NotNull
    private List<BuildSettingValuesProvider> getValueProviders(String forSetting) {
        boolean forSDKROOT = "SDKROOT".equals(forSetting);
        AppleSdk sdk = forSDKROOT ? null : this.getSdk();
        ApplePlatform platform = forSDKROOT ? null : this.getPlatform();
        PBXProjectFile projectFile = this.getProjectFile();
        PBXTarget target = this.getTarget();
        XCBuildConfiguration config = this.getBuildConfiguration();
        return BuildSettingsResolver.getProviders(projectFile, target, config, this.getAdditionalConfigurationSettings(), sdk, platform);
    }

    @NotNull
    private static List<BuildSettingValuesProvider> getProviders(final @NotNull PBXProjectFile projectFile, final @Nullable PBXTarget target, final @Nullable XCBuildConfiguration config, final @NotNull Map<String, Object> additionalBuildSettings, final @Nullable AppleSdk sdk, final @Nullable ApplePlatform platform) {
        BuildLocationPaths buildLocationPaths;
        if (projectFile == null) {
            BuildSettingsResolver.$$$reportNull$$$0(30);
        }
        if (additionalBuildSettings == null) {
            BuildSettingsResolver.$$$reportNull$$$0(31);
        }
        ArrayList<BuildSettingValuesProvider> result = new ArrayList<BuildSettingValuesProvider>();
        CoreXcodeWorkspace workspace = CoreXcodeWorkspace.getInstance(projectFile.getProject());
        BuildLocationPaths buildLocationPaths2 = buildLocationPaths = workspace != null ? workspace.getDerivedBuildLocationPaths() : null;
        if (buildLocationPaths != null) {
            final File productsBuildDir = buildLocationPaths.getProductsPath();
            final File intermediatesBuildDir = buildLocationPaths.getIntermediatesPath();
            if (productsBuildDir != null && intermediatesBuildDir != null) {
                result.add(new BuildSettingValuesProvider(){

                    @Override
                    @NotNull
                    public Dictionary getDeclaredBuildSettingValues() {
                        Dictionary result = new Dictionary();
                        result.setAttribute("SYMROOT", (Object)productsBuildDir.getPath());
                        result.setAttribute("OBJROOT", (Object)intermediatesBuildDir.getPath());
                        Dictionary dictionary = result;
                        if (dictionary == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return dictionary;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$3", "getDeclaredBuildSettingValues"));
                    }
                });
            }
        }
        if (!additionalBuildSettings.isEmpty()) {
            result.add(new BuildSettingValuesProvider(){

                @Override
                @NotNull
                public Dictionary getDeclaredBuildSettingValues() {
                    Dictionary result = new Dictionary();
                    result.putAll(additionalBuildSettings);
                    Dictionary dictionary = result;
                    if (dictionary == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return dictionary;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$4", "getDeclaredBuildSettingValues"));
                }
            });
        }
        ContainerUtil.addIfNotNull(result, (Object)config);
        ContainerUtil.addIfNotNull(result, (Object)(config == null ? null : config.getXCConfigBuildSettingValuesProvider()));
        result.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = projectFile.getProjectObject().getUserBuildSettings();
                if (dictionary == null) {
                    5.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$5", "getDeclaredBuildSettingValues"));
            }
        });
        XCBuildConfiguration baseConfig = config == null ? null : config.getBaseConfiguration();
        ContainerUtil.addIfNotNull(result, (Object)baseConfig);
        ContainerUtil.addIfNotNull(result, (Object)(baseConfig == null ? null : baseConfig.getXCConfigBuildSettingValuesProvider()));
        result.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary result = new Dictionary();
                String srcRoot = projectFile.getBaseDir().getPath();
                result.setAttribute("SRCROOT", (Object)srcRoot);
                result.setAttribute("SOURCE_ROOT", (Object)srcRoot);
                result.setAttribute("PROJECT", (Object)projectFile.getName());
                result.setAttribute("PROJECT_NAME", (Object)projectFile.getName());
                result.setAttribute("PROJECT_FILE_PATH", (Object)projectFile.getXcodeProjFile().getPath());
                if (target != null) {
                    result.setAttribute("TARGET_NAME", (Object)target.getName());
                    result.setAttribute("TARGETNAME", (Object)target.getName());
                }
                if (config != null) {
                    result.setAttribute("CONFIGURATION", (Object)config.getName());
                }
                Dictionary dictionary = result;
                if (dictionary == null) {
                    6.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$6", "getDeclaredBuildSettingValues"));
            }
        });
        if (target instanceof PBXNativeTarget) {
            PBXNativeTarget nativeTarget = (PBXNativeTarget)target;
            ContainerUtil.addIfNotNull(result, (Object)nativeTarget.getProductType(platform));
            ContainerUtil.addIfNotNull(result, (Object)nativeTarget.getPackageType(platform));
        }
        result.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary dictionary = XcodeBase.getInstance().getBuildSettings();
                if (dictionary == null) {
                    7.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$7", "getDeclaredBuildSettingValues"));
            }
        });
        ContainerUtil.addIfNotNull(result, (Object)AppleSdkManager.getInstance());
        ContainerUtil.addIfNotNull(result, (Object)sdk);
        ContainerUtil.addIfNotNull(result, (Object)platform);
        result.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary result = new Dictionary();
                if (platform != null) {
                    Object effectivePlatform = sdk != null && sdk.isMacCatalyst() ? "-maccatalyst" : (platform.isMacOS() ? null : "-" + platform.getName());
                    result.setAttribute("EFFECTIVE_PLATFORM_NAME", effectivePlatform);
                    ArrayList<String> validArchs = new ArrayList<String>();
                    for (AppleArchitecture each : platform.getArchitectures()) {
                        String setting;
                        if (each.isReal()) {
                            validArchs.add(each.getId());
                        }
                        if ((setting = each.getArchitectureSetting()) == null) continue;
                        result.setAttribute(setting, each.getRealArchitectures());
                    }
                    result.setAttribute("VALID_ARCHS", validArchs);
                    if (XcodeBase.getInstance().getVersion().lessThan(Integer.valueOf(14))) {
                        result.setAttribute("SWIFT_PLATFORM_TARGET_PREFIX", (Object)XcodeExtensionsManager.getInstance().getExtendedPlatformInfo(platform.getIdentifier(), "swiftTargetPrefix"));
                    }
                }
                result.setAttribute("NATIVE_ARCH", (Object)AppleSdkManager.getStandardNativeArchitectureId(platform));
                result.setAttribute("NATIVE_ARCH_ACTUAL", (Object)AppleSdkManager.getActualMacOSNativeArchitectureId());
                Dictionary dictionary = result;
                if (dictionary == null) {
                    8.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$8", "getDeclaredBuildSettingValues"));
            }
        });
        if (platform != null) {
            ContainerUtil.addIfNotNull(result, (Object)platform.findBuildSystem(AppleBuildSystem.Type.NATIVE));
        }
        if (config != null && sdk != null) {
            result.addAll(BuildSettingsUtilKt.collectConfigurationCompilers(config, sdk));
        }
        result.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary result = new Dictionary();
                result.setAttribute("SYMROOT", (Object)"build");
                result.setAttribute("OBJROOT", (Object)"build");
                Dictionary dictionary = result;
                if (dictionary == null) {
                    9.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$9", "getDeclaredBuildSettingValues"));
            }
        });
        result.add(new BuildSettingValuesProvider(){

            @Override
            @NotNull
            public Dictionary getDeclaredBuildSettingValues() {
                Dictionary result = new Dictionary();
                result.putAll(System.getenv());
                Dictionary dictionary = result;
                if (dictionary == null) {
                    10.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$10", "getDeclaredBuildSettingValues"));
            }
        });
        ArrayList<BuildSettingValuesProvider> arrayList = result;
        if (arrayList == null) {
            BuildSettingsResolver.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.getProjectFile().getProject();
        if (project == null) {
            BuildSettingsResolver.$$$reportNull$$$0(33);
        }
        return project;
    }

    @NotNull
    protected abstract PBXProjectFile getProjectFile();

    @Nullable
    protected abstract PBXTarget getTarget();

    @Nullable
    protected abstract XCBuildConfiguration getBuildConfiguration();

    @Nullable
    protected ApplePlatform getPlatform() {
        AppleSdk sdk = this.getSdk();
        return sdk == null ? null : sdk.getPlatform();
    }

    @Nullable
    protected abstract AppleSdk getSdk();

    @Nullable
    protected abstract Set<ArchitectureValue> getArchitectures();

    @NotNull
    protected Map<String, Object> getAdditionalConfigurationSettings() {
        Map<String, Object> map = Collections.emptyMap();
        if (map == null) {
            BuildSettingsResolver.$$$reportNull$$$0(34);
        }
        return map;
    }

    protected abstract boolean areSdkAndArchitectureOverridden();

    protected boolean areArchitecturesOverridden() {
        return this.areSdkAndArchitectureOverridden();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 13, 15, 25, 26, 28, 32, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSettings";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalBuildSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveValue";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVariables";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecsTables";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalConfigurationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildSetting";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveValue";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doResolveValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractVariables";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedValueWithSource";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doGetUnresolvedValueWithSource";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "handleOverriddenSettings";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSpecsTables";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSelector";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "convertValuesToSpecs";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 13, 15, 25, 26, 28, 32, 33, 34 -> new IllegalStateException(string);
        };
    }

    protected static class VariableMatch {
        private final int variableStart;
        private final int variableEnd;
        @Nullable
        private final String name;
        @Nullable
        private final List<String> qualifiers;
        private final boolean currentlyInQuotes;
        private final boolean partOfGroup;
        private final char escapeChar;

        VariableMatch(@NotNull String value, @NotNull MatchResult match, boolean currentlyInQuotes, char escapeChar) {
            if (value == null) {
                VariableMatch.$$$reportNull$$$0(0);
            }
            if (match == null) {
                VariableMatch.$$$reportNull$$$0(1);
            }
            this.variableStart = match.start();
            this.variableEnd = match.end();
            Pair<String, List<String>> variable = BuildSetting.VariableExtractor.getVariableAndQualifiers(match);
            this.name = variable == null ? null : (String)variable.first;
            this.qualifiers = variable == null ? null : (List)variable.second;
            this.currentlyInQuotes = currentlyInQuotes;
            this.partOfGroup = currentlyInQuotes || this.variableStart > 0 && value.charAt(this.variableStart - 1) != ' ' || this.variableEnd < value.length() && value.charAt(this.variableEnd) != ' ';
            this.escapeChar = escapeChar;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "match";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingsResolver$VariableMatch";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class BuildSettingSpecsTables
    extends ArrayList<Pair<BuildSettingValuesProvider, MostlySingularMultiMap<String, BuildSettingEntry>>> {
        private BuildSettingSpecsTables(int initialCapacity) {
            super(initialCapacity);
        }
    }
}

