/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescription;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptionProvider;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildSettingSpecification
implements BuildSettingDescriptionProvider {
    @NonNls
    private static final String SDKROOT_TYPE = "SDKRoot";
    @NonNls
    private static final String ARCHITECTURES_TYPE = "Architectures";
    @NotNull
    private final Type myType;
    @NotNull
    private final String myName;
    @Nullable
    private final String myDisplayName;
    @Nullable
    private final String myDescription;
    @Nullable
    private final String myUIType;
    @Nullable
    private final String myCategory;
    @Nullable
    private final Object myDefaultValue;

    public BuildSettingSpecification(@NotNull Type type, @NotNull String name, @Nullable String displayName, @Nullable String description, @Nullable String uiType, @Nullable String category, @Nullable Object defaultValue) {
        if (type == null) {
            BuildSettingSpecification.$$$reportNull$$$0(0);
        }
        if (name == null) {
            BuildSettingSpecification.$$$reportNull$$$0(1);
        }
        this.myType = type;
        this.myName = name;
        this.myDisplayName = displayName;
        this.myDescription = description;
        this.myUIType = uiType;
        this.myCategory = category;
        this.myDefaultValue = defaultValue;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            BuildSettingSpecification.$$$reportNull$$$0(2);
        }
        return type;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            BuildSettingSpecification.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    @Nullable
    public BuildSettingDescription getDescription(@Nullable String settingName) {
        if (!Objects.equals(settingName, this.myName)) {
            return null;
        }
        return new BuildSettingDescription(this.getDisplayName(), this.getDescription());
    }

    @Nullable
    public String getUIType() {
        return this.myUIType;
    }

    public boolean isSDKSetting() {
        return SDKROOT_TYPE.equals(this.getUIType());
    }

    public boolean isArchitecturesSetting() {
        return ARCHITECTURES_TYPE.equals(this.getUIType());
    }

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.myDefaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSpecification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSpecification";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        PATH,
        ENUM,
        STRING_LIST,
        PATH_LIST;

    }
}

