/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BuildSettingSelector {
    BuildSettingSelector() {
    }

    @Nullable
    public BuildSettingEntry select(@NotNull Collection<BuildSettingEntry> settings) {
        if (settings == null) {
            BuildSettingSelector.$$$reportNull$$$0(0);
        }
        BuildSettingEntry result = null;
        int resultWeight = -1;
        for (BuildSettingEntry each : this.retainSuitable(settings)) {
            int eachWeight = each.getWeight();
            if (result != null && resultWeight > eachWeight) continue;
            result = each;
            resultWeight = eachWeight;
        }
        return result;
    }

    @NotNull
    public BuildSettingSelector and(@Nullable BuildSettingSelector right) {
        return right == null ? this : new AndSelector(this, right);
    }

    protected abstract List<BuildSettingEntry> retainSuitable(@NotNull Collection<BuildSettingEntry> var1);

    @NotNull
    public static BuildSettingSelector nil() {
        return new LeafSelector(null, Collections.emptyList());
    }

    @NotNull
    public static BuildSettingSelector sdk(@Nullable AppleSdk sdk) {
        return new LeafSelector("sdk", sdk == null ? Collections.emptyList() : Collections.singletonList(sdk.getName()));
    }

    @NotNull
    public static BuildSettingSelector arch(@Nullable Collection<ArchitectureValue> architectures) {
        List<String> archs = Collections.emptyList();
        if (architectures != null) {
            archs = new ArrayList<String>(architectures.size());
            for (ArchitectureValue each : architectures) {
                archs.add(each.getId());
            }
        }
        return new LeafSelector("arch", archs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSelector", "select"));
    }

    private static class AndSelector
    extends BuildSettingSelector {
        private final BuildSettingSelector myLeft;
        private final BuildSettingSelector myRight;

        AndSelector(@NotNull BuildSettingSelector left, @NotNull BuildSettingSelector right) {
            if (left == null) {
                AndSelector.$$$reportNull$$$0(0);
            }
            if (right == null) {
                AndSelector.$$$reportNull$$$0(1);
            }
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        protected List<BuildSettingEntry> retainSuitable(@NotNull Collection<BuildSettingEntry> values) {
            if (values == null) {
                AndSelector.$$$reportNull$$$0(2);
            }
            return this.myRight.retainSuitable(this.myLeft.retainSuitable(values));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSelector$AndSelector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "retainSuitable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LeafSelector
    extends BuildSettingSelector {
        @Nullable
        private final String myFlavor;
        @NotNull
        private final List<String> myActualValues;

        LeafSelector(@Nullable @NonNls String flavor, @NotNull List<String> actualValues) {
            if (actualValues == null) {
                LeafSelector.$$$reportNull$$$0(0);
            }
            this.myFlavor = flavor;
            this.myActualValues = actualValues;
        }

        @Override
        protected List<BuildSettingEntry> retainSuitable(@NotNull Collection<BuildSettingEntry> values) {
            if (values == null) {
                LeafSelector.$$$reportNull$$$0(1);
            }
            ArrayList<BuildSettingEntry> result = new ArrayList<BuildSettingEntry>(values.size());
            block0: for (BuildSettingEntry eachValue : values) {
                for (BuildSettingEntry.ConditionSpec eachCondition : eachValue.getConditions()) {
                    if (this.myFlavor != null && !this.myFlavor.equals(eachCondition.getFlavor())) continue;
                    boolean matches = false;
                    for (String eachActualValue : this.myActualValues) {
                        if (!eachCondition.matches(eachActualValue)) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    continue block0;
                }
                result.add(eachValue);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actualValues";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSelector$LeafSelector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "retainSuitable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

