/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildSettingEntry {
    @NotNull
    private final String mySettingName;
    @NotNull
    private final Set<ConditionSpec> myConditions;
    @NotNull
    private final Object myValue;

    BuildSettingEntry(@NotNull String settingName, @NotNull Set<ConditionSpec> conditions, @NotNull Object value) {
        if (settingName == null) {
            BuildSettingEntry.$$$reportNull$$$0(0);
        }
        if (conditions == null) {
            BuildSettingEntry.$$$reportNull$$$0(1);
        }
        if (value == null) {
            BuildSettingEntry.$$$reportNull$$$0(2);
        }
        this.mySettingName = settingName;
        this.myConditions = conditions;
        this.myValue = value;
    }

    @NotNull
    public Collection<ConditionSpec> getConditions() {
        Set<ConditionSpec> set = this.myConditions;
        if (set == null) {
            BuildSettingEntry.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Object getValue() {
        Object object = this.myValue;
        if (object == null) {
            BuildSettingEntry.$$$reportNull$$$0(4);
        }
        return object;
    }

    public int getWeight() {
        if (this.myConditions.isEmpty()) {
            return -1;
        }
        int result = 0;
        for (ConditionSpec each : this.myConditions) {
            for (int i = 0; i < each.myPattern.length(); ++i) {
                char ch = each.myPattern.charAt(i);
                if (ch == '*') continue;
                result += ch == '?' ? 1 : 2;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mySettingName);
        for (ConditionSpec each : this.myConditions) {
            builder.append("[").append(each).append("]");
        }
        builder.append("=").append(this.myValue);
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildSettingEntry that = (BuildSettingEntry)o;
        if (!this.mySettingName.equals(that.mySettingName)) {
            return false;
        }
        return this.myConditions.equals(that.myConditions);
    }

    public int hashCode() {
        int result = this.mySettingName.hashCode();
        result = 31 * result + this.myConditions.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingEntry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class ConditionSpec {
        @NotNull
        private final String myFlavor;
        @NotNull
        private final String myPattern;

        public ConditionSpec(@NotNull String flavor, @NotNull String pattern) {
            if (flavor == null) {
                ConditionSpec.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                ConditionSpec.$$$reportNull$$$0(1);
            }
            this.myFlavor = flavor;
            this.myPattern = pattern;
        }

        @NotNull
        public String getFlavor() {
            String string = this.myFlavor;
            if (string == null) {
                ConditionSpec.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean matches(@Nullable String value) {
            return StringUtil.notNullize((String)value).matches(FileUtil.convertAntToRegexp((String)this.myPattern));
        }

        public String toString() {
            return this.myFlavor + "=" + this.myPattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionSpec that = (ConditionSpec)o;
            if (!this.myFlavor.equals(that.myFlavor)) {
                return false;
            }
            return this.myPattern.equals(that.myPattern);
        }

        public int hashCode() {
            int result = this.myFlavor.hashCode();
            result = 31 * result + this.myPattern.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flavor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingEntry$ConditionSpec";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingEntry$ConditionSpec";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFlavor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

