/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.StringsParser;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescription;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildSettingDescriptions {
    private static final Pattern PATTERN = Pattern.compile("\\[(.*)\\]-(?:(category||name||description)||(?:(value||description)-\\[(.*)\\]))");
    private static final Function<Map.Entry<String, Object>, Couple<String>> ENTRY_COUPLE_FUNCTION = entry -> {
        if (entry.getValue() instanceof String) {
            return Couple.of((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
        }
        return null;
    };
    private final Map<String, String> myCategoryDescriptions;
    private final Map<String, BuildSettingDescription> mySettingDescriptions;

    public BuildSettingDescriptions(@NotNull Path file) throws IOException {
        if (file == null) {
            BuildSettingDescriptions.$$$reportNull$$$0(0);
        }
        this.myCategoryDescriptions = new HashMap<String, String>();
        this.mySettingDescriptions = new HashMap<String, BuildSettingDescription>();
        Object result = BuildSettingDescriptions.loadFile(file);
        if (result instanceof String) {
            this.createBuildDescriptions(StringsParser.parse((String)result));
        }
        if (result instanceof Plist) {
            this.createBuildDescriptions(ContainerUtil.map((Collection)((Plist)result).entrySet(), ENTRY_COUPLE_FUNCTION));
        }
    }

    private static Object loadFile(Path file) throws IOException {
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            long len = Files.size(file);
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (FileSizeLimit.isTooLarge((long)len, null) || len > Integer.MAX_VALUE) {
                throw new FileTooBigException("Attempt to load '" + String.valueOf(file) + "' in memory buffer, file length is " + len + " bytes.");
            }
            byte[] bytes = FileUtil.loadBytes((InputStream)stream, (int)((int)len));
            Charset encoding = CharsetToolkit.guessFromBOM((byte[])bytes);
            if (encoding != null) {
                String string = new String(bytes, encoding);
                return string;
            }
            Plist plist = PlistDriver.readAnyFormat((Path)file);
            return plist;
        }
    }

    public BuildSettingDescriptions(@NotNull String text) {
        if (text == null) {
            BuildSettingDescriptions.$$$reportNull$$$0(1);
        }
        this.myCategoryDescriptions = new HashMap<String, String>();
        this.mySettingDescriptions = new HashMap<String, BuildSettingDescription>();
        List<Couple<String>> values = StringsParser.parse(text);
        this.createBuildDescriptions(values);
    }

    private void createBuildDescriptions(List<Couple<@NonNls String>> values) {
        for (Couple<String> each : values) {
            BuildSettingDescription.ValueDescription valueDesc;
            Matcher m = PATTERN.matcher((CharSequence)each.first);
            if (!m.matches()) continue;
            String value = (String)each.second;
            String id = m.group(1);
            @NonNls String type = m.group(2);
            String valueType = m.group(3);
            String valueId = m.group(4);
            if ("category".equals(type)) {
                this.myCategoryDescriptions.put(id, value);
                continue;
            }
            BuildSettingDescription desc = this.mySettingDescriptions.get(id);
            if (desc == null) {
                desc = new BuildSettingDescription();
                this.mySettingDescriptions.put(id, desc);
            }
            if (type != null) {
                if ("name".equals(type)) {
                    desc.displayName = value;
                    continue;
                }
                if (!"description".equals(type)) continue;
                desc.displayDescription = value;
                continue;
            }
            if (valueType == null) continue;
            if (desc.valueSpecs == null) {
                desc.valueSpecs = new LinkedHashMap();
            }
            if ((valueDesc = desc.valueSpecs.get(valueId)) == null) {
                valueDesc = new BuildSettingDescription.ValueDescription();
                desc.valueSpecs.put(valueId, valueDesc);
            }
            if ("value".equals(valueType)) {
                valueDesc.displayName = value;
                continue;
            }
            if (!"description".equals(valueType)) continue;
            valueDesc.displayDescription = value;
        }
    }

    @Nullable
    public BuildSettingDescription getDescription(@Nullable String buildSetting) {
        return buildSetting == null ? null : this.mySettingDescriptions.get(buildSetting);
    }

    @Nullable
    public String getCategoryDescription(@Nullable String category) {
        return category == null ? null : this.myCategoryDescriptions.get(category);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

