/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValueWithSource;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsResolver;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.PathListEntry;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.ResolvingContext;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.UnresolvedPathListEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildSetting {
    @NlsSafe
    public static final String RECURSIVE_PREFIX = "/**";
    private static final Set<String> STRING_BASED_LISTS = new HashSet<String>(Collections.singletonList("USER_HEADER_SEARCH_PATHS"));
    @NotNull
    private final String myName;
    @NotNull
    private final BuildSettingsResolver myProvider;
    @Nullable
    private final String myBaseDir;
    @Nullable
    private volatile Ref<Object> mySetUnresolvedValue;

    public BuildSetting(@NotNull String name, @NotNull BuildSettingsResolver provider, @Nullable String baseDir) {
        if (name == null) {
            BuildSetting.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            BuildSetting.$$$reportNull$$$0(1);
        }
        this.mySetUnresolvedValue = null;
        this.myName = name;
        this.myProvider = provider;
        this.myBaseDir = baseDir;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            BuildSetting.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getString() {
        return this.getString(new ResolvingContext());
    }

    @NotNull
    @NlsSafe
    public String getNotNullString() {
        String result = this.getString();
        return result != null ? result : "";
    }

    @Nullable
    @NlsSafe
    String getString(@NotNull ResolvingContext context) {
        if (context == null) {
            BuildSetting.$$$reportNull$$$0(3);
        }
        context.startResolving(this.myName);
        String result = this.myProvider.resolveValue(this.myName, this.getUnresolvedString(context), context);
        context.finishResolving(this.myName);
        return result;
    }

    public boolean getBoolean() {
        return "YES".equals(this.getString());
    }

    @Nullable
    @NlsSafe
    public String getAbsolutePath() {
        return this.getAbsolutePath(this.myBaseDir);
    }

    @Nullable
    @NlsSafe
    public String getAbsolutePath(@Nullable String baseDir) {
        File result = this.getAbsoluteFile(baseDir);
        return result == null ? null : result.getPath();
    }

    @Nullable
    public File getAbsoluteFile() {
        return this.getAbsoluteFile(this.myBaseDir);
    }

    @Nullable
    public File getAbsoluteFile(@Nullable String baseDir) {
        return BuildSetting.pathToFile(this.getString(new ResolvingContext(ResolvingContext.ResolveKind.PATH)), baseDir);
    }

    @Nullable
    private static File pathToFile(@Nullable String path, @Nullable String baseDir) {
        if (path == null || StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        if (path.startsWith("~")) {
            return new File(SystemProperties.getUserHome(), path.substring(1));
        }
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return baseDir == null ? null : new File(baseDir, path).getAbsoluteFile();
    }

    public @NotNull List<@NlsSafe String> getStringList() {
        List<String> list = this.getStringList(new ResolvingContext(true));
        if (list == null) {
            BuildSetting.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull List<@NlsSafe String> getStringList(@NotNull ResolvingContext context) {
        String string;
        if (context == null) {
            BuildSetting.$$$reportNull$$$0(5);
        }
        return (string = this.getString(context)) == null ? Collections.emptyList() : BuildSetting.splitString(string);
    }

    @NotNull
    public List<PathListEntry> getPathList() {
        List<String> stringList = this.getStringList(new ResolvingContext(ResolvingContext.ResolveKind.PATH, true));
        ArrayList<PathListEntry> result = new ArrayList<PathListEntry>(stringList.size());
        for (String each : stringList) {
            if (each == null) continue;
            String path = BuildSetting.unescapeListValue(each);
            Pair<String, Boolean> pair = BuildSetting.toPathAndRecursiveFlag(path);
            path = (String)pair.first;
            File file = BuildSetting.pathToFile(path, this.myBaseDir);
            if (file == null) continue;
            result.add(new PathListEntry(path, file, (Boolean)pair.second));
        }
        List<PathListEntry> list = Collections.unmodifiableList(result);
        if (list == null) {
            BuildSetting.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<UnresolvedPathListEntry> getUnresolvedPathList() {
        List<String> stringList = this.getUnresolvedStringList();
        ArrayList<UnresolvedPathListEntry> result = new ArrayList<UnresolvedPathListEntry>(stringList.size());
        for (String unresolvedPath : stringList) {
            Pair<String, Boolean> pair = BuildSetting.toPathAndRecursiveFlag(unresolvedPath);
            result.add(new UnresolvedPathListEntry((String)pair.first, (Boolean)pair.second));
        }
        List<UnresolvedPathListEntry> list = Collections.unmodifiableList(result);
        if (list == null) {
            BuildSetting.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static Pair<String, Boolean> toPathAndRecursiveFlag(@NotNull String value) {
        boolean recursive;
        if (value == null) {
            BuildSetting.$$$reportNull$$$0(8);
        }
        if (recursive = value.endsWith(RECURSIVE_PREFIX)) {
            value = value.substring(0, value.length() - RECURSIVE_PREFIX.length());
        }
        Pair pair = Pair.create((Object)value, (Object)recursive);
        if (pair == null) {
            BuildSetting.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @Nullable
    public AppleSdk getSdk() {
        return AppleSdkManager.getInstance().findSdkBySettingValue(this.getString());
    }

    @NotNull
    public Set<ArchitectureValue> getArchitectures() {
        List<String> stringList = this.getStringList();
        ImmutableSet.Builder result = ImmutableSet.builderWithExpectedSize((int)stringList.size());
        for (String each : stringList) {
            result.add((Object)new ArchitectureValue(each));
        }
        ImmutableSet immutableSet = result.build();
        if (immutableSet == null) {
            BuildSetting.$$$reportNull$$$0(10);
        }
        return immutableSet;
    }

    public boolean isDefinedIn(@Nullable BuildSettingValuesProvider source) {
        return this.getUnresolvedValueSource() == source;
    }

    @RequiresReadLock
    @Nullable
    public BuildSettingValuesProvider getUnresolvedValueSource() {
        ThreadingAssertions.softAssertReadAccess();
        ResolvingContext context = new ResolvingContext();
        context.startGettingValue(this.myName);
        BuildSettingValueWithSource valueWithSource = this.myProvider.getUnresolvedValueWithSource(this.myName, context);
        context.finishGettingValue(this.myName);
        return valueWithSource == null ? null : valueWithSource.source;
    }

    @Nullable
    public Object getUnresolvedValue() {
        return this.getUnresolvedValue(new ResolvingContext());
    }

    @Nullable
    private Object getUnresolvedValue(ResolvingContext context) {
        return this.getUnresolvedValue(context, false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Nullable
    private Object getUnresolvedValue(ResolvingContext resolvingContext, boolean bl) {
        BuildSettingValueWithSource valueWithSource;
        void ignoreModified;
        void context;
        ThreadingAssertions.softAssertReadAccess();
        context.startGettingValue(this.myName);
        Ref<Object> setValue = this.mySetUnresolvedValue;
        Object result = ignoreModified == false && setValue != null ? setValue.get() : ((valueWithSource = this.myProvider.getUnresolvedValueWithSource(this.myName, (ResolvingContext)context)) == null ? null : valueWithSource.value);
        context.finishGettingValue(this.myName);
        return result;
    }

    @Nullable
    @NlsSafe
    public String getUnresolvedString() {
        return this.getUnresolvedString(new ResolvingContext());
    }

    @Nullable
    @NlsSafe
    private String getUnresolvedString(@NotNull ResolvingContext context) {
        if (context == null) {
            BuildSetting.$$$reportNull$$$0(11);
        }
        return BuildSetting.convertToString(this.getUnresolvedValue(context));
    }

    public @NotNull List<@NlsSafe String> getUnresolvedStringList() {
        return BuildSetting.convertToList(this.getUnresolvedValue(new ResolvingContext()));
    }

    public boolean isModified() {
        Ref<Object> setValue = this.mySetUnresolvedValue;
        if (setValue == null) {
            return false;
        }
        List<String> original = this.getUnresolvedValue(new ResolvingContext(), true);
        List<String> changed = setValue.get();
        if (original instanceof List) {
            changed = BuildSetting.convertToList(changed);
        } else if (changed instanceof List) {
            original = BuildSetting.convertToList(original);
        }
        return !Comparing.equal(changed, original);
    }

    public void reset() {
        this.mySetUnresolvedValue = null;
    }

    public void setUnresolvedValue(@NonNls @Nullable Object value) {
        this.mySetUnresolvedValue = new Ref(value);
    }

    public void setUnresolvedString(@NonNls @Nullable String value) {
        this.setUnresolvedValue(value);
    }

    public void appendUnresolvedStringList(@Nullable String value) {
        this.doAppendStringList(BuildSetting.escapeListValue(value, false));
    }

    public void appendUnresolvedPathList(@Nullable String value, boolean recursive) {
        if ((value = BuildSetting.escapeListValue((String)value, true)) != null && recursive) {
            value = (String)value + RECURSIVE_PREFIX;
        }
        this.doAppendStringList((String)value);
    }

    @Contract(pure=true)
    @Nullable
    private static String escapeListValue(@Nullable String value, boolean escapeVariables) {
        if (value == null || StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        if ((StringUtil.containsWhitespaces((CharSequence)value) || escapeVariables && VariableExtractor.PATTERN.matcher((CharSequence)value).find()) && (!((String)value).startsWith("\"") || !((String)value).endsWith("\""))) {
            value = "\"" + StringUtil.escapeQuotes((String)value) + "\"";
        }
        return value;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    private static String unescapeListValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        value = QuotationExtractor.unquoted(value);
        value = StringUtil.unescapeChar((String)value, (char)'\"');
        value = StringUtil.unescapeChar((String)value, (char)'\'');
        return value;
    }

    private void doAppendStringList(@Nullable String value) {
        if (value == null) {
            return;
        }
        Object object = this.getUnresolvedValue();
        if (object == null) {
            this.setUnresolvedValue(value);
        } else if (object instanceof List) {
            ArrayList<String> copy = new ArrayList<String>((List)object);
            copy.add(value);
            this.setUnresolvedValue(copy);
        } else if (object instanceof String) {
            List<String> list = BuildSetting.splitString((String)object);
            if (list.size() == 1 && !this.isStringBasedList()) {
                list = new ArrayList<String>(list);
                list.add(value);
                this.setUnresolvedValue(list);
            } else {
                this.setUnresolvedValue((String.valueOf(object) + " " + value).trim());
            }
        } else {
            this.setUnresolvedValue((String.valueOf(object) + " " + value).trim());
        }
    }

    private boolean isStringBasedList() {
        return STRING_BASED_LISTS.contains(this.myName);
    }

    @NotNull
    private static List<String> convertToList(@Nullable Object result) {
        if (result == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BuildSetting.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (result instanceof List) {
            List<String> list = Collections.unmodifiableList((List)result);
            if (list == null) {
                BuildSetting.$$$reportNull$$$0(13);
            }
            return list;
        }
        if (result instanceof String) {
            List<String> list = Collections.unmodifiableList(BuildSetting.splitString((String)result));
            if (list == null) {
                BuildSetting.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<String> list = Collections.singletonList(result.toString());
        if (list == null) {
            BuildSetting.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    static List<String> splitString(@NotNull String s) {
        int nextSplit;
        if (s == null) {
            BuildSetting.$$$reportNull$$$0(16);
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher quotationMatcher = QuotationExtractor.PATTERN.matcher(s);
        int lastSplitExcl = 0;
        IntRange quotedRange = QuotationExtractor.findRange(quotationMatcher);
        do {
            int start = lastSplitExcl;
            int end = s.length();
            nextSplit = s.indexOf(32, start);
            while (nextSplit >= 0) {
                block6: {
                    while (quotedRange != null && nextSplit >= quotedRange.getStart()) {
                        if (nextSplit > quotedRange.getEndInclusive()) {
                            quotedRange = QuotationExtractor.findRange(quotationMatcher);
                            continue;
                        }
                        break block6;
                    }
                    end = nextSplit;
                    lastSplitExcl = end + 1;
                    break;
                }
                nextSplit = s.indexOf(32, nextSplit + 1);
            }
            if (start == end) continue;
            result.add(s.substring(start, end));
        } while (nextSplit >= 0);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            BuildSetting.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NlsSafe
    static String convertToString(@Nullable Object o) {
        if (o instanceof Collection) {
            return StringUtil.join((Collection)((Collection)o), o1 -> BuildSetting.convertToString(o1), (String)" ");
        }
        return o == null ? null : o.toString();
    }

    public String toString() {
        return this.myName + "=" + this.getUnresolvedString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7, 9, 10, 12, 13, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedPathList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toPathAndRecursiveFlag";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchitectures";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "splitString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStringList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toPathAndRecursiveFlag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "splitString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7, 9, 10, 12, 13, 14, 15, 17 -> new IllegalStateException(string);
        };
    }

    public static final class VariableExtractor {
        public static final Pattern PATTERN = Pattern.compile("\\$\\(([\\w.]+)((?::[^:)]*)*)\\)|\\$\\{([\\w.]+)((?::[^:}]*)*)\\}|\\$\\[([\\w.]+)((?::[^:\\]]*)*)\\]|\\$([\\w.]+)");

        @Nullable
        public static Pair<String, List<String>> getVariableAndQualifiers(@NotNull MatchResult m) {
            if (m == null) {
                VariableExtractor.$$$reportNull$$$0(0);
            }
            for (int i = 1; i <= m.groupCount(); i += 2) {
                String qualifiersString;
                String first = m.group(i);
                if (first == null) continue;
                List qualifiers = Collections.emptyList();
                String string = qualifiersString = i < m.groupCount() ? m.group(i + 1) : null;
                if (!StringUtil.isEmptyOrSpaces(qualifiersString)) {
                    qualifiers = StringUtil.split((String)qualifiersString, (String)":", (boolean)true, (boolean)true);
                }
                return Pair.create((Object)first, qualifiers);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting$VariableExtractor", "getVariableAndQualifiers"));
        }
    }

    public static final class QuotationExtractor {
        @NotNull
        public static final Pattern PATTERN = Pattern.compile("(?<!\\\\)(?:\\\\\\\\)*(?<quote>[\"'])(?<quoted>.*?)(?:(?<!\\\\)(?:\\\\\\\\)*\\k<quote>|$)");

        public static char getChar(@NotNull Matcher m) {
            if (m == null) {
                QuotationExtractor.$$$reportNull$$$0(0);
            }
            return StringsKt.single((CharSequence)m.group("quote"));
        }

        @Nullable
        public static IntRange findRange(@NotNull Matcher m) {
            if (m == null) {
                QuotationExtractor.$$$reportNull$$$0(1);
            }
            return m.find() ? QuotationExtractor.getRange(m) : null;
        }

        @NotNull
        public static IntRange getRange(@NonNls @NotNull Matcher m) {
            if (m == null) {
                QuotationExtractor.$$$reportNull$$$0(2);
            }
            IntRange intRange = RangesKt.until((int)m.start("quoted"), (int)m.end("quoted"));
            if (intRange == null) {
                QuotationExtractor.$$$reportNull$$$0(3);
            }
            return intRange;
        }

        @NotNull
        public static String unquoted(@NotNull String str) {
            if (str == null) {
                QuotationExtractor.$$$reportNull$$$0(4);
            }
            String string = PATTERN.matcher(str).replaceAll("${quoted}");
            if (string == null) {
                QuotationExtractor.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting$QuotationExtractor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting$QuotationExtractor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unquoted";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getChar";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRange";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "unquoted";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

