/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.google.common.collect.ImmutableSet;
import com.intellij.util.system.CpuArch;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.ArchitectureType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArchitectureValues {
    @NotNull
    public static Set<ArchitectureValue> getSimulatorBuildArchs(@NotNull Collection<ArchitectureValue> buildArchs) {
        if (buildArchs == null) {
            ArchitectureValues.$$$reportNull$$$0(0);
        }
        ImmutableSet.Builder simulatorBuildArchs = ImmutableSet.builderWithExpectedSize((int)3);
        for (ArchitectureValue eachOriginalBuildArch : buildArchs) {
            List<ArchitectureValue> simulatorArchs = ArchitectureValues.getSimulatorBuildArch(eachOriginalBuildArch);
            if (simulatorArchs != null) {
                for (ArchitectureValue eachSimulatorArch : simulatorArchs) {
                    if (!eachSimulatorArch.equals((Object)eachOriginalBuildArch) && buildArchs.contains(eachSimulatorArch)) continue;
                    simulatorBuildArchs.add((Object)eachSimulatorArch);
                }
                continue;
            }
            simulatorBuildArchs.add((Object)eachOriginalBuildArch);
        }
        ImmutableSet immutableSet = simulatorBuildArchs.build();
        if (immutableSet == null) {
            ArchitectureValues.$$$reportNull$$$0(1);
        }
        return immutableSet;
    }

    @Nullable
    private static List<ArchitectureValue> getSimulatorBuildArch(@NotNull ArchitectureValue buildArch) {
        if (buildArch == null) {
            ArchitectureValues.$$$reportNull$$$0(2);
        }
        if (!CpuArch.isIntel64()) {
            return Collections.singletonList(buildArch);
        }
        ArchitectureType type = buildArch.getType();
        if (type != ArchitectureType.UNKNOWN) {
            return switch (type.getBits()) {
                case 32 -> Collections.singletonList(ArchitectureValue.i386);
                case 64 -> Arrays.asList(ArchitectureValue.arm64, ArchitectureValue.x86_64);
                default -> null;
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildArchs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/ArchitectureValues";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildArch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/ArchitectureValues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimulatorBuildArchs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimulatorBuildArchs";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSimulatorBuildArch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

