/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescription;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptionProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptions;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSpecification;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSpecificationProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProviderWithBase;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsUtilKt;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAware;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001<B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010-\u001a\u00020.H\u0016J\u0014\u00101\u001a\u0004\u0018\u00010\u001d2\b\u00102\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u0001032\b\u00102\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u00104\u001a\u0004\u0018\u00010\f2\b\u00105\u001a\u0004\u0018\u00010\fH\u0016J\b\u00106\u001a\u00020\fH\u0017J\u0013\u00107\u001a\u00020\u00192\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\b\u0010:\u001a\u00020;H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u001aR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010*\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\f0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010(\u00a8\u0006="}, d2={"Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingValuesProvider;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSpecificationProvider;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptionProvider;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/DomainAware;", "file", "Ljava/nio/file/Path;", "plist", "Lcom/jetbrains/cidr/xcode/plist/Plist;", "platform", "Lcom/jetbrains/cidr/xcode/frameworks/ApplePlatform;", "domain", "", "<init>", "(Ljava/nio/file/Path;Lcom/jetbrains/cidr/xcode/plist/Plist;Lcom/jetbrains/cidr/xcode/frameworks/ApplePlatform;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "basedOnRef", "getDomain", "name", "getName", "description", "getDescription", "isAbstract", "", "()Z", "settings", "", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSpecification;", "getSettings", "()Ljava/util/Map;", "descriptions", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions;", "getDescriptions", "()Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions;", "inputFileTypes", "", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler$InputFileType;", "getInputFileTypes", "()Ljava/util/Set;", "settingValuesProvider", "baseCompiler", "getBaseCompiler", "()Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler;", "getDeclaredBuildSettingValues", "Lcom/jetbrains/cidr/xcode/Dictionary;", "buildSettings", "getBuildSettings", "getSpecification", "settingName", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescription;", "getCategoryDescription", "categoryName", "toString", "equals", "other", "", "hashCode", "", "InputFileType", "intellij.cidr.xcodeModel.core"})
@SourceDebugExtension(value={"SMAP\nAppleCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppleCompiler.kt\ncom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class AppleCompiler
implements BuildSettingValuesProvider,
BuildSettingSpecificationProvider,
BuildSettingDescriptionProvider,
DomainAware {
    @NotNull
    private final ApplePlatform platform;
    @NotNull
    private final String id;
    @Nullable
    private final String basedOnRef;
    @Nullable
    private final String domain;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    private final boolean isAbstract;
    @NotNull
    private final Map<String, BuildSettingSpecification> settings;
    @Nullable
    private final BuildSettingDescriptions descriptions;
    @NotNull
    private final Set<InputFileType> inputFileTypes;
    @NotNull
    private final BuildSettingValuesProvider settingValuesProvider;

    public AppleCompiler(@NotNull Path file, @NotNull Plist plist, @NotNull ApplePlatform platform, @Nullable String domain) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
        String string = plist.getNotNullString("Identifier");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNotNullString(...)");
        this.id = string;
        this.basedOnRef = plist.getString("BasedOn");
        this.domain = plist.getString("Domain", domain);
        this.name = plist.getString("Name");
        this.description = plist.getString("Description");
        Boolean bl = plist.getBoolean("IsAbstract", Boolean.valueOf(false));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getBoolean(...)");
        this.isAbstract = bl;
        List settings = plist.getAttributeList("Options", Dictionary.class, CollectionsKt.emptyList());
        LinkedHashMap settingsSpecifications = new LinkedHashMap();
        for (Dictionary each : settings) {
            AppleBuildSystem.readSetting(file, each, settingsSpecifications, null);
        }
        Map map = Collections.unmodifiableMap(settingsSpecifications);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        this.settings = map;
        if (this.name != null) {
            Path specDir = file.getParent();
            String stringsFile = this.name + ".strings";
            Path[] pathArray = new Path[3];
            Intrinsics.checkNotNullExpressionValue((Object)specDir.resolve(stringsFile), (String)"resolve(...)");
            String[] stringArray = new String[]{"English.lproj", stringsFile};
            Intrinsics.checkNotNullExpressionValue((Object)specDir.resolve(FileUtil.join((String[])stringArray)), (String)"resolve(...)");
            stringArray = new String[]{"en.lproj", stringsFile};
            Intrinsics.checkNotNullExpressionValue((Object)specDir.resolve(FileUtil.join((String[])stringArray)), (String)"resolve(...)");
            this.descriptions = BuildSettingsUtilKt.loadDescriptionsLayout(pathArray);
        } else {
            this.descriptions = null;
        }
        List inputFileTypes = plist.getAttributeList("InputFileTypes", Object.class, CollectionsKt.emptyList());
        Intrinsics.checkNotNull((Object)inputFileTypes);
        this.inputFileTypes = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)inputFileTypes), AppleCompiler::_init_$lambda$0));
        this.settingValuesProvider = new BuildSettingValuesProviderWithBase(){

            @Override
            protected BuildSettingValuesProvider getBase() {
                return this.getBaseCompiler();
            }

            @Override
            protected Dictionary getSettings() {
                Dictionary result = new Dictionary();
                for (Map.Entry<String, BuildSettingSpecification> entry : this.getSettings().entrySet()) {
                    String key = entry.getKey();
                    BuildSettingSpecification value = entry.getValue();
                    Object defaultValue = value.getDefaultValue();
                    if (defaultValue == null) continue;
                    ((Map)result).put(key, defaultValue);
                }
                return result;
            }
        };
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    @NotNull
    public final Map<String, BuildSettingSpecification> getSettings() {
        return this.settings;
    }

    @Nullable
    public final BuildSettingDescriptions getDescriptions() {
        return this.descriptions;
    }

    @NotNull
    public final Set<InputFileType> getInputFileTypes() {
        return this.inputFileTypes;
    }

    @Nullable
    public final AppleCompiler getBaseCompiler() {
        return this.platform.findCompilerByRef(this.basedOnRef);
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.settingValuesProvider.getDeclaredBuildSettingValues();
        Intrinsics.checkNotNullExpressionValue((Object)dictionary, (String)"getDeclaredBuildSettingValues(...)");
        return dictionary;
    }

    @Override
    @NotNull
    public Set<String> getBuildSettings() {
        Object object;
        return SetsKt.plus(this.settings.keySet(), (Iterable)((object = this.getBaseCompiler()) != null && (object = ((AppleCompiler)object).getBuildSettings()) != null ? (Iterable)object : (Iterable)SetsKt.emptySet()));
    }

    @Override
    @Nullable
    public BuildSettingSpecification getSpecification(@Nullable String settingName) {
        if (settingName == null) {
            return null;
        }
        BuildSettingSpecification buildSettingSpecification = this.settings.get(settingName);
        if (buildSettingSpecification == null) {
            AppleCompiler appleCompiler = this.getBaseCompiler();
            buildSettingSpecification = appleCompiler != null ? appleCompiler.getSpecification(settingName) : null;
        }
        return buildSettingSpecification;
    }

    @Override
    @Nullable
    public BuildSettingDescription getDescription(@Nullable String settingName) {
        if (settingName == null) {
            return null;
        }
        Object object = this.descriptions;
        if (object == null || (object = ((BuildSettingDescriptions)object).getDescription(settingName)) == null) {
            AppleCompiler appleCompiler = this.getBaseCompiler();
            object = appleCompiler != null ? appleCompiler.getDescription(settingName) : null;
        }
        return object;
    }

    @Override
    @Nullable
    public String getCategoryDescription(@Nullable String categoryName) {
        if (categoryName == null) {
            return null;
        }
        Object object = this.descriptions;
        if (object == null || (object = ((BuildSettingDescriptions)object).getCategoryDescription(categoryName)) == null) {
            AppleCompiler appleCompiler = this.getBaseCompiler();
            object = appleCompiler != null ? appleCompiler.getCategoryDescription(categoryName) : null;
            if (object == null) {
                object = categoryName;
            }
        }
        Object description = object;
        return this.name + " - " + (String)description;
    }

    @NonNls
    @NotNull
    public String toString() {
        Object object;
        String string;
        Object object2;
        block7: {
            block6: {
                String it;
                block5: {
                    block4: {
                        object2 = this.getDomain();
                        if (object2 == null) break block4;
                        it = object2;
                        boolean bl = false;
                        String string2 = it + ":";
                        object2 = string2;
                        if (string2 != null) break block5;
                    }
                    object2 = "";
                }
                string = this.id;
                object = this.basedOnRef;
                if (object == null) break block6;
                it = object;
                String string3 = string;
                Object object3 = object2;
                boolean bl = false;
                String string4 = "Based on: " + it;
                object2 = object3;
                string = string3;
                String string5 = string4;
                object = string5;
                if (string5 != null) break block7;
            }
            object = "";
        }
        return "Compiler: " + (String)object2 + string + " " + (String)object;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleCompiler");
        AppleCompiler cfr_ignored_0 = (AppleCompiler)object2;
        if (!Intrinsics.areEqual((Object)this.id, (Object)((AppleCompiler)other).id)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getDomain(), (Object)((AppleCompiler)other).getDomain());
    }

    public int hashCode() {
        int result = this.id.hashCode();
        String string = this.getDomain();
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    private static final InputFileType _init_$lambda$0(Object it) {
        InputFileType inputFileType;
        Object object = it;
        if (object instanceof String) {
            inputFileType = new InputFileType((String)it);
        } else if (object instanceof Dictionary) {
            inputFileType = new InputFileType((Dictionary)it);
        } else {
            throw new RuntimeException("Unknown InputFileType " + it);
        }
        return inputFileType;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler$InputFileType;", "", "fileType", "", "<init>", "(Ljava/lang/String;)V", "dictionary", "Lcom/jetbrains/cidr/xcode/Dictionary;", "(Lcom/jetbrains/cidr/xcode/Dictionary;)V", "getFileType", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.xcodeModel.core"})
    public static final class InputFileType {
        @NotNull
        private final String fileType;

        public InputFileType(@NotNull String fileType) {
            Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
            this.fileType = fileType;
        }

        @NotNull
        public final String getFileType() {
            return this.fileType;
        }

        public InputFileType(@NotNull Dictionary dictionary) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            String string = dictionary.getNotNullString("FileType");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNotNullString(...)");
            this(string);
        }

        @NotNull
        public final String component1() {
            return this.fileType;
        }

        @NotNull
        public final InputFileType copy(@NotNull String fileType) {
            Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
            return new InputFileType(fileType);
        }

        public static /* synthetic */ InputFileType copy$default(InputFileType inputFileType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = inputFileType.fileType;
            }
            return inputFileType.copy(string);
        }

        @NotNull
        public String toString() {
            return "InputFileType(fileType=" + this.fileType + ")";
        }

        public int hashCode() {
            return this.fileType.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputFileType)) {
                return false;
            }
            InputFileType inputFileType = (InputFileType)other;
            return Intrinsics.areEqual((Object)this.fileType, (Object)inputFileType.fileType);
        }
    }
}

