/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAndID;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAwareKt;
import org.jetbrains.annotations.Nullable;

public abstract class AppleBuildSystemProviderImpl
implements AppleBuildSystemProvider {
    @Nullable
    private final AppleBuildSystemProvider myParent;

    public AppleBuildSystemProviderImpl(@Nullable AppleBuildSystemProvider parent) {
        this.myParent = parent;
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable String id, @Nullable String domain) {
        if (id == null) {
            return null;
        }
        for (AppleBuildSystem each : this.getBuildSystems()) {
            if (!each.getId().equals(id) || !DomainAwareKt.isSuitableDomain(each, domain)) continue;
            return each;
        }
        return this.myParent == null ? null : this.myParent.findBuildSystem(id, this.myParent.getDomain());
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type, @Nullable String domain) {
        return this.findBuildSystem(type == null ? null : type.getId(), domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystemByRef(@Nullable String ref) {
        if (ref == null) {
            return null;
        }
        DomainAndID domainAndId = new DomainAndID(ref);
        String domain = domainAndId.getDomain();
        if (domain != null) {
            AppleBuildSystemProvider provider;
            AppleBuildSystemProvider appleBuildSystemProvider = provider = "default".equals(domain) ? this.myParent : this;
            if (provider != null) {
                return provider.findBuildSystem(domainAndId.getId(), domain);
            }
        }
        return this.findBuildSystem(domainAndId.getId(), this.getDomain());
    }
}

