/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.NullableFunction;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescription;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptionProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptions;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSpecification;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSpecificationProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProviderWithBase;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsUtilKt;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAware;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.EnumBuildSettingSpecification;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppleBuildSystem
implements BuildSettingValuesProvider,
BuildSettingSpecificationProvider,
BuildSettingDescriptionProvider,
DomainAware {
    @NotNull
    private final AppleBuildSystemProvider myProvider;
    @NotNull
    private final String myId;
    @Nullable
    private final String myName;
    @Nullable
    private final String myDomain;
    @Nullable
    private final String myBasedOnRef;
    @NotNull
    private final Map<String, BuildSettingSpecification> mySettings;
    @NotNull
    private final BuildSettingValuesProvider mySettingValuesProvider;
    @Nullable
    private final BuildSettingDescriptions myDescriptions;

    public AppleBuildSystem(@NotNull Path file, @NotNull Plist plist, @NotNull AppleBuildSystemProvider provider, @Nullable NullableFunction<String, List<Object>> enumValuesOverrider, @Nullable String domain) {
        if (file == null) {
            AppleBuildSystem.$$$reportNull$$$0(0);
        }
        if (plist == null) {
            AppleBuildSystem.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            AppleBuildSystem.$$$reportNull$$$0(2);
        }
        this.myProvider = provider;
        this.myId = plist.getNotNullString("Identifier");
        this.myName = plist.getString("Name");
        this.myBasedOnRef = plist.getString("BasedOn");
        this.myDomain = domain;
        List settings = plist.getAttributeList("Options", Dictionary.class, null);
        if (settings == null) {
            settings = plist.getAttributeList("Properties", Dictionary.class, Collections.emptyList());
        }
        LinkedHashMap<String, BuildSettingSpecification> result = new LinkedHashMap<String, BuildSettingSpecification>();
        for (Dictionary each : settings) {
            AppleBuildSystem.readSetting(file, each, result, enumValuesOverrider);
        }
        this.mySettings = Collections.unmodifiableMap(result);
        this.mySettingValuesProvider = new BuildSettingValuesProviderWithBase(){

            @Override
            protected BuildSettingValuesProvider getBase() {
                return AppleBuildSystem.this.getBaseBuildSystem();
            }

            @Override
            @NotNull
            protected Dictionary getSettings() {
                Dictionary result = new Dictionary();
                for (Map.Entry<String, BuildSettingSpecification> each : AppleBuildSystem.this.mySettings.entrySet()) {
                    Object defaultValue = each.getValue().getDefaultValue();
                    if (defaultValue == null) continue;
                    result.put(each.getKey(), defaultValue);
                }
                Dictionary dictionary = result;
                if (dictionary == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem$1", "getSettings"));
            }
        };
        Path specDir = file.getParent();
        String stringsFile = this.myName + ".strings";
        this.myDescriptions = BuildSettingsUtilKt.loadDescriptionsLayout(specDir.resolve(stringsFile), specDir.resolve(FileUtil.join((String[])new String[]{"English.lproj", stringsFile})), specDir.resolve(FileUtil.join((String[])new String[]{"en.lproj", stringsFile})));
    }

    public static void readSetting(@NotNull Path file, @NotNull Dictionary each, @NotNull Map<String, BuildSettingSpecification> result, @Nullable NullableFunction<String, List<Object>> enumValuesOverrider) {
        BuildSettingSpecification desc;
        if (file == null) {
            AppleBuildSystem.$$$reportNull$$$0(3);
        }
        if (each == null) {
            AppleBuildSystem.$$$reportNull$$$0(4);
        }
        if (result == null) {
            AppleBuildSystem.$$$reportNull$$$0(5);
        }
        String name = each.getString("Name");
        String displayName = each.getString("DisplayName");
        String description = each.getString("Description");
        @NonNls String type = each.getString("Type");
        String uiType = each.getString("UIType");
        String category = each.getString("Category");
        Object defValue = each.getAttribute("DefaultValue", null);
        if (name == null) {
            XCLog.LOG.debug("Cannot read build option's name in file: " + String.valueOf(file) + ":\n" + String.valueOf(each));
            return;
        }
        if ("Enumeration".equalsIgnoreCase(type) || "enum".equalsIgnoreCase(type)) {
            List values = null;
            if (enumValuesOverrider != null) {
                values = (List)enumValuesOverrider.fun((Object)name);
            }
            if (values == null) {
                values = each.getAttributeList("Values", Object.class, Collections.emptyList());
            }
            desc = new EnumBuildSettingSpecification(name, values, displayName, description, uiType, category, defValue);
        } else {
            BuildSettingSpecification.Type convertedType;
            if (type == null || "String".equalsIgnoreCase(type)) {
                convertedType = BuildSettingSpecification.Type.STRING;
            } else if ("Boolean".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
                convertedType = BuildSettingSpecification.Type.BOOLEAN;
            } else if ("StringList".equalsIgnoreCase(type)) {
                convertedType = BuildSettingSpecification.Type.STRING_LIST;
            } else if ("Path".equalsIgnoreCase(type)) {
                convertedType = BuildSettingSpecification.Type.PATH;
            } else if ("PathList".equalsIgnoreCase(type)) {
                convertedType = BuildSettingSpecification.Type.PATH_LIST;
            } else if ("CompilerVersion".equalsIgnoreCase(type) || "CodeSignIdentity".equalsIgnoreCase(type) || "ProvisioningProfile".equalsIgnoreCase(type) || "ProvisioningProfileSpecifier".equalsIgnoreCase(type) || "DevelopmentTeam".equalsIgnoreCase(type) || "CodeSignStyle".equalsIgnoreCase(type)) {
                convertedType = BuildSettingSpecification.Type.STRING;
            } else {
                XCLog.LOG.warn("unknown build setting type in file " + String.valueOf(file) + ":\n" + String.valueOf(each));
                convertedType = BuildSettingSpecification.Type.STRING;
            }
            desc = new BuildSettingSpecification(convertedType, name, displayName, description, uiType, category, defValue);
        }
        result.put(name, desc);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            AppleBuildSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        AppleBuildSystem base = this.getBaseBuildSystem();
        return base == null ? null : base.getName();
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.myDomain;
    }

    @Nullable
    public AppleBuildSystem getBaseBuildSystem() {
        return this.myBasedOnRef == null ? null : this.myProvider.findBuildSystemByRef(this.myBasedOnRef);
    }

    @Nullable
    public String getBaseBuildSystemRef() {
        return this.myBasedOnRef;
    }

    @Override
    @NotNull
    public Set<String> getBuildSettings() {
        Set<String> result = this.mySettings.keySet();
        AppleBuildSystem base = this.getBaseBuildSystem();
        if (base != null) {
            result = new HashSet<String>(result);
            result.addAll(base.getBuildSettings());
        }
        Set<String> set = Collections.unmodifiableSet(result);
        if (set == null) {
            AppleBuildSystem.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Override
    @Nullable
    public BuildSettingSpecification getSpecification(@Nullable String settingName) {
        if (settingName == null) {
            return null;
        }
        BuildSettingSpecification result = this.mySettings.get(settingName);
        if (result == null) {
            AppleBuildSystem base = this.getBaseBuildSystem();
            result = base != null ? base.getSpecification(settingName) : null;
        }
        return result;
    }

    @Override
    @Nullable
    public BuildSettingDescription getDescription(@Nullable String settingName) {
        BuildSettingDescription result;
        if (settingName == null) {
            return null;
        }
        BuildSettingDescription buildSettingDescription = result = this.myDescriptions != null ? this.myDescriptions.getDescription(settingName) : null;
        if (result == null) {
            AppleBuildSystem base = this.getBaseBuildSystem();
            result = base != null ? base.getDescription(settingName) : null;
        }
        return result;
    }

    @Override
    @Nullable
    public String getCategoryDescription(@Nullable String category) {
        String result;
        if (category == null) {
            return null;
        }
        String string = result = this.myDescriptions != null ? this.myDescriptions.getCategoryDescription(category) : null;
        if (result == null) {
            AppleBuildSystem base = this.getBaseBuildSystem();
            result = base != null ? base.getCategoryDescription(category) : null;
        }
        return result;
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.mySettingValuesProvider.getDeclaredBuildSettingValues();
        if (dictionary == null) {
            AppleBuildSystem.$$$reportNull$$$0(8);
        }
        return dictionary;
    }

    @NonNls
    public String toString() {
        return "Build System: " + (String)(this.myDomain != null ? this.myDomain + ":" : "") + this.myId + (String)(this.myBasedOnRef != null ? " Based on: " + this.myBasedOnRef : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSetting";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        CORE("com.apple.build-system.core"),
        NATIVE("com.apple.build-system.native"),
        STANDARD_SETTINGS("com.apple.buildsettings.standard");

        @NotNull
        @NonNls
        private final String myId;

        private Type(String id) {
            if (id == null) {
                Type.$$$reportNull$$$0(0);
            }
            this.myId = id;
        }

        @NotNull
        @NonNls
        public String getId() {
            String string = this.myId;
            if (string == null) {
                Type.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem$Type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem$Type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

