/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecListHelper {
    private static final ConcurrentMap<Path, Plist> ourSpecs = ContainerUtil.createConcurrentSoftValueMap();

    public static <T> List<T> readSpecs(@NotNull Path file, @Nullable @NonNls String type, Factory<T> factory) {
        Plist plist;
        if (file == null) {
            SpecListHelper.$$$reportNull$$$0(0);
        }
        if ((plist = (Plist)ourSpecs.get(file)) == null) {
            plist = PlistDriver.readAnyFormatSafe((Path)file);
            if (plist == null) {
                return Collections.emptyList();
            }
            ourSpecs.put(file, plist);
        }
        return SpecListHelper.doReadSpecs(file, plist, type, factory);
    }

    public static <T> List<T> readSpecs(@NotNull Plist plist, @Nullable @NonNls String type, Factory<T> factory) {
        if (plist == null) {
            SpecListHelper.$$$reportNull$$$0(1);
        }
        return SpecListHelper.doReadSpecs(null, plist, type, factory);
    }

    private static <T> List<T> doReadSpecs(@Nullable Path file, @NotNull Plist plist, @Nullable @NonNls String type, Factory<T> factory) {
        if (plist == null) {
            SpecListHelper.$$$reportNull$$$0(2);
        }
        ArrayList result = new ArrayList();
        if (type == null || !SpecListHelper.addObject(type, factory, plist, result)) {
            for (Plist each : plist.getObjects(Plist.class)) {
                try {
                    SpecListHelper.addObject(type, factory, each, result);
                }
                catch (InvalidSpecException e) {
                    if (file != null) {
                        XCLog.LOG.error("Invalid plist file: " + String.valueOf(file), (Throwable)e);
                        continue;
                    }
                    XCLog.LOG.error("Invalid plist: " + String.valueOf(plist), (Throwable)e);
                }
            }
        }
        return result;
    }

    private static <T> boolean addObject(@Nullable @NonNls String type, Factory<T> factory, Plist plist, List<T> result) {
        T o;
        if ((type == null || type.equals(plist.getString("Type"))) && (o = factory.create(plist)) != null) {
            result.add(o);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/SpecListHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readSpecs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doReadSpecs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface Factory<T> {
        @Nullable
        public T create(@NotNull Plist var1) throws InvalidSpecException;
    }
}

