/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import com.jetbrains.apple.sdk.AppleSdkManagerBase;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.frameworks.AppleArchitecture;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.SpecListHelper;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProviderImpl;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import com.jetbrains.cidr.xcode.xcspec.XCSpecFile;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class AppleSdkManager
extends AppleSdkManagerBase
implements AppleBuildSystemProvider,
BuildSettingValuesProvider {
    private static final Pattern PLUGIN_PATTERN = Pattern.compile(".+\\.(?!ideplugin\\b)\\w*plugin\\w*");
    @NotNull
    private final List<ApplePlatform> mySortedPlatforms;
    @NotNull
    private final List<AppleSdk> mySortedSdks;
    @NotNull
    private final List<AppleSdk> mySwiftPackageSdks;
    @NotNull
    private final List<AppleBuildSystem> myBuildSystems;
    @NotNull
    private final AppleBuildSystemProvider myBuildSystemProvider;
    @NotNull
    private final Dictionary myBuiltInBuildSettings;

    @NotNull
    public static AppleSdkManager getInstance() {
        AppleSdkManager appleSdkManager = (AppleSdkManager)AppleSdkManagerBase.getInstance();
        if (appleSdkManager == null) {
            AppleSdkManager.$$$reportNull$$$0(0);
        }
        return appleSdkManager;
    }

    public AppleSdkManager() {
        XcodeBase xcode = XcodeBase.getInstance();
        XcodeExtensionsManager extensionsManager = XcodeExtensionsManager.getInstance();
        XCLog.LOG.info("Configuring SDKs for Xcode located in " + String.valueOf(xcode.getBaseFile()));
        ArrayList<ApplePlatform> platforms = new ArrayList<ApplePlatform>();
        ArrayList<AppleSdk> sdks = new ArrayList<AppleSdk>();
        ArrayList<AppleBuildSystem> buildSystems = new ArrayList<AppleBuildSystem>();
        Path platformsRoot = Path.of(xcode.getSubFilePath("Platforms"), new String[0]);
        this.readPlatforms(platformsRoot, platforms);
        ContainerUtil.sort(platforms);
        platforms.trimToSize();
        this.mySortedPlatforms = Collections.unmodifiableList(platforms);
        for (ApplePlatform platform : platforms) {
            this.readSdksFrom(platform.getSdksRoot(), sdks);
        }
        this.readBuildSystems(ContainerUtil.map2Set(platforms, it -> it.getType().getPlatformName()), buildSystems, extensionsManager);
        ContainerUtil.sort(sdks);
        sdks.trimToSize();
        this.mySortedSdks = Collections.unmodifiableList(sdks);
        this.mySwiftPackageSdks = AppleSdkManager.filterSwiftPackageSdks(this.mySortedSdks);
        buildSystems.trimToSize();
        this.myBuildSystems = Collections.unmodifiableList(buildSystems);
        this.myBuildSystemProvider = new AppleBuildSystemProviderImpl(null){

            @Override
            @NotNull
            public List<AppleBuildSystem> getBuildSystems() {
                List<AppleBuildSystem> list = AppleSdkManager.this.myBuildSystems;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            @NotNull
            public String getDomain() {
                return "default";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/AppleSdkManager$1", "getBuildSystems"));
            }
        };
        this.myBuiltInBuildSettings = this.fillBuiltInBuildSettings();
    }

    private void readPlatforms(@NotNull Path dir, List<ApplePlatform> result) {
        if (dir == null) {
            AppleSdkManager.$$$reportNull$$$0(1);
        }
        try (DirectoryStream<Path> platforms = Files.newDirectoryStream(dir, "*.platform");){
            for (Path eachPlatform : platforms) {
                try {
                    Plist spec = AppleSdkManager.readSpec(eachPlatform.resolve("Info.plist"));
                    if (spec == null) continue;
                    ApplePlatform platform = new ApplePlatform(eachPlatform, spec, this);
                    result.add(platform);
                    XCLog.LOG.info("Platform configured: '" + String.valueOf(platform) + "'");
                }
                catch (InvalidSpecException e) {
                    XCLog.LOG.info("invalid platform: " + String.valueOf(eachPlatform), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            XCLog.LOG.warn((Throwable)e);
        }
    }

    private void readSdksFrom(@NotNull Path dir, List<AppleSdk> result) {
        if (dir == null) {
            AppleSdkManager.$$$reportNull$$$0(2);
        }
        try (DirectoryStream<Path> sdks = Files.newDirectoryStream(dir, "*.sdk");){
            for (Path sdkRoot : sdks) {
                try {
                    sdkRoot = sdkRoot.toRealPath(new LinkOption[0]);
                }
                catch (IOException e) {
                    XCLog.LOG.warn((Throwable)e);
                }
                if (AppleSdkManager.findSdkByRootFile(sdkRoot, result) != null) continue;
                try {
                    Plist spec = AppleSdkManager.readSpec(sdkRoot.resolve("SDKSettings.plist"));
                    if (spec == null) continue;
                    AppleSdk sdk = AppleSdk.createFromSpec(sdkRoot, spec, this);
                    result.add(sdk);
                    XCLog.LOG.info("SDK configured: '" + String.valueOf(sdk) + "' for platform: '" + String.valueOf(sdk.getPlatform()) + "'");
                }
                catch (InvalidSpecException e) {
                    XCLog.LOG.info("invalid sdk: " + String.valueOf(sdkRoot), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            XCLog.LOG.warn((Throwable)e);
        }
    }

    private void readBuildSystems(@NotNull Set<String> platformDomains, List<AppleBuildSystem> result, @NotNull XcodeExtensionsManager extensionsManager) {
        if (platformDomains == null) {
            AppleSdkManager.$$$reportNull$$$0(3);
        }
        if (extensionsManager == null) {
            AppleSdkManager.$$$reportNull$$$0(4);
        }
        NullableFunction overrider = name -> {
            if ("MACOSX_DEPLOYMENT_TARGET".equals(name)) {
                AppleSdk sdk = (AppleSdk)ContainerUtil.getFirstItem(this.findSdksForPlatform(ApplePlatform.Type.MACOS));
                if (sdk == null) {
                    return null;
                }
                String maxVersion = sdk.getVersionString();
                ArrayList<Object> result1 = new ArrayList<Object>();
                result1.add("");
                for (int i = 6; i < 15; ++i) {
                    String eachVersion = "10." + i;
                    result1.add(eachVersion);
                    if (maxVersion.equals(eachVersion)) break;
                    if (i != 14) continue;
                    XCLog.LOG.error("Unexpected OS X version: " + maxVersion);
                }
                result1.trimToSize();
                return result1;
            }
            return null;
        };
        Set xcSpecFiles = platformDomains.stream().flatMap(it -> extensionsManager.getXCSpecFileList((String)it).stream()).collect(Collectors.toSet());
        for (XCSpecFile file : xcSpecFiles) {
            XCLog.LOG.debug("Processing xcspec file from XCSpecProvider: " + String.valueOf(file));
            result.addAll(SpecListHelper.readSpecs(file.getPath(), "BuildSystem", plist -> new AppleBuildSystem(file.getPath(), plist, this, (NullableFunction<String, List<Object>>)overrider, file.getDomain())));
        }
        for (Path eachSpecFolder : AppleSdkManager.getSpecsFolders()) {
            try {
                DirectoryStream<Path> specFiles = Files.newDirectoryStream(eachSpecFolder);
                try {
                    for (Path eachSpecFile : specFiles) {
                        if (!StringUtil.endsWithIgnoreCase((String)eachSpecFile.getFileName().toString(), (String)".xcspec")) continue;
                        result.addAll(SpecListHelper.readSpecs(eachSpecFile, "BuildSystem", plist -> new AppleBuildSystem(eachSpecFile, plist, this, (NullableFunction<String, List<Object>>)overrider, "default")));
                    }
                }
                finally {
                    if (specFiles == null) continue;
                    specFiles.close();
                }
            }
            catch (IOException e) {
                XCLog.LOG.warn((Throwable)e);
            }
        }
    }

    @Deprecated
    @NotNull
    static List<Path> getSpecsFolders() {
        XcodeBase xcode = XcodeBase.getInstance();
        if (xcode.getVersion().isOrGreaterThan(Integer.valueOf(13), Integer.valueOf(3))) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                AppleSdkManager.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<Path> result = new ArrayList<Path>();
        AppleSdkManager.collectSpecDirs(xcode.getBaseFile().toPath(), result);
        AppleSdkManager.collectSpecDirs(xcode.getApplicationContentsSubFile(null).toPath(), result);
        AppleSdkManager.collectSpecDirs(xcode.getSubFile("Library").toPath(), result);
        AppleSdkManager.collectSpecDirs(xcode.getSubFile("Library/Xcode").toPath(), result);
        ArrayList<Path> arrayList = result;
        if (arrayList == null) {
            AppleSdkManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void collectSpecDirs(Path parent, List<Path> result) {
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(parent);){
            for (Path eachDir : dirs) {
                if ("OtherFrameworks".equals(eachDir.getFileName().toString())) continue;
                try {
                    DirectoryStream<Path> subDirs = Files.newDirectoryStream(eachDir);
                    try {
                        for (Path eachSubDir : subDirs) {
                            String name = eachSubDir.getFileName().toString();
                            if (name.endsWith(".framework")) {
                                result.add(eachSubDir.resolve("Resources"));
                            } else if (PLUGIN_PATTERN.matcher(name).matches()) {
                                result.add(eachSubDir.resolve("Contents/Resources"));
                            }
                            if (!name.endsWith(".ideplugin")) continue;
                            try {
                                DirectoryStream<Path> pluginFrameworksDir = Files.newDirectoryStream(eachSubDir.resolve("Contents/Frameworks"));
                                try {
                                    for (Path eachPluginFramework : pluginFrameworksDir) {
                                        String frameworkName = eachPluginFramework.getFileName().toString();
                                        if (!frameworkName.endsWith(".framework")) continue;
                                        result.add(eachPluginFramework.resolve("Resources"));
                                    }
                                }
                                finally {
                                    if (pluginFrameworksDir == null) continue;
                                    pluginFrameworksDir.close();
                                }
                            }
                            catch (IOException e) {
                                XCLog.LOG.warn((Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (subDirs == null) continue;
                        subDirs.close();
                    }
                }
                catch (IOException e) {
                    XCLog.LOG.warn((Throwable)e);
                }
            }
        }
        catch (IOException e) {
            XCLog.LOG.warn((Throwable)e);
        }
    }

    @Nullable
    private static Plist readSpec(Path settingsFile) {
        return !Files.exists(settingsFile, new LinkOption[0]) || Files.isDirectory(settingsFile, new LinkOption[0]) ? null : PlistDriver.readAnyFormatSafe((File)settingsFile.toFile());
    }

    private Dictionary fillBuiltInBuildSettings() {
        Dictionary result = new Dictionary();
        result.setAttribute("MAC_OS_X_VERSION_ACTUAL", (Object)AppleSdkManager.getMacOSVersionCode());
        result.setAttribute("MAC_OS_X_VERSION_MAJOR", (Object)AppleSdkManager.getMacOSMajorVersionCode());
        result.setAttribute("MAC_OS_X_VERSION_MINOR", (Object)AppleSdkManager.getMacOSMinorVersionCode());
        result.setAttribute("HOME", (Object)"~");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_APPS_DIR", "/Applications");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_ADMIN_APPS_DIR", "/Applications/Utilities");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEMOS_DIR", "/Applications/Extras");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_DIR", XcodeBase.getInstance().getBasePath());
        AppleSdkManager.addBuildSettingPath(result, "DEVELOPER_DIR", "$(SYSTEM_DEVELOPER_DIR)");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_APPS_DIR", XcodeBase.getInstance().getApplicationsSubFilePath(null));
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_JAVA_TOOLS_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Java Tools");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_PERFORMANCE_TOOLS_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Performance Tools");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_GRAPHICS_TOOLS_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Graphics Tools");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_UTILITIES_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Utilities");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_DEMOS_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Utilities/Built Examples");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_DOC_DIR", "$(SYSTEM_DEVELOPER_DIR)/ADC Reference Library");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_TOOLS_DOC_DIR", "$(SYSTEM_DEVELOPER_DIR)/ADC Reference Library/documentation/DeveloperTools");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_RELEASENOTES_DIR", "$(SYSTEM_DEVELOPER_DIR)/ADC Reference Library/releasenotes");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DEVELOPER_TOOLS_RELEASENOTES_DIR", "$(SYSTEM_DEVELOPER_DIR)/ADC Reference Library/releasenotes/DeveloperTools");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_LIBRARY_DIR", "/System/Library");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_CORE_SERVICES_DIR", "/System/Library/CoreServices");
        AppleSdkManager.addBuildSettingPath(result, "SYSTEM_DOCUMENTATION_DIR", "/Library/Documentation");
        AppleSdkManager.addBuildSettingPath(result, "LOCAL_ADMIN_APPS_DIR", "/Applications/Utilities");
        AppleSdkManager.addBuildSettingPath(result, "LOCAL_APPS_DIR", "/Applications");
        AppleSdkManager.addBuildSettingPath(result, "LOCAL_DEVELOPER_DIR", "/Library/Developer");
        AppleSdkManager.addBuildSettingPath(result, "LOCAL_LIBRARY_DIR", "/Library");
        AppleSdkManager.addBuildSettingPath(result, "USER_APPS_DIR", "$(HOME)/Applications");
        AppleSdkManager.addBuildSettingPath(result, "USER_LIBRARY_DIR", "$(HOME)/Library");
        AppleSdkManager.addBuildSettingPath(result, "MAN_PAGE_DIRECTORIES", "/usr/share/man");
        AppleSdk defaultSdk = this.getDefaultSdk();
        AppleSdkManager.addBuildSettingPath(result, "DEVELOPER_SDK_DIR", defaultSdk != null ? defaultSdk.getRoot().getParent().toString() : "$(SYSTEM_DEVELOPER_DIR)/SDKs");
        AppleSdkManager.addBuildSettingPath(result, "CONFIGURATION_BUILD_DIR", "$(BUILD_DIR)/$(CONFIGURATION)$(EFFECTIVE_PLATFORM_NAME)");
        AppleSdkManager.addBuildSettingPath(result, "CONFIGURATION_TEMP_DIR", "$(PROJECT_TEMP_DIR)/$(CONFIGURATION)$(EFFECTIVE_PLATFORM_NAME)");
        return result;
    }

    private static void addBuildSettingPath(Dictionary settings, @NonNls @NotNull String name, @NonNls @NotNull String value) {
        if (name == null) {
            AppleSdkManager.$$$reportNull$$$0(7);
        }
        if (value == null) {
            AppleSdkManager.$$$reportNull$$$0(8);
        }
        settings.setAttribute(name, (value = value.trim()).contains(" ") ? "\"" + StringUtil.escapeQuotes((String)value) + "\"" : value);
    }

    @NotNull
    public List<ApplePlatform> getPlatforms() {
        List<ApplePlatform> list = this.mySortedPlatforms;
        if (list == null) {
            AppleSdkManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public ApplePlatform findPlatformByName(@Nullable String platformName) {
        if (platformName == null) {
            return null;
        }
        for (ApplePlatform each : this.mySortedPlatforms) {
            if (!each.getName().equals(platformName)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public ApplePlatform findPlatformByType(@Nullable ApplePlatform.Type type) {
        if (type == null) {
            return null;
        }
        for (ApplePlatform each : this.mySortedPlatforms) {
            if (each.getType() != type) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public ApplePlatform findPlatformBySettingValue(@Nullable String settingValue) {
        return this.findPlatformByType(AppleSdkManager.getPlatformTypeBySettingValue(settingValue));
    }

    @Nullable
    public ApplePlatform findPlatformByID(@NotNull String identifier) {
        if (identifier == null) {
            AppleSdkManager.$$$reportNull$$$0(10);
        }
        for (ApplePlatform platform : this.mySortedPlatforms) {
            if (!identifier.equalsIgnoreCase(platform.getIdentifier())) continue;
            return platform;
        }
        return null;
    }

    @NotNull
    public static ApplePlatform.Type getPlatformTypeBySettingValue(@Nullable String value) {
        if (value != null) {
            for (ApplePlatform.Type each : ApplePlatform.Type.values()) {
                if (!value.startsWith(each.getPlatformName())) continue;
                ApplePlatform.Type type = each;
                if (type == null) {
                    AppleSdkManager.$$$reportNull$$$0(11);
                }
                return type;
            }
        }
        ApplePlatform.Type type = ApplePlatform.Type.MACOS;
        if (type == null) {
            AppleSdkManager.$$$reportNull$$$0(12);
        }
        return type;
    }

    @NotNull
    public List<AppleSdk> getSdks() {
        List<AppleSdk> list = this.mySortedSdks;
        if (list == null) {
            AppleSdkManager.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<AppleSdk> getSwiftSdks() {
        List<AppleSdk> list = this.mySwiftPackageSdks;
        if (list == null) {
            AppleSdkManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static List<AppleSdk> filterSwiftPackageSdks(@NotNull List<AppleSdk> sdks) {
        if (sdks == null) {
            AppleSdkManager.$$$reportNull$$$0(15);
        }
        ArrayList<AppleSdk> result = new ArrayList<AppleSdk>();
        for (AppleSdk sdk : sdks) {
            ApplePlatform platform = sdk.getPlatform();
            if (platform.getFamilyIdentifier().equals("driverkit") || platform.getFamilyIdentifier().equals("xros")) continue;
            if (platform.isIOS() || platform.isTv()) {
                result.add(sdk);
                continue;
            }
            if (!platform.isMacOS()) continue;
            result.add(sdk);
            AppleSdk catalystSdk = sdk.getCatalystVariant();
            if (catalystSdk == null) continue;
            result.add(catalystSdk);
        }
        ArrayList<AppleSdk> arrayList = result;
        if (arrayList == null) {
            AppleSdkManager.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    public AppleSdk getHostSwiftSdk() {
        return this.getDefaultSdk();
    }

    @Nullable
    public AppleSdk getDefaultSdk() {
        return (AppleSdk)ContainerUtil.find(this.findSdksForPlatform(ApplePlatform.Type.MACOS), it -> it.getName().startsWith("macosx"));
    }

    @Nullable
    public AppleSdk findSdk(@NotNull String name) {
        if (name == null) {
            AppleSdkManager.$$$reportNull$$$0(17);
        }
        for (AppleSdk each : this.mySortedSdks) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public AppleSdk findSdkByRootFile(@Nullable Path root) {
        try {
            root = root != null ? root.toRealPath(new LinkOption[0]) : null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return AppleSdkManager.findSdkByRootFile(root, this.mySortedSdks);
    }

    @Nullable
    private static AppleSdk findSdkByRootFile(@Nullable Path root, @NotNull List<AppleSdk> sdks) {
        if (sdks == null) {
            AppleSdkManager.$$$reportNull$$$0(18);
        }
        if (root == null) {
            return null;
        }
        for (AppleSdk each : sdks) {
            if (!root.equals(each.getRoot())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public AppleSdk findSdkBySettingValue(@Nullable String value) {
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return this.getDefaultSdk();
        }
        AppleSdk result = this.findSdk(value);
        if (result != null) {
            return result;
        }
        ApplePlatform platform = this.findPlatformByName(value);
        if (platform != null) {
            return (AppleSdk)ContainerUtil.getFirstItem(platform.getSdks());
        }
        return this.findSdkByPath(value);
    }

    @Nullable
    public AppleSdk findSdkByPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        try {
            path = Path.of(path, new String[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (AppleSdk each : this.mySortedSdks) {
            if (!FileUtil.pathsEqual((String)each.getRoot().toString(), (String)path)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public List<AppleSdk> findSdksForPlatformName(@NotNull String name) {
        if (name == null) {
            AppleSdkManager.$$$reportNull$$$0(19);
        }
        List<AppleSdk> list = this.findSdksForPlatform(AppleSdkManager.getPlatformTypeBySettingValue(name));
        if (list == null) {
            AppleSdkManager.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public List<AppleSdk> findSdksForPlatform(@Nullable ApplePlatform.Type type) {
        if (type == null) {
            List<AppleSdk> list = Collections.emptyList();
            if (list == null) {
                AppleSdkManager.$$$reportNull$$$0(21);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (AppleSdk each : this.mySortedSdks) {
            if (type != each.getPlatformType()) continue;
            result.add(each);
        }
        List<AppleSdk> list = Collections.unmodifiableList(result);
        if (list == null) {
            AppleSdkManager.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public static String getStandardNativeArchitectureId(@Nullable ApplePlatform platform) {
        AppleArchitecture standard;
        if (platform != null && (standard = platform.getStandardNativeArchitecture()) != null) {
            List<String> realArchitectures = standard.getRealArchitectures();
            if (realArchitectures.contains(ArchitectureValue.HOST_ARCH.getId())) {
                String string = ArchitectureValue.HOST_ARCH.getId();
                if (string == null) {
                    AppleSdkManager.$$$reportNull$$$0(23);
                }
                return string;
            }
            String id = (String)ContainerUtil.getFirstItem(realArchitectures);
            if (id != null) {
                String string = id;
                if (string == null) {
                    AppleSdkManager.$$$reportNull$$$0(24);
                }
                return string;
            }
        }
        return AppleSdkManager.getActualMacOSNativeArchitectureId();
    }

    @NotNull
    @NonNls
    public static String getActualMacOSNativeArchitectureId() {
        String string = ArchitectureValue.HOST_ARCH.getId();
        if (string == null) {
            AppleSdkManager.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type) {
        return this.myBuildSystemProvider.findBuildSystem(type, this.myBuildSystemProvider.getDomain());
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type, @Nullable String domain) {
        return this.myBuildSystemProvider.findBuildSystem(type, domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable String id, @Nullable String domain) {
        return this.myBuildSystemProvider.findBuildSystem(id, domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystemByRef(@Nullable String ref) {
        return this.myBuildSystemProvider.findBuildSystemByRef(ref);
    }

    @Override
    @NotNull
    public List<AppleBuildSystem> getBuildSystems() {
        List<AppleBuildSystem> list = this.myBuildSystemProvider.getBuildSystems();
        if (list == null) {
            AppleSdkManager.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.myBuildSystemProvider.getDomain();
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.myBuiltInBuildSettings;
        if (dictionary == null) {
            AppleSdkManager.$$$reportNull$$$0(27);
        }
        return dictionary;
    }

    @NotNull
    public static String getMacOSVersionCode() {
        return AppleSdkManager.getMacOSVersionCode(OS.CURRENT.parsedVersion());
    }

    @NotNull
    public static String getMacOSMajorVersionCode() {
        return AppleSdkManager.getMacOSMajorVersionCode(OS.CURRENT.parsedVersion());
    }

    @NotNull
    public static String getMacOSMinorVersionCode() {
        return AppleSdkManager.getMacOSMinorVersionCode(OS.CURRENT.parsedVersion());
    }

    @VisibleForTesting
    @NotNull
    public static String getMacOSVersionCode(@NotNull Version v) {
        if (v == null) {
            AppleSdkManager.$$$reportNull$$$0(28);
        }
        String string = String.format("%02d%d%d", v.major, AppleSdkManager.normalize(v.minor), AppleSdkManager.normalize(v.bugfix));
        if (string == null) {
            AppleSdkManager.$$$reportNull$$$0(29);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static String getMacOSMajorVersionCode(@NotNull Version v) {
        if (v == null) {
            AppleSdkManager.$$$reportNull$$$0(30);
        }
        String string = String.format("%02d%d%d", v.major, AppleSdkManager.normalize(v.minor), 0);
        if (string == null) {
            AppleSdkManager.$$$reportNull$$$0(31);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static String getMacOSMinorVersionCode(@NotNull Version v) {
        if (v == null) {
            AppleSdkManager.$$$reportNull$$$0(32);
        }
        String string = String.format("%02d%02d", v.minor, v.bugfix);
        if (string == null) {
            AppleSdkManager.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static int normalize(int number) {
        return Math.min(number, 9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 7, 8, 10, 15, 17, 18, 19, 28, 30, 32 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/AppleSdkManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformDomains";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsManager";
                break;
            }
            case 7: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/AppleSdkManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecsFolders";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatforms";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformTypeBySettingValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwiftSdks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSwiftPackageSdks";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findSdksForPlatformName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findSdksForPlatform";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardNativeArchitectureId";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualMacOSNativeArchitectureId";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSystems";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSVersionCode";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMajorVersionCode";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMinorVersionCode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readPlatforms";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSdksFrom";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readBuildSystems";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBuildSettingPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPlatformByID";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterSwiftPackageSdks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSdk";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByRootFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSdksForPlatformName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSVersionCode";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSMajorVersionCode";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSMinorVersionCode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 7, 8, 10, 15, 17, 18, 19, 28, 30, 32 -> new IllegalArgumentException(string);
        };
    }
}

