/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.apple.sdk.AppleSdkBase;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppleSdk
extends AppleSdkBase
implements BuildSettingValuesProvider {
    @NonNls
    public static final String[] DEFAULT_INCLUDE_PATHS = new String[]{"usr/include"};
    @NonNls
    public static final String[] DEFAULT_LIBRARIES_PATHS = new String[]{"usr/lib"};
    @NonNls
    public static final String[] DEFAULT_FRAMEWORK_PATHS = new String[]{"System/Library/Frameworks", "Library/Frameworks"};
    @NonNls
    public static final String[] DEVELOPER_FRAMEWORK_PATHS = new String[]{"Library/Frameworks"};
    @NonNls
    private static final String CATALYST_SDK_VARIANT = "iosmac";
    @NotNull
    private final Path myRoot;
    @NotNull
    private final String myCanonicalName;
    @NotNull
    @NlsSafe
    private final String myDisplayName;
    @NotNull
    private final String myVersionString;
    @NotNull
    private final String myFullVersion;
    @Nullable
    private final String myBuildVersion;
    @NotNull
    private final ApplePlatform myPlatform;
    @NotNull
    private final Dictionary myDeclaredBuildSettings;
    @Nullable
    @NlsSafe
    private final String myVariant;
    @NotNull
    private final Map<String, AppleSdk> myVariantsMap;
    private final boolean myIsDefaultVariant;
    private final String myUniqueId;
    private final String myDefaultLLVMTargetTripleBase;

    private AppleSdk(@NotNull Path root, @NotNull String canonicalName, @NotNull String displayName, @NotNull String versionString, @NotNull String fullVersion, @Nullable String buildVersion, @NotNull ApplePlatform platform, @NotNull Dictionary declaredBuildSettings, @Nullable String sdkVariant, @NotNull String defaultLLVMTargetTripleBase, boolean isDefaultVariant, @NotNull Map<String, AppleSdk> variantsMap) {
        if (root == null) {
            AppleSdk.$$$reportNull$$$0(0);
        }
        if (canonicalName == null) {
            AppleSdk.$$$reportNull$$$0(1);
        }
        if (displayName == null) {
            AppleSdk.$$$reportNull$$$0(2);
        }
        if (versionString == null) {
            AppleSdk.$$$reportNull$$$0(3);
        }
        if (fullVersion == null) {
            AppleSdk.$$$reportNull$$$0(4);
        }
        if (platform == null) {
            AppleSdk.$$$reportNull$$$0(5);
        }
        if (declaredBuildSettings == null) {
            AppleSdk.$$$reportNull$$$0(6);
        }
        if (defaultLLVMTargetTripleBase == null) {
            AppleSdk.$$$reportNull$$$0(7);
        }
        if (variantsMap == null) {
            AppleSdk.$$$reportNull$$$0(8);
        }
        this.myRoot = root;
        this.myCanonicalName = canonicalName;
        this.myDisplayName = displayName;
        this.myVersionString = versionString;
        this.myFullVersion = fullVersion;
        this.myBuildVersion = buildVersion;
        this.myPlatform = platform;
        this.myVariant = sdkVariant;
        this.myDeclaredBuildSettings = declaredBuildSettings;
        this.myIsDefaultVariant = isDefaultVariant;
        this.myVariantsMap = variantsMap;
        this.myDefaultLLVMTargetTripleBase = defaultLLVMTargetTripleBase;
        this.myUniqueId = this.myCanonicalName + ":" + this.myVariant + ":" + this.myFullVersion;
    }

    @Nullable
    public AppleSdk getCatalystVariant() {
        return this.getVariant(CATALYST_SDK_VARIANT);
    }

    @Nullable
    public AppleSdk getVariant(@NotNull String variant) {
        if (variant == null) {
            AppleSdk.$$$reportNull$$$0(9);
        }
        return this.myVariantsMap.get(variant);
    }

    public boolean isMacCatalyst() {
        return this.getPlatform().isMacOS() && CATALYST_SDK_VARIANT.equals(this.myVariant);
    }

    public boolean isIOSDevice() {
        return this.getPlatform().isIOSDevice();
    }

    public boolean isIOSSimulator() {
        return this.getPlatform().isIOSSimulator();
    }

    public boolean isTvDevice() {
        return this.getPlatform().isTvDevice();
    }

    public boolean isTvSimulator() {
        return this.getPlatform().isTvSimulator();
    }

    public boolean isVisionDevice() {
        return this.getPlatform().isVisionDevice();
    }

    public boolean isVisionSimulator() {
        return this.getPlatform().isVisionSimulator();
    }

    public boolean isWatchDevice() {
        return this.getPlatform().isWatchDevice();
    }

    public boolean isWatchSimulator() {
        return this.getPlatform().isWatchSimulator();
    }

    public boolean isMacOS() {
        return this.getPlatform().isMacOS();
    }

    public boolean isLinux() {
        return false;
    }

    public boolean isWindows() {
        return false;
    }

    @NotNull
    public String getUniqueID() {
        String string = this.myUniqueId;
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static AppleSdk createFromSpec(@NotNull Path root, @NotNull Plist spec, @NotNull AppleSdkManager manager) throws InvalidSpecException {
        if (root == null) {
            AppleSdk.$$$reportNull$$$0(11);
        }
        if (spec == null) {
            AppleSdk.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            AppleSdk.$$$reportNull$$$0(13);
        }
        Object name = spec.getString("CanonicalName");
        String displayName = spec.getString("DisplayName");
        Dictionary defaultProperties = AppleSdk.getDefaultProperties(spec);
        @NonNls String platformName = defaultProperties.getString("PLATFORM_NAME");
        String versionString = spec.getString("Version");
        String defaultVariant = spec.getString("DefaultVariant");
        if (name == null || displayName == null) {
            displayName = spec.getString("name");
            platformName = "macosx";
            versionString = spec.getString("MaximumDeploymentTarget");
            name = platformName + versionString;
        }
        if (displayName == null || platformName == null || versionString == null) {
            throw InvalidSpecException.unexpectedPListFormat((Plist)spec);
        }
        Path systemVersionPlistFile = root.resolve("System/Library/CoreServices/SystemVersion.plist");
        Plist systemVersionPlist = Files.exists(systemVersionPlistFile, new LinkOption[0]) ? PlistDriver.readAnyFormatSafe((File)systemVersionPlistFile.toFile()) : null;
        String fullVersion = null;
        String buildVersion = null;
        if (systemVersionPlist != null) {
            fullVersion = systemVersionPlist.getString("ProductVersion");
            buildVersion = systemVersionPlist.getString("ProductBuildVersion");
        }
        fullVersion = fullVersion == null ? versionString : fullVersion;
        ApplePlatform platform = manager.findPlatformByName(platformName);
        if (platform == null) {
            List<ApplePlatform> all = manager.getPlatforms();
            String available = all.isEmpty() ? "<none>" : "\n" + StringUtil.join(all, platform1 -> platform1.toString(), (String)"\n");
            throw new InvalidSpecException("Platform '" + platformName + "' not found. Available:" + available);
        }
        Map<String, Couple<String>> llvmTargetInfo = AppleSdk.getLLVMTargetInfo(spec, (String)name);
        HashMap<String, AppleSdk> sdkVariants = new HashMap<String, AppleSdk>();
        for (Pair<String, Dictionary> pair : AppleSdk.collectBuildSettingsForSDKVariants(spec)) {
            String variant = (String)pair.first;
            Dictionary variantSpecificBuildSettings = (Dictionary)pair.second;
            Dictionary declaredBuildSettings = AppleSdk.mergeDictionaries(defaultProperties, variantSpecificBuildSettings);
            declaredBuildSettings.put("SDK_NAME", name);
            boolean isDefaultVariant = Objects.equals(defaultVariant, variant);
            Couple<String> targetInfo = AppleSdk.getDefaultTargetTripleBase((String)name, isDefaultVariant ? platformName : variant, llvmTargetInfo);
            String defaultTargetTriple = (String)targetInfo.first;
            String llvmTargetSys = (String)targetInfo.second;
            if (XcodeBase.getInstance().getVersion().isOrGreaterThan(Integer.valueOf(14))) {
                declaredBuildSettings.put("SWIFT_PLATFORM_TARGET_PREFIX", (Object)llvmTargetSys);
            }
            AppleSdk sdk = new AppleSdk(root, (String)name, displayName, versionString, fullVersion, buildVersion, platform, declaredBuildSettings, variant, defaultTargetTriple, isDefaultVariant, sdkVariants);
            sdkVariants.put(variant, sdk);
        }
        AppleSdk appleSdk = (AppleSdk)sdkVariants.get(defaultVariant);
        if (appleSdk == null) {
            AppleSdk.$$$reportNull$$$0(14);
        }
        return appleSdk;
    }

    @NotNull
    private static Couple<String> getDefaultTargetTripleBase(@NotNull String sdkName, @Nullable String nonDefaultSdkVariant, @NotNull Map<String, Couple<String>> llvmTargetInfo) {
        Couple result;
        if (sdkName == null) {
            AppleSdk.$$$reportNull$$$0(15);
        }
        if (llvmTargetInfo == null) {
            AppleSdk.$$$reportNull$$$0(16);
        }
        if ((result = nonDefaultSdkVariant != null ? llvmTargetInfo.get(nonDefaultSdkVariant) : (Couple)ContainerUtil.getFirstItem(llvmTargetInfo.values())) == null) {
            XCLog.LOG.warn("Can't infer default LLVM triple base for sdk " + sdkName + " variant " + nonDefaultSdkVariant);
            result = Couple.of((Object)"unknown", (Object)"");
        }
        Couple couple = result;
        if (couple == null) {
            AppleSdk.$$$reportNull$$$0(17);
        }
        return couple;
    }

    @NotNull
    private static Map<String, Couple<String>> getLLVMTargetInfo(@NotNull Plist spec, @NotNull String sdkName) {
        if (spec == null) {
            AppleSdk.$$$reportNull$$$0(18);
        }
        if (sdkName == null) {
            AppleSdk.$$$reportNull$$$0(19);
        }
        Dictionary supportedTargets = spec.getDictionary("SupportedTargets", Dictionary.EMPTY_DICTIONARY);
        HashMap<String, Couple<String>> result = new HashMap<String, Couple<String>>();
        for (Map.Entry entry : supportedTargets.entrySet()) {
            String llvmTripleBase;
            String environment;
            Object value = entry.getValue();
            if (!(value instanceof Dictionary)) continue;
            Dictionary targetDictionary = (Dictionary)value;
            String targetName = (String)entry.getKey();
            String vendor = targetDictionary.getString("LLVMTargetTripleVendor", "unknown");
            String deploymentTarget = targetDictionary.getString("DefaultDeploymentTarget", "");
            String sys = targetDictionary.getString("LLVMTargetTripleSys", "unknown");
            Object suffix = AppleSdk.getDefaultProperties(spec).getString("LLVM_TARGET_TRIPLE_SUFFIX");
            if (suffix == null && (environment = StringUtil.nullize((String)targetDictionary.getString("LLVMTargetTripleEnvironment"))) != null) {
                suffix = "-" + environment;
            }
            if ((llvmTripleBase = vendor + "-" + sys + deploymentTarget + StringUtil.notNullize((String)suffix)).contains("unknown")) {
                XCLog.LOG.warn("Failed to infer default LLVM triple base value for " + sdkName + " for target " + targetName);
            }
            result.put(targetName, (Couple<String>)Couple.of((Object)llvmTripleBase, (Object)sys));
        }
        HashMap<String, Couple<String>> hashMap = result;
        if (hashMap == null) {
            AppleSdk.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    @NonNls
    @NotNull
    private static Dictionary getDefaultProperties(@NotNull Plist spec) {
        if (spec == null) {
            AppleSdk.$$$reportNull$$$0(21);
        }
        Dictionary dictionary = spec.getDictionary("DefaultProperties", Dictionary.EMPTY_DICTIONARY);
        if (dictionary == null) {
            AppleSdk.$$$reportNull$$$0(22);
        }
        return dictionary;
    }

    @NotNull
    public String getDefaultLLVMTargetTripleBase() {
        String string = this.myDefaultLLVMTargetTripleBase;
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public File getPlatformRootSubFilePath(@NotNull String relativePath) {
        if (relativePath == null) {
            AppleSdk.$$$reportNull$$$0(24);
        }
        File file = this.getPlatform().getRootSubFile(relativePath).toFile();
        if (file == null) {
            AppleSdk.$$$reportNull$$$0(25);
        }
        return file;
    }

    @NotNull
    private static List<Pair<String, Dictionary>> collectBuildSettingsForSDKVariants(@NotNull Plist spec) {
        if (spec == null) {
            AppleSdk.$$$reportNull$$$0(26);
        }
        List variants = spec.getAttributeList("Variants", Dictionary.class, Collections.emptyList());
        ArrayList<Pair<String, Dictionary>> result = new ArrayList<Pair<String, Dictionary>>();
        for (Dictionary variant : variants) {
            String name = variant.getString("Name");
            Dictionary buildSettings = variant.getDictionary("BuildSettings", Dictionary.EMPTY_DICTIONARY);
            if (name == null) continue;
            result.add((Pair<String, Dictionary>)Pair.create((Object)name, (Object)buildSettings));
        }
        if (result.isEmpty()) {
            result.add((Pair<String, Dictionary>)Pair.create(null, (Object)Dictionary.EMPTY_DICTIONARY));
        }
        ArrayList<Pair<String, Dictionary>> arrayList = result;
        if (arrayList == null) {
            AppleSdk.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    private static Dictionary mergeDictionaries(@NotNull Dictionary baseDictionary, @Nullable Dictionary extraDictionary) {
        if (baseDictionary == null) {
            AppleSdk.$$$reportNull$$$0(28);
        }
        Dictionary buildSettingsValues = new Dictionary();
        buildSettingsValues.putAll((Map)baseDictionary);
        if (extraDictionary != null) {
            buildSettingsValues.putAll((Map)extraDictionary);
        }
        Dictionary dictionary = buildSettingsValues;
        if (dictionary == null) {
            AppleSdk.$$$reportNull$$$0(29);
        }
        return dictionary;
    }

    @NotNull
    public Path getRoot() {
        Path path = this.myRoot;
        if (path == null) {
            AppleSdk.$$$reportNull$$$0(30);
        }
        return path;
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = this.myCanonicalName;
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getMajorVersionString() {
        Version version = Version.parseVersion((String)this.myVersionString);
        String string = version != null ? version.withoutBugfix().toCompactString() : this.myVersionString;
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getVersionString() {
        String string = this.myVersionString;
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getFullVersion() {
        String string = this.myFullVersion;
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getBuildVersion() {
        return this.myBuildVersion;
    }

    public boolean isDeploymentTargetValid(@NotNull String deploymentTarget) {
        if (deploymentTarget == null) {
            AppleSdk.$$$reportNull$$$0(35);
        }
        return StringUtil.compareVersionNumbers((String)this.myFullVersion, (String)deploymentTarget) >= 0;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        Object object = this.myIsDefaultVariant ? this.myDisplayName : this.myDisplayName + " (" + this.myVariant + ")";
        if (object == null) {
            AppleSdk.$$$reportNull$$$0(36);
        }
        return object;
    }

    @NotNull
    @NlsSafe
    public String getShortDisplayName() {
        String string = this.getDisplayName().replaceFirst("Simulator", "Sim");
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    public ApplePlatform getPlatform() {
        ApplePlatform applePlatform = this.myPlatform;
        if (applePlatform == null) {
            AppleSdk.$$$reportNull$$$0(38);
        }
        return applePlatform;
    }

    @Nullable
    public String getVariant() {
        return this.myVariant;
    }

    @NotNull
    public ApplePlatform.Type getPlatformType() {
        ApplePlatform.Type type = this.myPlatform.getType();
        if (type == null) {
            AppleSdk.$$$reportNull$$$0(39);
        }
        return type;
    }

    @NotNull
    public AppleSdk getBaseSdk() {
        AppleSdk compatibleSdk;
        ApplePlatform basePlatform = this.myPlatform.getBasePlatform();
        if (this.myPlatform != basePlatform && (compatibleSdk = basePlatform.findSuitableSdk(this)) != null) {
            AppleSdk appleSdk = compatibleSdk;
            if (appleSdk == null) {
                AppleSdk.$$$reportNull$$$0(40);
            }
            return appleSdk;
        }
        AppleSdk appleSdk = this;
        if (appleSdk == null) {
            AppleSdk.$$$reportNull$$$0(41);
        }
        return appleSdk;
    }

    @NotNull
    public List<File> getAllFrameworkSearchPaths() {
        ArrayList<File> results = new ArrayList<File>();
        File root = this.getRoot().toFile();
        for (String path : DEFAULT_FRAMEWORK_PATHS) {
            results.add(new File(root, path));
        }
        File devRoot = new File(root, "Developer");
        for (String path : DEVELOPER_FRAMEWORK_PATHS) {
            results.add(new File(devRoot, path));
        }
        ApplePlatform platform = this.getPlatform();
        for (File eachDeveloperRoot : platform.getDeveloperRoots()) {
            for (String path : DEVELOPER_FRAMEWORK_PATHS) {
                results.add(new File(eachDeveloperRoot, path));
            }
        }
        ArrayList<File> arrayList = results;
        if (arrayList == null) {
            AppleSdk.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    public boolean processFrameworkFiles(Processor<VirtualFile> processor) {
        VirtualFile root = StandardFileSystems.local().findFileByPath(this.myRoot.toString());
        if (root != null) {
            return AppleSdk.processFiles(processor, "framework", root, DEFAULT_FRAMEWORK_PATHS);
        }
        return true;
    }

    public boolean processLibraryFiles(Processor<VirtualFile> processor) {
        VirtualFile root = StandardFileSystems.local().findFileByPath(this.myRoot.toString());
        if (root != null) {
            return AppleSdk.processFiles(processor, "dylib", root, DEFAULT_LIBRARIES_PATHS);
        }
        return true;
    }

    public static boolean processDeveloperFrameworkFiles(BuildSettingsProvider settingsProvider, Processor<VirtualFile> processor) {
        VirtualFile root;
        String developerDir = settingsProvider.getBuildSetting("DEVELOPER_DIR").getAbsolutePath();
        VirtualFile virtualFile = root = developerDir != null ? StandardFileSystems.local().findFileByPath(developerDir) : null;
        if (root != null) {
            return AppleSdk.processFiles(processor, "framework", root, DEVELOPER_FRAMEWORK_PATHS);
        }
        return true;
    }

    private static boolean processFiles(@NotNull Processor<VirtualFile> processor, @NotNull @NonNls String extension, @NotNull VirtualFile root, String[] paths) {
        if (processor == null) {
            AppleSdk.$$$reportNull$$$0(43);
        }
        if (extension == null) {
            AppleSdk.$$$reportNull$$$0(44);
        }
        if (root == null) {
            AppleSdk.$$$reportNull$$$0(45);
        }
        for (String path : paths) {
            VirtualFile frameworkPath = root.findFileByRelativePath(path);
            if (frameworkPath == null) continue;
            for (VirtualFile file : frameworkPath.getChildren()) {
                if (!extension.equals(file.getExtension()) || processor.process((Object)file)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.myDeclaredBuildSettings;
        if (dictionary == null) {
            AppleSdk.$$$reportNull$$$0(46);
        }
        return dictionary;
    }

    @NotNull
    public String getHomePath() {
        String string = this.myRoot.toString();
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public File getSubFile(@NonNls @Nullable String relativePath) {
        return relativePath == null ? new File(this.getHomePath()) : new File(this.getHomePath(), relativePath);
    }

    @NotNull
    public String getSubFilePath(@NonNls @Nullable String relativePath) {
        String string = this.getSubFile(relativePath).getPath();
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(48);
        }
        return string;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.myDisplayName).append(" (").append(this.myCanonicalName);
        if (this.myVariant != null) {
            result.append(":").append(this.myVariant);
        }
        result.append(" ").append(this.myFullVersion);
        if (this.myBuildVersion != null) {
            result.append(":").append(this.myBuildVersion);
        }
        result.append(")");
        return result.toString();
    }

    public int compareTo(@NotNull AppleSdkBase other) {
        if (other == null) {
            AppleSdk.$$$reportNull$$$0(49);
        }
        if (!(other instanceof AppleSdk)) {
            return 1;
        }
        AppleSdk o = (AppleSdk)other;
        int result = this.getPlatform().compareTo(o.getPlatform());
        if (result != 0) {
            return result;
        }
        if (this.getPlatformType() == ApplePlatform.Type.MACOS && (this.getPlatform().getFamilyIdentifier().equals("driverkit") || this.getPlatform().getFamilyIdentifier().equals("xros"))) {
            return 1;
        }
        if (o.getPlatformType() == ApplePlatform.Type.MACOS && (o.getPlatform().getFamilyIdentifier().equals("driverkit") || o.getPlatform().getFamilyIdentifier().equals("xros"))) {
            return -1;
        }
        return StringUtil.compareVersionNumbers((String)o.getVersionString(), (String)this.getVersionString());
    }

    @NotNull
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    @NlsSafe
    public String getPlatformName() {
        String string = this.getPlatform().getName();
        if (string == null) {
            AppleSdk.$$$reportNull$$$0(50);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 17, 20, 22, 23, 25, 27, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 46, 47, 48, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredBuildSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLLVMTargetTripleBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantsMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/AppleSdk";
                break;
            }
            case 12: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "llvmTargetInfo";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDictionary";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentTarget";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/AppleSdk";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueID";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromSpec";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTargetTripleBase";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLVMTargetInfo";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLLVMTargetTripleBase";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformRootSubFilePath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBuildSettingsForSDKVariants";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeDictionaries";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorVersionString";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionString";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortDisplayName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseSdk";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFrameworkSearchPaths";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFilePath";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVariant";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 50: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFromSpec";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTargetTripleBase";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLLVMTargetInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperties";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRootSubFilePath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectBuildSettingsForSDKVariants";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "mergeDictionaries";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDeploymentTargetValid";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 17, 20, 22, 23, 25, 27, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 46, 47, 48, 50 -> new IllegalStateException(string);
        };
    }
}

