/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.frameworks.AppleArchitecture;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.ApplePackageType;
import com.jetbrains.cidr.xcode.frameworks.AppleProductType;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.SpecListHelper;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProviderImpl;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleCompiler;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAndID;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAwareKt;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.xcspec.XCSpecFile;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplePlatform
implements AppleBuildSystemProvider,
BuildSettingValuesProvider,
Comparable<ApplePlatform> {
    @NonNls
    private static final String IDEPLUGIN_EXTENSION = "ideplugin";
    private static final Map<Type, Type> BASE_PLATFORMS = ImmutableMap.of((Object)((Object)Type.IOS_SIMULATOR), (Object)((Object)Type.IOS), (Object)((Object)Type.WATCH_SIMULATOR), (Object)((Object)Type.WATCH), (Object)((Object)Type.TVOS_SIMULATOR), (Object)((Object)Type.TVOS), (Object)((Object)Type.VISION_SIMULATOR), (Object)((Object)Type.VISION));
    @NotNull
    private final Path myRoot;
    @NotNull
    private final AppleSdkManager myManager;
    @NotNull
    private final String myName;
    @NotNull
    private final String myFamilyDisplayName;
    @NotNull
    private final String myFamilyIdentifier;
    @NotNull
    private final String myVersion;
    @NotNull
    private final String myIdentifier;
    @NotNull
    private final Type myType;
    @NotNull
    private final Dictionary myDeclaredBuildSettingValues;
    @NotNull
    private List<AppleArchitecture> myArchitectures;
    @NotNull
    private List<AppleProductType> myProductTypes;
    @NotNull
    private List<ApplePackageType> myPackageTypes;
    @NotNull
    private List<AppleBuildSystem> myBuildSystems;
    @NotNull
    private List<AppleCompiler> myCompilers;
    @NotNull
    private final Map<Pair<AppleFileType, String>, List<AppleCompiler>> myFileTypeToCompilersCache;
    @NotNull
    private final AppleBuildSystemProviderImpl myBuildSystemProvider;

    @NotNull
    public String getFamilyIdentifier() {
        String string = this.myFamilyIdentifier;
        if (string == null) {
            ApplePlatform.$$$reportNull$$$0(0);
        }
        return string;
    }

    ApplePlatform(@NotNull Path root, @NotNull Plist spec, @NotNull AppleSdkManager manager) throws InvalidSpecException {
        if (root == null) {
            ApplePlatform.$$$reportNull$$$0(1);
        }
        if (spec == null) {
            ApplePlatform.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            ApplePlatform.$$$reportNull$$$0(3);
        }
        this.myRoot = root;
        this.myManager = manager;
        @NonNls String type = spec.getString("Type");
        if (!"Platform".equals(type)) {
            throw InvalidSpecException.unexpectedPListFormat((Plist)spec);
        }
        this.myName = spec.getNotNullString("Name");
        this.myFamilyDisplayName = spec.getString("FamilyDisplayName", spec.getNotNullString("FamilyName"));
        this.myFamilyIdentifier = spec.getNotNullString("FamilyIdentifier");
        this.myIdentifier = spec.getNotNullString("Identifier");
        String version = spec.getString("Version");
        if (version == null) {
            version = spec.getNotNullString("CFBundleShortVersionString");
        }
        this.myVersion = version;
        this.myType = AppleSdkManager.getPlatformTypeBySettingValue(this.myName);
        this.myDeclaredBuildSettingValues = spec.getDictionary("DefaultProperties", new Dictionary());
        this.readSpecs();
        this.myBuildSystemProvider = new AppleBuildSystemProviderImpl(this.myManager){

            @Override
            @NotNull
            public List<AppleBuildSystem> getBuildSystems() {
                List<AppleBuildSystem> list = ApplePlatform.this.myBuildSystems;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            @Nullable
            public String getDomain() {
                return ApplePlatform.this.myType.getPlatformName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/ApplePlatform$1", "getBuildSystems"));
            }
        };
        this.myFileTypeToCompilersCache = new HashMap<Pair<AppleFileType, String>, List<AppleCompiler>>();
    }

    private void readSpecs() {
        ArrayList<AppleArchitecture> architectures = new ArrayList<AppleArchitecture>();
        ArrayList<AppleProductType> productTypes = new ArrayList<AppleProductType>();
        ArrayList<ApplePackageType> packageTypes = new ArrayList<ApplePackageType>();
        ArrayList<AppleBuildSystem> buildSystems = new ArrayList<AppleBuildSystem>();
        ArrayList<AppleCompiler> compilers = new ArrayList<AppleCompiler>();
        String platformDomain = this.myType.getPlatformName();
        for (File eachDir : this.getDirectoriesToProcess()) {
            try {
                DirectoryStream<Path> specFiles = Files.newDirectoryStream(eachDir.toPath());
                try {
                    XCLog.LOG.debug("Processing xcspecs in folder: " + String.valueOf(eachDir));
                    boolean isPlatformSpecs = FileUtil.isAncestor((String)this.myRoot.toString(), (String)eachDir.toString(), (boolean)true);
                    for (Path eachSpec : specFiles) {
                        this.doProcessSpecFile(new XCSpecFile(eachSpec, isPlatformSpecs ? platformDomain : null), architectures, packageTypes, buildSystems, productTypes, compilers);
                    }
                }
                finally {
                    if (specFiles == null) continue;
                    specFiles.close();
                }
            }
            catch (IOException e) {
                XCLog.LOG.warn((Throwable)e);
            }
        }
        for (XCSpecFile file : XcodeExtensionsManager.getInstance().getXCSpecFileList(platformDomain)) {
            XCLog.LOG.debug("Processing xcspec file from XCSpecProvider: " + String.valueOf(file));
            this.doProcessSpecFile(file, architectures, packageTypes, buildSystems, productTypes, compilers);
        }
        Collections.sort(architectures);
        architectures.trimToSize();
        productTypes.trimToSize();
        packageTypes.trimToSize();
        buildSystems.trimToSize();
        this.myArchitectures = Collections.unmodifiableList(architectures);
        this.myProductTypes = Collections.unmodifiableList(productTypes);
        this.myPackageTypes = Collections.unmodifiableList(packageTypes);
        this.myBuildSystems = Collections.unmodifiableList(buildSystems);
        this.myCompilers = Collections.unmodifiableList(compilers);
    }

    @NotNull
    private List<File> getDirectoriesToProcess() {
        ArrayList<File> dirsToProcess = new ArrayList<File>();
        for (File eachLibRoot : this.getDeveloperLibraryRoots()) {
            File[] dirs = new File(eachLibRoot, "Xcode").listFiles();
            if (dirs == null) continue;
            for (File eachDir : dirs) {
                if (!eachDir.isDirectory()) continue;
                dirsToProcess.add(eachDir);
                File[] subDirs = eachDir.listFiles();
                if (subDirs == null) continue;
                for (File eachPlugin : subDirs) {
                    if (!eachPlugin.isDirectory() || eachPlugin.getName().endsWith(IDEPLUGIN_EXTENSION)) continue;
                    dirsToProcess.add(new File(eachPlugin, "Contents/Resources"));
                }
            }
        }
        ArrayList<File> arrayList = dirsToProcess;
        if (arrayList == null) {
            ApplePlatform.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void doProcessSpecFile(XCSpecFile eachSpec, ArrayList<AppleArchitecture> architectures, ArrayList<ApplePackageType> packageTypes, ArrayList<AppleBuildSystem> buildSystems, ArrayList<AppleProductType> productTypes, ArrayList<AppleCompiler> compilers) {
        Path file = eachSpec.getPath();
        String name = file.getFileName().toString();
        if (!StringUtil.endsWithIgnoreCase((String)name, (String)".xcspec")) {
            return;
        }
        architectures.addAll(SpecListHelper.readSpecs(file, "Architecture", plist -> new AppleArchitecture(plist, this)));
        productTypes.addAll(SpecListHelper.readSpecs(file, "ProductType", plist -> {
            String domain = plist.getString("Domain");
            if (domain != null && !domain.equals(this.myType.getPlatformName())) {
                return null;
            }
            return new AppleProductType(plist, this);
        }));
        packageTypes.addAll(SpecListHelper.readSpecs(file, "PackageType", plist -> new ApplePackageType(plist, this)));
        compilers.addAll(SpecListHelper.readSpecs(file, "Compiler", plist -> new AppleCompiler(file, plist, this, eachSpec.getDomain())));
        buildSystems.addAll(SpecListHelper.readSpecs(file, "BuildSystem", plist -> new AppleBuildSystem(file, plist, this, null, eachSpec.getDomain())));
        this.addDefaultBuildProperties(file);
    }

    private void addDefaultBuildProperties(@NotNull Path file) {
        if (file == null) {
            ApplePlatform.$$$reportNull$$$0(5);
        }
        SpecListHelper.readSpecs(file, "BuildSettings", plist -> {
            List properties = plist.getAttributeList("Properties", Dictionary.class, Collections.emptyList());
            for (Dictionary buildSettingDeclaration : properties) {
                String propertyName = buildSettingDeclaration.getString("Name");
                String defaultValue = buildSettingDeclaration.getString("DefaultValue");
                if (propertyName == null || defaultValue == null) continue;
                this.myDeclaredBuildSettingValues.put(propertyName, (Object)defaultValue);
            }
            return null;
        });
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ApplePlatform.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        String string = this.myFamilyDisplayName;
        if (string == null) {
            ApplePlatform.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            ApplePlatform.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getIdentifier() {
        String string = this.myIdentifier;
        if (string == null) {
            ApplePlatform.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            ApplePlatform.$$$reportNull$$$0(10);
        }
        return type;
    }

    public boolean isMacOS() {
        return this.myType == Type.MACOS;
    }

    public boolean isIOS() {
        return this.isIOSDevice() || this.isIOSSimulator();
    }

    public boolean isWatch() {
        return this.isWatchDevice() || this.isWatchSimulator();
    }

    public boolean isVision() {
        return this.isVisionDevice() || this.isVisionSimulator();
    }

    public boolean isTv() {
        return this.isTvDevice() || this.isTvSimulator();
    }

    public boolean isDevice() {
        return !this.isMacOS() && !this.isSimulator();
    }

    public boolean isSimulator() {
        return this.myType.isSimulator();
    }

    public boolean isIOSDevice() {
        return this.myType == Type.IOS;
    }

    public boolean isIOSSimulator() {
        return this.myType == Type.IOS_SIMULATOR;
    }

    public boolean isWatchDevice() {
        return this.myType == Type.WATCH;
    }

    public boolean isWatchSimulator() {
        return this.myType == Type.WATCH_SIMULATOR;
    }

    public boolean isVisionDevice() {
        return this.myType == Type.VISION;
    }

    public boolean isVisionSimulator() {
        return this.myType == Type.VISION_SIMULATOR;
    }

    public boolean isTvDevice() {
        return this.myType == Type.TVOS;
    }

    public boolean isTvSimulator() {
        return this.myType == Type.TVOS_SIMULATOR;
    }

    public boolean isCompatiblePlatform(@Nullable ApplePlatform platform) {
        if (platform == null) {
            return false;
        }
        if (this.isMacOS() == platform.isMacOS()) {
            return true;
        }
        return !this.isMacOS() && !platform.isMacOS();
    }

    @NotNull
    public ApplePlatform getBasePlatform() {
        ApplePlatform result;
        if (BASE_PLATFORMS.containsKey((Object)this.myType) && (result = this.myManager.findPlatformByType(BASE_PLATFORMS.get((Object)this.myType))) != null) {
            ApplePlatform applePlatform = result;
            if (applePlatform == null) {
                ApplePlatform.$$$reportNull$$$0(11);
            }
            return applePlatform;
        }
        ApplePlatform applePlatform = this;
        if (applePlatform == null) {
            ApplePlatform.$$$reportNull$$$0(12);
        }
        return applePlatform;
    }

    @NotNull
    public List<AppleSdk> getSdks() {
        List<AppleSdk> list = this.myManager.findSdksForPlatform(this.myType);
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public AppleSdk findSuitableSdk(@NotNull AppleSdk sdk) {
        if (sdk == null) {
            ApplePlatform.$$$reportNull$$$0(14);
        }
        if (sdk.getPlatform() == this) {
            return sdk;
        }
        for (AppleSdk each : this.getSdks()) {
            if (!each.getVersionString().equals(sdk.getVersionString())) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public List<AppleArchitecture> getArchitectures() {
        List<AppleArchitecture> list = this.myArchitectures;
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    public AppleArchitecture getStandardNativeArchitecture() {
        for (String each : AppleArchitecture.PLATFORM_STANDARD_ARCHS_ID) {
            AppleArchitecture result = this.findArchitectureById(each);
            if (result == null) continue;
            return result;
        }
        XCLog.LOG.error("Standard architecture not found for " + this.getDisplayName() + " among:\n" + StringUtil.join(this.myArchitectures, architecture -> architecture.toString(), (String)"\n"));
        return null;
    }

    @Nullable
    public AppleArchitecture findArchitectureById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (AppleArchitecture each : this.myArchitectures) {
            if (!each.getId().equals(id)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public AppleArchitecture findArchitectureBySetting(@Nullable String archSetting) {
        if (archSetting == null) {
            return null;
        }
        for (AppleArchitecture each : this.myArchitectures) {
            if (!Objects.equals(each.getArchitectureSetting(), archSetting)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public List<AppleProductType> getProductTypes() {
        List<AppleProductType> list = this.myProductTypes;
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    public AppleProductType findProductType(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (AppleProductType each : this.myProductTypes) {
            if (!each.getId().equals(id)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public List<ApplePackageType> getPackageTypes() {
        List<ApplePackageType> list = this.myPackageTypes;
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    public ApplePackageType findPackageType(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (ApplePackageType each : this.myPackageTypes) {
            if (!each.getId().equals(id)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type) {
        return this.myBuildSystemProvider.findBuildSystem(type, this.myType.getPlatformName());
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type, @Nullable String domain) {
        return this.myBuildSystemProvider.findBuildSystem(type, domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable String id, @Nullable String domain) {
        return this.myBuildSystemProvider.findBuildSystem(id, domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystemByRef(@Nullable String ref) {
        return this.myBuildSystemProvider.findBuildSystemByRef(ref);
    }

    @Nullable
    public AppleCompiler findCompilerByRef(@Nullable String ref) {
        if (ref == null) {
            return null;
        }
        DomainAndID domainAndId = new DomainAndID(ref);
        String domain = domainAndId.getDomain();
        if (domain != null) {
            return this.findCompiler(domainAndId.getId(), domain);
        }
        return this.findCompiler(domainAndId.getId(), this.getDomain());
    }

    @NotNull
    public Collection<AppleCompiler> getCompilers() {
        List<AppleCompiler> list = Collections.unmodifiableList(this.myCompilers);
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    public AppleCompiler findCompiler(@Nullable String id, @Nullable String domain) {
        AppleCompiler domainCompiler = (AppleCompiler)ContainerUtil.find(this.myCompilers, compiler -> compiler.getId().equals(id) && ApplePlatform.isSuitableDomain(compiler, domain, true));
        if (domainCompiler == null) {
            domainCompiler = (AppleCompiler)ContainerUtil.find(this.myCompilers, compiler -> compiler.getId().equals(id) && ApplePlatform.isSuitableDomain(compiler, null, false));
        }
        return domainCompiler;
    }

    @NotNull
    public Collection<AppleCompiler> findCompilersForFileType(@Nullable AppleFileType type, @Nullable String domain) {
        if (type == null) {
            List<AppleCompiler> list = Collections.emptyList();
            if (list == null) {
                ApplePlatform.$$$reportNull$$$0(19);
            }
            return list;
        }
        Pair cacheKey = Pair.create((Object)type, (Object)domain);
        Collection compilersForFileType = this.myFileTypeToCompilersCache.get(cacheKey);
        if (compilersForFileType != null) {
            Collection collection = compilersForFileType;
            if (collection == null) {
                ApplePlatform.$$$reportNull$$$0(20);
            }
            return collection;
        }
        ArrayList<AppleCompiler> compilers = new ArrayList<AppleCompiler>();
        for (AppleCompiler each : this.myCompilers) {
            if (each.isAbstract() || !each.getInputFileTypes().contains(new AppleCompiler.InputFileType(type.getId())) || !ApplePlatform.isSuitableDomain(each, domain, false)) continue;
            compilers.add(each);
        }
        List result = ContainerUtil.trimToSize(compilers);
        this.myFileTypeToCompilersCache.put((Pair<AppleFileType, String>)cacheKey, result);
        List list = result;
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static boolean isSuitableDomain(@NotNull AppleCompiler compiler, @Nullable String domain, boolean strict) {
        if (compiler == null) {
            ApplePlatform.$$$reportNull$$$0(22);
        }
        if (!strict && compiler.getDomain() == null) {
            return true;
        }
        return DomainAwareKt.isSuitableDomain(compiler, domain);
    }

    @Override
    @NotNull
    public List<AppleBuildSystem> getBuildSystems() {
        List<AppleBuildSystem> list = this.myBuildSystemProvider.getBuildSystems();
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.myBuildSystemProvider.getDomain();
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.myDeclaredBuildSettingValues;
        if (dictionary == null) {
            ApplePlatform.$$$reportNull$$$0(24);
        }
        return dictionary;
    }

    @NotNull
    public Path getRoot() {
        Path path = this.myRoot;
        if (path == null) {
            ApplePlatform.$$$reportNull$$$0(25);
        }
        return path;
    }

    @NotNull
    public Path getRootSubFile(@Nullable String relativePath) {
        Path path = relativePath == null ? this.myRoot : FileSystems.getDefault().getPath(this.myRoot.toString(), relativePath);
        if (path == null) {
            ApplePlatform.$$$reportNull$$$0(26);
        }
        return path;
    }

    @NotNull
    public String getRootSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getRootSubFile(relativePath).toString();
        if (string == null) {
            ApplePlatform.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public List<File> getDeveloperRoots() {
        File platformDeveloperRoot = this.myRoot.resolve("Developer").toFile();
        File xcodeCorePluginRoot = XcodeBase.getInstance().getApplicationContentsSubFile("PlugIns/Xcode3Core.ideplugin/Contents/SharedSupport/Developer");
        List<File> list = this.isMacOS() ? Arrays.asList(platformDeveloperRoot, this.myRoot.toFile().getParentFile().getParentFile(), xcodeCorePluginRoot) : Arrays.asList(platformDeveloperRoot, xcodeCorePluginRoot);
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public List<File> getDeveloperSubFiles(@NonNls @Nullable String relativePath) {
        List<File> roots = this.getDeveloperRoots();
        if (relativePath == null) {
            List<File> list = roots;
            if (list == null) {
                ApplePlatform.$$$reportNull$$$0(29);
            }
            return list;
        }
        ArrayList<File> result = new ArrayList<File>(roots.size());
        for (File eachRoot : roots) {
            result.add(new File(eachRoot, relativePath));
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            ApplePlatform.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    private List<File> getDeveloperLibraryRoots() {
        if (XcodeBase.getInstance().getVersion().isOrGreaterThan(Integer.valueOf(13), Integer.valueOf(3))) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                ApplePlatform.$$$reportNull$$$0(31);
            }
            return list;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File eachRoot : this.getDeveloperRoots()) {
            result.add(new File(eachRoot, "Library"));
        }
        List<File> list = Collections.unmodifiableList(result);
        if (list == null) {
            ApplePlatform.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public Path getSdksRoot() {
        Path path = this.myRoot.resolve("Developer/SDKs");
        if (path == null) {
            ApplePlatform.$$$reportNull$$$0(33);
        }
        return path;
    }

    @Override
    public int compareTo(@NotNull ApplePlatform o) {
        if (o == null) {
            ApplePlatform.$$$reportNull$$$0(34);
        }
        if (this.getFamilyIdentifier().equals("driverkit") || this.getFamilyIdentifier().equals("xros")) {
            return 1;
        }
        if (o.getFamilyIdentifier().equals("driverkit") || o.getFamilyIdentifier().equals("xros")) {
            return -1;
        }
        return this.myType.compareTo(o.myType);
    }

    public String toString() {
        return this.myFamilyDisplayName + " " + this.myVersion + " (" + this.myName + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 14, 22, 34 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/ApplePlatform";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyIdentifier";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 22: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/ApplePlatform";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesToProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePlatform";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdks";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchitectures";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductTypes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilers";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompilersForFileType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSystems";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootSubFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootSubFilePath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeveloperRoots";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeveloperSubFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeveloperLibraryRoots";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdksRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultBuildProperties";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableSdk";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableDomain";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 14, 22, 34 -> new IllegalArgumentException(string);
        };
    }

    public static enum Type {
        MACOS("macosx", "macOS", new Version(3, 0, 0), false),
        IOS("iphoneos", "iOS", new Version(3, 0, 0), false),
        IOS_SIMULATOR("iphonesimulator", "iOS", new Version(3, 0, 0), true),
        TVOS("appletvos", "tvOS", new Version(7, 1, 0), false),
        TVOS_SIMULATOR("appletvsimulator", "tvOS", new Version(7, 1, 0), true),
        WATCH("watchos", "watchOS", new Version(7, 0, 0), false),
        WATCH_SIMULATOR("watchsimulator", "watchOS", new Version(7, 0, 0), true),
        VISION("xros", "visionOS", new Version(15, 2, 0), false),
        VISION_SIMULATOR("xrsimulator", "visionOS", new Version(15, 2, 0), true);

        @NotNull
        @NonNls
        private final String myPlatformName;
        @NotNull
        @NonNls
        private final String myOSName;
        @NotNull
        private final Version myVersionSince;
        private final boolean myIsSimulator;

        private Type(@NotNull String platformName, String OSName, Version versionSince, boolean isSumulator) {
            if (platformName == null) {
                Type.$$$reportNull$$$0(0);
            }
            if (OSName == null) {
                Type.$$$reportNull$$$0(1);
            }
            if (versionSince == null) {
                Type.$$$reportNull$$$0(2);
            }
            this.myPlatformName = platformName;
            this.myOSName = OSName;
            this.myVersionSince = versionSince;
            this.myIsSimulator = isSumulator;
        }

        @NotNull
        @NonNls
        public String getPlatformName() {
            String string = this.myPlatformName;
            if (string == null) {
                Type.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String getOSName() {
            String string = this.myOSName;
            if (string == null) {
                Type.$$$reportNull$$$0(4);
            }
            return string;
        }

        public Version getVersionSince() {
            return this.myVersionSince;
        }

        public boolean isSimulator() {
            return this.myIsSimulator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "platformName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "OSName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionSince";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/ApplePlatform$Type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/ApplePlatform$Type";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlatformName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOSName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

